/*
 * Decompiled with CFR 0.152.
 */
package org.xml.sax.helpers;

import java.io.IOException;
import java.util.Locale;
import org.xml.sax.Configurable;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;

public class ConfigurableParserAdapter
implements Parser,
Configurable {
    private Parser parser = null;
    private Configurable configurable = null;

    public ConfigurableParserAdapter(Parser parser) {
        this.parser = parser;
        if (parser instanceof Configurable) {
            this.configurable = (Configurable)((Object)parser);
        }
    }

    public void setLocale(Locale locale) throws SAXException {
        this.parser.setLocale(locale);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.parser.setEntityResolver(entityResolver);
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.parser.setDTDHandler(dTDHandler);
    }

    public void setDocumentHandler(DocumentHandler documentHandler) {
        this.parser.setDocumentHandler(documentHandler);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.parser.setErrorHandler(errorHandler);
    }

    public void parse(InputSource inputSource) throws SAXException, IOException {
        this.parser.parse(inputSource);
    }

    public void parse(String string) throws SAXException, IOException {
        this.parser.parse(string);
    }

    public void setFeature(String string, boolean bl) throws SAXException {
        if (this.configurable == null) {
            throw new SAXNotRecognizedException("Feature: " + string);
        }
        this.configurable.setFeature(string, bl);
    }

    public boolean getFeature(String string) throws SAXException {
        if (this.configurable == null) {
            throw new SAXNotRecognizedException("Feature: " + string);
        }
        return this.configurable.getFeature(string);
    }

    public void setProperty(String string, Object object) throws SAXException {
        if (this.configurable == null) {
            throw new SAXNotRecognizedException("Property: " + string);
        }
        this.configurable.setProperty(string, object);
    }

    public Object getProperty(String string) throws SAXException {
        if (this.configurable == null) {
            throw new SAXNotRecognizedException("Property: " + string);
        }
        return this.configurable.getProperty(string);
    }
}

