/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.util;

import java.awt.Color;

public final class ColorUtil {
    public static Color changeBrightness(Color color, double d2) {
        float[] fArray = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), fArray);
        fArray[2] = (float)((double)fArray[2] * d2);
        if (fArray[2] > 1.0f) {
            fArray[2] = 1.0f;
        }
        float[] fArray2 = fArray;
        return Color.getHSBColor(fArray2[0], fArray2[1], fArray2[2]);
    }

    public static int changeBrightness(int n, double d2) {
        float[] fArray = new float[3];
        Color.RGBtoHSB(ColorUtil.red(n), ColorUtil.green(n), ColorUtil.blue(n), fArray);
        fArray[2] = (float)((double)fArray[2] * d2);
        if (fArray[2] > 1.0f) {
            fArray[2] = 1.0f;
        }
        float[] fArray2 = fArray;
        return Color.HSBtoRGB(fArray2[0], fArray2[1], fArray2[2]);
    }

    public static int rgbv(int n, int n2, int n3) {
        return 0xFF000000 | n << 16 | n2 << 8 | n3;
    }

    public static int rgb(int n, int n2, int n3) {
        if (n < 0) {
            n = 0;
        }
        if (n > 255) {
            n = 255;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > 255) {
            n2 = 255;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n3 > 255) {
            n3 = 255;
        }
        return 0xFF000000 | n << 16 | n2 << 8 | n3;
    }

    public static int argbv(int n, int n2, int n3, int n4) {
        return n << 24 | n2 << 16 | n3 << 8 | n4;
    }

    public static int argb(int n, int n2, int n3, int n4) {
        if (n < 0) {
            n = 0;
        }
        if (n > 255) {
            n = 255;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > 255) {
            n2 = 255;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n3 > 255) {
            n3 = 255;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        if (n4 > 255) {
            n4 = 255;
        }
        return n << 24 | n2 << 16 | n3 << 8 | n4;
    }

    public static int gray(int n) {
        return ((n & 0xFF) + (n >> 8 & 0xFF) + (n >> 16 & 0xFF)) / 3;
    }

    public static int alpha(int n) {
        return n >> 24 & 0xFF;
    }

    public static int red(int n) {
        return n >> 16 & 0xFF;
    }

    public static int green(int n) {
        return n >> 8 & 0xFF;
    }

    public static int blue(int n) {
        return n & 0xFF;
    }
}

