/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap;

import com.bbn.openmap.Environment;
import com.bbn.openmap.I18n;
import com.bbn.openmap.LayerHandler;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.MapHandler;
import com.bbn.openmap.ProjectionPainter;
import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.event.InfoDisplayEvent;
import com.bbn.openmap.event.InfoDisplayListener;
import com.bbn.openmap.event.LayerStatusEvent;
import com.bbn.openmap.event.LayerStatusListener;
import com.bbn.openmap.event.ListenerSupport;
import com.bbn.openmap.event.MapMouseListener;
import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.event.ProjectionListener;
import com.bbn.openmap.gui.ScrollPaneWindowSupport;
import com.bbn.openmap.gui.WindowSupport;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import com.bbn.openmap.util.propertyEditor.Inspector;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.Beans;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextChildSupport;
import java.beans.beancontext.BeanContextMembershipEvent;
import java.beans.beancontext.BeanContextMembershipListener;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.JComponent;

public abstract class Layer
extends JComponent
implements ProjectionListener,
ProjectionPainter,
BeanContextChild,
BeanContextMembershipListener,
PropertyConsumer,
ActionListener {
    protected static final String SWING_PACKAGE = Layer.getPackage(class$javax$swing$JComponent == null ? (class$javax$swing$JComponent = Layer.class$("javax.swing.JComponent")) : class$javax$swing$JComponent);
    public static final String PrettyNameProperty = "prettyName";
    public static final String AddToBeanContextProperty = "addToBeanContext";
    public static final String AddAsBackgroundProperty = "background";
    public static final String RemoveableProperty = "removeable";
    public static final String AutoPaletteProperty = "autoPalette";
    public static final String DisplayPaletteCmd = "displayPaletteCmd";
    public static final String HidePaletteCmd = "hidePaletteCmd";
    public static final String DisplayPropertiesCmd = "displayPropertiesCmd";
    public static final String RedrawCmd = "redrawCmd";
    protected ListenerSupport IDListeners = null;
    protected ListenerSupport lsListeners = null;
    protected String propertyPrefix = null;
    protected boolean addToBeanContext = true;
    protected boolean addAsBackground = false;
    protected boolean removeable = true;
    protected boolean autoPalette = false;
    private Projection projection = null;
    protected transient WindowSupport windowSupport;
    protected transient ComponentListener paletteListener;
    protected transient Container palette;
    protected final BeanContextChildSupport beanContextChildSupport = new BeanContextChildSupport(this);
    protected I18n i18n = Environment.getI18n();
    protected ListenerSupport localHackList;
    protected boolean doHack = true;
    static /* synthetic */ Class class$javax$swing$JComponent;
    static /* synthetic */ Class class$com$bbn$openmap$Layer;
    static /* synthetic */ Class class$java$awt$Frame;

    protected static String getPackage(Class c) {
        String className = c.getName();
        int lastDot = className.lastIndexOf(46);
        return className.substring(0, lastDot);
    }

    public final void addMouseListener(MouseListener l) {
        String pkg = Layer.getPackage(l.getClass());
        if (!(Beans.isDesignTime() || pkg.equals(SWING_PACKAGE) || pkg.startsWith(SWING_PACKAGE))) {
            throw new IllegalArgumentException("This operation is disallowed because the package \"" + pkg + "\" is not in the swing package (\"" + SWING_PACKAGE + "\").");
        }
        super.addMouseListener(l);
    }

    public void setProperties(Properties props) {
        this.setProperties(this.getPropertyPrefix(), props);
    }

    public void setProperties(String prefix, Properties props) {
        String prettyName = PrettyNameProperty;
        this.setPropertyPrefix(prefix);
        String realPrefix = PropUtils.getScopedPropertyPrefix(prefix);
        prettyName = realPrefix + PrettyNameProperty;
        String defaultName = this.getName();
        if (defaultName == null) {
            defaultName = "Anonymous";
        }
        this.setName(props.getProperty(prettyName, defaultName));
        this.setAddToBeanContext(PropUtils.booleanFromProperties(props, realPrefix + AddToBeanContextProperty, this.addToBeanContext));
        this.setAddAsBackground(PropUtils.booleanFromProperties(props, realPrefix + AddAsBackgroundProperty, this.addAsBackground));
        this.setRemoveable(PropUtils.booleanFromProperties(props, realPrefix + RemoveableProperty, this.removeable));
        this.autoPalette = PropUtils.booleanFromProperties(props, realPrefix + AutoPaletteProperty, this.autoPalette);
    }

    public void setName(String name) {
        LayerHandler lh;
        super.setName(name);
        BeanContext bc = this.getBeanContext();
        if (bc != null && bc instanceof MapHandler && (lh = (LayerHandler)((MapHandler)bc).get("com.bbn.openmap.LayerHandler")) != null) {
            lh.setLayers();
        }
    }

    public Properties getProperties(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        String prefix = PropUtils.getScopedPropertyPrefix(this.propertyPrefix);
        props.put(prefix + "class", this.getClass().getName());
        String prettyName = this.getName();
        if (prettyName != null) {
            props.put(prefix + PrettyNameProperty, prettyName);
        }
        props.put(prefix + AutoPaletteProperty, new Boolean(this.autoPalette).toString());
        props.put(prefix + AddAsBackgroundProperty, new Boolean(this.addAsBackground).toString());
        props.put(prefix + RemoveableProperty, new Boolean(this.removeable).toString());
        props.put(prefix + AddToBeanContextProperty, new Boolean(this.addToBeanContext).toString());
        return props;
    }

    public Properties getPropertyInfo(Properties list) {
        if (list == null) {
            list = new Properties();
        }
        list.put("class", "Class Name used for Layer.");
        list.put("class.editor", "com.bbn.openmap.util.propertyEditor.NonEditablePropertyEditor");
        String internString = this.i18n.get(class$com$bbn$openmap$Layer == null ? (class$com$bbn$openmap$Layer = Layer.class$("com.bbn.openmap.Layer")) : class$com$bbn$openmap$Layer, PrettyNameProperty, 3, "Presentable name for Layer");
        list.put(PrettyNameProperty, internString);
        internString = this.i18n.get(class$com$bbn$openmap$Layer == null ? (class$com$bbn$openmap$Layer = Layer.class$("com.bbn.openmap.Layer")) : class$com$bbn$openmap$Layer, PrettyNameProperty, "Layer Name");
        list.put("prettyName.label", internString);
        list.put("prettyName.editor", "com.bbn.openmap.util.propertyEditor.NonEditablePropertyEditor");
        internString = this.i18n.get(class$com$bbn$openmap$Layer == null ? (class$com$bbn$openmap$Layer = Layer.class$("com.bbn.openmap.Layer")) : class$com$bbn$openmap$Layer, AutoPaletteProperty, 3, "Flag to automatically display palette when properties are set");
        list.put(AutoPaletteProperty, internString);
        internString = this.i18n.get(class$com$bbn$openmap$Layer == null ? (class$com$bbn$openmap$Layer = Layer.class$("com.bbn.openmap.Layer")) : class$com$bbn$openmap$Layer, AutoPaletteProperty, "Open Palette At Start");
        list.put("autoPalette.label", internString);
        list.put("autoPalette.editor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        internString = this.i18n.get(class$com$bbn$openmap$Layer == null ? (class$com$bbn$openmap$Layer = Layer.class$("com.bbn.openmap.Layer")) : class$com$bbn$openmap$Layer, AddAsBackgroundProperty, 3, "Flag to use the layer as a background layer");
        list.put(AddAsBackgroundProperty, internString);
        internString = this.i18n.get(class$com$bbn$openmap$Layer == null ? (class$com$bbn$openmap$Layer = Layer.class$("com.bbn.openmap.Layer")) : class$com$bbn$openmap$Layer, AddAsBackgroundProperty, "Background");
        list.put("background.label", internString);
        list.put("background.editor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        internString = this.i18n.get(class$com$bbn$openmap$Layer == null ? (class$com$bbn$openmap$Layer = Layer.class$("com.bbn.openmap.Layer")) : class$com$bbn$openmap$Layer, RemoveableProperty, 3, "Flag to allow layer to be deleted.");
        list.put(RemoveableProperty, internString);
        internString = this.i18n.get(class$com$bbn$openmap$Layer == null ? (class$com$bbn$openmap$Layer = Layer.class$("com.bbn.openmap.Layer")) : class$com$bbn$openmap$Layer, RemoveableProperty, "Removeable");
        list.put("removeable.label", internString);
        list.put("removeable.editor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        internString = this.i18n.get(class$com$bbn$openmap$Layer == null ? (class$com$bbn$openmap$Layer = Layer.class$("com.bbn.openmap.Layer")) : class$com$bbn$openmap$Layer, AddToBeanContextProperty, 3, "Flag to give the layer access to all of the other application components.");
        list.put(AddToBeanContextProperty, internString);
        internString = this.i18n.get(class$com$bbn$openmap$Layer == null ? (class$com$bbn$openmap$Layer = Layer.class$("com.bbn.openmap.Layer")) : class$com$bbn$openmap$Layer, AddToBeanContextProperty, "Add to MapHandler");
        list.put("addToBeanContext.label", internString);
        list.put("addToBeanContext.editor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        return list;
    }

    public void setPropertyPrefix(String prefix) {
        this.propertyPrefix = prefix;
    }

    public String getPropertyPrefix() {
        return this.propertyPrefix;
    }

    public void setProjection(Projection proj) {
        this.projection = proj;
    }

    public Projection setProjection(ProjectionEvent projEvent) {
        Projection newProjection = projEvent.getProjection();
        if (!newProjection.equals(this.getProjection())) {
            Projection clone = newProjection.makeClone();
            this.setProjection(clone);
            return clone;
        }
        return null;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public synchronized MapMouseListener getMapMouseListener() {
        return null;
    }

    public Component getGUI() {
        return null;
    }

    public synchronized void addInfoDisplayListener(InfoDisplayListener aInfoDisplayListener) {
        if (this.IDListeners == null) {
            this.IDListeners = new ListenerSupport(this);
        }
        this.IDListeners.addListener(aInfoDisplayListener);
    }

    public synchronized void removeInfoDisplayListener(InfoDisplayListener aInfoDisplayListener) {
        if (this.IDListeners != null) {
            this.IDListeners.removeListener(aInfoDisplayListener);
        }
    }

    public void fireRequestInfoLine(InfoDisplayEvent evt) {
        if (this.IDListeners != null) {
            Iterator it = this.IDListeners.iterator();
            while (it.hasNext()) {
                ((InfoDisplayListener)it.next()).requestInfoLine(evt);
            }
        } else if (Debug.debugging("layer")) {
            Debug.output(this.getName() + "|Layer.fireRequestInfoLine(): no info request listener!");
        }
    }

    public void fireRequestInfoLine(String infoLine) {
        this.fireRequestInfoLine(new InfoDisplayEvent(this, infoLine));
    }

    public void fireRequestInfoLine(String infoLine, int loc) {
        this.fireRequestInfoLine(new InfoDisplayEvent(this, infoLine, loc));
    }

    public void fireRequestBrowserContent(InfoDisplayEvent evt) {
        if (this.IDListeners != null) {
            Iterator it = this.IDListeners.iterator();
            while (it.hasNext()) {
                ((InfoDisplayListener)it.next()).requestBrowserContent(evt);
            }
        } else if (Debug.debugging("layer")) {
            Debug.output(this.getName() + "|Layer.fireRequestBrowserContent(): no info request listener!");
        }
    }

    public void fireRequestBrowserContent(String browserContent) {
        this.fireRequestBrowserContent(new InfoDisplayEvent(this, browserContent));
    }

    public void fireRequestURL(InfoDisplayEvent evt) {
        if (this.IDListeners != null) {
            Iterator it = this.IDListeners.iterator();
            while (it.hasNext()) {
                ((InfoDisplayListener)it.next()).requestURL(evt);
            }
        } else if (Debug.debugging("layer")) {
            Debug.output(this.getName() + "|Layer.fireRequestURL(): no info request listener!");
        }
    }

    public void fireRequestURL(String url) {
        this.fireRequestURL(new InfoDisplayEvent(this, url));
    }

    public void fireRequestCursor(Cursor cursor) {
        if (this.IDListeners != null) {
            Iterator it = this.IDListeners.iterator();
            while (it.hasNext()) {
                ((InfoDisplayListener)it.next()).requestCursor(cursor);
            }
        } else if (Debug.debugging("layer")) {
            Debug.output(this.getName() + "|Layer.fireRequestCursor(): no info request listener!");
        }
    }

    public void fireRequestMessage(InfoDisplayEvent evt) {
        if (this.IDListeners != null) {
            Iterator it = this.IDListeners.iterator();
            while (it.hasNext()) {
                ((InfoDisplayListener)it.next()).requestMessage(evt);
            }
        } else if (Debug.debugging("layer")) {
            Debug.output(this.getName() + "|Layer.fireRequestMessage(): no info request listener!");
        }
    }

    public void fireRequestMessage(String message) {
        this.fireRequestMessage(new InfoDisplayEvent(this, message));
    }

    public void fireRequestToolTip(MouseEvent me, String tip) {
        this.fireRequestToolTip(new InfoDisplayEvent(this, tip));
    }

    public void fireRequestToolTip(String tip) {
        this.fireRequestToolTip(new InfoDisplayEvent(this, tip));
    }

    public void fireHideToolTip(MouseEvent me) {
        this.fireRequestToolTip((InfoDisplayEvent)null);
    }

    public void fireHideToolTip() {
        this.fireRequestToolTip((InfoDisplayEvent)null);
    }

    public void fireRequestToolTip(MouseEvent me, InfoDisplayEvent event) {
        this.fireRequestToolTip(event);
    }

    public void fireRequestToolTip(InfoDisplayEvent event) {
        if (this.IDListeners != null) {
            Iterator it = this.IDListeners.iterator();
            while (it.hasNext()) {
                if (event != null) {
                    ((InfoDisplayListener)it.next()).requestShowToolTip(event);
                    continue;
                }
                ((InfoDisplayListener)it.next()).requestHideToolTip();
            }
        } else if (Debug.debugging("layer")) {
            Debug.output(this.getName() + "|Layer.fireRequestShowToolTip(): no info request listener!");
        }
    }

    public synchronized void addLayerStatusListener(LayerStatusListener aLayerStatusListener) {
        if (this.lsListeners == null) {
            this.lsListeners = new ListenerSupport(this);
        }
        this.lsListeners.addListener(aLayerStatusListener);
    }

    public synchronized void removeLayerStatusListener(LayerStatusListener aLayerStatusListener) {
        if (this.lsListeners != null) {
            this.lsListeners.removeListener(aLayerStatusListener);
        }
    }

    public void fireStatusUpdate(LayerStatusEvent evt) {
        if (this.lsListeners != null) {
            Iterator it = this.lsListeners.iterator();
            while (it.hasNext()) {
                ((LayerStatusListener)it.next()).updateLayerStatus(evt);
            }
        } else if (Debug.debugging("layer")) {
            Debug.output(this.getName() + "|Layer.fireStatusUpdate(): no LayerStatusListeners!");
        }
    }

    public void fireStatusUpdate(int status) {
        this.fireStatusUpdate(new LayerStatusEvent(this, status));
    }

    public void repaint(long tm, int x, int y, int width, int height) {
        Container p = this.getParent();
        if (p instanceof MapBean) {
            ((MapBean)p).setBufferDirty(true);
            if (Debug.debugging("basic")) {
                Debug.output(this.getName() + "|Layer: repaint(tm=" + tm + ", x=" + x + ", y=" + y + ", width=" + width + ", height=" + height + ")");
            }
            ((MapBean)p).repaint(this);
        } else if (p != null) {
            p.repaint(tm, x, y, width, height);
        } else {
            super.repaint(tm, x, y, width, height);
        }
    }

    public void renderDataForProjection(Projection proj, Graphics g) {
        this.paint(g);
    }

    public void added(Container cont) {
    }

    public void removed(Container cont) {
    }

    public void setVisible(boolean show) {
        super.setVisible(show);
        if (this.doHack && !show) {
            this.notifyHideHack();
        }
    }

    public void addComponentListener(ComponentListener cl) {
        super.addComponentListener(cl);
        if (this.localHackList == null) {
            this.localHackList = new ListenerSupport(this);
        }
        this.localHackList.addListener(cl);
    }

    public void removeComponentListener(ComponentListener cl) {
        super.removeComponentListener(cl);
        if (this.localHackList != null) {
            this.localHackList.removeListener(cl);
        }
    }

    public void notifyHideHack() {
        if (this.localHackList == null) {
            return;
        }
        ComponentEvent ce = new ComponentEvent(this, 103);
        Iterator it = this.localHackList.iterator();
        while (it.hasNext()) {
            ((ComponentListener)it.next()).componentHidden(ce);
        }
    }

    public void setAddToBeanContext(boolean set) {
        this.addToBeanContext = set;
    }

    public boolean getAddToBeanContext() {
        return this.addToBeanContext;
    }

    public void setAddAsBackground(boolean set) {
        this.addAsBackground = set;
    }

    public boolean getAddAsBackground() {
        return this.addAsBackground;
    }

    public void setRemoveable(boolean set) {
        this.removeable = set;
    }

    public boolean isRemoveable() {
        return this.removeable;
    }

    public void findAndInit(Iterator it) {
        while (it.hasNext()) {
            this.findAndInit(it.next());
        }
    }

    public void findAndInit(Object obj) {
    }

    public void childrenAdded(BeanContextMembershipEvent bcme) {
        this.findAndInit(bcme.iterator());
    }

    public void childrenRemoved(BeanContextMembershipEvent bcme) {
        Iterator it = bcme.iterator();
        while (it.hasNext()) {
            this.findAndUndo(it.next());
        }
    }

    public void findAndUndo(Object obj) {
    }

    public BeanContext getBeanContext() {
        return this.beanContextChildSupport.getBeanContext();
    }

    public void setBeanContext(BeanContext in_bc) throws PropertyVetoException {
        if (in_bc != null) {
            in_bc.addBeanContextMembershipListener(this);
            this.beanContextChildSupport.setBeanContext(in_bc);
            this.findAndInit(in_bc.iterator());
        }
    }

    public void addVetoableChangeListener(String propertyName, VetoableChangeListener in_vcl) {
        this.beanContextChildSupport.addVetoableChangeListener(propertyName, in_vcl);
    }

    public void removeVetoableChangeListener(String propertyName, VetoableChangeListener in_vcl) {
        this.beanContextChildSupport.removeVetoableChangeListener(propertyName, in_vcl);
    }

    public void fireVetoableChange(String name, Object oldValue, Object newValue) throws PropertyVetoException {
        super.fireVetoableChange(name, oldValue, newValue);
        this.beanContextChildSupport.fireVetoableChange(name, oldValue, newValue);
    }

    public void clearListeners() {
        BeanContext bc;
        if (this.localHackList != null) {
            this.localHackList.removeAll();
        }
        if (this.IDListeners != null) {
            this.IDListeners.removeAll();
        }
        if (this.lsListeners != null) {
            this.lsListeners.removeAll();
        }
        if ((bc = this.getBeanContext()) != null) {
            bc.removeBeanContextMembershipListener(this);
        }
    }

    public void finalize() {
        if (Debug.debugging("gc")) {
            Debug.output("Layer |" + this.getName() + " |: getting GC'd");
        }
    }

    public void firePaletteEvent(ComponentEvent event) {
        if (this.localHackList == null) {
            return;
        }
        this.palette = (Container)event.getSource();
        int eventType = event.getID();
        Iterator it = this.localHackList.iterator();
        while (it.hasNext()) {
            ComponentListener target = (ComponentListener)it.next();
            if (eventType == 103) {
                target.componentHidden(event);
                continue;
            }
            if (eventType != 102) continue;
            target.componentShown(event);
        }
        if (eventType == 103) {
            this.palette = null;
        }
    }

    public Container getPalette() {
        return this.palette;
    }

    protected void resetPalette() {
        Container pal = this.getPalette();
        boolean putUp = false;
        if (pal != null && pal.isVisible()) {
            putUp = true;
            this.setPaletteVisible(false);
        }
        if (putUp) {
            this.setPaletteVisible(true);
        }
    }

    public void setPaletteVisible(boolean visible) {
        if (visible) {
            this.showPalette();
        } else {
            this.hidePalette();
        }
    }

    public void setWindowSupport(WindowSupport ws) {
        this.windowSupport = ws;
    }

    public WindowSupport getWindowSupport() {
        return this.windowSupport;
    }

    protected WindowSupport createWindowSupport() {
        return new ScrollPaneWindowSupport(this.getGUI(), this.getName());
    }

    public void showPalette() {
        WindowSupport ws = this.getWindowSupport();
        if (ws == null) {
            ws = this.createWindowSupport();
            this.paletteListener = new ComponentAdapter(){

                public void componentShown(ComponentEvent e) {
                    Layer.this.firePaletteEvent(e);
                }

                public void componentHidden(ComponentEvent e) {
                    Layer.this.firePaletteEvent(e);
                }
            };
            this.setWindowSupport(ws);
        } else {
            ws.setTitle(this.getName());
            ws.setContent(this.getGUI());
        }
        if (ws != null) {
            MapHandler mh = (MapHandler)this.getBeanContext();
            Frame frame = null;
            if (mh != null && (frame = (Frame)mh.get(class$java$awt$Frame == null ? (class$java$awt$Frame = Layer.class$("java.awt.Frame")) : class$java$awt$Frame)) == null) {
                MapBean mapBean = (MapBean)mh.get("com.bbn.openmap.MapBean");
                if (mapBean == null) {
                    Debug.message("layer", "Layer.showPalette: Warning...mapBean = null");
                } else {
                    try {
                        Container parent = mapBean.getParent();
                        while (parent.getParent() != null && !(parent instanceof Frame)) {
                            parent = parent.getParent();
                        }
                        if (parent instanceof Frame) {
                            frame = (Frame)parent;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if (this.paletteListener != null) {
                ws.addComponentListener(this.paletteListener);
            }
            ws.displayInWindow(frame);
        }
    }

    public void hidePalette() {
        WindowSupport ws = this.getWindowSupport();
        if (ws != null) {
            ws.killWindow();
        }
    }

    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if (command == DisplayPaletteCmd) {
            if (Debug.debugging("layer")) {
                Debug.output(this.getName() + " displaying palette");
            }
            this.showPalette();
        } else if (command == HidePaletteCmd) {
            if (Debug.debugging("layer")) {
                Debug.output(this.getName() + " hiding palette");
            }
            this.hidePalette();
        } else if (command == DisplayPropertiesCmd) {
            Inspector inspector = new Inspector();
            inspector.inspectPropertyConsumer(this);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

