/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.dted;

import com.bbn.openmap.dataAccess.dted.DTEDLocator;
import com.bbn.openmap.dataAccess.dted.DTEDNameTranslator;
import com.bbn.openmap.io.BinaryBufferedFile;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.util.ArgParser;
import com.bbn.openmap.util.Debug;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Iterator;
import java.util.LinkedList;

public class DTEDAdmin {
    protected boolean framesPrepped = false;
    protected int level_;
    protected double ullat_;
    protected double ullon_;
    protected double lrlat_;
    protected double lrlon_;
    protected boolean inside_;
    protected int equal_;
    protected LinkedList frameList = null;
    protected DTEDLocator locator = null;
    public static final int MAXLEVELS = 3;
    public static final int DTED_LARGER_LEVELS = 0;
    public static final int DTED_SMALLER_LEVELS = 1;
    public static final int DTED_NOTEQUAL_LEVELS = 2;
    public static final int DTED_EQUAL_LEVELS = 3;

    public DTEDAdmin() {
    }

    public DTEDAdmin(String dtedDir, double ullat, double ullon, double lrlat, double lrlon, int level, boolean inside, int equal) {
        this.setFrameList(dtedDir, ullat, ullon, lrlat, lrlon, level, inside, equal);
    }

    protected LinkedList organizeFrames(String dtedDir, double ullat, double ullon, double lrlat, double lrlon, int level, boolean inside, int equal) {
        this.framesPrepped = false;
        if (Debug.debugging("dted")) {
            Debug.output("DTEDAdmin: Checking for directory " + dtedDir);
        }
        LinkedList frames = null;
        this.level_ = level;
        this.ullat_ = ullat;
        this.ullon_ = ullon;
        this.lrlat_ = lrlat;
        this.lrlon_ = lrlon;
        this.inside_ = inside;
        this.equal_ = equal;
        Debug.output("DTEDAdmin: Figuring out which frames fit the criteria...");
        frames = this.getFrameList(dtedDir);
        this.framesPrepped = true;
        return frames;
    }

    public void setFrameList(String dtedDir, double ullat, double ullon, double lrlat, double lrlon, int level, boolean inside, int equal) {
        this.setFrameList(this.organizeFrames(dtedDir, ullat, ullon, lrlat, lrlon, level, inside, equal));
    }

    protected void setFrameList(LinkedList ll) {
        this.frameList = ll;
    }

    protected LinkedList getFrameList() {
        return this.frameList;
    }

    protected LinkedList getFrameList(String dtedDir) {
        int leftx = (int)Math.floor(this.ullon_);
        int rightx = (int)Math.ceil(this.lrlon_);
        int bottomy = (int)Math.floor(this.lrlat_);
        int topy = (int)Math.ceil(this.ullat_);
        LinkedList<File> frames = new LinkedList<File>();
        this.locator = new DTEDLocator(dtedDir);
        this.locator.organize();
        int hor = leftx;
        while (hor < rightx) {
            int ver = bottomy;
            while (ver < topy) {
                int lev = 0;
                while (lev < 3) {
                    File file;
                    boolean dothisone = false;
                    switch (this.equal_) {
                        case 0: {
                            if (lev <= this.level_) break;
                            dothisone = true;
                            break;
                        }
                        case 1: {
                            if (lev >= this.level_) break;
                            dothisone = true;
                            break;
                        }
                        case 2: {
                            if (lev == this.level_) break;
                            dothisone = true;
                            break;
                        }
                        default: {
                            if (lev != this.level_) break;
                            dothisone = true;
                        }
                    }
                    if (dothisone && (file = this.locator.get(ver, hor, lev)) != null) {
                        if (Debug.debugging("dted")) {
                            Debug.output("DTEDAdmin adding " + file.getAbsolutePath() + " to list");
                        }
                        frames.add(file);
                    }
                    ++lev;
                }
                ++ver;
            }
            ++hor;
        }
        return frames;
    }

    public boolean copyTo(String todteddir) {
        return this.copyTo(this.getFrameList(), todteddir);
    }

    protected boolean copyTo(LinkedList files, String todteddir) {
        if (files == null) {
            Debug.error("No files configured for copying!");
            return false;
        }
        Iterator it = files.iterator();
        while (it.hasNext()) {
            File file = (File)it.next();
            DTEDNameTranslator dnt = this.locator.getTranslator();
            try {
                File toDir;
                dnt.set(file.getAbsolutePath());
                String dsd = dnt.getSubDirs();
                if (dsd != null && dsd.length() > 0) {
                    dsd = "/" + dsd;
                }
                if (!(toDir = new File(todteddir + dsd)).exists()) {
                    toDir.mkdirs();
                }
                File outputFile = new File(toDir, dnt.getFileName());
                if (Debug.debugging("dted")) {
                    Debug.output("DTEDAdmin copying " + file.getAbsolutePath() + " to " + outputFile.getAbsolutePath());
                }
                BinaryBufferedFile input = new BinaryBufferedFile(file);
                RandomAccessFile output = new RandomAccessFile(outputFile, "rw");
                byte[] bytes = new byte[4096];
                int numBytes = input.read(bytes);
                while (numBytes > 0) {
                    output.write(bytes, 0, numBytes);
                    numBytes = input.read(bytes);
                }
                input.close();
                output.close();
            }
            catch (FormatException fe) {
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        return true;
    }

    public boolean remove() {
        return this.remove(this.getFrameList());
    }

    protected boolean remove(LinkedList files) {
        if (files == null) {
            Debug.error("No files configured for removal!");
            return false;
        }
        Iterator it = files.iterator();
        while (it.hasNext()) {
            File file = (File)it.next();
            Debug.output("DTEDAdmin deleting " + file.getAbsolutePath());
            file.delete();
        }
        return true;
    }

    public boolean query() {
        return this.query(this.getFrameList());
    }

    protected boolean query(LinkedList files) {
        if (files == null) {
            Debug.error("No files configured for query!");
            return false;
        }
        Iterator it = files.iterator();
        while (it.hasNext()) {
            File file = (File)it.next();
            Debug.output("  " + file.getAbsolutePath());
        }
        return true;
    }

    public static void main(String[] argv) {
        Debug.init();
        ArgParser ap = new ArgParser("DTEDAdmin");
        ap.add("boundary", "upper lat, left lon, lower lat, right lon", 4, true);
        ap.add("copy", "Copy files to DTED directory.", 1);
        ap.add("level", "DTED level to consider (0, 1, 2).", 1);
        ap.add("outside", "Use files outside boundary.");
        ap.add("query", "Print out files that meet parameters.");
        ap.add("remove", "Delete DTED files.");
        ap.add("source", "The source DTED directory path.", 1);
        ap.add("verbose", "Print out progress.");
        if (!ap.parse(argv)) {
            ap.printUsage();
            System.exit(0);
        }
        String sourceDir = null;
        String[] arg = ap.getArgValues("source");
        if (arg != null) {
            sourceDir = arg[0];
        }
        boolean inside = true;
        arg = ap.getArgValues("outside");
        if (arg != null) {
            inside = false;
        }
        int level = 0;
        arg = ap.getArgValues("level");
        if (arg != null) {
            try {
                level = Integer.parseInt(arg[0]);
            }
            catch (NumberFormatException nfe) {
                level = 0;
            }
        }
        if ((arg = ap.getArgValues("verbose")) != null) {
            Debug.put("dted");
        }
        DTEDAdmin admin = null;
        double ullat = 89.0;
        double ullon = -180.0;
        double lrlat = -90.0;
        double lrlon = 179.0;
        arg = ap.getArgValues("boundary");
        if (arg != null) {
            try {
                ullat = Double.parseDouble(arg[0]);
                ullon = Double.parseDouble(arg[1]);
                lrlat = Double.parseDouble(arg[2]);
                lrlon = Double.parseDouble(arg[3]);
            }
            catch (NumberFormatException nfe1) {
                Debug.error("DTEDAdmin: boundary coordinates not valid:\n  " + arg[0] + "\n  " + arg[1] + "\n  " + arg[2] + "\n  " + arg[3]);
                System.exit(0);
            }
        }
        if (sourceDir != null) {
            admin = new DTEDAdmin(sourceDir, ullat, ullon, lrlat, lrlon, level, inside, 3);
        }
        if ((arg = ap.getArgValues("copy")) != null) {
            if (admin != null) {
                admin.copyTo(arg[0]);
            } else {
                Debug.error("DTEDAdmin:  frame parameters not set for copy.  Need source directory");
                System.exit(0);
            }
        }
        if ((arg = ap.getArgValues("query")) != null) {
            if (admin != null) {
                Debug.output("DTED frame files found:");
                admin.query();
            } else {
                Debug.error("DTEDAdmin:  frame parameters not set for query.  Need source directory");
                System.exit(0);
            }
        }
        if ((arg = ap.getArgValues("remove")) != null) {
            if (admin != null) {
                Debug.output("These files will be deleted:");
                admin.query();
                Debug.output("Are you sure you want to delete them? [y/N]");
                int answer = 110;
                try {
                    answer = System.in.read();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                if (answer == 89 || answer == 121) {
                    admin.remove();
                } else {
                    Debug.output("File removal aborted.");
                }
            } else {
                Debug.error("DTEDAdmin:  frame parameters not set for copy.  Need source directory");
                System.exit(0);
            }
        }
    }
}

