/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.dted;

import com.bbn.openmap.dataAccess.dted.OMDTEDGrid;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGrid;
import com.bbn.openmap.omGraphics.OMRaster;
import com.bbn.openmap.omGraphics.OMScalingRaster;
import com.bbn.openmap.omGraphics.grid.ElevationColors;
import com.bbn.openmap.omGraphics.grid.SlopeGenerator;
import com.bbn.openmap.proj.EqualArc;
import com.bbn.openmap.proj.Projection;

public class DTEDSlopeGenerator
extends SlopeGenerator {
    protected OMScalingRaster raster;
    protected float generatedScale = Float.MAX_VALUE;

    public DTEDSlopeGenerator() {
    }

    public DTEDSlopeGenerator(ElevationColors elevColors) {
        super(elevColors);
    }

    protected OMRaster getRaster(OMGrid grid) {
        if (grid instanceof OMDTEDGrid) {
            OMDTEDGrid dGrid = (OMDTEDGrid)grid;
            this.raster = new OMScalingRaster(dGrid.getUpperLat(), dGrid.getLeftLon(), dGrid.getLowerLat(), dGrid.getRightLon(), dGrid.width, dGrid.height, new int[dGrid.width * dGrid.height]);
            return this.raster;
        }
        this.raster = null;
        return super.getRaster(grid);
    }

    public OMGraphic generate(OMGrid grid, Projection proj) {
        if (this.raster != null && proj instanceof EqualArc && proj.getScale() >= this.generatedScale && !this.isIncompleteImage()) {
            this.raster.generate(proj);
            return this.raster;
        }
        this.generatedScale = proj.getScale();
        return super.generate(grid, proj);
    }
}

