/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.event;

import com.bbn.openmap.OMComponent;
import com.bbn.openmap.event.MapMouseListener;
import com.bbn.openmap.event.MapMouseMode;
import com.bbn.openmap.event.MapMouseSupport;
import com.bbn.openmap.util.PropUtils;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class AbstractMouseMode
extends OMComponent
implements MapMouseMode,
Serializable {
    protected String ID = null;
    protected MapMouseSupport mouseSupport;
    protected Cursor cursor = Cursor.getDefaultCursor();
    protected transient Icon guiIcon = null;
    public transient DecimalFormat df = new DecimalFormat("0.###");
    protected transient boolean visible = true;
    protected String prettyName;
    public static final String IDProperty = "id";
    public static final String PrettyNameProperty = "prettyName";

    public AbstractMouseMode() {
        this("Unnamed Mode", true);
    }

    public AbstractMouseMode(String name, boolean shouldConsumeEvents) {
        this.mouseSupport = new MapMouseSupport(this, shouldConsumeEvents);
        this.ID = name;
        URL url = this.getClass().getResource(name + ".gif");
        if (url != null) {
            this.guiIcon = new ImageIcon(url);
        }
    }

    public String getID() {
        return this.ID;
    }

    public void setID(String id) {
        this.ID = id;
    }

    public void setPrettyName(String pn) {
        this.prettyName = pn;
    }

    public String getPrettyName() {
        if (this.prettyName == null) {
            return this.ID;
        }
        return this.prettyName;
    }

    public Cursor getModeCursor() {
        return this.cursor;
    }

    public void setModeCursor(Cursor curs) {
        this.cursor = curs;
    }

    public Icon getGUIIcon() {
        return this.guiIcon;
    }

    public void setGUIIcon(Icon icon) {
        this.guiIcon = icon;
    }

    public void setConsumeEvents(boolean value) {
        this.mouseSupport.setConsumeEvents(value);
    }

    public boolean isConsumeEvents() {
        return this.mouseSupport.isConsumeEvents();
    }

    public void addMapMouseListener(MapMouseListener l) {
        this.mouseSupport.addMapMouseListener(l);
    }

    public void removeMapMouseListener(MapMouseListener l) {
        this.mouseSupport.removeMapMouseListener(l);
    }

    public void removeAllMapMouseListeners() {
        this.mouseSupport.removeAllMapMouseListeners();
    }

    public void mouseClicked(MouseEvent e) {
        this.mouseSupport.fireMapMouseClicked(e);
    }

    public void mousePressed(MouseEvent e) {
        e.getComponent().requestFocus();
        this.mouseSupport.fireMapMousePressed(e);
    }

    public void mouseReleased(MouseEvent e) {
        this.mouseSupport.fireMapMouseReleased(e);
    }

    public void mouseEntered(MouseEvent e) {
        this.mouseSupport.fireMapMouseEntered(e);
    }

    public void mouseExited(MouseEvent e) {
        this.mouseSupport.fireMapMouseExited(e);
    }

    public void mouseDragged(MouseEvent e) {
        this.mouseSupport.fireMapMouseDragged(e);
    }

    public void mouseMoved(MouseEvent e) {
        this.mouseSupport.fireMapMouseMoved(e);
    }

    public void setActive(boolean active) {
    }

    public void setMouseSupport(MapMouseSupport support) {
        this.mouseSupport = support;
    }

    public MapMouseSupport getMouseSupport() {
        return this.mouseSupport;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean value) {
        this.visible = value;
    }

    public boolean actAsProxyFor(MapMouseMode mmm) {
        return this.actAsProxyFor(mmm, 0);
    }

    public boolean actAsProxyFor(MapMouseMode mmm, int pdm) {
        return this.mouseSupport.setProxyFor(mmm, pdm);
    }

    public boolean isProxyFor(MapMouseMode mmm) {
        return this.mouseSupport.isProxyFor(mmm);
    }

    public void releaseProxy() {
        this.mouseSupport.releaseProxy();
    }

    public void setProxyDistributionMask(int mask) {
        this.mouseSupport.setProxyDistributionMask(mask);
    }

    public int getProxyDistributionMask() {
        return this.mouseSupport.getProxyDistributionMask();
    }

    public void setProperties(String prefix, Properties props) {
        String idString;
        super.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        String prettyNameString = props.getProperty(prefix + PrettyNameProperty);
        if (prettyNameString != null) {
            this.setPrettyName(prettyNameString);
        }
        if ((idString = props.getProperty(prefix + IDProperty)) != null) {
            this.setID(idString);
        }
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        if (this.prettyName != null) {
            props.put(prefix + PrettyNameProperty, this.prettyName);
        }
        props.put(prefix + IDProperty, this.getID());
        return props;
    }

    public Properties getPropertyInfo(Properties props) {
        props = super.getPropertyInfo(props);
        props.put(PrettyNameProperty, "Presentable name for Mouse Mode.");
        props.put(IDProperty, "Internal ID for Mouse Mode, used by Layers.");
        return props;
    }

    public void listenerPaint(Graphics g) {
    }
}

