/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.event;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.event.CoordMouseMode;
import com.bbn.openmap.proj.Proj;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class NavMouseMode
extends CoordMouseMode {
    public static final transient String modeID = "Navigation";
    protected Point point1;
    protected Point point2;
    protected boolean autoZoom = false;

    public NavMouseMode() {
        this(true);
    }

    public NavMouseMode(boolean shouldConsumeEvents) {
        super(modeID, shouldConsumeEvents);
        this.setModeCursor(Cursor.getPredefinedCursor(1));
    }

    public void mousePressed(MouseEvent e) {
        if (Debug.debugging("mousemode")) {
            Debug.output(this.getID() + "|NavMouseMode.mousePressed()");
        }
        e.getComponent().requestFocus();
        if (!this.mouseSupport.fireMapMousePressed(e) && e.getSource() instanceof MapBean) {
            this.point1 = e.getPoint();
            this.point2 = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseReleased(MouseEvent e) {
        if (Debug.debugging("mousemode")) {
            Debug.output(this.getID() + "|NavMouseMode.mouseReleased()");
        }
        Object obj = e.getSource();
        this.mouseSupport.fireMapMouseReleased(e);
        if (!(obj instanceof MapBean) || !this.autoZoom || this.point1 == null) {
            return;
        }
        MapBean map = (MapBean)obj;
        Projection projection = map.getProjection();
        Proj p = (Proj)projection;
        NavMouseMode navMouseMode = this;
        synchronized (navMouseMode) {
            this.point2 = e.getPoint();
            int dx = Math.abs(this.point2.x - this.point1.x);
            int dy = Math.abs(this.point2.y - this.point1.y);
            if (dx < 5 || dy < 5) {
                this.paintRectangle(map, this.point1, this.point2);
                if (dx < 5 && dy < 5) {
                    boolean notLeftButton;
                    LatLonPoint llp = projection.inverse(e.getPoint());
                    boolean shift = e.isShiftDown();
                    boolean control = e.isControlDown();
                    boolean bl = notLeftButton = (e.getModifiers() & 0x10) == 0;
                    if (control) {
                        if (shift) {
                            p.setScale(p.getScale() * 2.0f);
                        } else {
                            p.setScale(p.getScale() / 2.0f);
                        }
                    }
                    this.point1 = null;
                    this.point2 = null;
                    p.setCenter(llp);
                    map.setProjection(p);
                }
                return;
            }
            float newScale = ProjMath.getScale(this.point1, this.point2, projection);
            int centerx = Math.min(this.point1.x, this.point2.x) + dx / 2;
            int centery = Math.min(this.point1.y, this.point2.y) + dy / 2;
            LatLonPoint center = projection.inverse(centerx, centery);
            p.setScale(newScale);
            p.setCenter(center);
            this.point1 = null;
            this.point2 = null;
            map.setProjection(p);
        }
    }

    public void mouseEntered(MouseEvent e) {
        if (Debug.debugging("mousemodedetail")) {
            Debug.output(this.getID() + "|NavMouseMode.mouseEntered()");
        }
        super.mouseEntered(e);
        this.autoZoom = true;
    }

    public void mouseExited(MouseEvent e) {
        if (Debug.debugging("mousemodedetail")) {
            Debug.output(this.getID() + "|NavMouseMode.mouseExited()");
        }
        super.mouseExited(e);
        if (e.getSource() instanceof MapBean) {
            this.autoZoom = false;
            this.paintRectangle((MapBean)e.getSource(), this.point1, this.point2);
            this.point2 = null;
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (Debug.debugging("mousemodedetail")) {
            Debug.output(this.getID() + "|NavMouseMode.mouseDragged()");
        }
        super.mouseDragged(e);
        if (e.getSource() instanceof MapBean) {
            if (!this.autoZoom) {
                return;
            }
            this.paintRectangle((MapBean)e.getSource(), this.point1, this.point2);
            this.point2 = this.getRatioPoint((MapBean)e.getSource(), this.point1, e.getPoint());
            this.paintRectangle((MapBean)e.getSource(), this.point1, this.point2);
        }
    }

    protected Point getRatioPoint(MapBean map, Point pt1, Point pt2) {
        Projection proj = map.getProjection();
        float mapRatio = (float)proj.getHeight() / (float)proj.getWidth();
        float boxHeight = pt1.y - pt2.y;
        float boxWidth = pt1.x - pt2.x;
        float boxRatio = Math.abs(boxHeight / boxWidth);
        int isNegative = -1;
        if (boxRatio > mapRatio) {
            if (boxHeight < 0.0f) {
                isNegative = 1;
            }
            boxHeight = Math.abs(mapRatio * boxWidth);
            pt2.y = pt1.y + isNegative * (int)boxHeight;
        } else if (boxRatio < mapRatio) {
            if (boxWidth < 0.0f) {
                isNegative = 1;
            }
            boxWidth = Math.abs(boxHeight / mapRatio);
            pt2.x = pt1.x + isNegative * (int)boxWidth;
        }
        return pt2;
    }

    protected void paintRectangle(MapBean map, Point pt1, Point pt2) {
        if (map != null) {
            this.paintRectangle(map.getGraphics(), pt1, pt2);
        }
    }

    protected void paintRectangle(Graphics g, Point pt1, Point pt2) {
        g.setXORMode(Color.lightGray);
        g.setColor(Color.darkGray);
        if (pt1 != null && pt2 != null) {
            int width = Math.abs(pt2.x - pt1.x);
            int height = Math.abs(pt2.y - pt1.y);
            if (width == 0) {
                ++width;
            }
            if (height == 0) {
                ++height;
            }
            g.drawRect(pt1.x < pt2.x ? pt1.x : pt2.x, pt1.y < pt2.y ? pt1.y : pt2.y, width, height);
            g.drawRect(pt1.x < pt2.x ? pt1.x + (pt2.x - pt1.x) / 2 - 1 : pt2.x + (pt1.x - pt2.x) / 2 - 1, pt1.y < pt2.y ? pt1.y + (pt2.y - pt1.y) / 2 - 1 : pt2.y + (pt1.y - pt2.y) / 2 - 1, 2, 2);
        }
    }

    public void listenerPaint(Graphics g) {
        this.paintRectangle(g, this.point1, this.point2);
    }
}

