/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.geo;

import java.util.Enumeration;

public class Geo {
    public static final double radiusKM = 6378.13662;
    public static final double radiusNM = 3443.9182;
    public static final double flattening = 0.003352819697896193;
    public static final double f = 0.9933056020041341;
    private double x;
    private double y;
    private double z;
    public static Geo north = new Geo(0.0, 0.0, 1.0);

    public static double geocentricLatitude(double geographicLatitude) {
        return Math.atan(Math.tan(geographicLatitude) * 0.9933056020041341);
    }

    public static double geographicLatitude(double geocentricLatitude) {
        return Math.atan(Math.tan(geocentricLatitude) / 0.9933056020041341);
    }

    public static double radians(double degrees) {
        return degrees * Math.PI / 180.0;
    }

    public static double degrees(double radians) {
        return radians * 180.0 / Math.PI;
    }

    public static double km(double radians) {
        return radians * 6378.13662;
    }

    public static double kmToAngle(double km) {
        return km / 6378.13662;
    }

    public static double nm(double radians) {
        return radians * 3443.9182;
    }

    public static double nmToAngle(double nm) {
        return nm / 3443.9182;
    }

    public Geo(double lat, double lon) {
        double theta = Geo.radians(lon);
        double rlat = Geo.geocentricLatitude(Geo.radians(lat));
        double c = Math.cos(rlat);
        this.x = c * Math.cos(theta);
        this.y = c * Math.sin(theta);
        this.z = Math.sin(rlat);
    }

    public static Geo createGeo(double rlatR, double rlon) {
        double theta = rlon;
        double rlat = Geo.geocentricLatitude(rlatR);
        double c = Math.cos(rlat);
        double x = c * Math.cos(theta);
        double y = c * Math.sin(theta);
        double z = Math.sin(rlat);
        return new Geo(x, y, z);
    }

    public Geo(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Geo midPoint(Geo g2) {
        return this.add(g2).normalize();
    }

    public Geo interpolate(Geo g2, double x) {
        return this.scale(x).add(g2.scale(1.0 - x)).normalize();
    }

    public String toString() {
        return "(Geo. " + this.getLatitude() + " " + this.getLongitude() + ")";
    }

    public double getLatitude() {
        return Geo.degrees(Geo.geographicLatitude(Math.atan2(this.z, Math.sqrt(this.x * this.x + this.y * this.y))));
    }

    public double getLongitude() {
        return Geo.degrees(Math.atan2(this.y, this.x));
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public double z() {
        return this.z;
    }

    public double dot(Geo b) {
        return this.x() * b.x() + this.y() * b.y() + this.z() * b.z();
    }

    public static double dot(Geo a, Geo b) {
        return a.x() * b.x() + a.y() * b.y() + a.z() * b.z();
    }

    public double length() {
        return Math.sqrt(this.dot(this));
    }

    public Geo scale(double s) {
        return new Geo(this.x() * s, this.y() * s, this.z() * s);
    }

    public Geo normalize() {
        return this.scale(1.0 / this.length());
    }

    public Geo cross(Geo b) {
        return new Geo(this.y() * b.z() - this.z() * b.y(), this.z() * b.x() - this.x() * b.z(), this.x() * b.y() - this.y() * b.x());
    }

    public double crossLength(Geo b) {
        double x = this.y() * b.z() - this.z() * b.y();
        double y = this.z() * b.x() - this.x() * b.z();
        double z = this.x() * b.y() - this.y() * b.x();
        return Math.sqrt(x * x + y * y + z * z);
    }

    public Geo crossNormalize(Geo b) {
        double x = this.y() * b.z() - this.z() * b.y();
        double y = this.z() * b.x() - this.x() * b.z();
        double z = this.x() * b.y() - this.y() * b.x();
        double L = Math.sqrt(x * x + y * y + z * z);
        return new Geo(x / L, y / L, z / L);
    }

    public static Geo crossNormalize(Geo a, Geo b) {
        return a.crossNormalize(b);
    }

    public Geo add(Geo b) {
        return new Geo(this.x() + b.x(), this.y() + b.y(), this.z() + b.z());
    }

    public Geo subtract(Geo b) {
        return new Geo(this.x() - b.x(), this.y() - b.y(), this.z() - b.z());
    }

    public double distance(Geo v2) {
        return Math.atan2(v2.crossLength(this), v2.dot(this));
    }

    public static double distance(Geo v1, Geo v2) {
        return v1.distance(v2);
    }

    public static double distance(double lat1, double lon1, double lat2, double lon2) {
        return Geo.distance(new Geo(lat1, lon1), new Geo(lat2, lon2));
    }

    public double distanceKM(Geo v2) {
        return Geo.km(this.distance(v2));
    }

    public static double distanceKM(Geo v1, Geo v2) {
        return v1.distanceKM(v2);
    }

    public static double distanceKM(double lat1, double lon1, double lat2, double lon2) {
        return Geo.distanceKM(new Geo(lat1, lon1), new Geo(lat2, lon2));
    }

    public double distanceNM(Geo v2) {
        return Geo.nm(this.distance(v2));
    }

    public static double distanceNM(Geo v1, Geo v2) {
        return v1.distanceNM(v2);
    }

    public static double distanceNM(double lat1, double lon1, double lat2, double lon2) {
        return Geo.distanceNM(new Geo(lat1, lon1), new Geo(lat2, lon2));
    }

    public double azimuth(Geo v2) {
        Geo n1 = north.cross(this);
        double s1 = n1.length();
        Geo n2 = v2.cross(this);
        double az = Math.atan2(-north.dot(n2), n1.dot(n2));
        return az > 0.0 ? az : Math.PI * 2 + az;
    }

    public static double angle(Geo p0, Geo p1, Geo p2) {
        return Math.PI - p0.cross(p1).distance(p1.cross(p2));
    }

    public static double area(Enumeration vs) {
        int count = 0;
        double area = 0.0;
        Geo v0 = (Geo)vs.nextElement();
        Geo v1 = (Geo)vs.nextElement();
        Geo p0 = v0;
        Geo p1 = v1;
        Geo p2 = null;
        while (vs.hasMoreElements()) {
            ++count;
            p2 = (Geo)vs.nextElement();
            area += Geo.angle(p0, p1, p2);
            p0 = p1;
            p1 = p2;
        }
        ++count;
        p2 = v0;
        area += Geo.angle(p0, p1, p2);
        p0 = p1;
        p1 = p2;
        p2 = v1;
        return (area += Geo.angle(p0, p1, p2)) - (double)(++count - 2) * Math.PI;
    }

    public boolean isInside(Geo v2, double radius, Geo p) {
        Geo dp;
        Geo gc = this.crossNormalize(v2);
        if (!(Math.abs(gc.dot(p)) <= Math.cos(1.5707963267948966 - radius))) {
            return false;
        }
        if (this.distance(p) <= radius || v2.distance(p) <= radius) {
            return true;
        }
        Geo d = v2.subtract(this);
        double L = d.length();
        Geo n = d.normalize();
        double size = n.dot(dp = p.subtract(this));
        return 0.0 <= size && size <= L;
    }

    public static boolean isInside(double lat1, double lon1, double lat2, double lon2, double radius, double lat3, double lon3) {
        return new Geo(lat1, lon1).isInside(new Geo(lat2, lon2), radius, new Geo(lat3, lon3));
    }

    public boolean inBubble(Geo v2, double forwardRadius, double backRadius, Geo p) {
        return this.distance(p) <= (v2.subtract(this).normalize().dot(p.subtract(this)) > 0.0 ? forwardRadius : backRadius);
    }

    public Geo antipode() {
        return this.scale(-1.0);
    }

    public Geo intersect(Geo q, Geo r) {
        double a = this.dot(r);
        double b = q.dot(r);
        double x = -b / (a - b);
        return this.scale(x).add(q.scale(1.0 - x)).normalize();
    }
}

