/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.event.CenterEvent;
import com.bbn.openmap.event.CenterListener;
import com.bbn.openmap.event.CenterSupport;
import com.bbn.openmap.gui.CoordPanel;
import com.bbn.openmap.gui.DMSCoordPanel;
import com.bbn.openmap.gui.MGRSCoordPanel;
import com.bbn.openmap.gui.OMComponentPanel;
import com.bbn.openmap.gui.UTMCoordPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class CombinedCoordPanel
extends OMComponentPanel
implements Serializable,
ActionListener,
CenterListener {
    protected transient JButton closebutton;
    protected transient JButton applybutton;
    protected transient JTabbedPane tabPane;
    protected transient CoordPanel coordPanel;
    protected transient DMSCoordPanel dmsPanel;
    protected transient UTMCoordPanel utmPanel;
    protected transient MGRSCoordPanel mgrsPanel;
    protected transient CenterSupport centerDelegate;
    public static final String DEFAULT_COMMENT = "Set Center of Map to Coordinates:";
    public static final String CloseCmd = "Close";

    public CombinedCoordPanel() {
        this.setup(DEFAULT_COMMENT, null);
    }

    public CombinedCoordPanel(ActionListener closeButtonListener) {
        this.setup(DEFAULT_COMMENT, closeButtonListener);
    }

    public CombinedCoordPanel(String comment, ActionListener closeButtonListener) {
        this.setup(comment, closeButtonListener);
    }

    protected void setup(String comment, ActionListener closeButtonListener) {
        this.centerDelegate = new CenterSupport(this);
        this.addCenterListener(this);
        this.setLayout(new BoxLayout(this, 1));
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new BoxLayout(titlePanel, 0));
        JLabel clarification = new JLabel(comment);
        titlePanel.add(clarification);
        this.add(titlePanel);
        this.coordPanel = new CoordPanel(this.centerDelegate);
        this.dmsPanel = new DMSCoordPanel(this.centerDelegate);
        this.utmPanel = new UTMCoordPanel(this.centerDelegate);
        this.mgrsPanel = new MGRSCoordPanel(this.centerDelegate);
        this.tabPane = new JTabbedPane();
        this.tabPane.addTab("Dec Deg", this.coordPanel);
        this.tabPane.addTab("DMS", this.dmsPanel);
        this.tabPane.addTab("UTM", this.utmPanel);
        this.tabPane.addTab("MGRS", this.mgrsPanel);
        this.add(this.tabPane);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        this.applybutton = new JButton("Apply");
        this.applybutton.addActionListener(this);
        buttonPanel.add(this.applybutton);
        if (closeButtonListener != null) {
            this.closebutton = new JButton(CloseCmd);
            this.closebutton.setActionCommand(CloseCmd);
            this.closebutton.addActionListener(closeButtonListener);
            buttonPanel.add(this.closebutton);
        }
        this.add(buttonPanel);
    }

    public LatLonPoint getLatLon() {
        return this.coordPanel.getLatLon();
    }

    public void setLatLon(LatLonPoint llpoint) {
        this.coordPanel.setLatLon(llpoint);
        this.dmsPanel.setLatLon(llpoint);
        this.utmPanel.setLatLon(llpoint);
        this.mgrsPanel.setLatLon(llpoint);
    }

    public boolean setCenter() {
        return ((CoordPanel)this.tabPane.getSelectedComponent()).setCenter();
    }

    public void actionPerformed(ActionEvent e) {
        boolean allOK;
        if (e.getSource() == this.applybutton && !(allOK = this.setCenter())) {
            this.setLatLon(null);
        }
    }

    public void addCenterListener(CenterListener listener) {
        this.centerDelegate.addCenterListener(listener);
    }

    public void removeCenterListener(CenterListener listener) {
        this.centerDelegate.removeCenterListener(listener);
    }

    public void center(CenterEvent centerEvent) {
        this.setLatLon(new LatLonPoint(centerEvent.getLatitude(), centerEvent.getLongitude()));
    }

    public void findAndInit(Object someObj) {
        if (someObj instanceof CenterListener) {
            this.addCenterListener((CenterListener)someObj);
        }
    }

    public void findAndUndo(Object someObj) {
        if (someObj instanceof CenterListener) {
            this.removeCenterListener((CenterListener)someObj);
        }
    }
}

