/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.event.CenterListener;
import com.bbn.openmap.event.CenterSupport;
import com.bbn.openmap.util.Debug;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.Serializable;
import java.text.DecimalFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class CoordPanel
extends JPanel
implements Serializable {
    protected transient JTextField latitude;
    protected transient JTextField longitude;
    protected transient CenterSupport centerDelegate;
    protected DecimalFormat df = new DecimalFormat("0.###");

    public CoordPanel() {
        this.centerDelegate = new CenterSupport(this);
        this.makeWidgets();
    }

    public CoordPanel(CenterSupport support) {
        this.centerDelegate = support;
        this.makeWidgets();
    }

    protected void makeWidgets() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        this.setBorder(new TitledBorder(new EtchedBorder(), "Decimal Degrees"));
        JLabel latlabel = new JLabel("Latitude: ");
        c.gridx = 0;
        c.gridy = 0;
        gridbag.setConstraints(latlabel, c);
        this.add(latlabel);
        this.latitude = new JTextField(10);
        c.gridx = 1;
        c.gridy = 0;
        gridbag.setConstraints(this.latitude, c);
        this.add(this.latitude);
        JLabel lonlabel = new JLabel("Longitude: ");
        c.gridx = 0;
        c.gridy = 1;
        gridbag.setConstraints(lonlabel, c);
        this.add(lonlabel);
        this.longitude = new JTextField(10);
        c.gridx = 1;
        c.gridy = 1;
        gridbag.setConstraints(this.longitude, c);
        this.add(this.longitude);
    }

    public LatLonPoint getLatLon() {
        float lon;
        float lat;
        try {
            lat = Float.valueOf(this.latitude.getText()).floatValue();
            lon = Float.valueOf(this.longitude.getText()).floatValue();
        }
        catch (NumberFormatException except) {
            Debug.error("CoordPanel.getLatLon(): " + except.toString());
            this.clearTextBoxes();
            return null;
        }
        if (Debug.debugging("coordpanel")) {
            Debug.output("CoordPanel.getLatLon(): lat= " + lat + ", lon= " + lon);
        }
        return new LatLonPoint(lat, lon);
    }

    public void setLatLon(LatLonPoint llpoint) {
        if (llpoint == null) {
            this.clearTextBoxes();
        } else {
            this.latitude.setText("" + llpoint.getLatitude());
            this.longitude.setText("" + llpoint.getLongitude());
        }
    }

    public boolean setCenter() {
        LatLonPoint llp = this.getLatLon();
        if (llp == null) {
            return false;
        }
        if (Debug.debugging("coordpanel")) {
            Debug.output("CoordPanel.setCenter(): " + llp);
        }
        this.centerDelegate.fireCenter(llp.getLatitude(), llp.getLongitude());
        return true;
    }

    protected void clearTextBoxes() {
        this.latitude.setText("");
        this.longitude.setText("");
    }

    public void addCenterListener(CenterListener listener) {
        this.centerDelegate.addCenterListener(listener);
    }

    public void removeCenterListener(CenterListener listener) {
        this.centerDelegate.removeCenterListener(listener);
    }
}

