/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui;

import com.bbn.openmap.MapBean;
import com.bbn.openmap.gui.OMToolComponent;
import com.bbn.openmap.omGraphics.OMAction;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.event.SelectionEvent;
import com.bbn.openmap.omGraphics.event.SelectionListener;
import com.bbn.openmap.omGraphics.event.SelectionProvider;
import com.bbn.openmap.tools.drawing.DrawingToolRequestor;
import com.bbn.openmap.tools.drawing.OMDrawingTool;
import com.bbn.openmap.util.Debug;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;

public class OMGraphicDeleteTool
extends OMToolComponent
implements SelectionListener,
ActionListener,
KeyListener {
    protected JButton deleteButton = null;
    protected String defaultKey = "omgraphicdeletetool";
    protected Hashtable deleteList;
    protected Vector requestors;
    protected JToolBar jToolBar;

    public OMGraphicDeleteTool() {
        this.setKey(this.defaultKey);
        Debug.message("deletebutton", "OMGTL()");
        this.setLayout(new GridLayout());
        this.jToolBar = new JToolBar();
        this.jToolBar.setFloatable(false);
        this.deleteList = new Hashtable();
        this.requestors = new Vector();
        URL url = this.getClass().getResource("delete.gif");
        if (url != null) {
            ImageIcon icon = new ImageIcon(url);
            this.deleteButton = new JButton(icon);
        } else {
            this.deleteButton = new JButton("Delete");
        }
        this.deleteButton.addActionListener(this);
        this.deleteButton.setToolTipText("Delete selected map graphic");
        this.deleteButton.setEnabled(false);
        this.jToolBar.add(this.deleteButton);
        this.add(this.jToolBar);
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 8) {
            this.deleteSelected();
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void actionPerformed(ActionEvent ae) {
        Debug.message("deletebutton", "OMGDT.actionPerformed()");
        this.deleteSelected();
    }

    public void deleteSelected() {
        Iterator it = this.deleteList.values().iterator();
        while (it.hasNext()) {
            SelectionEvent item = (SelectionEvent)it.next();
            Object itemSource = item.getSource();
            if (itemSource instanceof OMDrawingTool) {
                ((OMDrawingTool)itemSource).deactivate(4);
                continue;
            }
            if (item == null) continue;
            DrawingToolRequestor requestor = item.getRequestor();
            OMGraphic omg = item.getOMGraphic();
            if (requestor != null) {
                requestor.drawingComplete(omg, new OMAction(4));
                continue;
            }
            Iterator reqs = this.requestors.iterator();
            while (reqs.hasNext()) {
                ((DrawingToolRequestor)reqs.next()).drawingComplete(omg, new OMAction(4));
            }
        }
        this.deleteList.clear();
        this.deleteButton.setEnabled(!this.deleteList.isEmpty());
    }

    public void selectionNotification(SelectionEvent event) {
        if (event.isSelected() && event.getOMGraphic() != null) {
            Debug.message("deletebutton", "OMGDT.selection notification: adding selected to list.");
            this.deleteList.put(event.getOMGraphic(), event);
        } else if (!event.isSelected()) {
            Debug.message("deletebutton", "OMGDT.selection notification: removing selected from list.");
            this.deleteList.remove(event.getOMGraphic());
        } else {
            Debug.message("deletebutton", "OMGDT.selection notification: omgraphic missing from notification.");
        }
        this.deleteButton.setEnabled(!this.deleteList.isEmpty());
    }

    public void findAndInit(Object obj) {
        if (obj instanceof SelectionProvider) {
            Debug.message("deletebutton", "OMGDT.findAndInit() found selection provider");
            ((SelectionProvider)obj).addSelectionListener(this);
        }
        if (obj instanceof DrawingToolRequestor) {
            this.requestors.add((DrawingToolRequestor)obj);
        }
        if (obj instanceof MapBean) {
            ((MapBean)obj).addKeyListener(this);
        }
    }

    public void findAndUndo(Object obj) {
        if (obj instanceof SelectionProvider) {
            ((SelectionProvider)obj).removeSelectionListener(this);
        }
        if (obj instanceof DrawingToolRequestor) {
            this.requestors.remove((DrawingToolRequestor)obj);
        }
        if (obj instanceof MapBean) {
            ((MapBean)obj).removeKeyListener(this);
        }
    }
}

