/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui;

import com.bbn.openmap.Environment;
import com.bbn.openmap.event.ProgressEvent;
import com.bbn.openmap.event.ProgressListener;
import com.bbn.openmap.util.Debug;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class ProgressListenerGauge
extends JPanel
implements ProgressListener {
    protected JLabel message;
    protected JProgressBar jpb;
    protected boolean createWindowsForDisplay = false;
    protected String title;
    protected transient JFrame progressWindowFrame;
    protected transient JInternalFrame progressWindow;

    public ProgressListenerGauge() {
        this.init();
    }

    public ProgressListenerGauge(String windowTitle) {
        this.init();
        this.createWindowsForDisplay = true;
        this.title = windowTitle;
    }

    protected void manageWindow(boolean visible) {
        if (visible) {
            if (this.progressWindow == null && this.progressWindowFrame == null) {
                if (Environment.getBoolean("openmap.UseInternalFrames")) {
                    this.progressWindow = new JInternalFrame(this.title, true, true, false, true);
                    this.progressWindow.setContentPane(this);
                    this.progressWindow.pack();
                    this.progressWindow.setOpaque(true);
                    this.progressWindow.setDefaultCloseOperation(2);
                    this.setPosition(this.progressWindow);
                    JLayeredPane desktop = Environment.getInternalFrameDesktop();
                    if (desktop != null) {
                        desktop.remove(this.progressWindow);
                        desktop.add((Component)this.progressWindow, JLayeredPane.POPUP_LAYER);
                        this.progressWindow.show();
                    }
                } else {
                    this.progressWindowFrame = new JFrame(this.title);
                    this.progressWindowFrame.setContentPane(this);
                    this.progressWindowFrame.pack();
                    this.setPosition(this.progressWindowFrame);
                    this.progressWindowFrame.setState(0);
                    this.progressWindowFrame.show();
                    this.progressWindowFrame.setDefaultCloseOperation(2);
                }
            }
            if (this.progressWindow != null) {
                this.progressWindow.toFront();
            } else if (this.progressWindowFrame != null) {
                this.progressWindowFrame.toFront();
            }
        } else if (this.progressWindow != null) {
            this.progressWindow.dispose();
            this.progressWindow = null;
        } else if (this.progressWindowFrame != null) {
            this.progressWindowFrame.dispose();
            this.progressWindowFrame = null;
        }
    }

    protected void init() {
        this.setLayout(new BorderLayout());
        this.add((Component)new JLabel("     "), "East");
        this.add((Component)new JLabel("     "), "West");
        this.add((Component)new JLabel("      "), "North");
        this.add((Component)new JLabel("      "), "South");
        this.message = new JLabel("");
        this.jpb = new JProgressBar(0, 0, 100);
        JPanel cpanel = new JPanel();
        cpanel.setLayout(new GridLayout(0, 1));
        cpanel.add(this.jpb);
        cpanel.add(this.message);
        this.add((Component)cpanel, "Center");
        this.setPreferredSize(new Dimension(300, 75));
    }

    public void setVisible(boolean set) {
        if (this.createWindowsForDisplay) {
            this.manageWindow(set);
        } else {
            super.setVisible(set);
        }
    }

    public void updateProgress(ProgressEvent evt) {
        int type = evt.getType();
        if (type == 0 || type == 1) {
            this.setVisible(true);
            this.message.setText(evt.getTaskDescription());
            this.jpb.setValue(evt.getPercentComplete());
        } else {
            this.setVisible(false);
        }
    }

    protected void setPosition(Component comp) {
        int w = comp.getWidth();
        int h = comp.getHeight();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        Debug.message("basic", "Screen dimensions are " + d);
        int x = d.width / 2 - w / 2;
        int y = d.height / 2 - h / 2;
        if (Debug.debugging("basic")) {
            Debug.output("Setting PLG frame X and Y from properties to " + x + " " + y);
        }
        comp.setBounds(x, y, w, h);
    }

    public void toFront() {
        if (this.progressWindow != null) {
            this.progressWindow.toFront();
        } else if (this.progressWindowFrame != null) {
            this.progressWindowFrame.toFront();
        }
    }
}

