/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui.menu;

import com.bbn.openmap.MapBean;
import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.event.ProjectionListener;
import com.bbn.openmap.event.ProjectionSupport;
import com.bbn.openmap.gui.AbstractOpenMapMenu;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.ProjectionFactory;
import com.bbn.openmap.util.Debug;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;

public class ProjectionMenu
extends AbstractOpenMapMenu
implements ActionListener,
ProjectionListener {
    protected transient ProjectionSupport projectionSupport = new ProjectionSupport(this);
    protected transient Projection projection;
    protected transient Component projComponent;
    public static final transient String projCmd = "setProj";

    public ProjectionMenu() {
        this.setText("Projection");
        ButtonGroup group = new ButtonGroup();
        String[] availableProjections = ProjectionFactory.getAvailableProjections();
        int i = 0;
        while (i < availableProjections.length) {
            JRadioButtonMenuItem rb = (JRadioButtonMenuItem)this.add(new JRadioButtonMenuItem(this.i18n.get(this, "proj." + availableProjections[i], availableProjections[i])));
            rb.setActionCommand(projCmd);
            rb.setName("" + ProjectionFactory.getProjType(availableProjections[i]));
            rb.addActionListener(this);
            group.add(rb);
            ++i;
        }
    }

    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        Debug.message("projectionmenu", "ProjectionMenu.actionPerformed(): " + command);
        if (command.startsWith(projCmd)) {
            JRadioButtonMenuItem rb = (JRadioButtonMenuItem)ae.getSource();
            short projType = Short.parseShort(rb.getName());
            Debug.message("projectionmenu", "ProjectionMenu.projType: " + projType);
            Projection newProj = ProjectionFactory.makeProjection(projType, this.projection);
            this.fireProjectionChanged(newProj);
        }
    }

    public void projectionChanged(ProjectionEvent e) {
        if (Debug.debugging("projectionmenu")) {
            System.out.println("ProjectionMenu.projectionChanged()");
        }
        Projection newProj = e.getProjection();
        if (this.projection == null || !this.projection.equals(newProj)) {
            this.setProjection(newProj.makeClone());
            Object source = e.getSource();
            if (source instanceof Component) {
                this.projComponent = (Component)source;
            }
        }
    }

    protected synchronized void setProjection(Projection aProjection) {
        this.projection = aProjection;
        int projType = this.projection.getProjectionType();
        int i = 0;
        while (i < this.getItemCount()) {
            try {
                JMenuItem item = this.getItem(i);
                int projID = Integer.parseInt(item.getName());
                if (projID == projType) {
                    this.getItem(i).setSelected(true);
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public void setupListeners(MapBean map) {
        Debug.message("projectionmenu", "ProjectionMenu | setupListeners");
        this.addProjectionListener(map);
        map.addProjectionListener(this);
    }

    public void undoListeners(MapBean map) {
        this.removeProjectionListener(map);
        map.removeProjectionListener(this);
    }

    protected synchronized void addProjectionListener(ProjectionListener l) {
        this.projectionSupport.addProjectionListener(l);
    }

    protected synchronized void removeProjectionListener(ProjectionListener l) {
        this.projectionSupport.removeProjectionListener(l);
    }

    public void fireProjectionChanged(Projection p) {
        this.projectionSupport.fireProjectionChanged(p);
    }

    public void findAndInit(Object someObj) {
        if (someObj instanceof MapBean) {
            this.setupListeners((MapBean)someObj);
        }
    }

    public void findAndUndo(Object someObj) {
        if (someObj instanceof MapBean) {
            this.undoListeners((MapBean)someObj);
        }
    }
}

