/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.image;

import com.bbn.openmap.image.ImageHelper;
import com.bbn.openmap.util.ComponentFactory;
import com.bbn.openmap.util.Debug;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import javax.swing.ImageIcon;

public class BufferedImageHelper {
    private static Object jaiObj = null;
    private static boolean checkedForJAI = false;

    private BufferedImageHelper() {
    }

    protected static Object getJAI() {
        if (!checkedForJAI) {
            jaiObj = ComponentFactory.create("javax.media.jai.JAI");
            checkedForJAI = true;
        }
        return jaiObj;
    }

    public static BufferedImage getJAIBufferedImage(String opName, Object param) {
        block13: {
            boolean DEBUG = Debug.debugging("bufferedimage");
            Object jai = BufferedImageHelper.getJAI();
            if (jai == null) {
                return null;
            }
            if (DEBUG) {
                Debug.output("Using JAI to create image from " + opName);
            }
            try {
                Class[] createArgs = new Class[]{Class.forName("java.lang.String"), Class.forName("java.lang.Object")};
                Method createMethod = jai.getClass().getDeclaredMethod("create", createArgs);
                Object[] createParams = new Object[]{opName, param};
                Object planarImageObject = createMethod.invoke(jai, createParams);
                if (planarImageObject != null) {
                    Method getBufferedImageMethod = planarImageObject.getClass().getMethod("getAsBufferedImage", null);
                    return (BufferedImage)getBufferedImageMethod.invoke(planarImageObject, null);
                }
            }
            catch (ClassNotFoundException cnfe) {
                if (DEBUG) {
                    Debug.error("BufferedImageHelper.getJAIBufferedImage() ClassNotFoundException error: \n" + cnfe.getMessage());
                }
            }
            catch (IllegalAccessException iae) {
                if (DEBUG) {
                    Debug.error("BufferedImageHelper.getJAIBufferedImage() IllegalAccessException error: \n" + iae.getMessage());
                }
            }
            catch (InvocationTargetException ite) {
                if (DEBUG) {
                    Debug.error("BufferedImageHelper.getJAIBufferedImage() InvocationTargetException error: \n" + ite.getMessage());
                }
            }
            catch (NoSuchMethodException nsme) {
                if (DEBUG) {
                    Debug.error("BufferedImageHelper.getJAIBufferedImage() NoSuchMethodException error: " + nsme.toString());
                    nsme.printStackTrace();
                }
            }
            catch (SecurityException se) {
                if (!DEBUG) break block13;
                Debug.error("BufferedImageHelper.getJAIBufferedImage() SecurityException error: \n" + se.getMessage());
            }
        }
        return null;
    }

    public static BufferedImage getJAIBufferedImage(String opName, Object param, int x, int y, int w, int h) throws InterruptedException {
        BufferedImage bi = BufferedImageHelper.getJAIBufferedImage(opName, param);
        if (bi != null && (x != 0 || y != 0 || w > 0 || h > 0)) {
            int imageType = 1;
            if (bi.getColorModel().hasAlpha()) {
                imageType = 2;
            }
            return BufferedImageHelper.getBufferedImage(bi, x, y, w, h, imageType);
        }
        return bi;
    }

    public static BufferedImage getBufferedImage(URL url) throws InterruptedException {
        return BufferedImageHelper.getBufferedImage(url, 0, 0, -1, -1);
    }

    public static BufferedImage getBufferedImage(URL url, int x, int y, int w, int h) throws InterruptedException {
        BufferedImage bi = BufferedImageHelper.getJAIBufferedImage("url", url, x, y, w, h);
        if (bi != null) {
            return bi;
        }
        if (Debug.debugging("bufferedimage")) {
            Debug.output("BufferedImageHelper.getBufferedImage(URL) can't use JAI, using ImageIcon");
        }
        ImageIcon ii = new ImageIcon(url);
        if (w <= 0) {
            w = ii.getIconWidth();
        }
        if (h <= 0) {
            h = ii.getIconHeight();
        }
        return BufferedImageHelper.getBufferedImage(ii.getImage(), x, y, w, h, 2);
    }

    public static BufferedImage getBufferedImage(String path) throws InterruptedException {
        return BufferedImageHelper.getBufferedImage(path, 0, 0, -1, -1);
    }

    public static BufferedImage getBufferedImage(String path, int x, int y, int w, int h) throws InterruptedException {
        BufferedImage bi = BufferedImageHelper.getJAIBufferedImage("file", path, x, y, w, h);
        if (bi != null) {
            return bi;
        }
        if (Debug.debugging("bufferedimage")) {
            Debug.output("BufferedImageHelper.getBufferedImage(path) can't use JAI, using ImageIcon");
        }
        ImageIcon ii = new ImageIcon(path);
        if (w <= 0) {
            w = ii.getIconWidth();
        }
        if (h <= 0) {
            h = ii.getIconHeight();
        }
        return BufferedImageHelper.getBufferedImage(ii.getImage(), x, y, w, h, 2);
    }

    public static BufferedImage getBufferedImage(Image image, int x, int y, int w, int h) throws InterruptedException {
        return BufferedImageHelper.getBufferedImage(image, x, y, w, h, 1);
    }

    public static BufferedImage getBufferedImage(Image image, int x, int y, int w, int h, int imageType) throws InterruptedException {
        if (w <= 0 || h <= 0) {
            if (Debug.debugging("bufferedimage")) {
                Debug.output("BufferedImageHelper.getBufferedImage() don't know h/w, using pixel grabber");
            }
            return BufferedImageHelper.getBufferedImageFromPixelGrabber(image, x, y, w, h, imageType);
        }
        BufferedImage bufferedImage = new BufferedImage(w, h, imageType);
        Graphics2D g2d = bufferedImage.createGraphics();
        g2d.drawImage(image, x, y, null);
        g2d.dispose();
        return bufferedImage;
    }

    public static BufferedImage getBufferedImageFromPixelGrabber(Image image, int x, int y, int w, int h, int imageType) {
        PixelGrabber pg = new PixelGrabber(image, x, y, w, h, true);
        int[] pixels = ImageHelper.grabPixels(pg);
        if (pixels == null) {
            return null;
        }
        w = pg.getWidth();
        h = pg.getHeight();
        pg = null;
        BufferedImage bi = new BufferedImage(w, h, imageType);
        if (Debug.debugging("imagehelper")) {
            Debug.output("BufferedImageHelper.getBufferedImage(): Got buffered image...");
        }
        bi.setRGB(0, 0, w, h, pixels, 0, w);
        if (Debug.debugging("imagehelper")) {
            Debug.output("BufferedImageHelper.getBufferedImage(): set pixels in image...");
        }
        return bi;
    }
}

