/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.io;

import com.bbn.openmap.layer.util.LayerUtils;
import com.bbn.openmap.util.CSVTokenizer;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.HandleError;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Vector;

public class CSVFile {
    public URL infoUrl;
    protected Vector infoRecords = null;
    protected Vector headerRecord = null;
    protected boolean headersExist = true;

    public CSVFile(String name) throws MalformedURLException {
        this.infoUrl = LayerUtils.getResourceOrFileOrURL(null, name);
    }

    public CSVFile(URL url) throws MalformedURLException {
        this.infoUrl = url;
    }

    public void setHeadersExist(boolean set) {
        this.headersExist = set;
    }

    public boolean isHeadersExist() {
        return this.headersExist;
    }

    public void loadData() {
        this.loadData(false);
    }

    public void loadData(boolean readNumbersAsStrings) {
        BufferedReader streamReader = null;
        Vector records = new Vector();
        try {
            Object token = null;
            boolean header_read = false;
            if (!this.headersExist) {
                header_read = true;
                this.headerRecord = new Vector();
            }
            URL csvURL = this.infoUrl;
            streamReader = new BufferedReader(new InputStreamReader(csvURL.openStream()));
            CSVTokenizer csvt = new CSVTokenizer((Reader)streamReader, readNumbersAsStrings);
            Object name = null;
            Object abbreviation = null;
            int count = 0;
            token = csvt.token();
            while (!csvt.isEOF(token)) {
                ++count;
                Vector<Object> rec_line = new Vector<Object>();
                while (!csvt.isNewline(token)) {
                    rec_line.addElement(token);
                    token = csvt.token();
                    if (csvt.isEOF(token)) break;
                }
                if (header_read) {
                    records.addElement(rec_line);
                } else if (this.headersExist) {
                    this.headerRecord = rec_line;
                    header_read = true;
                }
                if (Debug.debugging("csv")) {
                    Debug.output("CSVFile.read: " + rec_line);
                }
                token = csvt.token();
            }
        }
        catch (IOException ioe) {
            throw new HandleError(ioe);
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            throw new HandleError(aioobe);
        }
        catch (ClassCastException cce) {
            throw new HandleError(cce);
        }
        try {
            if (streamReader != null) {
                streamReader.close();
            }
        }
        catch (IOException ioe) {
            throw new HandleError(ioe);
        }
        this.infoRecords = records;
        if (Debug.debugging("csv")) {
            Debug.output("CSVFile: read in " + this.infoRecords.size() + " records");
        }
    }

    public Vector getRecord(int recordnumber) {
        Vector vector;
        try {
            vector = (Vector)this.infoRecords.elementAt(recordnumber);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Debug.error(this.infoUrl.toString() + ": Don't have information for shape record " + recordnumber);
            return null;
        }
        return vector;
    }

    public Iterator iterator() {
        return this.infoRecords.iterator();
    }
}

