/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer;

import com.bbn.openmap.BufferedMapBean;
import com.bbn.openmap.Layer;
import com.bbn.openmap.LayerHandler;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.layer.util.LayerUtils;
import com.bbn.openmap.omGraphics.OMColor;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class BufferedLayer
extends Layer
implements PropertyChangeListener {
    public static final String LayersProperty = "layers";
    public static final String VisibleLayersProperty = "visibleLayers";
    public static final String HasActiveLayersProperty = "hasActiveLayers";
    protected boolean hasActiveLayers = false;
    protected boolean hasTransparentBackground = true;
    MapBean mapBean;
    JPanel panel = null;

    public BufferedLayer() {
        this.setLayout(new BorderLayout());
        BLMapBean mb = new BLMapBean(this);
        this.setMapBean(mb);
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.hasActiveLayers = LayerUtils.booleanFromProperties(props, prefix + HasActiveLayersProperty, this.hasActiveLayers);
        Vector layersValue = PropUtils.parseSpacedMarkers(props.getProperty(prefix + LayersProperty));
        Vector startuplayers = PropUtils.parseSpacedMarkers(props.getProperty(prefix + VisibleLayersProperty));
        Layer[] layers = LayerHandler.getLayers(layersValue, startuplayers, props);
        int i = 0;
        while (i < layers.length) {
            this.mapBean.add(layers[i]);
            ++i;
        }
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        return props;
    }

    public Properties getPropertyInfo(Properties props) {
        props = super.getPropertyInfo(props);
        return props;
    }

    public void setHasActiveLayers(boolean value) {
        this.hasActiveLayers = value;
    }

    public boolean getHasActiveLayers() {
        return this.hasActiveLayers;
    }

    public void setHasTransparentBackground(boolean value) {
        this.hasTransparentBackground = value;
    }

    public boolean getHasTransparentBackground() {
        return this.hasTransparentBackground;
    }

    public void clearLayers() {
        this.mapBean.removeAll();
        this.resetPalette();
    }

    public void addLayer(Layer layer) {
        this.mapBean.add(layer);
        this.resetPalette();
    }

    public void removeLayer(Layer layer) {
        this.mapBean.remove(layer);
        this.resetPalette();
    }

    public boolean hasLayers() {
        return this.mapBean.getComponentCount() > 0;
    }

    public Component[] getLayers() {
        return this.mapBean.getComponents();
    }

    public void firePaletteEvent(ComponentEvent event) {
        super.firePaletteEvent(event);
        this.hasActiveLayers = event.getID() == 102;
    }

    public void setMapBean(MapBean mb) {
        if (this.mapBean != null) {
            this.remove(this.mapBean);
        }
        this.mapBean = mb;
        this.add((Component)this.mapBean, "Center");
    }

    public MapBean getMapBean() {
        return this.mapBean;
    }

    public void setBackground(Color color) {
        this.setBckgrnd(color);
    }

    public void setBckgrnd(Paint paint) {
        this.mapBean.setBckgrnd(paint);
        if (paint instanceof Color) {
            this.setHasTransparentBackground(((Color)paint).getAlpha() < 255);
        } else {
            this.setHasTransparentBackground(true);
        }
    }

    public Color getBackground() {
        return this.mapBean.getBackground();
    }

    public Paint getBckgrnd(Paint paint) {
        return this.mapBean.getBckgrnd();
    }

    public void projectionChanged(ProjectionEvent pe) {
        Projection proj = this.setProjection(pe);
        if (proj != null && this.mapBean instanceof BLMapBean && this.hasTransparentBackground) {
            ((BLMapBean)this.mapBean).wipeImage();
        }
        this.mapBean.setProjection(proj);
    }

    public void resetPalette() {
        this.panel = null;
        super.resetPalette();
    }

    public Component getGUI() {
        if (this.panel == null) {
            Component[] layerComps = this.getLayers();
            this.panel = new JPanel();
            JTabbedPane tabs = new JTabbedPane();
            JPanel bfPanel = new JPanel();
            bfPanel.setLayout(new BoxLayout(bfPanel, 1));
            bfPanel.setAlignmentX(0.5f);
            bfPanel.setAlignmentY(0.5f);
            tabs.addTab("Layer Visibility", bfPanel);
            int i = 0;
            while (i < layerComps.length) {
                Layer layer = (Layer)layerComps[i];
                Component layerGUI = layer.getGUI();
                if (layerGUI != null) {
                    tabs.addTab(layer.getName(), layerGUI);
                }
                VisHelper layerVisibility = new VisHelper(layer);
                bfPanel.add(layerVisibility);
                ++i;
            }
            this.panel.add(tabs);
        }
        return this.panel;
    }

    public void paint(Graphics g) {
        if (this.hasLayers()) {
            super.paint(g);
        }
    }

    public void renderDataForProjection(Projection proj, Graphics g) {
        Component[] layersComps = this.mapBean.getComponents();
        int i = layersComps.length - 1;
        while (i >= 0) {
            Layer layer = (Layer)layersComps[i];
            layer.renderDataForProjection(proj, g);
            --i;
        }
    }

    public void propertyChange(PropertyChangeEvent pce) {
        if (pce.getPropertyName() == "MapBean.background") {
            this.mapBean.setBckgrnd((Paint)pce.getNewValue());
        }
    }

    public class BLMapBean
    extends BufferedMapBean {
        Layer layer;

        public BLMapBean(Layer parent) {
            this.background = OMColor.clear;
            this.layer = parent;
        }

        public void repaint() {
            this.setBufferDirty(true);
            if (Debug.debugging("bufferedlayer")) {
                Debug.output("BLMapBean.repaint() has active layers = " + BufferedLayer.this.hasActiveLayers);
            }
            if (BufferedLayer.this.hasActiveLayers && BufferedLayer.this.hasTransparentBackground) {
                this.wipeImage();
            }
            if (this.layer != null) {
                this.layer.repaint();
            }
        }

        public void wipeImage() {
            this.setBufferDirty(true);
            if (this.getBackground() == OMColor.clear) {
                this.drawingBuffer = this.createImage(this.getWidth(), this.getHeight());
            }
        }

        public Image createImage(int width, int height) {
            if (Debug.debugging("bufferedlayer")) {
                Debug.output("BLMapBean.createImage()");
            }
            if (width <= 0) {
                width = 1;
            }
            if (height <= 0) {
                height = 1;
            }
            return new BufferedImage(width, height, 2);
        }
    }

    protected class VisHelper
    extends JCheckBox
    implements ActionListener {
        Layer layer;

        public VisHelper(Layer l) {
            super(l.getName(), l.isVisible());
            super.addActionListener(this);
            this.layer = l;
        }

        public void actionPerformed(ActionEvent ae) {
            this.layer.setVisible(((JCheckBox)ae.getSource()).isSelected());
            if (Debug.debugging("bufferedlayer")) {
                Debug.output("Turning " + this.layer.getName() + (((JCheckBox)ae.getSource()).isSelected() ? " on" : " off"));
            }
            if (BufferedLayer.this.mapBean instanceof BLMapBean && BufferedLayer.this.hasTransparentBackground) {
                ((BLMapBean)BufferedLayer.this.mapBean).wipeImage();
            }
            this.layer.repaint();
        }
    }
}

