/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer;

import com.bbn.openmap.Layer;
import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.event.InfoDisplayEvent;
import com.bbn.openmap.event.MapMouseListener;
import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.layer.policy.ProjectionChangePolicy;
import com.bbn.openmap.layer.policy.RenderPolicy;
import com.bbn.openmap.layer.policy.StandardPCPolicy;
import com.bbn.openmap.layer.policy.StandardRenderPolicy;
import com.bbn.openmap.omGraphics.FilterSupport;
import com.bbn.openmap.omGraphics.OMAction;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.event.GestureResponsePolicy;
import com.bbn.openmap.omGraphics.event.MapMouseInterpreter;
import com.bbn.openmap.omGraphics.event.StandardMapMouseInterpreter;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.ComponentFactory;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import com.bbn.openmap.util.SwingWorker;
import java.awt.Graphics;
import java.awt.Shape;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

public class OMGraphicHandlerLayer
extends Layer
implements GestureResponsePolicy {
    public static final String ProjectionChangePolicyProperty = "projectionChangePolicy";
    public static final String RenderPolicyProperty = "renderPolicy";
    public static final String MouseModesProperty = "mouseModes";
    public static final String ConsumeEventsProperty = "consumeEvents";
    protected FilterSupport filter = new FilterSupport();
    protected ProjectionChangePolicy projectionChangePolicy = null;
    protected RenderPolicy renderPolicy = null;
    protected SwingWorker layerWorker;
    protected String[] mouseModeIDs = null;
    protected boolean consumeEvents = false;
    protected boolean cancelled = false;
    protected MapMouseInterpreter mouseEventInterpreter = null;
    protected OMGraphicList selectedList;

    public OMGraphicList filter(Shape withinThisShape) {
        return this.filter.filter(withinThisShape);
    }

    public OMGraphicList filter(Shape shapeBoundary, boolean getInsideBoundary) {
        return this.filter.filter(shapeBoundary, getInsideBoundary);
    }

    public boolean supportsSQL() {
        return this.filter.supportsSQL();
    }

    public OMGraphicList filter(String SQLQuery) {
        return this.filter.filter(SQLQuery);
    }

    public boolean doAction(OMGraphic graphic, OMAction action) {
        return this.filter.doAction(graphic, action);
    }

    public OMGraphicList getList() {
        return this.filter.getList();
    }

    public boolean canSetList() {
        return this.filter.canSetList();
    }

    public void setList(OMGraphicList omgl) {
        this.filter.setList(omgl);
    }

    public void resetFiltering() {
        this.filter.resetFiltering();
    }

    public void setFilter(FilterSupport fs) {
        this.filter = fs;
    }

    public FilterSupport getFilter() {
        return this.filter;
    }

    public void projectionChanged(ProjectionEvent pe) {
        if (Debug.debugging("layer")) {
            Debug.output("OMGraphicHandlerLayer " + this.getName() + " projection changed, calling " + this.getProjectionChangePolicy().getClass().getName());
        }
        this.getProjectionChangePolicy().projectionChanged(pe);
    }

    public ProjectionChangePolicy getProjectionChangePolicy() {
        if (this.projectionChangePolicy == null) {
            this.projectionChangePolicy = new StandardPCPolicy(this);
        }
        return this.projectionChangePolicy;
    }

    public void setProjectionChangePolicy(ProjectionChangePolicy pcp) {
        this.projectionChangePolicy = pcp;
        pcp.setLayer(this);
    }

    public RenderPolicy getRenderPolicy() {
        if (this.renderPolicy == null) {
            this.renderPolicy = new StandardRenderPolicy(this);
        }
        return this.renderPolicy;
    }

    public void setRenderPolicy(RenderPolicy rp) {
        this.renderPolicy = rp;
        rp.setLayer(this);
    }

    public void interrupt() {
        try {
            if (this.layerWorker != null) {
                this.layerWorker.interrupt();
            }
        }
        catch (SecurityException se) {
            Debug.output(this.getName() + " layer caught a SecurityException when something tried to stop work on the worker thread");
        }
    }

    protected void setLayerWorker(SwingWorker worker) {
        this.layerWorker = worker;
    }

    protected SwingWorker getLayerWorker() {
        return this.layerWorker;
    }

    public synchronized void renderDataForProjection(Projection proj, Graphics g) {
        if (proj == null) {
            Debug.error("Layer(" + this.getName() + ").renderDataForProjection: null projection!");
            return;
        }
        if (!proj.equals(this.getProjection())) {
            this.setProjection(proj.makeClone());
            this.setList(this.prepare());
        }
        this.paint(g);
    }

    public void paint(Graphics g) {
        this.getRenderPolicy().paint(g);
    }

    public synchronized void doPrepare() {
        if (this.layerWorker == null) {
            this.layerWorker = new LayerWorker();
            this.layerWorker.execute();
        } else {
            if (Debug.debugging("layer")) {
                Debug.output(this.getName() + " layer already working in prepare(), cancelling");
            }
            this.setCancelled(true);
        }
    }

    public boolean isWorking() {
        return this.layerWorker != null;
    }

    public synchronized OMGraphicList prepare() {
        OMGraphicList currentList = this.getList();
        Projection proj = this.getProjection();
        if (currentList != null && proj != null) {
            currentList.generate(proj);
        }
        return currentList;
    }

    public synchronized void setCancelled(boolean set) {
        if (set) {
            this.interrupt();
        }
        this.cancelled = set;
    }

    public synchronized boolean isCancelled() {
        return this.cancelled;
    }

    protected synchronized void workerComplete(LayerWorker worker) {
        if (!this.isCancelled()) {
            this.layerWorker = null;
            this.getProjectionChangePolicy().workerComplete((OMGraphicList)worker.get());
            this.repaint();
        } else {
            this.setCancelled(false);
            this.layerWorker = new LayerWorker();
            this.layerWorker.execute();
        }
    }

    public void setProperties(String prefix, Properties props) {
        Vector mmv;
        String policyPrefix;
        super.setProperties(prefix, props);
        String realPrefix = PropUtils.getScopedPropertyPrefix(prefix);
        String pcpString = props.getProperty(realPrefix + ProjectionChangePolicyProperty);
        if (pcpString != null) {
            policyPrefix = realPrefix + pcpString;
            String pcpClass = props.getProperty(policyPrefix + ".class");
            if (pcpClass == null) {
                Debug.error("Layer " + this.getName() + " has " + policyPrefix + " property defined in properties for PropertyChangePolicy, but " + policyPrefix + ".class property is undefined.");
            } else {
                Object obj = ComponentFactory.create(pcpClass, policyPrefix, props);
                if (obj != null) {
                    if (Debug.debugging("layer")) {
                        Debug.output("Layer " + this.getName() + " setting ProjectionChangePolicy [" + obj.getClass().getName() + "]");
                    }
                    try {
                        this.setProjectionChangePolicy((ProjectionChangePolicy)obj);
                    }
                    catch (ClassCastException cce) {
                        Debug.error("Layer " + this.getName() + " has " + policyPrefix + " property defined in properties for ProjectionChangePolicy, but " + policyPrefix + ".class property (" + pcpClass + ") does not define a valid ProjectionChangePolicy. A " + obj.getClass().getName() + " was created instead.");
                    }
                } else {
                    Debug.error("Layer " + this.getName() + " has " + policyPrefix + " property defined in properties for PropertyChangePolicy, but " + policyPrefix + ".class property does not define a valid PropertyChangePolicy.");
                }
            }
        } else if (Debug.debugging("layer")) {
            Debug.output("Layer " + this.getName() + " using default ProjectionChangePolicy [" + this.getProjectionChangePolicy().getClass().getName() + "]");
        }
        String rpString = props.getProperty(realPrefix + RenderPolicyProperty);
        if (rpString != null) {
            policyPrefix = realPrefix + rpString;
            String rpClass = props.getProperty(policyPrefix + ".class");
            if (rpClass == null) {
                Debug.error("Layer " + this.getName() + " has " + policyPrefix + " property defined in properties for RenderPolicy, but " + policyPrefix + ".class property is undefined.");
            } else {
                Object rpObj = ComponentFactory.create(rpClass, policyPrefix, props);
                if (rpObj != null) {
                    if (Debug.debugging("layer")) {
                        Debug.output("Layer " + this.getName() + " setting RenderPolicy [" + rpObj.getClass().getName() + "]");
                    }
                    try {
                        this.setRenderPolicy((RenderPolicy)rpObj);
                    }
                    catch (ClassCastException cce) {
                        Debug.error("Layer " + this.getName() + " has " + policyPrefix + " property defined in properties for RenderPolicy, but " + policyPrefix + ".class property (" + rpClass + ") does not define a valid RenderPolicy. A " + rpObj.getClass().getName() + " was created instead.");
                    }
                } else {
                    Debug.error("Layer " + this.getName() + " has " + policyPrefix + " property defined in properties for RenderPolicy, but " + policyPrefix + ".class property (" + rpClass + ") isn't being created.");
                }
            }
        } else if (Debug.debugging("layer")) {
            Debug.output("Layer " + this.getName() + " using default RenderPolicy [" + this.getRenderPolicy().getClass().getName() + "]");
        }
        String mmString = props.getProperty(realPrefix + MouseModesProperty);
        if (mmString != null && (mmv = PropUtils.parseSpacedMarkers(mmString)).size() > 0) {
            String[] mm = new String[mmv.size()];
            Iterator it = mmv.iterator();
            int i = 0;
            while (it.hasNext()) {
                mm[i] = (String)it.next();
            }
            this.setMouseModeIDsForEvents(mm);
        }
        this.consumeEvents = PropUtils.booleanFromProperties(props, realPrefix + ConsumeEventsProperty, this.consumeEvents);
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        String policyPrefix = null;
        ProjectionChangePolicy pcp = this.getProjectionChangePolicy();
        if (pcp instanceof PropertyConsumer) {
            policyPrefix = ((PropertyConsumer)((Object)pcp)).getPropertyPrefix();
            ((PropertyConsumer)((Object)pcp)).getProperties(props);
        }
        if (policyPrefix == null) {
            policyPrefix = prefix + "pcp";
        }
        props.put(prefix + ProjectionChangePolicyProperty, policyPrefix.substring(prefix.length()));
        policyPrefix = PropUtils.getScopedPropertyPrefix(policyPrefix);
        props.put(policyPrefix + "class", pcp.getClass().getName());
        RenderPolicy rp = this.getRenderPolicy();
        if (rp instanceof PropertyConsumer) {
            policyPrefix = ((PropertyConsumer)((Object)rp)).getPropertyPrefix();
            ((PropertyConsumer)((Object)rp)).getProperties(props);
        }
        if (policyPrefix == null) {
            policyPrefix = prefix + "rp";
        }
        props.put(prefix + RenderPolicyProperty, policyPrefix.substring(prefix.length()));
        policyPrefix = PropUtils.getScopedPropertyPrefix(policyPrefix);
        props.put(policyPrefix + "class", rp.getClass().getName());
        props.put(prefix + ConsumeEventsProperty, new Boolean(this.consumeEvents).toString());
        String[] mm = this.getMouseModeIDsForEvents();
        if (mm != null && mm.length > 0) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < mm.length) {
                if (!mm[i].equals(this.getName())) {
                    sb.append(mm[i] + " ");
                }
                ++i;
            }
            props.put(prefix + MouseModesProperty, sb.toString());
        }
        return props;
    }

    public Properties getPropertyInfo(Properties list) {
        list = super.getPropertyInfo(list);
        String policyPrefix = null;
        ProjectionChangePolicy pcp = this.getProjectionChangePolicy();
        if (pcp instanceof PropertyConsumer && (policyPrefix = ((PropertyConsumer)((Object)pcp)).getPropertyPrefix()) != null) {
            int index = policyPrefix.indexOf(".");
            if (index != -1) {
                policyPrefix = policyPrefix.substring(index + 1);
            }
            ((PropertyConsumer)((Object)pcp)).getPropertyInfo(list);
        }
        if (policyPrefix == null) {
            policyPrefix = "pcp";
        }
        list.put(policyPrefix + ".class", "Class name of ProjectionChangePolicy (optional)");
        RenderPolicy rp = this.getRenderPolicy();
        if (rp instanceof PropertyConsumer) {
            int index;
            policyPrefix = ((PropertyConsumer)((Object)rp)).getPropertyPrefix();
            if (policyPrefix != null && (index = policyPrefix.indexOf(".")) != -1) {
                policyPrefix = policyPrefix.substring(index + 1);
            }
            ((PropertyConsumer)((Object)rp)).getPropertyInfo(list);
        }
        if (policyPrefix == null) {
            policyPrefix = "rp";
        }
        list.put(policyPrefix + ".class", "Class name of RenderPolicy (optional)");
        list.put(ConsumeEventsProperty, "Flag that tells the layer to consume MouseEvents, or let others use them as well.");
        list.put("consumeEvents.editor", "com.bbn.openmap.util.propertyEditor.OnOffPropertyEditor");
        list.put(MouseModesProperty, "Space-separated list of MouseMode IDs to receive events from.");
        return list;
    }

    public void setMouseEventInterpreter(MapMouseInterpreter mmi) {
        if (mmi instanceof StandardMapMouseInterpreter) {
            String[] modeList = this.getMouseModeIDsForEvents();
            ((StandardMapMouseInterpreter)mmi).setMouseModeServiceList(modeList);
            ((StandardMapMouseInterpreter)mmi).setConsumeEvents(this.getConsumeEvents());
        }
        mmi.setGRP(this);
        this.mouseEventInterpreter = mmi;
    }

    public MapMouseInterpreter getMouseEventInterpreter() {
        if (this.getMouseModeIDsForEvents() != null && this.mouseEventInterpreter == null) {
            this.setMouseEventInterpreter(new StandardMapMouseInterpreter(this));
        }
        return this.mouseEventInterpreter;
    }

    public synchronized MapMouseListener getMapMouseListener() {
        MapMouseInterpreter mml = this.getMouseEventInterpreter();
        if (mml != null && Debug.debugging("layer")) {
            String[] modes = mml.getMouseModeServiceList();
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < modes.length) {
                sb.append(modes[i] + ", ");
                ++i;
            }
            Debug.output("Layer " + this.getName() + " returning " + mml.getClass().getName() + " as map mouse listener that listens to: " + sb.toString());
        }
        return mml;
    }

    public void setConsumeEvents(boolean consume) {
        this.consumeEvents = consume;
    }

    public boolean getConsumeEvents() {
        return this.consumeEvents;
    }

    public String[] getMouseModeIDsForEvents() {
        return this.mouseModeIDs;
    }

    public void setMouseModeIDsForEvents(String[] mm) {
        if (Debug.debugging("layer")) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < mm.length) {
                sb.append(mm[i] + " ");
                ++i;
            }
            Debug.output("For layer " + this.getName() + ", setting mouse modes to " + sb.toString());
        }
        this.mouseModeIDs = mm;
    }

    public boolean isHighlightable(OMGraphic omg) {
        return true;
    }

    public boolean isSelectable(OMGraphic omg) {
        return false;
    }

    public OMGraphicList getSelected() {
        return this.selectedList;
    }

    public void highlight(OMGraphic omg) {
        omg.select();
        omg.generate(this.getProjection());
        this.repaint();
    }

    public void unhighlight(OMGraphic omg) {
        omg.deselect();
        omg.generate(this.getProjection());
        this.repaint();
    }

    public void select(OMGraphicList list) {
        if (list != null) {
            Iterator it = list.iterator();
            while (it.hasNext()) {
                OMGraphic omg;
                if (this.selectedList == null) {
                    this.selectedList = new OMGraphicList();
                }
                if ((omg = (OMGraphic)it.next()) instanceof OMGraphicList && !((OMGraphicList)omg).isVague()) {
                    this.select((OMGraphicList)omg);
                    continue;
                }
                this.selectedList.add(omg);
            }
        }
    }

    public void deselect(OMGraphicList list) {
        if (list != null) {
            Iterator it = list.iterator();
            while (it.hasNext() && this.selectedList != null) {
                OMGraphic omg = (OMGraphic)it.next();
                if (omg instanceof OMGraphicList && !((OMGraphicList)omg).isVague()) {
                    this.deselect((OMGraphicList)omg);
                    continue;
                }
                this.selectedList.remove(omg);
            }
        }
    }

    public OMGraphicList cut(OMGraphicList omgl) {
        OMGraphicList list = this.getList();
        if (list != null && omgl != null) {
            Iterator it = omgl.iterator();
            while (it.hasNext()) {
                list.remove((OMGraphic)it.next());
            }
        }
        return omgl;
    }

    public OMGraphicList copy(OMGraphicList omgl) {
        return null;
    }

    public void paste(OMGraphicList omgl) {
        OMGraphicList list = this.getList();
        if (list != null && omgl != null) {
            Iterator it = omgl.iterator();
            while (it.hasNext()) {
                list.add((OMGraphic)it.next());
            }
        }
    }

    public String getInfoText(OMGraphic omg) {
        return null;
    }

    public String getToolTipTextFor(OMGraphic omg) {
        return null;
    }

    public List getItemsForMapMenu() {
        return null;
    }

    public List getItemsForOMGraphicMenu(OMGraphic omg) {
        return null;
    }

    class LayerWorker
    extends SwingWorker {
        public Object construct() {
            String msg;
            Debug.message("layer", OMGraphicHandlerLayer.this.getName() + "|LayerWorker.construct()");
            OMGraphicHandlerLayer.this.fireStatusUpdate(8342);
            try {
                long start = System.currentTimeMillis();
                OMGraphicList list = OMGraphicHandlerLayer.this.getRenderPolicy().prepare();
                long stop = System.currentTimeMillis();
                if (Debug.debugging("layer")) {
                    Debug.output(OMGraphicHandlerLayer.this.getName() + "|LayerWorker.construct(): fetched " + (list == null ? "null list " : list.size() + " graphics ") + "in " + (double)(stop - start) / 1000.0 + " seconds");
                }
                return list;
            }
            catch (OutOfMemoryError e) {
                msg = OMGraphicHandlerLayer.this.getName() + "|LayerWorker.construct(): " + e;
                Debug.error(msg);
                e.printStackTrace();
            }
            catch (Exception e) {
                msg = OMGraphicHandlerLayer.this.getName() + "|LayerWorker.construct(): " + e;
                Debug.error(msg);
                e.printStackTrace();
            }
            OMGraphicHandlerLayer.this.fireRequestMessage(new InfoDisplayEvent(this, msg));
            OMGraphicHandlerLayer.this.fireStatusUpdate(8359);
            return null;
        }

        public void finished() {
            OMGraphicHandlerLayer.this.workerComplete(this);
            OMGraphicHandlerLayer.this.fireStatusUpdate(8359);
        }
    }
}

