/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.daynight;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.event.ProjectionListener;
import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.layer.daynight.SunPosition;
import com.bbn.openmap.omGraphics.OMCircle;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMRaster;
import com.bbn.openmap.proj.Cylindrical;
import com.bbn.openmap.proj.GreatCircle;
import com.bbn.openmap.proj.Length;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.ColorFactory;
import com.bbn.openmap.util.Debug;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.Timer;

public class DayNightLayer
extends OMGraphicHandlerLayer
implements ProjectionListener,
ActionListener {
    public static final transient float DEFAULT_TERM_FADE = 0.1f;
    public static final transient int DO_NOT_UPDATE = -1;
    protected Color daytimeColor;
    protected String defaultDaytimeColorString = "00FFFFFF";
    protected Color nighttimeColor;
    protected String defaultNighttimeColorString = "7F000000";
    protected float termFade = 0.1f;
    protected boolean currentTime = true;
    protected long overlayTime;
    protected int updateInterval = 300000;
    protected Timer timer;
    protected boolean doPolyTerminator = true;
    protected int terminatorVerts = 360;
    public static final transient String DaytimeColorProperty = ".daytimeColor";
    public static final transient String NighttimeColorProperty = ".nighttimeColor";
    public static final transient String TermFadeProperty = ".termFade";
    public static final transient String CurrentTimeProperty = ".useCurrentTime";
    public static final transient String OverlayTimeProperty = ".overlayTime";
    public static final transient String UpdateIntervalProperty = ".updateInterval";
    public static final transient String DoPolyTerminatorProperty = ".doPolyTerminator";
    public static final transient String TerminatorVertsProperty = ".terminatorVerts";

    public void setProperties(String prefix, Properties properties) {
        super.setProperties(prefix, properties);
        String termFadeString = properties.getProperty(prefix + TermFadeProperty);
        String currentTimeString = properties.getProperty(prefix + CurrentTimeProperty);
        String overlayTimeString = properties.getProperty(prefix + OverlayTimeProperty);
        String updateIntervalString = properties.getProperty(prefix + UpdateIntervalProperty);
        if (currentTimeString != null) {
            this.currentTime = Boolean.valueOf(currentTimeString);
        }
        try {
            if (overlayTimeString != null) {
                this.overlayTime = Long.valueOf(overlayTimeString);
            }
            if (this.overlayTime <= 0L) {
                this.currentTime = true;
            }
        }
        catch (NumberFormatException e) {
            System.err.println("DayNightLayer: Unable to parse .overlayTime = " + overlayTimeString);
            this.currentTime = true;
        }
        try {
            if (updateIntervalString != null) {
                this.updateInterval = Integer.valueOf(updateIntervalString);
            }
            if (this.updateInterval <= 0) {
                this.updateInterval = -1;
                System.err.println("DayNightLayer: Not updating display.");
            } else {
                this.timer = new Timer(this.updateInterval, this);
            }
        }
        catch (NumberFormatException e) {
            System.err.println("DayNightLayer: Unable to parse .updateInterval = " + updateIntervalString);
            this.updateInterval = -1;
        }
        try {
            this.termFade = termFadeString != null ? Float.valueOf(termFadeString).floatValue() : 0.1f;
            if (this.termFade < 0.0f || (double)this.termFade >= 0.5) {
                System.err.println("DayNightLayer: termFade funky value ignored.");
                this.termFade = 0.1f;
            }
        }
        catch (NumberFormatException e) {
            System.err.println("DayNightLayer: Unable to parse .termFade = " + termFadeString);
            this.termFade = 0.1f;
        }
        this.daytimeColor = ColorFactory.parseColorFromProperties(properties, prefix + DaytimeColorProperty, this.defaultDaytimeColorString, true);
        this.nighttimeColor = ColorFactory.parseColorFromProperties(properties, prefix + NighttimeColorProperty, this.defaultNighttimeColorString, true);
        this.doPolyTerminator = Boolean.valueOf(properties.getProperty(prefix + DoPolyTerminatorProperty, "" + this.doPolyTerminator));
        try {
            this.terminatorVerts = Integer.parseInt(properties.getProperty(prefix + TerminatorVertsProperty, "" + this.terminatorVerts));
        }
        catch (NumberFormatException e) {
            System.err.println("DayNightLayer: Unable to parse .terminatorVerts");
        }
    }

    public void actionPerformed(ActionEvent ae) {
        super.actionPerformed(ae);
        if (Debug.debugging("daynight")) {
            Debug.output(this.getName() + "| updating image via timer...");
        }
        this.doPrepare();
    }

    protected OMGraphic createImage(Projection projection) {
        if (this.currentTime) {
            this.overlayTime = System.currentTimeMillis();
        }
        if (Debug.debugging("daynight")) {
            Debug.output("DayNightLayer: Calculating sun position at time " + Long.toString(this.overlayTime));
        }
        LatLonPoint brightPoint = SunPosition.sunPosition(this.overlayTime);
        Debug.message("daynight", "DayNightLayer: Calculated sun position");
        if (this.doPolyTerminator) {
            Debug.message("daynight", "DayNightLayer:  Creating polygon terminator");
            LatLonPoint darkPoint = GreatCircle.spherical_between(brightPoint.radlat_, brightPoint.radlon_, (float)Math.PI, 0.7853982f);
            OMCircle circle = new OMCircle(darkPoint, projection instanceof Cylindrical ? 90.0f : 89.0f, Length.DECIMAL_DEGREE, this.terminatorVerts);
            circle.setPolarCorrection(true);
            circle.setFillPaint(this.nighttimeColor);
            circle.setLinePaint(this.nighttimeColor);
            circle.generate(projection);
            Debug.message("daynight", "DayNightLayer: Done creating polygon terminator");
            return circle;
        }
        int width = projection.getWidth();
        int height = projection.getHeight();
        int[] pixels = new int[width * height];
        OMRaster ret = new OMRaster(0, 0, width, height, pixels);
        Debug.message("daynight", this.getName() + "|createImage: Center of bright spot lat= " + brightPoint.getLatitude() + ", lon= " + brightPoint.getLongitude());
        int light = this.daytimeColor.getRGB();
        LatLonPoint testPoint = new LatLonPoint(0.0f, 0.0f);
        int dark = this.nighttimeColor.getRGB();
        int darkness = dark >>> 24;
        float upperFadeLimit = (float)(1.5707963705062866 * (1.0 + (double)this.termFade));
        float lowerFadeLimit = (float)(1.5707963705062866 * (1.0 - (double)this.termFade));
        int fadeColorValue = 0xFFFFFF & dark;
        int i = 0;
        while (i < width) {
            int j = 0;
            while (j < height) {
                testPoint = projection.inverse(i, j, testPoint);
                float distance = GreatCircle.spherical_distance(brightPoint.radlat_, brightPoint.radlon_, testPoint.radlat_, testPoint.radlon_);
                if (distance > upperFadeLimit) {
                    pixels[j * width + i] = dark;
                } else if (distance > lowerFadeLimit) {
                    int value = (int)((float)darkness * (1.0f - (upperFadeLimit - distance) / (upperFadeLimit - lowerFadeLimit)));
                    pixels[j * width + i] = fadeColorValue | (value <<= 24);
                } else {
                    pixels[j * width + i] = light;
                }
                ++j;
            }
            ++i;
        }
        ret.generate(projection);
        return ret;
    }

    public synchronized OMGraphicList prepare() {
        OMGraphicList list = this.getList();
        if (list == null) {
            list = new OMGraphicList();
        } else {
            list.clear();
        }
        if (this.isCancelled()) {
            Debug.message("daynight", this.getName() + "|DayNightLayer.prepare(): aborted.");
            return null;
        }
        Debug.message("basic", this.getName() + "|DayNightLayer.prepare(): doing it");
        OMGraphic ras = this.createImage(this.getProjection());
        if (this.timer != null) {
            this.timer.restart();
        }
        list.add(ras);
        return list;
    }

    public long getOverlayTime() {
        return this.overlayTime;
    }

    public void setOverlayTime(long ot) {
        this.overlayTime = ot;
        this.currentTime = false;
        this.doPrepare();
    }

    public boolean getCurrentTime() {
        return this.currentTime;
    }

    public void setCurrentTime(boolean ct) {
        this.currentTime = ct;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public void setTimer(Timer t) {
        this.timer = t;
    }
}

