/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.dted;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.io.BinaryBufferedFile;
import com.bbn.openmap.io.BinaryFile;
import com.bbn.openmap.io.Closable;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.dted.DTEDFrameColorTable;
import com.bbn.openmap.layer.dted.DTEDFrameDSI;
import com.bbn.openmap.layer.dted.DTEDFrameSubframe;
import com.bbn.openmap.layer.dted.DTEDFrameSubframeInfo;
import com.bbn.openmap.layer.dted.DTEDFrameUHL;
import com.bbn.openmap.omGraphics.OMRaster;
import com.bbn.openmap.proj.CADRG;
import com.bbn.openmap.proj.EqualArc;
import com.bbn.openmap.util.Debug;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.io.IOException;

public class DTEDFrame
implements Closable {
    public static final int UHL_SIZE = 80;
    public static final int DSI_SIZE = 648;
    public static final int ACC_SIZE = 2700;
    public static final int ACC_SR_SIZE = 284;
    protected BinaryFile binFile;
    protected String path;
    protected short[][] elevations;
    public DTEDFrameDSI dsi;
    public DTEDFrameUHL uhl;
    public DTEDFrameColorTable colorTable;
    public DTEDFrameSubframeInfo subframeInfo;
    public boolean frame_is_valid = false;
    public int number_horiz_subframes;
    public int number_vert_subframes;
    public DTEDFrameSubframe[][] subframes;

    public DTEDFrame(String filePath) {
        this(filePath, null, null, false);
    }

    public DTEDFrame(String filePath, DTEDFrameColorTable cTable, DTEDFrameSubframeInfo info) {
        this(filePath, cTable, info, false);
    }

    public DTEDFrame(String filePath, boolean readWholeFile) {
        this(filePath, null, null, readWholeFile);
    }

    public DTEDFrame(String filePath, DTEDFrameColorTable cTable, DTEDFrameSubframeInfo info, boolean readWholeFile) {
        try {
            this.binFile = new BinaryBufferedFile(filePath);
            this.read(this.binFile, readWholeFile);
            if (readWholeFile) {
                this.close(true);
            } else {
                BinaryFile.addClosable(this);
            }
        }
        catch (FileNotFoundException e) {
            Debug.error("DTEDFrame: file " + filePath + " not found");
        }
        catch (IOException e) {
            Debug.error("DTEDFrame: File IO Error!\n" + e.toString());
        }
        this.colorTable = cTable;
        this.subframeInfo = info;
        this.path = filePath;
    }

    public void setColorTable(DTEDFrameColorTable c_Table) {
        this.colorTable = c_Table;
    }

    public DTEDFrameColorTable getColorTable() {
        return this.colorTable;
    }

    protected void read(BinaryFile binFile, boolean readWholeFile) {
        binFile.byteOrder(true);
        this.dsi = new DTEDFrameDSI(binFile);
        this.uhl = new DTEDFrameUHL(binFile);
        this.elevations = new short[this.uhl.num_lon_lines][];
        if (readWholeFile) {
            this.read_data_records();
        }
        this.frame_is_valid = true;
    }

    public void dispose() {
        BinaryFile.removeClosable(this);
    }

    public boolean close(boolean done) {
        try {
            this.binFile.close();
            this.binFile = null;
            return true;
        }
        catch (IOException e) {
            Debug.error("DTEDFrame close(): File IO Error!\n" + e.toString());
            return false;
        }
    }

    protected boolean reopen() {
        try {
            this.binFile = new BinaryBufferedFile(this.path);
            return true;
        }
        catch (FileNotFoundException e) {
            Debug.error("DTEDFrame reopen(): file " + this.path + " not found");
            return false;
        }
        catch (IOException e) {
            Debug.error("DTEDFrame close(): File IO Error!\n" + e.toString());
            return false;
        }
    }

    public int elevationAt(float lat, float lon) {
        if (this.frame_is_valid && lat >= this.dsi.sw_lat && lat <= this.dsi.ne_lat && lon >= this.dsi.sw_lon && lon <= this.dsi.ne_lon) {
            int lat_index = Math.round((lat - this.dsi.sw_lat) * 36000.0f / (float)this.uhl.lat_post_interval);
            int lon_index = Math.round((lon - this.dsi.sw_lon) * 36000.0f / (float)this.uhl.lon_post_interval);
            if (this.elevations[lon_index] == null) {
                this.read_data_record(lon_index);
            }
            return this.elevations[lon_index][lat_index];
        }
        return -32767;
    }

    public int interpElevationAt(float lat, float lon) {
        if (this.frame_is_valid && lat >= this.dsi.sw_lat && lat <= this.dsi.ne_lat && lon >= this.dsi.sw_lon && lon <= this.dsi.ne_lon) {
            float lat_index = (lat - this.dsi.sw_lat) * 36000.0f / (float)this.uhl.lat_post_interval;
            float lon_index = (lon - this.dsi.sw_lon) * 36000.0f / (float)this.uhl.lon_post_interval;
            int lflon_index = (int)Math.floor(lon_index);
            int lclon_index = (int)Math.ceil(lon_index);
            int lflat_index = (int)Math.floor(lat_index);
            int lclat_index = (int)Math.ceil(lat_index);
            if (this.elevations[lflon_index] == null) {
                this.read_data_record(lflon_index);
            }
            if (this.elevations[lclon_index] == null) {
                this.read_data_record(lclon_index);
            }
            short ul = this.elevations[lflon_index][lclat_index];
            short ur = this.elevations[lclon_index][lclat_index];
            short ll = this.elevations[lflon_index][lclat_index];
            short lr = this.elevations[lclon_index][lclat_index];
            float answer = this.resolve_four_points(ul, ur, lr, ll, lat_index, lon_index);
            return Math.round(answer);
        }
        return -32767;
    }

    public int[] getIndexesFromLatLons(float ullat, float ullon, float lrlat, float lrlon) {
        float upper = ullat;
        float lower = lrlat;
        float right = lrlon;
        float left = ullon;
        if (ullon > lrlon) {
            right = ullon;
            left = lrlon;
        }
        if (lrlat > ullat) {
            upper = lrlat;
            lower = ullat;
        }
        int[] ret = new int[4];
        float ullat_index = (upper - this.dsi.sw_lat) * 36000.0f / (float)this.uhl.lat_post_interval;
        float ullon_index = (left - this.dsi.sw_lon) * 36000.0f / (float)this.uhl.lon_post_interval;
        float lrlat_index = (lower - this.dsi.sw_lat) * 36000.0f / (float)this.uhl.lat_post_interval;
        float lrlon_index = (right - this.dsi.sw_lon) * 36000.0f / (float)this.uhl.lon_post_interval;
        ret[0] = Math.round(ullon_index);
        ret[1] = Math.round(lrlat_index);
        ret[2] = Math.round(lrlon_index);
        ret[3] = Math.round(ullat_index);
        if (ret[0] < 0) {
            ret[0] = 0;
        }
        if (ret[0] > this.uhl.num_lon_lines - 2) {
            ret[0] = this.uhl.num_lon_lines - 2;
        }
        if (ret[1] < 0) {
            ret[1] = 0;
        }
        if (ret[1] > this.uhl.num_lat_points - 2) {
            ret[1] = this.uhl.num_lat_points - 2;
        }
        if (ret[2] < 0) {
            ret[2] = 0;
        }
        if (ret[2] > this.uhl.num_lon_lines - 2) {
            ret[2] = this.uhl.num_lon_lines - 2;
        }
        if (ret[3] < 0) {
            ret[3] = 0;
        }
        if (ret[3] > this.uhl.num_lat_points - 2) {
            ret[3] = this.uhl.num_lat_points - 2;
        }
        return ret;
    }

    public short[][] getElevations(float ullat, float ullon, float lrlat, float lrlon) {
        int[] indexes = this.getIndexesFromLatLons(ullat, ullon, lrlat, lrlon);
        return this.getElevations(indexes[0], indexes[1], indexes[2], indexes[3]);
    }

    public short[][] getElevations(int startx, int starty, int endx, int endy) {
        int upper = endy;
        int lower = starty;
        int right = endx;
        int left = startx;
        if (startx > endx) {
            right = startx;
            left = endx;
        }
        if (starty > endy) {
            upper = starty;
            lower = endy;
        }
        short[][] matrix = new short[right - left + 1][upper - lower + 1];
        int matrixColumn = 0;
        int x = left;
        while (x <= right) {
            if (this.elevations[x] == null) {
                this.read_data_record(x);
            }
            System.arraycopy(this.elevations[x], lower, matrix[matrixColumn], 0, upper - lower + 1);
            ++matrixColumn;
            ++x;
        }
        return matrix;
    }

    private float resolve_four_points(int ul, int ur, int lr, int ll, float lat_index, float lon_index) {
        float top_avg = (lon_index - new Double(Math.floor(lon_index)).floatValue()) * (float)(ur - ul) + (float)ul;
        float bottom_avg = (lon_index - new Double(Math.floor(lon_index)).floatValue()) * (float)(lr - ll) + (float)ll;
        float right_avg = (lat_index - new Double(Math.floor(lat_index)).floatValue()) * (float)(ur - lr) + (float)lr;
        float left_avg = (lat_index - new Double(Math.floor(lat_index)).floatValue()) * (float)(ul - ll) / 100.0f + (float)ll;
        float lon_avg = (lat_index - new Double(Math.floor(lat_index)).floatValue()) * (top_avg - bottom_avg) + bottom_avg;
        float lat_avg = (lon_index - new Double(Math.floor(lon_index)).floatValue()) * (right_avg - left_avg) + left_avg;
        float result = (lon_avg + lat_avg) / 2.0f;
        return result;
    }

    protected boolean read_data_record(int lon_index) {
        try {
            if (this.binFile == null && !this.reopen()) {
                return false;
            }
            this.binFile.seek(3428 + lon_index * (12 + 2 * this.uhl.num_lat_points));
            int sent = this.binFile.read();
            this.binFile.skipBytes(3L);
            short lon_count = this.binFile.readShort();
            short lat_count = this.binFile.readShort();
            this.elevations[lon_index] = new short[this.uhl.num_lat_points];
            int j = 0;
            while (j < this.uhl.num_lat_points) {
                this.elevations[lon_index][j] = this.binFile.readShort();
                ++j;
            }
        }
        catch (IOException e3) {
            Debug.error("DTEDFrame.RDR: Error reading file.");
            e3.printStackTrace();
            this.elevations[lon_index] = null;
            return false;
        }
        catch (FormatException f) {
            Debug.error("DTEDFrame.RDR: File IO Format error!");
            this.elevations[lon_index] = null;
            return false;
        }
        return true;
    }

    protected boolean read_data_records() {
        boolean ret = true;
        int lon_index = 0;
        while (lon_index < this.uhl.num_lon_lines) {
            if (!this.read_data_record(lon_index)) {
                ret = false;
            }
            ++lon_index;
        }
        return ret;
    }

    public void initSubframes(int numHorizSubframes, int numVertSubframes) {
        this.number_horiz_subframes = numHorizSubframes;
        this.number_vert_subframes = numVertSubframes;
        this.subframes = new DTEDFrameSubframe[numHorizSubframes][numVertSubframes];
        if (Debug.debugging("dted")) {
            Debug.output("///////// DTEDFrame: subframe array initialized, " + numHorizSubframes + "x" + numVertSubframes);
        }
    }

    public OMRaster getOMRaster(EqualArc proj) {
        return this.getOMRaster(null, null, proj);
    }

    public OMRaster getOMRaster(DTEDFrameSubframeInfo dfsi, DTEDFrameColorTable colortable, EqualArc proj) {
        if (proj == null) {
            Debug.error("DTEDFrame.getOMRaster: need projection to create image.");
            return null;
        }
        if (colortable == null) {
            colortable = new DTEDFrameColorTable();
        }
        if (dfsi == null) {
            dfsi = new DTEDFrameSubframeInfo(5, 25, 1, 3);
        }
        dfsi.xPixInterval = 360.0 / proj.getXPixConstant();
        dfsi.yPixInterval = 90.0 / proj.getYPixConstant();
        dfsi.height = (int)(1.0 / dfsi.yPixInterval);
        dfsi.width = (int)(1.0 / dfsi.xPixInterval);
        this.subframes = null;
        return this.getSubframeOMRaster(dfsi, colortable);
    }

    public OMRaster getSubframeOMRaster(DTEDFrameSubframeInfo dfsi, DTEDFrameColorTable colortable) {
        if (!this.frame_is_valid) {
            return null;
        }
        OMRaster raster = null;
        if (dfsi.viewType == 0) {
            return null;
        }
        if (dfsi.viewType == 5) {
            colortable.setGreyScale(false);
        } else {
            colortable.setGreyScale(true);
        }
        float lat_origin = dfsi.lat;
        float lon_origin = dfsi.lon;
        if (this.subframes == null) {
            this.initSubframes(1, 1);
            lat_origin = this.dsi.lat_origin + 1.0f;
            lon_origin = this.dsi.lon_origin;
        }
        DTEDFrameSubframe subframe = this.subframes[dfsi.subx][dfsi.suby];
        if (Debug.debugging("dteddetail")) {
            Debug.output("Subframe lat/lon => lat= " + lat_origin + " vs. " + dfsi.lat + " lon= " + lon_origin + " vs. " + dfsi.lon + " subx = " + dfsi.subx + " suby = " + dfsi.suby);
            Debug.output("Height/width of subframe => height= " + dfsi.height + " width= " + dfsi.width);
        }
        if (subframe != null) {
            if (subframe.image != null && subframe.si.equals(dfsi)) {
                raster = subframe.image;
                if (Debug.debugging("dted")) {
                    Debug.output("######## DTEDFrame: returning cached subframe");
                }
                return raster;
            }
            if (Debug.debugging("dted")) {
                Debug.output("   *** DTEDFrame: changing image of cached subframe");
            }
            if (subframe.image == null) {
                if (Debug.debugging("dted")) {
                    Debug.output("   +++ DTEDFrame: creating subframe image");
                }
                subframe.image = dfsi.colorModel == 0 ? new OMRaster(lat_origin, lon_origin, dfsi.width, dfsi.height, new int[dfsi.height * dfsi.width]) : new OMRaster(lat_origin, lon_origin, dfsi.width, dfsi.height, null, (Color[])colortable.colors, 255);
            }
            subframe.si = dfsi.makeClone();
        } else {
            if (Debug.debugging("dted")) {
                Debug.output("   +++ DTEDFrame: creating subframe");
            }
            this.subframes[dfsi.subx][dfsi.suby] = new DTEDFrameSubframe(dfsi);
            subframe = this.subframes[dfsi.subx][dfsi.suby];
            subframe.image = dfsi.colorModel == 0 ? new OMRaster(lat_origin, lon_origin, dfsi.width, dfsi.height, new int[dfsi.height * dfsi.width]) : new OMRaster(lat_origin, lon_origin, dfsi.width, dfsi.height, null, (Color[])colortable.colors, 255);
        }
        raster = subframe.image;
        double start_lat_index = ((double)lat_origin - (double)this.dsi.sw_lat) * 36000.0 / (double)this.uhl.lat_post_interval;
        double start_lon_index = ((double)lon_origin - (double)this.dsi.sw_lon) * 36000.0 / (double)this.uhl.lon_post_interval;
        double end_lat_index = ((double)lat_origin - (double)dfsi.height * dfsi.yPixInterval - (double)this.dsi.sw_lat) * 36000.0 / (double)this.uhl.lat_post_interval;
        double end_lon_index = ((double)lon_origin + (double)dfsi.width * dfsi.xPixInterval - (double)this.dsi.sw_lon) * 36000.0 / (double)this.uhl.lon_post_interval;
        double lat_interval = (start_lat_index - end_lat_index) / (double)dfsi.height;
        double lon_interval = (end_lon_index - start_lon_index) / (double)dfsi.width;
        if (Debug.debugging("dteddetail")) {
            Debug.output("  start_lat_index => " + start_lat_index + "\n" + "  end_lat_index => " + end_lat_index + "\n" + "  start_lon_index => " + start_lon_index + "\n" + "  end_lon_index => " + end_lon_index + "\n" + "  lat_interval => " + lat_interval + "\n" + "  lon_interval => " + lon_interval);
        }
        short xc = 0;
        short yc = 0;
        short xnw = 0;
        short ynw = 0;
        short xse = 0;
        short yse = 0;
        double distance = 1.0;
        float value = 0.0f;
        int assignment = 0;
        double modifier = 0.0;
        double xw_offset = 0.0;
        double xe_offset = 0.0;
        double yn_offset = 0.0;
        double ys_offset = 0.0;
        int elevation = 0;
        if (dfsi.viewType == 1 || dfsi.viewType == 5 && colortable.colors.length > 16) {
            xw_offset = start_lon_index - Math.ceil(lon_interval);
            xe_offset = start_lon_index + Math.ceil(lon_interval);
            yn_offset = start_lat_index + Math.ceil(lat_interval);
            ys_offset = start_lat_index - Math.ceil(lat_interval);
            switch (dfsi.dtedLevel) {
                case 0: {
                    modifier = 4.0;
                    break;
                }
                case 1: {
                    modifier = 0.02;
                    break;
                }
                case 2: {
                    modifier = 1.0E-4;
                    break;
                }
                case 3: {
                    modifier = 1.0E-6;
                    break;
                }
                default: {
                    modifier = 1.0;
                }
            }
            if (colortable.colors.length > 215) {
                modifier /= 10.0;
            }
            int h = dfsi.slopeAdjust;
            while (h < 5) {
                modifier *= 10.0;
                ++h;
            }
            distance = Math.sqrt(modifier * lon_interval * lon_interval + modifier * lat_interval * lat_interval);
        }
        int x = 0;
        while (x < dfsi.width) {
            xc = (short)(start_lon_index + (double)x * lon_interval);
            if (xc < 0) {
                xc = 0;
            }
            if (xc > this.dsi.num_lon_points - 1) {
                xc = (short)(this.dsi.num_lon_points - 1);
            }
            if (this.elevations[xc] == null && !this.read_data_record(xc)) {
                Debug.error("DTEDFrame: Problem reading lat point line in data record");
                return null;
            }
            if (dfsi.viewType == 1 || dfsi.viewType == 5 && colortable.colors.length > 16) {
                xnw = (short)(xw_offset + Math.floor((double)x * lon_interval));
                xse = (short)(xe_offset + Math.floor((double)x * lon_interval));
                if (xc == 0 || xnw < 0) {
                    xnw = xc;
                    xse = (short)((double)xnw + 2.0 * Math.ceil(lon_interval));
                }
                if (xc == this.dsi.num_lon_points - 1 || xse > this.dsi.num_lon_points - 1) {
                    xse = (short)(this.dsi.num_lon_points - 1);
                    xnw = (short)((double)xse - 2.0 * Math.ceil(lon_interval));
                }
                if (this.elevations[xnw] == null && !this.read_data_record(xnw) || this.elevations[xse] == null && !this.read_data_record(xse)) {
                    Debug.error("DTEDFrame: Problem reading lat point line in data record");
                    return null;
                }
            }
            int y = 0;
            while (y < dfsi.height) {
                yc = (short)(start_lat_index - (double)y * lat_interval);
                if (yc < 0) {
                    yc = 0;
                }
                elevation = this.elevations[xc][yc];
                if (dfsi.viewType == 2 || dfsi.viewType == 3) {
                    if (elevation == 0) {
                        assignment = 0;
                    } else {
                        if (elevation < 0) {
                            elevation *= -1;
                        }
                        if (dfsi.viewType == 3) {
                            elevation = (int)((double)elevation * 3.2);
                        }
                        if (colortable.colors.length < 216) {
                            try {
                                assignment = elevation / dfsi.bandHeight % (colortable.colors.length - 6) + 6;
                            }
                            catch (ArithmeticException ae) {
                                assignment = 1;
                            }
                        } else {
                            try {
                                assignment = elevation / dfsi.bandHeight % (10 - 2 * (3 - dfsi.slopeAdjust)) * (colortable.colors.length / (10 - 2 * (3 - dfsi.slopeAdjust))) + 6;
                            }
                            catch (ArithmeticException ae) {
                                assignment = 1;
                            }
                        }
                    }
                    if (dfsi.colorModel == 0) {
                        raster.setPixel(x, y, colortable.colors[assignment].getRGB());
                    } else {
                        raster.setByte(x, y, (byte)assignment);
                    }
                } else if (dfsi.viewType == 1 || dfsi.viewType == 5 && colortable.colors.length > 16) {
                    ynw = (short)(yn_offset - Math.floor((double)y * lat_interval));
                    yse = (short)(ys_offset - Math.floor((double)y * lat_interval));
                    if (yse < 0) {
                        yse = 0;
                    }
                    if (yc == this.dsi.num_lat_lines - 1 || ynw > this.dsi.num_lat_lines - 1) {
                        ynw = (short)(this.dsi.num_lat_lines - 1);
                    }
                    short e2 = this.elevations[xse][yse];
                    short e1 = this.elevations[xnw][ynw];
                    double slope = (double)(e2 - e1) / distance;
                    if (dfsi.viewType == 5) {
                        assignment = 1;
                        elevation = (int)((double)elevation * 3.2);
                        int l = 1;
                        while (l < 16) {
                            if (elevation <= colortable.elevation_color_cutoff[l]) {
                                if (slope < 0.0) {
                                    assignment = l + 16;
                                    break;
                                }
                                if (slope > 0.0) {
                                    assignment = l + 32;
                                    break;
                                }
                                assignment = l;
                                break;
                            }
                            ++l;
                        }
                        if (elevation == 0) {
                            assignment = 0;
                        }
                        if (dfsi.colorModel == 0) {
                            raster.setPixel(x, y, colortable.colors[assignment].getRGB());
                        } else {
                            raster.setByte(x, y, (byte)assignment);
                        }
                    } else {
                        value = (float)((double)((colortable.colors.length - 1) / 2) + slope);
                        if (slope != 0.0 && value < 1.0f) {
                            value = 1.0f;
                        }
                        if (elevation == 0) {
                            value = 0.0f;
                        }
                        if (value > (float)(colortable.colors.length - 1)) {
                            value = colortable.colors.length - 1;
                        }
                        assignment = (int)value;
                        if (dfsi.colorModel == 0) {
                            raster.setPixel(x, y, colortable.colors[assignment].getRGB());
                        } else {
                            raster.setByte(x, y, (byte)assignment);
                        }
                    }
                } else if (dfsi.viewType == 4) {
                    int c = x < 1 ? 1 : (x > dfsi.width - 2 ? 12 : (y < 1 ? 1 : (y > dfsi.height - 2 ? 12 : 7)));
                    if (dfsi.colorModel == 0) {
                        raster.setPixel(x, y, colortable.colors[c].getRGB());
                    } else {
                        raster.setByte(x, y, (byte)c);
                    }
                } else if (dfsi.viewType == 5) {
                    assignment = 1;
                    elevation = (int)((double)elevation * 3.2);
                    int l = 1;
                    while (l < 16) {
                        if (elevation <= colortable.elevation_color_cutoff[l]) {
                            assignment = l;
                            break;
                        }
                        ++l;
                    }
                    if (elevation == 0) {
                        assignment = 0;
                    }
                    if (elevation < 0) {
                        assignment = 1;
                    }
                    if (elevation > 33000) {
                        assignment = 1;
                    }
                    if (dfsi.colorModel == 0) {
                        raster.setPixel(x, y, colortable.colors[assignment].getRGB());
                    } else {
                        raster.setByte(x, y, (byte)assignment);
                    }
                }
                y = (short)(y + 1);
            }
            x = (short)(x + 1);
        }
        if (Debug.debugging("dteddetail")) {
            Debug.output("DTEDFrame: leaving raster");
        }
        return raster;
    }

    public static void main(String[] args) {
        Debug.init();
        if (args.length < 1) {
            System.out.println("DTEDFrame:  Need a path/filename");
            System.exit(0);
        }
        System.out.println("DTEDFrame: " + args[0]);
        DTEDFrame df = new DTEDFrame(args[0]);
        if (df.frame_is_valid) {
            System.out.println(df.uhl);
            System.out.println(df.dsi);
        }
        float lat = df.dsi.lat_origin + 0.5f;
        float lon = df.dsi.lon_origin + 0.5f;
        CADRG crg = new CADRG(new LatLonPoint(lat, lon), 1500000.0f, 600, 600);
        final OMRaster ras = df.getOMRaster(crg);
        crg.setHeight(ras.getHeight());
        crg.setWidth(ras.getWidth());
        ras.generate(crg);
        Frame window = new Frame(args[0]){

            public void paint(Graphics g) {
                if (ras != null) {
                    ras.render(g);
                }
            }
        };
        window.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        window.setSize(ras.getWidth(), ras.getHeight());
        window.show();
        window.repaint();
    }
}

