/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.e00;

import com.bbn.openmap.Layer;
import com.bbn.openmap.event.InfoDisplayEvent;
import com.bbn.openmap.event.MapMouseListener;
import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.layer.e00.ArcData;
import com.bbn.openmap.layer.e00.E00Data;
import com.bbn.openmap.layer.e00.E00Parser;
import com.bbn.openmap.layer.location.BasicLocation;
import com.bbn.openmap.layer.util.LayerUtils;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PaletteHelper;
import com.bbn.openmap.util.SwingWorker;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Properties;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class E00Layer
extends Layer
implements MapMouseListener,
ActionListener {
    protected OMGraphicList graphics;
    protected OMGraphicList arcs;
    protected OMGraphicList labs;
    protected OMGraphicList tx7;
    protected boolean ArcVisible = true;
    protected boolean LabVisible = true;
    protected boolean Tx7Visible = true;
    protected boolean cancelled = false;
    protected JPanel gui;
    protected JLabel label;
    Paint[] ArcColors;
    Paint[] LabColors;
    Paint Tx7Color;
    Paint SelectTx7Color;
    Paint SelectLabColor;
    Paint SelectArcColor;
    Paint LabTextColor;
    OMGraphic LabMarker;
    Font LabFont;
    Font Tx7Font;
    int filtreValeur = Integer.MIN_VALUE;
    int filtreType = Integer.MIN_VALUE;
    JFileChooser fileChooser;
    File E00File;
    E00Worker currentWorker;
    private Projection projection;

    public void setProperties(String prefix, Properties props) {
        block2: {
            super.setProperties(prefix, props);
            String E00FileName = props.getProperty(prefix + ".FileName");
            this.ArcVisible = LayerUtils.booleanFromProperties(props, prefix + ".ArcVisible", this.ArcVisible);
            this.LabVisible = LayerUtils.booleanFromProperties(props, prefix + ".LabVisible", this.LabVisible);
            this.Tx7Visible = LayerUtils.booleanFromProperties(props, prefix + ".Tx7Visible", this.Tx7Visible);
            Paint dfault = null;
            this.ArcColors = this.parseColors(props, prefix, "ArcColors", Color.black);
            this.LabColors = this.parseColors(props, prefix, "LabColors", Color.black);
            this.Tx7Color = this.parseColor(props, prefix, "Tx7Color", dfault);
            this.SelectTx7Color = this.parseColor(props, prefix, "SelectTx7Color", null);
            this.SelectLabColor = this.parseColor(props, prefix, "SelectLabColor", null);
            this.SelectArcColor = this.parseColor(props, prefix, "SelectArcColor", null);
            this.LabTextColor = this.parseColor(props, prefix, "LabTextColor", null);
            this.LabFont = this.parseFont(props, prefix, "LabFont", null);
            this.Tx7Font = this.parseFont(props, prefix, "tx7Font", null);
            try {
                this.openFile(new File(E00FileName));
            }
            catch (Exception ex) {
                Debug.error("E00Layer: error - " + ex.getMessage());
                if (!Debug.debugging("e00")) break block2;
                ex.printStackTrace();
            }
        }
    }

    public synchronized void setCancelled(boolean set) {
        this.cancelled = set;
    }

    public synchronized boolean isCancelled() {
        return this.cancelled;
    }

    public Component getGUI() {
        if (this.gui == null) {
            this.gui = PaletteHelper.createPaletteJPanel("E00");
            this.label = new JLabel(this.E00File != null ? this.E00File.getName() : "       ");
            this.gui.add(this.label);
            this.addGui(new JButton("OPEN"), "OPEN");
            this.addGui(new JCheckBox("Arcs", this.ArcVisible), "ARCS");
            this.addGui(new JCheckBox("Labs", this.LabVisible), "LABS");
            this.addGui(new JCheckBox("Tx7", this.Tx7Visible), "TX7");
            this.gui.add(new JLabel("Filter"));
            this.gui.add(new JLabel(" By Value"));
            this.addGui(new JTextField(10), "VALEUR");
            this.gui.add(new JLabel(" By Type"));
            this.addGui(new JTextField(10), "TYPE");
            this.addGui(new JButton("ExpArcs"), "ExpArcs");
            this.addGui(new JButton("ExpPoints"), "ExpPoints");
        }
        return this.gui;
    }

    public MapMouseListener getMapMouseListener() {
        return this;
    }

    public String[] getMouseModeServiceList() {
        String[] ret = new String[]{"Gestures"};
        return ret;
    }

    public void projectionChanged(ProjectionEvent e) {
        this.projection = e.getProjection();
        if (this.graphics != null) {
            this.graphics.generate(this.projection);
        }
        this.repaint();
        if (this.projection == null && Debug.debugging("e00")) {
            Debug.output("E00Layer.projectionChanged(): projection null");
        }
    }

    public void paint(Graphics g) {
        if (this.graphics != null) {
            this.graphics.render(g);
        }
    }

    public void added(Container cont) {
        this.fireStatusUpdate(8359);
    }

    public void actionPerformed(ActionEvent e) {
        String Action2 = e.getActionCommand();
        if ("OPEN".equals(Action2)) {
            this.openFile(this.chooseFile(0));
        } else if ("ExpArcs".equals(Action2)) {
            this.exportArcs1();
        } else if ("ExpPoints".equals(Action2)) {
            this.exportPoints();
        } else if ("VALEUR".equals(Action2)) {
            this.filtreValeur = this.getVal(e);
            this.filtre();
        } else if ("TYPE".equals(Action2)) {
            this.filtreType = this.getVal(e);
            this.filtre();
        } else if ("ARCS".equals(Action2)) {
            JCheckBox cb = (JCheckBox)e.getSource();
            this.ArcVisible = cb.isSelected();
            if (this.arcs != null) {
                this.arcs.setVisible(this.ArcVisible);
            }
            this.repaint();
        } else if ("LABS".equals(Action2)) {
            JCheckBox cb = (JCheckBox)e.getSource();
            this.LabVisible = cb.isSelected();
            if (this.labs != null) {
                this.labs.setVisible(this.LabVisible);
            }
            this.repaint();
        } else if ("TX7".equals(Action2)) {
            JCheckBox cb = (JCheckBox)e.getSource();
            this.Tx7Visible = cb.isSelected();
            if (this.tx7 != null) {
                this.tx7.setVisible(this.Tx7Visible);
            }
            this.repaint();
        }
    }

    public boolean mousePressed(MouseEvent e) {
        String t;
        int x = e.getX();
        int y = e.getY();
        OMGraphic g = null;
        if ((e.getModifiers() & 0x10) > 0) {
            if (this.arcs != null) {
                g = this.arcs.findClosest(x, y, 10.0f);
            }
            t = "arc";
        } else {
            if (this.labs != null) {
                g = this.labs.findClosest(x, y, 5.0f);
            }
            t = "point";
        }
        if (g != null) {
            g.setSelected(!g.isSelected());
            E00Data d = (E00Data)g.getAppObject();
            if (d != null) {
                this.fireRequestInfoLine(t + d);
            } else {
                this.fireRequestInfoLine("");
            }
            this.repaint();
            return true;
        }
        this.fireRequestInfoLine("");
        return false;
    }

    public boolean mouseReleased(MouseEvent e) {
        return false;
    }

    public boolean mouseClicked(MouseEvent e) {
        return false;
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public boolean mouseDragged(MouseEvent e) {
        return false;
    }

    public void mouseMoved() {
    }

    public boolean mouseMoved(MouseEvent e) {
        return false;
    }

    protected Frame getFrame() {
        if (this.gui == null) {
            return null;
        }
        Container p = this.gui.getParent();
        while (p != null) {
            if (p instanceof Frame) {
                return (Frame)p;
            }
            p = p.getParent();
        }
        return null;
    }

    protected synchronized void workerComplete(E00Worker worker) {
        if (!this.isCancelled()) {
            this.currentWorker = null;
            this.graphics = (OMGraphicList)worker.get();
            if (this.projection != null) {
                this.graphics.generate(this.projection);
            }
            this.repaint();
            OMGraphic og = this.graphics.getOMGraphicWithAppObject("ARCS");
            if (og != null) {
                this.arcs = (OMGraphicList)og;
                this.arcs.setVisible(this.ArcVisible);
            } else {
                this.arcs = null;
            }
            og = this.graphics.getOMGraphicWithAppObject("LABS");
            if (og != null) {
                this.labs = (OMGraphicList)og;
                this.labs.setVisible(this.LabVisible);
            } else {
                this.labs = null;
            }
            og = this.graphics.getOMGraphicWithAppObject("TX7");
            if (og != null) {
                this.tx7 = (OMGraphicList)og;
                this.tx7.setVisible(this.Tx7Visible);
            } else {
                this.tx7 = null;
            }
        } else {
            this.setCancelled(false);
            this.currentWorker = new E00Worker(this.E00File);
            this.currentWorker.execute();
        }
    }

    void setLineColor(Color C) {
        if (this.graphics != null) {
            this.graphics.setLinePaint(C);
        }
        this.repaint();
    }

    int getVal(ActionEvent e) {
        int val;
        JTextField T = (JTextField)e.getSource();
        try {
            val = Integer.parseInt(T.getText());
        }
        catch (NumberFormatException ex) {
            val = Integer.MIN_VALUE;
        }
        return val;
    }

    OMGraphicList prepare(File f) {
        OMGraphicList g = null;
        try {
            if (this.isCancelled()) {
                return null;
            }
            E00Parser SP = new E00Parser(this.E00File);
            SP.setPaints(this.ArcColors, this.LabColors, this.Tx7Color, this.SelectTx7Color, this.SelectLabColor, this.SelectArcColor, this.LabTextColor);
            SP.setLabMarker(this.LabMarker);
            SP.setFonts(this.LabFont, this.Tx7Font);
            g = SP.getOMGraphics();
            if (this.isCancelled()) {
                return null;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
            Debug.error("E00Layer: " + ex.getMessage());
        }
        return g;
    }

    void openFile(File f) {
        if (f == null) {
            return;
        }
        if (!f.exists()) {
            Debug.output("E00: missing file");
            return;
        }
        this.E00File = f;
        if (this.gui != null) {
            this.label.setText(this.E00File.getName());
        }
        if (this.currentWorker == null) {
            this.fireStatusUpdate(8342);
            this.currentWorker = new E00Worker(f);
            this.currentWorker.execute();
        } else {
            this.setCancelled(true);
        }
    }

    void addGui(AbstractButton b, String cmd) {
        b.setActionCommand(cmd);
        b.addActionListener(this);
        this.gui.add(b);
    }

    void addGui(JTextField b, String cmd) {
        b.setActionCommand(cmd);
        b.addActionListener(this);
        this.gui.add(b);
    }

    File chooseFile(int type) {
        Frame frame = this.getFrame();
        File f = null;
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
        }
        this.fileChooser.setCurrentDirectory(this.E00File);
        if (type == 0) {
            this.fileChooser.setDialogType(0);
        } else {
            this.fileChooser.setDialogType(1);
        }
        int retval = this.fileChooser.showDialog(frame, null);
        if (retval == 0) {
            f = this.fileChooser.getSelectedFile();
        }
        return f;
    }

    void filtre() {
        System.out.print("E00: filter type=" + this.filtreType + "  value=" + this.filtreValeur);
        int count = 0;
        OMGraphicList g = this.arcs;
        int n = this.arcs.size();
        if (this.filtreType == Integer.MIN_VALUE && this.filtreValeur == Integer.MIN_VALUE) {
            int i = 0;
            while (i < n) {
                g.getOMGraphicAt(i).setVisible(true);
                ++i;
            }
            count = n;
        } else {
            int i = 0;
            while (i < n) {
                OMGraphic og = g.getOMGraphicAt(i);
                Object O = og.getAppObject();
                if (O == null) {
                    this.setVisible(false);
                } else {
                    E00Data d = (E00Data)O;
                    boolean r = true;
                    if (this.filtreType != Integer.MIN_VALUE) {
                        r &= this.filtreType == d.type;
                    }
                    if (this.filtreValeur != Integer.MIN_VALUE) {
                        r &= this.filtreValeur == d.valeur;
                    }
                    og.setVisible(r);
                    if (r) {
                        ++count;
                    }
                }
                ++i;
            }
        }
        Debug.output(" count:" + count);
        this.repaint();
    }

    void exportArcs() {
        double ln;
        double lt;
        int llsize;
        float[] ll;
        double lnmin;
        if (this.arcs == null) {
            return;
        }
        Vector<ArcData> V = new Vector<ArcData>();
        int n = this.arcs.size();
        double lnmax = Double.MIN_VALUE;
        double ltmin = lnmin = Double.MAX_VALUE;
        double ltmax = lnmax;
        int i = 0;
        while (i < n) {
            E00Data data;
            OMPoly oj = (OMPoly)this.arcs.getOMGraphicAt(i);
            if (oj != null && (data = (E00Data)oj.getAppObject()) != null) {
                ll = oj.getLatLonArray();
                llsize = ll.length;
                boolean closed = true;
                if (ll[0] != ll[llsize - 2] || ll[1] != ll[llsize - 1]) {
                    float[] coords = new float[]{ll[0], ll[1], ll[llsize - 2], ll[llsize - 1]};
                    ArcData dn = new ArcData(data);
                    dn.coords = coords;
                    oj.setAppObject(dn);
                    V.add(dn);
                }
                int k = 0;
                while (k < llsize) {
                    lt = ll[k++];
                    ln = ll[k++];
                    if (lt > ltmax) {
                        ltmax = lt;
                    } else if (lt < ltmin) {
                        ltmin = lt;
                    }
                    if (ln > lnmax) {
                        lnmax = ln;
                        continue;
                    }
                    if (!(ln < lnmin)) continue;
                    lnmin = ln;
                }
            }
            ++i;
        }
        System.out.println("#minmax " + lnmin + " " + lnmax + " " + ltmin + " " + ltmax);
        int unClosedCount = V.size();
        ArcData[] unClosed = V.toArray(new ArcData[unClosedCount]);
        V.clear();
        V = null;
        int i2 = 0;
        while (i2 < unClosedCount) {
            ArcData d0 = unClosed[i2];
            d0.deja = 0;
            if (d0.type <= 1) {
                float lt1 = d0.coords[0];
                float lg1 = d0.coords[1];
                float lt2 = d0.coords[2];
                float lg2 = d0.coords[3];
                int j = i2 + 1;
                while (j < unClosedCount) {
                    ArcData d1 = unClosed[j];
                    if (d1.type <= 1) {
                        if (lt1 == d1.coords[0] && lg1 == d1.coords[1]) {
                            d1.setC(d0);
                            d0.setC(d1);
                        } else if (lt1 == d1.coords[2] && lg1 == d1.coords[3]) {
                            d1.setF(d0);
                            d0.setC(d1);
                        }
                        if (lt2 == d1.coords[0] && lg2 == d1.coords[1]) {
                            d1.setC(d0);
                            d0.setF(d1);
                        } else if (lt2 == d1.coords[2] && lg2 == d1.coords[3]) {
                            d1.setF(d0);
                            d0.setF(d1);
                        }
                    }
                    ++j;
                }
            }
            ++i2;
        }
        int k = 0;
        while (k < unClosedCount) {
            ArcData d0 = unClosed[k];
            if (d0.type == 0 && d0.deja == 0 && (d0.c0 != null || d0.f0 != null)) {
                ArcData d1 = d0;
                ArcData d2 = d1.c0 == null ? d1.f0 : d1.c0;
                System.out.print("#contour ");
                System.out.print(d0.id);
                System.out.print(' ');
                int decount = unClosedCount * 3 / 2;
                do {
                    System.out.print(d2.id);
                    if (d2.deja != 0) {
                        System.out.print('*');
                    }
                    System.out.print(' ');
                    ArcData dx = d2.visit(d1);
                    d1 = d2;
                    d2 = dx;
                    if (decount-- >= 0) continue;
                    System.out.print(" BOUCLE ");
                    break;
                } while (d2 != null && d2 != d0);
                if (d2 == null) {
                    System.out.print(" unclosed");
                }
                System.out.println();
                System.out.println();
            }
            ++k;
        }
        int i3 = 0;
        while (i3 < n) {
            E00Data data;
            OMPoly oj = (OMPoly)this.arcs.getOMGraphicAt(i3);
            if (oj != null && (data = (E00Data)oj.getAppObject()) != null) {
                ll = oj.getLatLonArray();
                llsize = ll.length;
                double z = (double)data.valeur * 0.304;
                double z2 = (double)data.valeur2 * 0.304;
                boolean closed = true;
                float[] coords = null;
                if (data instanceof ArcData) {
                    ArcData dn = (ArcData)data;
                    coords = dn.coords;
                    dn.coords = null;
                    closed = false;
                }
                int k2 = 0;
                System.out.println("#type " + data.type);
                while (k2 < llsize) {
                    lt = ll[k2++];
                    ln = ll[k2++];
                    System.out.println("c " + ln + " " + lt + " " + z);
                }
                System.out.println(closed ? "#LC" : "#LX");
                System.out.println();
            }
            ++i3;
        }
    }

    void exportArcs1() {
        PrintStream out = null;
        File f = this.chooseFile(1);
        if (this.arcs == null) {
            return;
        }
        if (f == null) {
            return;
        }
        try {
            out = new PrintStream(new FileOutputStream(f));
        }
        catch (IOException e) {
            System.out.println(e);
            return;
        }
        int n = this.arcs.size();
        int i = 0;
        while (i < n) {
            OMPoly oj = (OMPoly)this.arcs.getOMGraphicAt(i);
            if (oj != null && oj.isSelected()) {
                float[] ll = oj.getLatLonArray();
                int llsize = ll.length;
                boolean closed = true;
                out.println(oj.getLinePaint());
                if (ll[0] != ll[llsize - 2] || ll[1] != ll[llsize - 1]) {
                    out.print("MetaPolyline: ");
                } else {
                    llsize -= 2;
                    out.print("MetaPolyline: ");
                }
                out.print(llsize / 2);
                Object o = oj.getAppObject();
                if (o != null && o instanceof String) {
                    System.out.println(o);
                } else {
                    out.println();
                }
                int k = 0;
                while (k < llsize) {
                    double lt = ll[k++];
                    double ln = ll[k++];
                    out.println(ln + " " + lt);
                }
            }
            ++i;
        }
        out.close();
    }

    void exportPoints() {
        if (this.labs == null) {
            return;
        }
        int n = this.labs.size();
        System.out.println("#type 0");
        int i = 0;
        while (i < n) {
            E00Data data;
            BasicLocation oj = (BasicLocation)this.labs.getOMGraphicAt(i);
            if (oj != null && (data = (E00Data)oj.getAppObject()) != null) {
                double lt = (double)(oj.lat / 180.0f) * Math.PI;
                double ln = (double)(oj.lon / 180.0f) * Math.PI;
                double z = (double)data.valeur * 0.304;
                System.out.println("c " + ln + " " + lt + " " + z);
            }
            ++i;
        }
    }

    private Paint parseColor(Properties props, String prefix, String prop, Paint dfault) {
        try {
            return LayerUtils.parseColorFromProperties(props, prefix + "." + prop, dfault);
        }
        catch (NumberFormatException exc) {
            System.out.println("Color Error " + prefix + "." + prop);
            return dfault;
        }
    }

    private Paint[] parseColors(Properties props, String prefix, String prop, Paint err) {
        Color[] colors = null;
        String[] colorStrings = LayerUtils.stringArrayFromProperties(props, prefix + "." + prop, " ,");
        if (colorStrings != null) {
            colors = new Color[colorStrings.length];
            int i = 0;
            while (i < colorStrings.length) {
                try {
                    colors[i] = LayerUtils.parseColor(colorStrings[i]);
                }
                catch (NumberFormatException exc) {
                    System.out.println("Colors Error " + prefix + "." + prop + " " + i);
                    colors[i] = err;
                }
                ++i;
            }
        }
        return colors;
    }

    private Font parseFont(Properties props, String prefix, String prop, Font dfault) {
        String[] fontItems = LayerUtils.stringArrayFromProperties(props, prefix + "." + prop, " ,");
        int style = 0;
        int size = 10;
        if (fontItems == null || fontItems.length == 0) {
            return dfault;
        }
        try {
            size = Integer.parseInt(fontItems[1]);
        }
        catch (Exception e) {
            // empty catch block
        }
        int i = 2;
        while (i < fontItems.length) {
            String S = fontItems[i];
            if ("BOLD".equals(S)) {
                style |= 1;
            } else if ("ITALIC".equals(S)) {
                style |= 2;
            } else if ("PLAIN".equals(S)) {
                style |= 0;
            }
            ++i;
        }
        return new Font(fontItems[0], style, size);
    }

    class E00Worker
    extends SwingWorker {
        File file;

        public E00Worker(File f) {
            this.file = f;
        }

        public Object construct() {
            Debug.message("e00", E00Layer.this.getName() + "|E00Worker.construct()");
            E00Layer.this.fireStatusUpdate(8342);
            try {
                return E00Layer.this.prepare(this.file);
            }
            catch (OutOfMemoryError e) {
                String msg = E00Layer.this.getName() + "|E00Layer.E00Worker.construct(): " + e;
                Debug.error(msg);
                E00Layer.this.fireRequestMessage(new InfoDisplayEvent(this, msg));
                E00Layer.this.fireStatusUpdate(8359);
                return null;
            }
        }

        public void finished() {
            E00Layer.this.workerComplete(this);
            E00Layer.this.fireStatusUpdate(8359);
        }
    }
}

