/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.nexrad;

import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.util.ColorFactory;
import com.bbn.openmap.util.Debug;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.StringTokenizer;

public class NexradLayer
extends OMGraphicHandlerLayer {
    public static final transient String plotColorProperty = ".color.plot";
    public static final transient String fontProperty = ".font";
    public static final transient String maxRainProperty = ".rain.max";
    public static final transient String minRainProperty = ".rain.min";
    public static final transient String dataURLProperty = ".url";
    protected Color plotColor = new Color(0, 0, 200);
    protected int maxRain = 1000;
    protected int minRain = 0;
    protected URL dataURL = null;
    protected Font legendFont = Font.decode("SanSerif");

    public void setProperties(String prefix, Properties props) {
        String tmpMinRain;
        super.setProperties(prefix, props);
        this.plotColor = ColorFactory.parseColorFromProperties(props, prefix + plotColorProperty, "0000C8");
        String tmpMaxRain = props.getProperty(prefix + maxRainProperty);
        if (tmpMaxRain != null) {
            try {
                this.maxRain = Integer.valueOf(tmpMaxRain);
            }
            catch (NumberFormatException e) {
                this.maxRain = 1000;
            }
        }
        if ((tmpMinRain = props.getProperty(prefix + minRainProperty)) != null) {
            try {
                this.minRain = Integer.valueOf(tmpMinRain);
            }
            catch (NumberFormatException e) {
                this.minRain = 0;
            }
        }
        try {
            this.dataURL = new URL(props.getProperty(prefix + dataURLProperty));
            this.loadData(this.dataURL);
        }
        catch (MalformedURLException e) {
            this.dataURL = null;
        }
        this.legendFont = Font.decode(props.getProperty(prefix + fontProperty));
    }

    public void loadData(URL theDataStream) {
        try {
            BufferedReader f = new BufferedReader(new InputStreamReader(theDataStream.openStream()));
            StringTokenizer tok = new StringTokenizer(f.readLine());
            int ulhrapx = new Integer(tok.nextToken());
            int ulhrapy = new Integer(tok.nextToken());
            int maxx = new Integer(tok.nextToken());
            int maxy = new Integer(tok.nextToken());
            int[][] rain = new int[maxx][maxy];
            if (Debug.debugging("nexrad")) {
                Debug.output("NexradLayer: Reading " + theDataStream + " " + maxx + " " + maxy);
            }
            int any = 0;
            while (any < maxy) {
                tok = new StringTokenizer(f.readLine());
                int anx = 0;
                while (anx < maxx) {
                    rain[anx][any] = new Integer(tok.nextToken());
                    ++anx;
                }
                ++any;
            }
            f.close();
            if (Debug.debugging("nexrad")) {
                Debug.output("NexradLayer: Completed " + theDataStream + " " + maxx + " " + maxy);
            }
            this.setList(this.createGraphics(ulhrapx, ulhrapy, maxx, maxy, rain));
        }
        catch (Exception oops) {
            Debug.error("NexradLayer.loadData: Failed to read " + theDataStream);
            oops.printStackTrace();
        }
    }

    public OMGraphicList createGraphics(int ulhrapx, int ulhrapy, int xcount, int ycount, int[][] rain) {
        OMGraphicList graphics = new OMGraphicList();
        float[] ul = new float[]{0.0f, 0.0f};
        float[] ur = new float[]{0.0f, 0.0f};
        float[] ll = new float[]{0.0f, 0.0f};
        float[] lr = new float[]{0.0f, 0.0f};
        int x = 0;
        while (x < xcount) {
            ll = this.hrap2lonlat(ulhrapx + x, ulhrapy);
            lr = this.hrap2lonlat(ulhrapx + x + 1, ulhrapy);
            int y = 0;
            while (y < ycount) {
                ul = ll;
                ur = lr;
                ll = this.hrap2lonlat(ulhrapx + x, ulhrapy + y + 1);
                lr = this.hrap2lonlat(ulhrapx + x + 1, ulhrapy + y + 1);
                if (rain[x][y] > 0) {
                    if (Debug.debugging("nexrad")) {
                        Debug.output("NexradLayer: Rain " + rain[x][y] + " " + x + " " + y);
                    }
                    float[] polypoints = new float[]{ul[0], ul[1], ur[0], ur[1], lr[0], lr[1], ll[0], ll[1], ul[0], ul[1]};
                    OMPoly poly = new OMPoly(polypoints, 0, 1);
                    Color plotc = this.scaledColor(rain[x][y]);
                    poly.setFillPaint(plotc);
                    poly.setLinePaint(plotc);
                    graphics.addOMGraphic(poly);
                }
                ++y;
            }
            ++x;
        }
        return graphics;
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.plotScale(g);
    }

    public void plotScale(Graphics g) {
        g.setColor(Color.red);
        int nameMin = 1;
        Font tmpFont = g.getFont();
        g.setFont(this.legendFont);
        g.drawString(this.maxRain + " mm", 30, 30);
        g.drawString(nameMin + " mm", 30, 450);
        g.setFont(tmpFont);
        int range = 430;
        int k = 0;
        while (k <= range) {
            g.setColor(this.scaledColor(this.minRain + k * (this.maxRain - this.minRain) / range));
            g.fillRect(10, 450 - k, 10, 5);
            k += 5;
        }
    }

    public Color scaledColor(int value) {
        int alphaValue = 15 * value / this.maxRain;
        if (alphaValue > 15) {
            alphaValue = 15;
        }
        if (alphaValue < 0) {
            alphaValue = 0;
        }
        alphaValue *= 10;
        return new Color(this.plotColor.getRed(), this.plotColor.getGreen(), this.plotColor.getBlue(), alphaValue += 55);
    }

    public float[] hrap2lonlat(int xhrap, int yhrap) {
        float mesh = 4762.5f;
        float earthr = 6371200.0f;
        float stlond = -105.0f;
        float stlatd = 60.0f;
        float x = ((float)xhrap - 401.0f) * mesh;
        float y = ((float)yhrap - 1601.0f) * mesh;
        float arg = (float)(Math.pow(Math.pow(x, 2.0) + Math.pow(y, 2.0), 0.5) / ((double)earthr * (1.0 + Math.sin(Math.toRadians(stlatd)))));
        float latd = 90.0f - 2.0f * (float)Math.toDegrees(Math.atan(arg));
        float ang = (float)Math.toDegrees(Math.atan2(y, x));
        ang = y > 0.0f ? 270.0f - stlond - ang : -90.0f - stlond - ang;
        float lond = 0.0f;
        lond = ang < 180.0f ? -1.0f * ang : 360.0f - ang;
        float[] res = new float[]{latd, lond};
        return res;
    }
}

