/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.policy;

import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.layer.policy.ProjectionChangePolicy;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;

public class StandardPCPolicy
implements ProjectionChangePolicy {
    protected OMGraphicHandlerLayer layer;
    protected int graphicCutoff = 50;

    public StandardPCPolicy() {
    }

    public StandardPCPolicy(OMGraphicHandlerLayer layer) {
        this.layer = layer;
    }

    public void setLayer(OMGraphicHandlerLayer l) {
        this.layer = l;
    }

    public OMGraphicHandlerLayer getLayer() {
        return this.layer;
    }

    public void projectionChanged(ProjectionEvent pe) {
        if (this.layer != null) {
            Projection proj = this.layer.setProjection(pe);
            if (proj != null) {
                if (this.shouldSpawnThreadForPrepare()) {
                    if (Debug.debugging("layer")) {
                        Debug.output(this.getLayer().getName() + ": StandardPCPolicy projectionChanged with NEW projection, spawning thread to handle it.");
                    }
                    this.layer.doPrepare();
                    return;
                }
                if (Debug.debugging("layer")) {
                    Debug.output(this.getLayer().getName() + ": StandardPCPolicy projectionChanged with NEW projection, handling it within current thread.");
                }
                this.layer.prepare();
                this.layer.repaint();
            } else {
                this.layer.repaint();
            }
            this.layer.fireStatusUpdate(8359);
        } else {
            Debug.error("StandardPCPolicy.projectionChanged(): NULL layer, can't do anything.");
        }
    }

    public void workerComplete(OMGraphicList aList) {
        if (this.layer != null) {
            this.layer.setList(aList);
        }
    }

    protected boolean shouldSpawnThreadForPrepare() {
        OMGraphicList list;
        if (this.layer != null && (list = this.layer.getList()) != null) {
            return this.layer.getList().size() > this.graphicCutoff;
        }
        return true;
    }

    public void setGraphicCutoff(int number) {
        this.graphicCutoff = number;
    }

    public int getGraphicCutoff() {
        return this.graphicCutoff;
    }
}

