/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.rpf;

import com.bbn.openmap.Layer;
import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.layer.rpf.RpfConstants;
import com.bbn.openmap.layer.rpf.RpfCoverageManager;
import com.bbn.openmap.layer.rpf.RpfFrameProvider;
import com.bbn.openmap.layer.util.LayerUtils;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.ColorFactory;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class RpfCoverage
implements ActionListener,
RpfConstants,
PropertyConsumer {
    protected Vector omGraphics;
    protected boolean cancelled = false;
    protected RpfCoverageManager coverageManager = null;
    protected String propertyPrefix = null;
    protected boolean showCG;
    protected boolean showTLM;
    protected boolean showJOG;
    protected boolean showTPC;
    protected boolean showONC;
    protected boolean showJNC;
    protected boolean showGNC;
    protected boolean showCIB10;
    protected boolean showCIB5;
    protected boolean showMISC;
    protected Color CGColor;
    protected Color TLMColor;
    protected Color JOGColor;
    protected Color TPCColor;
    protected Color ONCColor;
    protected Color JNCColor;
    protected Color GNCColor;
    protected Color CIB10Color;
    protected Color CIB5Color;
    protected Color MISCColor;
    protected int opaqueness;
    protected boolean fillRects;
    public static final String OpaquenessProperty = "coverageOpaque";
    public static final String FillProperty = "coverageFill";
    protected Layer layer;
    protected boolean inUse = false;
    protected boolean showPalette = true;
    protected JFrame paletteWindow = null;

    public RpfCoverage(Layer l) {
        this.layer = l;
    }

    protected void setDefaultValues() {
        this.allCoveragesOn();
        this.opaqueness = 255;
        this.fillRects = true;
    }

    public boolean isInUse() {
        return this.inUse;
    }

    public void setInUse(boolean iu) {
        this.inUse = iu;
        if (this.showPalette || !this.inUse) {
            this.getPaletteWindow().setVisible(this.inUse);
        }
    }

    public boolean isShowPalette() {
        return this.showPalette;
    }

    public void setShowPalette(boolean sp) {
        this.showPalette = sp;
        if (!this.showPalette) {
            this.allCoveragesOn();
        }
    }

    public void allCoveragesOn() {
        this.showCG = true;
        this.showTLM = true;
        this.showJOG = true;
        this.showTPC = true;
        this.showONC = true;
        this.showJNC = true;
        this.showGNC = true;
        this.showCIB10 = true;
        this.showCIB5 = true;
        this.showMISC = true;
    }

    public void setProperties(Properties props) {
        this.setProperties(null, props);
    }

    public void setProperties(String prefix, Properties properties) {
        this.setPropertyPrefix(prefix);
        this.setDefaultValues();
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.fillRects = LayerUtils.booleanFromProperties(properties, prefix + FillProperty, true);
        this.opaqueness = LayerUtils.intFromProperties(properties, prefix + OpaquenessProperty, 255);
        this.CGColor = LayerUtils.parseColorFromProperties(properties, prefix + "CG.color", "AC4853");
        this.TLMColor = LayerUtils.parseColorFromProperties(properties, prefix + "TLM.color", "CE4F3F");
        this.JOGColor = LayerUtils.parseColorFromProperties(properties, prefix + "JOG.color", "AC7D74");
        this.TPCColor = LayerUtils.parseColorFromProperties(properties, prefix + "TPC.color", "ACCD10");
        this.ONCColor = LayerUtils.parseColorFromProperties(properties, prefix + "ONC.color", "FCCDE5");
        this.JNCColor = LayerUtils.parseColorFromProperties(properties, prefix + "JNC.color", "7386E5");
        this.GNCColor = LayerUtils.parseColorFromProperties(properties, prefix + "GNC.color", "55866B");
        this.CIB10Color = LayerUtils.parseColorFromProperties(properties, prefix + "CIB10.color", "07516B");
        this.CIB5Color = LayerUtils.parseColorFromProperties(properties, prefix + "CIB5.color", "071CE0");
        this.MISCColor = LayerUtils.parseColorFromProperties(properties, prefix + "MISC.color", "F2C921");
        if (this.showPalette) {
            this.showCG = LayerUtils.booleanFromProperties(properties, prefix + "CG.showcov", true);
            this.showTLM = LayerUtils.booleanFromProperties(properties, prefix + "TLM.showcov", true);
            this.showJOG = LayerUtils.booleanFromProperties(properties, prefix + "JOG.showcov", true);
            this.showTPC = LayerUtils.booleanFromProperties(properties, prefix + "TPC.showcov", true);
            this.showONC = LayerUtils.booleanFromProperties(properties, prefix + "ONC.showcov", true);
            this.showJNC = LayerUtils.booleanFromProperties(properties, prefix + "JNC.showcov", true);
            this.showGNC = LayerUtils.booleanFromProperties(properties, prefix + "GNC.showcov", true);
            this.showCIB10 = LayerUtils.booleanFromProperties(properties, prefix + "CIB10.showcov", true);
            this.showCIB5 = LayerUtils.booleanFromProperties(properties, prefix + "CIB5.showcov", true);
            this.showMISC = LayerUtils.booleanFromProperties(properties, prefix + "MISC.showcov", true);
        }
    }

    public Properties getProperties(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        String prefix = PropUtils.getScopedPropertyPrefix(this.propertyPrefix);
        props.put(prefix + FillProperty, new Boolean(this.fillRects).toString());
        props.put(prefix + OpaquenessProperty, Integer.toString(this.opaqueness));
        props.put(prefix + "CG.color", this.CGColor);
        props.put(prefix + "TLM.color", this.TLMColor);
        props.put(prefix + "JOG.color", this.JOGColor);
        props.put(prefix + "TPC.color", this.TPCColor);
        props.put(prefix + "ONC.color", this.ONCColor);
        props.put(prefix + "JNC.color", this.JNCColor);
        props.put(prefix + "GNC.color", this.GNCColor);
        props.put(prefix + "CIB10.color", this.CIB10Color);
        props.put(prefix + "CIB5.color", this.CIB5Color);
        props.put(prefix + "MISC.color", this.MISCColor);
        return props;
    }

    public Properties getPropertyInfo(Properties list) {
        if (list == null) {
            list = new Properties();
        }
        list.put(FillProperty, "Flag to set if the coverage rectangles should be filled.");
        list.put("coverageFill.editor", "com.bbn.openmap.util.propertyEditor.OnOffPropertyEditor");
        list.put(OpaquenessProperty, "Integer representing opaqueness level (0-255, 0 is clear) of rectangles.");
        list.put("CG.color", "Color string for City Graphics chart coverage.");
        list.put("CG.color.editor", "com.bbn.openmap.util.propertyEditor.ColorPropertyEditor");
        list.put("TLM.color", "Color string for TLM chart coverage.");
        list.put("TLM.color.editor", "com.bbn.openmap.util.propertyEditor.ColorPropertyEditor");
        list.put("JOG.color", "Color string for JOG chart coverage.");
        list.put("JOG.color.editor", "com.bbn.openmap.util.propertyEditor.ColorPropertyEditor");
        list.put("TPC.color", "Color string for TPC chart coverage.");
        list.put("TPC.color.editor", "com.bbn.openmap.util.propertyEditor.ColorPropertyEditor");
        list.put("ONC.color", "Color string for ONC chart coverage.");
        list.put("ONC.color.editor", "com.bbn.openmap.util.propertyEditor.ColorPropertyEditor");
        list.put("JNC.color", "Color string for JNC chart coverage.");
        list.put("JNC.color.editor", "com.bbn.openmap.util.propertyEditor.ColorPropertyEditor");
        list.put("GNC.color", "Color string for GNC chart coverage.");
        list.put("GNC.color.editor", "com.bbn.openmap.util.propertyEditor.ColorPropertyEditor");
        list.put("CIB10.color", "Color string for CIB 10 meter image coverage.");
        list.put("CIB10.color.editor", "com.bbn.openmap.util.propertyEditor.ColorPropertyEditor");
        list.put("CIB5.color", "Color string for CIB 5 meter image coverage.");
        list.put("CIB5.color.editor", "com.bbn.openmap.util.propertyEditor.ColorPropertyEditor");
        list.put("MISC.color", "Color string for all other chart coverage.");
        list.put("MISC.color.editor", "com.bbn.openmap.util.propertyEditor.ColorPropertyEditor");
        return list;
    }

    public String getInitPropertiesOrder() {
        return " coverageFill coverageOpaque GNC.color JNC.color ONC.color TPC.color JOG.color TLM.color CIB10.color CIB5.color MISC.color";
    }

    public void setPropertyPrefix(String prefix) {
        this.propertyPrefix = prefix;
    }

    public String getPropertyPrefix() {
        return this.propertyPrefix;
    }

    public void prepare(RpfFrameProvider frameProvider, Projection projection, String chartSeries) {
        float ullat = 90.0f;
        float ullon = -180.0f;
        float lrlat = -90.0f;
        float lrlon = 180.0f;
        if (projection != null) {
            ullat = projection.getUpperLeft().getLatitude();
            ullon = projection.getUpperLeft().getLongitude();
            lrlat = projection.getLowerRight().getLatitude();
            lrlon = projection.getLowerRight().getLongitude();
        }
        Debug.message("basic", "RpfCoverage.prepare(): doing it");
        if (this.coverageManager == null) {
            this.coverageManager = new RpfCoverageManager(frameProvider);
            Color[] colors = new Color[10];
            int opa = this.opaqueness << 24;
            colors[0] = ColorFactory.createColor(this.CGColor.getRGB() & 0xFFFFFF | opa, true);
            colors[1] = ColorFactory.createColor(this.TLMColor.getRGB() & 0xFFFFFF | opa, true);
            colors[2] = ColorFactory.createColor(this.JOGColor.getRGB() & 0xFFFFFF | opa, true);
            colors[3] = ColorFactory.createColor(this.TPCColor.getRGB() & 0xFFFFFF | opa, true);
            colors[4] = ColorFactory.createColor(this.ONCColor.getRGB() & 0xFFFFFF | opa, true);
            colors[5] = ColorFactory.createColor(this.JNCColor.getRGB() & 0xFFFFFF | opa, true);
            colors[6] = ColorFactory.createColor(this.GNCColor.getRGB() & 0xFFFFFF | opa, true);
            colors[7] = ColorFactory.createColor(this.CIB10Color.getRGB() & 0xFFFFFF | opa, true);
            colors[8] = ColorFactory.createColor(this.CIB5Color.getRGB() & 0xFFFFFF | opa, true);
            colors[9] = ColorFactory.createColor(this.MISCColor.getRGB() & 0xFFFFFF | opa, true);
            this.coverageManager.setColors(colors, this.opaqueness, this.fillRects);
        }
        this.setGraphicLists(this.coverageManager.getCatalogCoverage(ullat, ullon, lrlat, lrlon, projection, chartSeries));
    }

    public synchronized void setGraphicLists(Vector lists) {
        this.omGraphics = lists;
    }

    public synchronized Vector getGraphicLists() {
        return this.omGraphics;
    }

    public void paint(Graphics g) {
        Debug.message("rpfcov", "RpfCoverage.paint()");
        Vector tmpGraphics = this.getGraphicLists();
        if (tmpGraphics != null) {
            int length = tmpGraphics.size();
            Debug.message("rpfcov", "RpfCoverage.painting(): " + length + " lists");
            int k = length - 1;
            while (k >= 0) {
                if (k == 0 && this.showCG) {
                    ((OMGraphicList)tmpGraphics.elementAt(k)).render(g);
                }
                if (k == 1 && this.showCIB5) {
                    ((OMGraphicList)tmpGraphics.elementAt(k)).render(g);
                }
                if (k == 2 && this.showTLM) {
                    ((OMGraphicList)tmpGraphics.elementAt(k)).render(g);
                }
                if (k == 3 && this.showCIB10) {
                    ((OMGraphicList)tmpGraphics.elementAt(k)).render(g);
                }
                if (k == 4 && this.showJOG) {
                    ((OMGraphicList)tmpGraphics.elementAt(k)).render(g);
                }
                if (k == 5 && this.showMISC) {
                    ((OMGraphicList)tmpGraphics.elementAt(k)).render(g);
                }
                if (k == 6 && this.showTPC) {
                    ((OMGraphicList)tmpGraphics.elementAt(k)).render(g);
                }
                if (k == 7 && this.showONC) {
                    ((OMGraphicList)tmpGraphics.elementAt(k)).render(g);
                }
                if (k == 8 && this.showJNC) {
                    ((OMGraphicList)tmpGraphics.elementAt(k)).render(g);
                }
                if (k == 9 && this.showGNC) {
                    ((OMGraphicList)tmpGraphics.elementAt(k)).render(g);
                }
                --k;
            }
        } else {
            Debug.message("rpfcov", "RpfCoverage.paint(): null graphics list");
        }
    }

    public void generate(Projection proj) {
        Debug.message("rpfcov", "RpfCoverage.generate()");
        Vector tmpGraphics = this.getGraphicLists();
        if (tmpGraphics != null) {
            int length = tmpGraphics.size();
            int k = length - 1;
            while (k >= 0) {
                if (k == 0) {
                    ((OMGraphicList)tmpGraphics.elementAt(k)).generate(proj);
                }
                if (k == 1) {
                    ((OMGraphicList)tmpGraphics.elementAt(k)).generate(proj);
                }
                if (k == 2) {
                    ((OMGraphicList)tmpGraphics.elementAt(k)).generate(proj);
                }
                if (k == 3) {
                    ((OMGraphicList)tmpGraphics.elementAt(k)).generate(proj);
                }
                if (k == 4) {
                    ((OMGraphicList)tmpGraphics.elementAt(k)).generate(proj);
                }
                if (k == 5) {
                    ((OMGraphicList)tmpGraphics.elementAt(k)).generate(proj);
                }
                if (k == 6) {
                    ((OMGraphicList)tmpGraphics.elementAt(k)).generate(proj);
                }
                if (k == 7) {
                    ((OMGraphicList)tmpGraphics.elementAt(k)).generate(proj);
                }
                if (k == 8) {
                    ((OMGraphicList)tmpGraphics.elementAt(k)).generate(proj);
                }
                if (k == 9) {
                    ((OMGraphicList)tmpGraphics.elementAt(k)).generate(proj);
                }
                --k;
            }
        }
    }

    public Component getGUI() {
        JCheckBox showCGCheck = new JCheckBox("Show City Graphic Coverage", this.showCG);
        showCGCheck.setActionCommand("showCG");
        showCGCheck.addActionListener(this);
        showCGCheck.setForeground(this.CGColor);
        JCheckBox showTLMCheck = new JCheckBox("Show TLM (1:50k) Coverage", this.showTLM);
        showTLMCheck.setActionCommand("showTLM");
        showTLMCheck.addActionListener(this);
        showTLMCheck.setForeground(this.TLMColor);
        JCheckBox showJOGCheck = new JCheckBox("Show JOG (1:250k) Coverage", this.showJOG);
        showJOGCheck.setActionCommand("showJOG");
        showJOGCheck.addActionListener(this);
        showJOGCheck.setForeground(this.JOGColor);
        JCheckBox showTPCCheck = new JCheckBox("Show TPC (1:500k) Coverage", this.showTPC);
        showTPCCheck.setActionCommand("showTPC");
        showTPCCheck.addActionListener(this);
        showTPCCheck.setForeground(this.TPCColor);
        JCheckBox showONCCheck = new JCheckBox("Show ONC (1:1M) Coverage", this.showONC);
        showONCCheck.setActionCommand("showONC");
        showONCCheck.addActionListener(this);
        showONCCheck.setForeground(this.ONCColor);
        JCheckBox showJNCCheck = new JCheckBox("Show JNC (1:2M) Coverage", this.showJNC);
        showJNCCheck.setActionCommand("showJNC");
        showJNCCheck.addActionListener(this);
        showJNCCheck.setForeground(this.JNCColor);
        JCheckBox showGNCCheck = new JCheckBox("Show GNC (1:5M) Coverage", this.showGNC);
        showGNCCheck.setActionCommand("showGNC");
        showGNCCheck.addActionListener(this);
        showGNCCheck.setForeground(this.GNCColor);
        JCheckBox showCIB10Check = new JCheckBox("Show CIB 10m Coverage", this.showCIB10);
        showCIB10Check.setActionCommand("showCIB10");
        showCIB10Check.addActionListener(this);
        showCIB10Check.setForeground(this.CIB10Color);
        JCheckBox showCIB5Check = new JCheckBox("Show CIB 5m Coverage", this.showCIB5);
        showCIB5Check.setActionCommand("showCIB5");
        showCIB5Check.addActionListener(this);
        showCIB5Check.setForeground(this.CIB5Color);
        JCheckBox showMISCCheck = new JCheckBox("Show Coverage of all Others", this.showMISC);
        showMISCCheck.setActionCommand("showMISC");
        showMISCCheck.addActionListener(this);
        showMISCCheck.setForeground(this.MISCColor);
        Box box = Box.createVerticalBox();
        box.add(showCGCheck);
        box.add(showTLMCheck);
        box.add(showJOGCheck);
        box.add(showTPCCheck);
        box.add(showONCCheck);
        box.add(showJNCCheck);
        box.add(showGNCCheck);
        box.add(showCIB10Check);
        box.add(showCIB5Check);
        box.add(showMISCCheck);
        return box;
    }

    public JFrame getPaletteWindow() {
        if (this.paletteWindow == null) {
            Component pal = this.getGUI();
            if (pal == null) {
                pal = new JLabel("No Palette");
            }
            JPanel p = new JPanel();
            p.setLayout(new BoxLayout(p, 1));
            p.setAlignmentX(0.0f);
            p.setAlignmentY(1.0f);
            p.add(pal);
            JScrollPane scrollPane = new JScrollPane(p, 20, 30);
            scrollPane.setAlignmentX(0.0f);
            scrollPane.setAlignmentY(0.0f);
            this.paletteWindow = new JFrame("RPF Coverage Palette");
            this.paletteWindow.setContentPane(scrollPane);
            this.paletteWindow.pack();
        }
        return this.paletteWindow;
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        JCheckBox check = (JCheckBox)e.getSource();
        if (cmd == "showCG") {
            this.showCG = check.isSelected();
        } else if (cmd == "showTLM") {
            this.showTLM = check.isSelected();
        } else if (cmd == "showJOG") {
            this.showJOG = check.isSelected();
        } else if (cmd == "showTPC") {
            this.showTPC = check.isSelected();
        } else if (cmd == "showONC") {
            this.showONC = check.isSelected();
        } else if (cmd == "showJNC") {
            this.showJNC = check.isSelected();
        } else if (cmd == "showGNC") {
            this.showGNC = check.isSelected();
        } else if (cmd == "showCIB10") {
            this.showCIB10 = check.isSelected();
        } else if (cmd == "showCIB5") {
            this.showCIB5 = check.isSelected();
        } else if (cmd == "showMISC") {
            this.showMISC = check.isSelected();
        } else {
            System.err.println("Unknown action command \"" + cmd + "\" in RpfCoverageLayer.actionPerformed().");
        }
        this.layer.repaint();
    }
}

