/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.rpf;

import com.bbn.openmap.layer.rpf.RpfCoverageBox;
import com.bbn.openmap.layer.rpf.RpfFrameProvider;
import com.bbn.openmap.layer.rpf.RpfProductInfo;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMRect;
import com.bbn.openmap.proj.CADRG;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.Color;
import java.util.Vector;

public class RpfCoverageManager {
    protected int currentLineType;
    public static final String defaultCGColorString = "AC4853";
    public static final String defaultTLMColorString = "CE4F3F";
    public static final String defaultJOGColorString = "AC7D74";
    public static final String defaultTPCColorString = "ACCD10";
    public static final String defaultONCColorString = "FCCDE5";
    public static final String defaultJNCColorString = "7386E5";
    public static final String defaultGNCColorString = "55866B";
    public static final String defaultCIB10ColorString = "07516B";
    public static final String defaultCIB5ColorString = "071CE0";
    public static final String defaultMISCColorString = "F2C921";
    protected Color CGColor = new Color(Integer.parseInt("AC4853", 16));
    protected Color TLMColor = new Color(Integer.parseInt("CE4F3F", 16));
    protected Color JOGColor = new Color(Integer.parseInt("AC7D74", 16));
    protected Color TPCColor = new Color(Integer.parseInt("ACCD10", 16));
    protected Color ONCColor = new Color(Integer.parseInt("FCCDE5", 16));
    protected Color JNCColor = new Color(Integer.parseInt("7386E5", 16));
    protected Color GNCColor = new Color(Integer.parseInt("55866B", 16));
    protected Color CIB10Color = new Color(Integer.parseInt("07516B", 16));
    protected Color CIB5Color = new Color(Integer.parseInt("071CE0", 16));
    protected Color MISCColor = new Color(Integer.parseInt("F2C921", 16));
    protected int opaqueness = 255;
    protected boolean fillRects = true;
    protected Vector omGraphics = null;
    protected RpfFrameProvider frameProvider;

    public RpfCoverageManager(RpfFrameProvider rfp) {
        this.frameProvider = rfp;
        this.omGraphics = new Vector();
    }

    public void setColors(Color[] colors, int opaque, boolean fillRectangles) {
        if (colors.length == 10) {
            this.CGColor = colors[0];
            this.TLMColor = colors[1];
            this.JOGColor = colors[2];
            this.TPCColor = colors[3];
            this.ONCColor = colors[4];
            this.JNCColor = colors[5];
            this.GNCColor = colors[6];
            this.CIB10Color = colors[7];
            this.CIB5Color = colors[8];
            this.MISCColor = colors[9];
        }
        this.opaqueness = opaque;
        this.fillRects = fillRectangles;
    }

    protected Vector getCatalogCoverage(float ullat, float ullon, float lrlat, float lrlon, Projection proj, String chartSeries) {
        Debug.message("rpfcov", "RpfCoverageManager: Getting catalog coverage from RpfFrameProvider");
        if (proj == null || this.frameProvider == null) {
            return new Vector();
        }
        CADRG cadrg = proj instanceof CADRG ? (CADRG)proj : new CADRG(proj.getCenter(), proj.getScale(), proj.getWidth(), proj.getHeight());
        Vector[] hemisphereData = ullon > 0.0f && lrlon < 0.0f || (double)Math.abs(ullon - lrlon) < 0.001 ? new Vector[]{this.frameProvider.getCatalogCoverage(ullat, ullon, lrlat, 180.0f, cadrg, chartSeries), this.frameProvider.getCatalogCoverage(ullat, -180.0f, lrlat, lrlon, cadrg, chartSeries)} : new Vector[]{this.frameProvider.getCatalogCoverage(ullat, ullon, lrlat, lrlon, cadrg, chartSeries)};
        this.omGraphics.removeAllElements();
        this.currentLineType = 2;
        OMGraphicList cgs = new OMGraphicList();
        OMGraphicList tlms = new OMGraphicList();
        OMGraphicList jogs = new OMGraphicList();
        OMGraphicList tpcs = new OMGraphicList();
        OMGraphicList oncs = new OMGraphicList();
        OMGraphicList jncs = new OMGraphicList();
        OMGraphicList gncs = new OMGraphicList();
        OMGraphicList cib10s = new OMGraphicList();
        OMGraphicList cib5s = new OMGraphicList();
        OMGraphicList miscs = new OMGraphicList();
        this.omGraphics.addElement(cgs);
        this.omGraphics.addElement(cib5s);
        this.omGraphics.addElement(tlms);
        this.omGraphics.addElement(cib10s);
        this.omGraphics.addElement(jogs);
        this.omGraphics.addElement(miscs);
        this.omGraphics.addElement(tpcs);
        this.omGraphics.addElement(oncs);
        this.omGraphics.addElement(jncs);
        this.omGraphics.addElement(gncs);
        int j = 0;
        while (j < hemisphereData.length) {
            block17: {
                block16: {
                    if (hemisphereData[j] != null) break block16;
                    Debug.message("rpfcov", "RpfCoverageManager. vector " + j + " is null");
                    break block17;
                }
                int size = hemisphereData[j].size();
                int i = 0;
                while (i < size) {
                    block28: {
                        OMRect rect;
                        block19: {
                            float scale;
                            block27: {
                                block26: {
                                    block25: {
                                        block24: {
                                            block23: {
                                                block22: {
                                                    block21: {
                                                        block20: {
                                                            block18: {
                                                                RpfCoverageBox box = (RpfCoverageBox)hemisphereData[j].elementAt(i);
                                                                rect = new OMRect((float)box.nw_lat, (float)box.nw_lon, (float)box.se_lat, (float)box.se_lon, this.currentLineType);
                                                                scale = RpfProductInfo.get((String)box.chartCode).scale;
                                                                if (!(scale < 15000.0f)) break block18;
                                                                rect.setLinePaint(this.CGColor);
                                                                if (this.fillRects) {
                                                                    rect.setFillPaint(this.CGColor);
                                                                }
                                                                cgs.add(rect);
                                                                break block19;
                                                            }
                                                            if (scale != 50000.0f) break block20;
                                                            rect.setLinePaint(this.TLMColor);
                                                            if (this.fillRects) {
                                                                rect.setFillPaint(this.TLMColor);
                                                            }
                                                            tlms.add(rect);
                                                            break block19;
                                                        }
                                                        if (scale != 250000.0f) break block21;
                                                        rect.setLinePaint(this.JOGColor);
                                                        if (this.fillRects) {
                                                            rect.setFillPaint(this.JOGColor);
                                                        }
                                                        jogs.add(rect);
                                                        break block19;
                                                    }
                                                    if (scale != 500000.0f) break block22;
                                                    rect.setLinePaint(this.TPCColor);
                                                    if (this.fillRects) {
                                                        rect.setFillPaint(this.TPCColor);
                                                    }
                                                    tpcs.add(rect);
                                                    break block19;
                                                }
                                                if (scale != 1000000.0f) break block23;
                                                rect.setLinePaint(this.ONCColor);
                                                if (this.fillRects) {
                                                    rect.setFillPaint(this.ONCColor);
                                                }
                                                oncs.add(rect);
                                                break block19;
                                            }
                                            if (scale != 2000000.0f) break block24;
                                            rect.setLinePaint(this.JNCColor);
                                            if (this.fillRects) {
                                                rect.setFillPaint(this.JNCColor);
                                            }
                                            jncs.add(rect);
                                            break block19;
                                        }
                                        if (scale != 5000000.0f) break block25;
                                        rect.setLinePaint(this.GNCColor);
                                        if (this.fillRects) {
                                            rect.setFillPaint(this.GNCColor);
                                        }
                                        gncs.add(rect);
                                        break block19;
                                    }
                                    if (scale != 66666.0f) break block26;
                                    rect.setLinePaint(this.CIB10Color);
                                    if (this.fillRects) {
                                        rect.setFillPaint(this.CIB10Color);
                                    }
                                    cib10s.add(rect);
                                    break block19;
                                }
                                if (scale != 33333.0f) break block27;
                                rect.setLinePaint(this.CIB5Color);
                                if (this.fillRects) {
                                    rect.setFillPaint(this.CIB5Color);
                                }
                                cib5s.add(rect);
                                break block19;
                            }
                            if (scale == -1.0f) break block28;
                            rect.setLinePaint(this.MISCColor);
                            if (this.fillRects) {
                                rect.setFillPaint(this.MISCColor);
                            }
                            miscs.add(rect);
                        }
                        rect.generate(proj);
                    }
                    ++i;
                }
            }
            ++j;
        }
        return this.omGraphics;
    }
}

