/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.rpf;

import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.layer.policy.ListResetPCPolicy;
import com.bbn.openmap.layer.rpf.RpfCacheManager;
import com.bbn.openmap.layer.rpf.RpfConstants;
import com.bbn.openmap.layer.rpf.RpfCoverage;
import com.bbn.openmap.layer.rpf.RpfCoverageBox;
import com.bbn.openmap.layer.rpf.RpfFrameCacheHandler;
import com.bbn.openmap.layer.rpf.RpfFrameProvider;
import com.bbn.openmap.layer.rpf.RpfViewAttributes;
import com.bbn.openmap.layer.util.LayerUtils;
import com.bbn.openmap.layer.util.cacheHandler.CacheHandler;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.proj.CADRG;
import com.bbn.openmap.proj.EqualArc;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PaletteHelper;
import com.bbn.openmap.util.PropUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RpfLayer
extends OMGraphicHandlerLayer
implements ActionListener,
RpfConstants,
Serializable {
    protected transient RpfCacheManager cache = null;
    protected String[] paths;
    protected RpfViewAttributes viewAttributes = new RpfViewAttributes();
    protected boolean killCache = true;
    protected RpfFrameProvider frameProvider;
    protected RpfCoverage coverage;
    protected int subframeCacheSize;
    protected int auxSubframeCacheSize;
    private transient Box box = null;

    public RpfLayer() {
        this.setProjectionChangePolicy(new ListResetPCPolicy(this));
    }

    public RpfLayer(String[] pathsToRPFDirs) {
        this();
        this.setPaths(pathsToRPFDirs);
    }

    public void setPaths(String[] pathsToRPFDirs) {
        if (pathsToRPFDirs != null) {
            this.setFrameProvider(new RpfFrameCacheHandler(pathsToRPFDirs));
        } else {
            Debug.output("RpfLayer: Need RPF directory paths.");
            this.frameProvider = null;
        }
        this.paths = pathsToRPFDirs;
        this.cache = null;
    }

    public String[] getPaths() {
        return this.paths;
    }

    public void removed(Container cont) {
        if (this.killCache) {
            Debug.message("rpf", "RpfLayer: emptying cache!");
            this.clearCache();
        }
        this.setProjection((Projection)null);
    }

    protected void setDefaultValues() {
        this.paths = null;
    }

    public void setProperties(String prefix, Properties properties) {
        super.setProperties(prefix, properties);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.paths = LayerUtils.initPathsFromProperties(properties, prefix + "paths");
        this.viewAttributes.setProperties(prefix, properties);
        this.subframeCacheSize = LayerUtils.intFromProperties(properties, prefix + "subframeCacheSize", 20);
        this.auxSubframeCacheSize = LayerUtils.intFromProperties(properties, prefix + "subframeCacheSize", 10);
        if (this.viewAttributes.chartSeries == null) {
            this.viewAttributes.chartSeries = "ANY";
        }
        this.killCache = LayerUtils.booleanFromProperties(properties, prefix + "killCache", true);
        if (LayerUtils.booleanFromProperties(properties, prefix + "coverage", false)) {
            this.setCoverage(new RpfCoverage(this));
            this.coverage.setProperties(prefix, properties);
        }
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        String[] p = this.getPaths();
        StringBuffer pathString = new StringBuffer();
        if (p != null) {
            int i = 0;
            while (i < p.length) {
                if (p[i] != null) {
                    pathString.append(p[i]);
                    if (i < p.length - 1) {
                        pathString.append(";");
                    }
                }
                ++i;
            }
            props.put(prefix + "paths", pathString.toString());
        } else {
            props.put(prefix + "paths", "");
        }
        props.put(prefix + "killCache", new Boolean(this.killCache).toString());
        props.put(prefix + "coverage", new Boolean(this.coverage == null).toString());
        props.put(prefix + "subframeCacheSize", Integer.toString(this.subframeCacheSize));
        props.put(prefix + "auxSubframeCacheSize", Integer.toString(this.auxSubframeCacheSize));
        this.viewAttributes.setPropertyPrefix(prefix);
        this.viewAttributes.getProperties(props);
        if (this.coverage == null) {
            RpfCoverage cov = new RpfCoverage(this);
            cov.setProperties(prefix, new Properties());
            cov.getProperties(props);
        } else {
            this.coverage.getProperties(props);
        }
        return props;
    }

    public Properties getPropertyInfo(Properties list) {
        list = super.getPropertyInfo(list);
        list.put("paths", "Paths to RPF directories.  Semi-colon separated paths");
        list.put("paths.editor", "com.bbn.openmap.util.propertyEditor.MultiDirectoryPropertyEditor");
        list.put("killCache", "Flag to trigger the cache to be cleared when layer is removed from the map.");
        list.put("killCache.editor", "com.bbn.openmap.util.propertyEditor.OnOffPropertyEditor");
        list.put("coverage", "Flag that adds the coverage tool to the layer.");
        list.put("coverage.editor", "com.bbn.openmap.util.propertyEditor.OnOffPropertyEditor");
        list.put("subframeCacheSize", "Number of frames to hold in the frame cache.");
        list.put("auxSubframeCacheSize", "Number of subframes to hold in the subframe cache.");
        this.viewAttributes.getPropertyInfo(list);
        RpfCoverage tmpCov = this.coverage;
        if (tmpCov == null) {
            tmpCov = new RpfCoverage(this);
        }
        tmpCov.getPropertyInfo(list);
        list.put("initProperties", "paths killCache subframeCacheSize auxSubframeCacheSize " + this.viewAttributes.getInitPropertiesOrder() + " " + "addToBeanContext" + " " + "background" + " " + "removeable" + " " + "coverage" + " " + tmpCov.getInitPropertiesOrder());
        return list;
    }

    public synchronized void setGraphicList(OMGraphicList aList) {
        this.setList(aList);
    }

    public synchronized OMGraphicList getGraphicList() {
        return this.getList();
    }

    public void clearCache() {
        if (this.frameProvider instanceof CacheHandler) {
            ((CacheHandler)((Object)this.frameProvider)).resetCache();
        }
        if (this.cache != null) {
            this.cache.setViewAttributes(null);
            this.cache.setFrameProvider(null);
            this.cache.clearCaches();
        }
        this.frameProvider = null;
        this.setGraphicList(null);
        this.cache = null;
    }

    public void setViewAttributes(RpfViewAttributes rva) {
        this.viewAttributes = rva;
        if (this.cache != null) {
            this.cache.setViewAttributes(rva);
        }
    }

    public RpfViewAttributes getViewAttributes() {
        return this.viewAttributes;
    }

    public void setCoverage(RpfCoverage cov) {
        this.coverage = cov;
        if (this.viewAttributes != null && this.coverage != null && !this.viewAttributes.chartSeries.equalsIgnoreCase("ANY")) {
            this.coverage.setShowPalette(false);
        }
    }

    public RpfCoverage getCoverage() {
        return this.coverage;
    }

    public void setFrameProvider(RpfFrameProvider fp) {
        this.frameProvider = fp;
        if (this.cache != null) {
            this.cache.setFrameProvider(this.frameProvider);
        }
    }

    public RpfFrameProvider getFrameProvider() {
        return this.frameProvider;
    }

    public Vector getCoverageBoxes() {
        return this.cache.getCoverageBoxes();
    }

    public void projectionChanged(ProjectionEvent e) {
        this.projectionChanged(e, false);
    }

    public void projectionChanged(ProjectionEvent e, boolean saveGraphicsForRedraw) {
        Debug.message("basic", this.getName() + "|RpfLayer.projectionChanged()");
        Projection oldProj = this.getProjection();
        Projection newProj = this.setProjection(e);
        if (newProj == null) {
            this.repaint();
            return;
        }
        if (saveGraphicsForRedraw && oldProj instanceof CADRG && newProj instanceof CADRG) {
            CADRG cadrg1 = (CADRG)oldProj;
            CADRG cadrg2 = (CADRG)newProj;
            if (cadrg1.getScale() != cadrg2.getScale() || cadrg1.getZone() != cadrg2.getZone()) {
                this.setGraphicList(null);
            }
        } else {
            this.setGraphicList(null);
        }
        this.doPrepare();
    }

    public synchronized OMGraphicList prepare() {
        OMGraphicList omGraphicList;
        if (this.isCancelled()) {
            Debug.message("rpf", this.getName() + "|RpfLayer.prepare(): aborted.");
            return null;
        }
        if (this.frameProvider == null) {
            this.setPaths(this.paths);
            if (this.frameProvider == null) {
                Debug.error(this.getName() + "|RpfLayer.prepare(): null frame provider - either no RPF paths were set, or no frame provider was assigned.  The RpfLayer has no way to get RPF data.");
                return new OMGraphicList();
            }
        }
        if (this.cache == null) {
            Debug.message("rpf", this.getName() + "|RpfLayer: Creating cache!");
            this.cache = new RpfCacheManager(this.frameProvider, this.viewAttributes, this.subframeCacheSize, this.auxSubframeCacheSize);
        }
        Projection projection = this.getProjection();
        if (this.coverage != null && this.coverage.isInUse()) {
            this.coverage.prepare(this.frameProvider, projection, this.viewAttributes.chartSeries);
        }
        if (!(projection instanceof EqualArc) && (this.viewAttributes.showMaps || this.viewAttributes.showInfo)) {
            this.fireRequestInfoLine("RpfLayer requires an Equal Arc projection (CADRG/LLXY) for images or attributes!");
            return null;
        }
        Debug.message("basic", this.getName() + "|RpfLayer.prepare(): doing it");
        if (Debug.debugging("rpf")) {
            Debug.output(this.getName() + "|RpfLayer.prepare(): " + "calling getRectangle " + " with projection: " + projection + " ul = " + projection.getUpperLeft() + " lr = " + projection.getLowerRight());
        }
        if (this.frameProvider.needViewAttributeUpdates()) {
            this.frameProvider.setViewAttributes(this.viewAttributes);
        }
        Projection cadrgProj = projection;
        if (!(projection instanceof CADRG)) {
            cadrgProj = new CADRG(projection.getCenter(), projection.getScale(), projection.getWidth(), projection.getHeight());
            Point ulp = cadrgProj.forward(projection.getUpperLeft());
            Point lrp = cadrgProj.forward(projection.getLowerRight());
            int w = (int)Math.abs(lrp.getX() - ulp.getX());
            int h = (int)Math.abs(lrp.getY() - ulp.getY());
            cadrgProj = new CADRG(projection.getCenter(), projection.getScale(), w, h);
        }
        try {
            omGraphicList = this.cache.getRectangle(cadrgProj);
        }
        catch (NullPointerException npe) {
            Debug.error(this.getName() + "|RpfLayer.prepare(): Something really bad happened - \n " + npe);
            npe.printStackTrace();
            omGraphicList = new OMGraphicList();
            this.cache = null;
        }
        int size = 0;
        if (omGraphicList != null) {
            size = omGraphicList.size();
            if (Debug.debugging("basic")) {
                Debug.output("RpfLayer.prepare(): finished with " + size + " graphics");
            }
            omGraphicList.project(projection, true);
        } else {
            Debug.message("basic", "RpfLayer.prepare(): finished with null graphics list");
        }
        return omGraphicList;
    }

    public void paint(Graphics g) {
        Debug.message("rpf", "RpfLayer.paint()");
        super.paint(g);
        if (this.coverage != null && this.coverage.isInUse()) {
            this.coverage.paint(g);
        }
    }

    public Component getGUI() {
        if (this.box == null) {
            this.box = Box.createVerticalBox();
            Box box1 = Box.createVerticalBox();
            Box box2 = Box.createVerticalBox();
            JPanel topbox = new JPanel();
            JPanel subbox2 = new JPanel();
            JCheckBox showMapsCheck = new JCheckBox("Show Images", this.viewAttributes.showMaps);
            showMapsCheck.setActionCommand("mapsCheckCmd");
            showMapsCheck.addActionListener(this);
            JCheckBox showInfoCheck = new JCheckBox("Show Attributes", this.viewAttributes.showInfo);
            showInfoCheck.setActionCommand("infoCheckCmd");
            showInfoCheck.addActionListener(this);
            String tmpCS = this.viewAttributes.chartSeries;
            if (tmpCS == null) {
                tmpCS = "ANY";
            }
            boolean locked = !tmpCS.equalsIgnoreCase("ANY");
            String lockedTitle = locked ? "Displaying Only - " + tmpCS : "Limit Chart Selection";
            JCheckBox lockSeriesCheck = new JCheckBox(lockedTitle, locked);
            lockSeriesCheck.setActionCommand("lockSeriesCmd");
            lockSeriesCheck.addActionListener(this);
            box1.add(showMapsCheck);
            box1.add(showInfoCheck);
            box1.add(lockSeriesCheck);
            if (this.coverage != null) {
                JCheckBox showCoverageCheck = this.coverage.isShowPalette() ? new JCheckBox("Show Coverage Tool", false) : new JCheckBox("Show Coverage", false);
                showCoverageCheck.setActionCommand("coverageCheckCmd");
                showCoverageCheck.addActionListener(this);
                box1.add(showCoverageCheck);
            }
            topbox.add(box1);
            topbox.add(box2);
            this.box.add(topbox);
            JPanel opaquePanel = PaletteHelper.createPaletteJPanel("Map Opaqueness");
            JSlider opaqueSlide = new JSlider(0, 0, 255, this.viewAttributes.opaqueness);
            Hashtable<Integer, JLabel> dict = new Hashtable<Integer, JLabel>();
            dict.put(new Integer(0), new JLabel("clear"));
            dict.put(new Integer(255), new JLabel("opaque"));
            opaqueSlide.setLabelTable(dict);
            opaqueSlide.setPaintLabels(true);
            opaqueSlide.setMajorTickSpacing(50);
            opaqueSlide.setPaintTicks(true);
            opaqueSlide.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent ce) {
                    JSlider slider = (JSlider)ce.getSource();
                    if (slider.getValueIsAdjusting()) {
                        RpfLayer.this.viewAttributes.opaqueness = slider.getValue();
                        RpfLayer.this.fireRequestInfoLine("RPF Opaqueness set to " + RpfLayer.this.viewAttributes.opaqueness + " for future requests.");
                    }
                }
            });
            opaquePanel.add(opaqueSlide);
            this.box.add(opaquePanel);
            JButton redraw = new JButton("Redraw RPF Layer");
            redraw.addActionListener(this);
            subbox2.add(redraw);
            this.box.add(subbox2);
        }
        return this.box;
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        String cmd = e.getActionCommand();
        if (cmd == "mapsCheckCmd") {
            JCheckBox mapCheck = (JCheckBox)e.getSource();
            this.viewAttributes.showMaps = mapCheck.isSelected();
            this.repaint();
        } else if (cmd == "infoCheckCmd") {
            JCheckBox infoCheck = (JCheckBox)e.getSource();
            this.viewAttributes.showInfo = infoCheck.isSelected();
            this.repaint();
        } else if (cmd == "lockSeriesCmd") {
            JCheckBox lockCheck = (JCheckBox)e.getSource();
            boolean locked = lockCheck.isSelected();
            if (locked) {
                Vector vector = this.getCoverageBoxes();
                String seriesName = vector == null || vector.size() == 0 ? "ANY" : ((RpfCoverageBox)vector.elementAt((int)0)).chartCode;
                if (seriesName == null) {
                    seriesName = "ANY";
                    this.fireRequestMessage("The " + this.getName() + " Layer is having trouble determining what kind\nof charts are being displayed.  Can't establish lock for charts\ncurrently being viewed.");
                }
                lockCheck.setText("Displaying Only - " + seriesName);
                this.viewAttributes.chartSeries = seriesName;
            } else {
                lockCheck.setText("Limit Chart Selection");
                this.viewAttributes.chartSeries = "ANY";
            }
        } else if (cmd == "coverageCheckCmd") {
            if (this.coverage != null) {
                JCheckBox coverageCheck = (JCheckBox)e.getSource();
                this.coverage.setInUse(coverageCheck.isSelected());
                if (this.coverage.isInUse()) {
                    this.coverage.prepare(this.frameProvider, this.getProjection(), this.viewAttributes.chartSeries);
                }
                this.repaint();
            }
        } else {
            this.doPrepare();
        }
    }

    public static void main(String[] argv) {
        System.out.println("#########################################");
        System.out.println("# Properties for the JAVA RpfLayer");
        System.out.println("# Mandatory properties:");
        System.out.println("layer.class=com.bbn.openmap.layer.rpf.RpfLayer");
        System.out.println("layer.prettyName=CADRG");
        System.out.println("# This property should reflect the paths to the RPF directories");
        System.out.println("layer.paths=<Path to RPF dir>;/cdrom/cdrom0/RPF");
        System.out.println("# Optional properties - Defaults will be set for properties not included (defaults are listed):");
        System.out.println("# Number between 0-255: 0 is transparent, 255 is opaque");
        System.out.println("layer.opaque=255");
        System.out.println("# Number of colors to use on the maps - 16, 32, 216");
        System.out.println("layer.numberColors=216");
        System.out.println("# Display maps on startup");
        System.out.println("layer.showMaps=true");
        System.out.println("# Display attribute information on startup");
        System.out.println("layer.showInfo=false");
        System.out.println("# Scale images to match map scale");
        System.out.println("layer.scaleImages=true");
        System.out.println("# The scale factor to allow when scaling images (2x, 4x, also mean 1/2, 1/4).  Default is 4.");
        System.out.println("rpf.imageScaleFactor=4");
        System.out.println("# Reset the cache if layer is removed from map");
        System.out.println("layer.killCache=false");
        System.out.println("# Limit the display to the chart code specified. (GN, JN, ON, TP, etc.)");
        System.out.println("layer.chartSeries=ANY");
        System.out.println("# Set the subframe cache size. (Number of subframes to hold on to, 256x256 pixels");
        System.out.println("layer.subframeCacheSize=128");
        System.out.println("# Get the subframe attribute data from the frame provider.");
        System.out.println("rpf.autofetchAttributes=false");
        System.out.println("#If you want the coverage tool to be available");
        System.out.println("layer.coverage=true");
        System.out.println("#Then add coverage constants as needed.");
    }
}

