/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.rpf;

import com.bbn.openmap.omGraphics.OMRect;
import com.bbn.openmap.omGraphics.OMScalingRaster;
import com.bbn.openmap.omGraphics.OMText;
import java.awt.Color;
import java.awt.Font;

public class RpfSubframe {
    public int version;
    public OMScalingRaster image;
    public OMText information;
    public OMRect rectangle;
    public int nextSubframe;
    public int prevSubframe;
    public static final int PIXEL_EDGE_SIZE = 256;
    protected int colorModel;
    protected String data = "";
    public int opaqueness;

    public RpfSubframe() {
        this(0);
    }

    public RpfSubframe(int colormodel) throws OutOfMemoryError {
        this.init(colormodel);
    }

    protected void init(int colormodel) {
        if (this.image != null && this.colorModel == colormodel) {
            return;
        }
        this.colorModel = colormodel;
        this.image = this.colorModel == 0 ? new OMScalingRaster(0.0f, 0.0f, 0.0f, 0.0f, 256, 256, new int[65536]) : new OMScalingRaster(0.0f, 0.0f, 0.0f, 0.0f, 256, 256, (byte[])null, (Color[])null, this.opaqueness);
        this.information = new OMText(0.0f, 0.0f, 10, 20, "***", new Font("Helvetica", 0, 10), 0);
        this.information.setLinePaint(Color.red);
        this.rectangle = new OMRect(0.0f, 0.0f, 0.0f, 0.0f, 1);
        this.rectangle.setLinePaint(Color.red);
        this.rectangle.setLineType(1);
    }

    public int getColorModel() {
        return this.colorModel;
    }

    public void setColorModel(int colorModel) {
        this.init(colorModel);
    }

    public void setScalingTo(int width, int height) {
        if (width == 256 && height == 256) {
            this.information.setData(this.data);
        } else if (width > 256 && height > 256) {
            this.information.setData(this.data);
        } else {
            this.information.setData("");
        }
        this.rectangle.setLocation(this.image.getLat(), this.image.getLon(), 0, 0, width, height);
    }

    public void setLocation(float lat, float lon) {
        this.image.setLat(lat);
        this.image.setLon(lon);
        this.information.setLat(lat);
        this.information.setLon(lon);
        this.rectangle.setLocation(lat, lon, 0, 0, this.rectangle.getRight(), this.rectangle.getBottom());
    }

    public void setLocation(float ulat, float wlon, float llat, float elon) {
        this.image.setULLat(ulat);
        this.image.setULLon(wlon);
        this.image.setLRLat(llat);
        this.image.setLRLon(elon);
        this.information.setLat(ulat);
        this.information.setLon(wlon);
        this.rectangle.setLocation(ulat, wlon, llat, elon, 1);
    }

    public void setAttributeText(String text) {
        this.data = text;
    }

    public String getAttributeText() {
        return this.data;
    }
}

