/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.rpf;

import com.bbn.openmap.io.BinaryBufferedFile;
import com.bbn.openmap.io.BinaryFile;
import com.bbn.openmap.io.FileInputReader;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.rpf.RpfConstants;
import com.bbn.openmap.layer.rpf.RpfFileSections;
import com.bbn.openmap.layer.rpf.RpfFrameCacheHandler;
import com.bbn.openmap.layer.rpf.RpfFrameEntry;
import com.bbn.openmap.layer.rpf.RpfHeader;
import com.bbn.openmap.layer.rpf.RpfProductInfo;
import com.bbn.openmap.layer.rpf.RpfTocEntry;
import com.bbn.openmap.layer.rpf.RpfViewAttributes;
import com.bbn.openmap.proj.CADRG;
import com.bbn.openmap.util.Debug;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Vector;

public class RpfTocHandler {
    public static final String RPF_TOC_FILE_NAME = "A.TOC";
    public static final String LITTLE_RPF_TOC_FILE_NAME = "a.toc";
    public static final int DEFAULT_FRAME_SPACE = 300;
    protected RpfHeader head;
    protected BinaryFile binFile;
    protected RpfFileSections.RpfLocationRecord[] locations;
    protected RpfTocEntry[] entries;
    protected String dir;
    protected boolean Dchum;
    protected long estimateDiskSpace;
    protected int numBoundaries;
    protected long currencyTime;
    protected boolean valid = false;
    private int tocNumber = 0;
    protected Vector entryResponses = new Vector();
    protected boolean fullPathsInATOC = false;
    protected boolean DEBUG_RPF = false;
    protected boolean DEBUG_RPFTOC = false;
    protected boolean DEBUG_RPFTOCDETAIL = false;
    protected boolean DEBUG_RPFTOCFRAMEDETAIL = false;
    private static final int[] CADRG_zone_extents = new int[]{0, 32, 48, 56, 64, 68, 72, 76, 80, 90};

    public RpfTocHandler() {
        this.estimateDiskSpace = 300L;
        if (Debug.debugging("rpftoc")) {
            Debug.error("RpfTocHandler: No TOC parent directory name in constructor");
        }
    }

    public RpfTocHandler(String parentDir) {
        this(parentDir, 0);
    }

    public RpfTocHandler(String parentDir, int TOCNumber) {
        this.tocNumber = TOCNumber;
        this.estimateDiskSpace = 300L;
        this.valid = this.loadFile(parentDir);
        if (!this.valid) {
            Debug.error("RpfTocHandler: Invalid TOC File in " + parentDir);
        }
        this.DEBUG_RPF = Debug.debugging("rpf");
        this.DEBUG_RPFTOC = Debug.debugging("rpftoc");
        this.DEBUG_RPFTOCDETAIL = Debug.debugging("rpftocdetail");
        this.DEBUG_RPFTOCFRAMEDETAIL = Debug.debugging("rpftocframedetail");
    }

    public File getTocFile(String parentDir) {
        File file = new File(parentDir + "/" + RPF_TOC_FILE_NAME);
        if (!file.exists() && !(file = new File(parentDir + "/" + LITTLE_RPF_TOC_FILE_NAME)).exists()) {
            return null;
        }
        if (this.DEBUG_RPFTOCDETAIL) {
            Debug.output("RpfTocHandler: getTocFile(): TOC file is " + file);
        }
        return file;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean hasChanged() {
        return false;
    }

    public boolean reload() {
        return this.loadFile(this.dir);
    }

    public boolean loadFile(String parentDir) {
        boolean ret = true;
        String upperCaseVersion = parentDir + "/" + RPF_TOC_FILE_NAME;
        String lowerCaseVersion = parentDir + "/" + LITTLE_RPF_TOC_FILE_NAME;
        try {
            if (BinaryFile.exists(upperCaseVersion)) {
                this.binFile = new BinaryBufferedFile(upperCaseVersion);
            } else if (BinaryFile.exists(lowerCaseVersion)) {
                this.binFile = new BinaryBufferedFile(lowerCaseVersion);
            }
            if (this.binFile == null) {
                return false;
            }
            if (this.DEBUG_RPFTOC) {
                Debug.output("RpfTocHandler: TOC file is in " + parentDir);
            }
            this.dir = parentDir + "/";
            if (!this.parseToc(this.binFile)) {
                ret = false;
                Debug.error("RpfTocHandler: loadFile(): error parsing A.TOC file!!");
            }
            this.binFile.close();
        }
        catch (IOException e) {
            ret = false;
        }
        this.binFile = null;
        return ret;
    }

    protected boolean parseToc(BinaryFile binFile) {
        int indexSubheaderLength = 9;
        if (this.DEBUG_RPFTOC) {
            Debug.output("ENTER TOC parsing...");
        }
        boolean local = false;
        if (binFile.getInputReader() instanceof FileInputReader) {
            local = true;
        }
        try {
            binFile.seek(0L);
            this.head = new RpfHeader();
            if (!this.head.read(binFile)) {
                return false;
            }
            if (this.DEBUG_RPFTOC) {
                Debug.output("RpfTocHandler.parseToc: read header:\n" + this.head);
            }
            binFile.seek(this.head.locationSectionLocation);
            RpfFileSections rfs = new RpfFileSections(binFile);
            RpfFileSections.RpfLocationRecord[] locations = rfs.getLocations(4);
            if (this.DEBUG_RPFTOCDETAIL) {
                Debug.output("RpfTocHandler: parseToc(): fseek to Boundary section subheader: " + locations[0].componentLocation);
            }
            binFile.seek(locations[0].componentLocation);
            long boundRectTableOffset = binFile.readInteger();
            if (this.DEBUG_RPFTOCDETAIL) {
                Debug.output("RpfTocHandler: parseToc(): BoundRectTableOffset: " + boundRectTableOffset);
            }
            int n = binFile.readShort();
            if (this.DEBUG_RPFTOCDETAIL) {
                Debug.output("RpfTocHandler: parseToc(): # Boundary rect. recs: " + n);
            }
            this.numBoundaries = n;
            short boundaryRecordLength = binFile.readShort();
            if (this.DEBUG_RPFTOCDETAIL) {
                Debug.output("RpfTocHandler: parseToc(): should be 132: " + boundaryRecordLength);
            }
            if (this.DEBUG_RPFTOCDETAIL) {
                Debug.output("RpfTocHandler: parseToc(): fseek to Boundary Rectangle Table: " + locations[1].componentLocation);
            }
            binFile.seek(locations[1].componentLocation);
            this.entries = new RpfTocEntry[this.numBoundaries];
            int i = 0;
            while (i < n) {
                if (this.DEBUG_RPFTOCDETAIL) {
                    Debug.output("RpfTocHandler: parseToc(): read boundary rec#: " + i);
                }
                this.entries[i] = new RpfTocEntry(binFile, this.tocNumber, i);
                if (this.DEBUG_RPFTOCDETAIL) {
                    Debug.output("RpfTocHandler: parseToc(): entry " + i + " has scale " + this.entries[i].scale + ", type " + (this.entries[i].Cib ? "CIB" : "CADRG") + " in zone " + this.entries[i].zone);
                    if (this.entries[i].Cib) {
                        Debug.output("RpfTocHandler: parseToc(): entry noted as a Cib entry.");
                    }
                }
                ++i;
            }
            if (this.DEBUG_RPFTOCDETAIL) {
                Debug.output("RpfTocHandler: parseToc(): Read frame file index section subheader at loc: " + locations[2].componentLocation);
            }
            binFile.seek(locations[2].componentLocation + 1L);
            long frameIndexTableOffset = binFile.readInteger();
            long numFrameIndexRecords = binFile.readInteger();
            short numPathnameRecords = binFile.readShort();
            short indexRecordLength = binFile.readShort();
            if (this.DEBUG_RPFTOCDETAIL) {
                Debug.output("RpfTocHandler: parseToc(): frameIndexTableOffset: " + frameIndexTableOffset);
                Debug.output("RpfTocHandler: parseToc(): # Frame file index recs: " + numFrameIndexRecords);
                Debug.output("RpfTocHandler: parseToc(): # pathname records: " + numPathnameRecords);
                Debug.output("RpfTocHandler: parseToc(): Index rec len(33): " + indexRecordLength);
            }
            i = 0;
            while ((long)i < numFrameIndexRecords) {
                if (this.DEBUG_RPFTOCFRAMEDETAIL) {
                    Debug.output("RpfTocHandler: parseToc(): Read frame file index rec #: " + i);
                }
                binFile.seek(locations[3].componentLocation + (long)(indexRecordLength * i));
                short boundaryId = binFile.readShort();
                if (this.DEBUG_RPFTOCFRAMEDETAIL) {
                    Debug.output("boundary id for frame: " + i + " is " + boundaryId);
                }
                if (boundaryId > this.numBoundaries - 1) {
                    Debug.output("Bad boundary id in FF index record " + i);
                    return false;
                }
                RpfTocEntry entry = this.entries[boundaryId];
                short frameRow = binFile.readShort();
                short frameCol = binFile.readShort();
                if (frameRow > entry.vertFrames - 1) {
                    Debug.output(" Bad row number: " + frameRow + ", in FF index record " + i);
                    Debug.output(" Min row num=0;  Max. row num:" + (entry.horizFrames - 1));
                    return false;
                }
                if (frameCol > entry.horizFrames - 1) {
                    Debug.output(" Bad col number in FF index record " + i);
                    return false;
                }
                RpfFrameEntry frame = entry.frames[entry.vertFrames - 1 - frameRow][frameCol];
                if (frame.exists && this.DEBUG_RPFTOCDETAIL) {
                    Debug.output("FF " + i + " is a duplicate");
                }
                long pathOffset = binFile.readInteger();
                int currentPosition = (int)binFile.getFilePointer();
                if (this.DEBUG_RPFTOCFRAMEDETAIL) {
                    Debug.output("RpfTocHandler: parseToc(): locations[1].componentLocation: " + locations[1].componentLocation);
                }
                binFile.seek(locations[3].componentLocation + pathOffset);
                short pathLength = binFile.readShort();
                if (this.DEBUG_RPFTOCFRAMEDETAIL) {
                    Debug.output("RpfTocHandler: parseToc(): pathLength:" + pathLength);
                }
                frame.rpfdir = this.dir;
                StringBuffer sBuf = new StringBuffer();
                String pathTest = binFile.readFixedLengthString(2);
                this.fullPathsInATOC = !pathTest.equals("./");
                if (!this.fullPathsInATOC) {
                    sBuf.append(binFile.readFixedLengthString(pathLength - 2));
                } else {
                    sBuf.append(pathTest);
                    sBuf.append(binFile.readFixedLengthString(pathLength - 2));
                }
                frame.directory = sBuf.toString().trim();
                if (this.DEBUG_RPFTOCFRAMEDETAIL) {
                    Debug.output("RpfTocHandler: parseToc(): frame directory: " + frame.directory);
                }
                binFile.seek(currentPosition);
                frame.filename = binFile.readFixedLengthString(12);
                if (this.DEBUG_RPFTOCFRAMEDETAIL) {
                    Debug.output("RpfTocHandler: parseToc(): frame filename: " + frame.filename);
                }
                int dot = frame.filename.lastIndexOf(46);
                entry.setInfo(frame.filename.substring(dot + 1, dot + 3).intern());
                String tempPath = !this.fullPathsInATOC ? frame.rpfdir + frame.directory + frame.filename : frame.directory + frame.filename;
                long diskspace = 288000L;
                boolean exists = true;
                if (local) {
                    exists = BinaryFile.exists(tempPath);
                }
                if (exists) {
                    frame.diskspace = diskspace;
                    frame.framePath = tempPath;
                    frame.exists = true;
                } else if (!this.fullPathsInATOC && BinaryFile.exists(tempPath = frame.rpfdir + frame.directory.toLowerCase() + frame.filename.toLowerCase())) {
                    frame.diskspace = diskspace;
                    frame.framePath = tempPath;
                    frame.exists = true;
                }
                if (frame.framePath == null) {
                    Debug.output("RpfTocHandler: Frame " + tempPath + " doesn't exist.  Please rebuild A.TOC file using MakeToc, or check read permissions for the file.");
                }
                ++i;
            }
        }
        catch (IOException ioe) {
            Debug.error("RpfTocHandler: IO ERROR parsing file!\n\t" + ioe);
            return false;
        }
        catch (FormatException fe) {
            Debug.error("RpfTocHandler: Format ERROR parsing file!\n\t" + fe);
            return false;
        }
        if (this.DEBUG_RPFTOC) {
            Debug.output("LEAVE TOC parsing...");
        }
        return true;
    }

    public static String translateScaleToSeries(long scale) {
        if (scale == 0L) {
            return "Various    ";
        }
        if (scale == 50000L) {
            return "1:50K      ";
        }
        if (scale == 100000L) {
            return "1:100K     ";
        }
        if (scale == 200000L) {
            return "1:200K     ";
        }
        if (scale == 250000L) {
            return "1:250K     ";
        }
        if (scale == 500000L) {
            return "1:500K     ";
        }
        if (scale == 1000000L) {
            return "1:1M       ";
        }
        if (scale == 2000000L) {
            return "1:2M       ";
        }
        if (scale == 5000000L) {
            return "1:5M       ";
        }
        if (scale == 66666L) {
            return "10M         ";
        }
        if (scale == 33333L) {
            return "5M          ";
        }
        return null;
    }

    public static long textScaleToLong(String textScale) {
        Long realValue;
        Long resolution2;
        int colon = textScale.indexOf(":");
        boolean hasExpLetter = false;
        try {
            StringBuffer buf;
            if (colon == -1) {
                int expLetter = textScale.indexOf("m");
                if (expLetter == -1 && (expLetter = textScale.indexOf("M")) == -1) {
                    return -1L;
                }
                Long resolution2 = new Long(textScale.substring(0, expLetter));
                return (long)((double)resolution2.longValue() / 1.5E-4);
            }
            String expValue = "";
            resolution2 = new Long(textScale.substring(0, colon));
            int expLetter = textScale.lastIndexOf(75);
            int expLetterSmall = textScale.lastIndexOf(107);
            if (expLetter == -1 && expLetterSmall == -1) {
                expLetter = textScale.lastIndexOf(77);
                expLetterSmall = textScale.lastIndexOf(109);
                if (expLetter != -1 || expLetterSmall != -1) {
                    expValue = "000000";
                }
            } else {
                expValue = "000";
            }
            if (!expValue.equals("")) {
                if (expLetter == -1) {
                    expLetter = expLetterSmall;
                }
                buf = new StringBuffer(textScale.substring(colon + 1, expLetter));
                buf.append(expValue);
            } else {
                buf = new StringBuffer(textScale.substring(colon + 1));
            }
            String longString = buf.toString().trim();
            realValue = new Long(longString);
        }
        catch (NumberFormatException nfe) {
            if (Debug.debugging("rpftoc")) {
                Debug.output("textScaleToLong: Number Format Exception!!!!" + textScale);
            }
            return (long)RpfConstants.UK.scale;
        }
        catch (StringIndexOutOfBoundsException sioobe) {
            if (Debug.debugging("rpftoc")) {
                Debug.output("textScaleToLong: String index out of bounds:\n" + sioobe.getMessage());
            }
            return (long)RpfConstants.UK.scale;
        }
        long ret = realValue / resolution2;
        if (Debug.debugging("rpftoc")) {
            Debug.output("RpfTocHandler: textScaleToLong converted " + textScale + " to " + ret);
        }
        return ret;
    }

    protected int getASCIIZone(float ullat, int zone) {
        int z = zone;
        if (ullat > 0.0f) {
            z += 48;
        } else if ((z += 64) == 73) {
            ++z;
        }
        return z;
    }

    public void getCatalogCoverage(float ullat, float ullon, float lrlat, float lrlon, CADRG proj, String chartSeriesCode, Vector coverages) {
        if (!this.valid) {
            return;
        }
        int i = 0;
        while (i < this.numBoundaries) {
            this.entries[i].coverage.reset();
            String chartSeries = chartSeriesCode == null ? "ANY" : chartSeriesCode;
            if ((chartSeries.equalsIgnoreCase("ANY") || chartSeries.equalsIgnoreCase(this.entries[i].info.seriesCode)) && this.entries[i].coverage.setPercentCoverage(ullat, ullon, lrlat, lrlon) > 0.0f) {
                coverages.addElement(this.entries[i].coverage);
            }
            ++i;
        }
    }

    public List getBestCoverageEntry(float ullat, float ullon, float lrlat, float lrlon, CADRG proj, RpfViewAttributes viewAtts) {
        if (!this.valid) {
            return null;
        }
        Vector<RpfTocEntry> coverageEntries = new Vector<RpfTocEntry>();
        boolean insideBoundaries = false;
        double scaleFactor = 0.0;
        double lowerScaleFactorLimit = 1.0;
        double upperScaleFactorLimit = 1.0;
        int prevBoundaryHits = 0;
        if (viewAtts != null) {
            lowerScaleFactorLimit = 1.0 / (double)viewAtts.imageScaleFactor;
            upperScaleFactorLimit = viewAtts.imageScaleFactor;
        }
        int nscale = 0;
        int scale = (int)proj.getScale();
        RpfTocEntry bestEntry = null;
        if (this.DEBUG_RPFTOCDETAIL) {
            Debug.output("getBestCoverageEntry(): Checking for coverage");
            Debug.output("  nw_lat: " + ullat);
            Debug.output("  se_lat: " + lrlat);
            Debug.output("  nw_lon: " + ullon);
            Debug.output("  se_lon: " + lrlon);
        }
        int zone = this.getASCIIZone(ullat, proj.getZone());
        char[] okZones = RpfTocHandler.getOkZones(ullat, lrlat, (char)zone);
        int i = 0;
        while (i < this.numBoundaries) {
            if (this.DEBUG_RPFTOCDETAIL) {
                Debug.output("********************");
                Debug.output("  tochandler: Boundary #" + i);
                Debug.output(this.entries[i].toString());
            }
            this.entries[i].coverage.reset();
            if (this.entries[i].info == null || this.entries[i].info.scale == -1.0f) {
                nscale = (int)RpfTocHandler.textScaleToLong(this.entries[i].scale);
                this.entries[i].info = new RpfProductInfo();
                this.entries[i].info.scale = nscale;
                this.entries[i].info.scaleString = this.entries[i].scale;
                this.entries[i].coverage.scale = nscale;
            } else {
                this.entries[i].coverage.scale = this.entries[i].info.scale;
                nscale = (int)this.entries[i].info.scale;
            }
            if (this.DEBUG_RPFTOCDETAIL) {
                Debug.output("getBestCoverageEntry(): Query scale = " + scale + " vs. brect scale = " + nscale);
            }
            scaleFactor = viewAtts != null && !viewAtts.scaleImages ? (scale == nscale ? 1.0 : lowerScaleFactorLimit - 1.0) : (double)nscale / (double)scale;
            String chartSeries = viewAtts == null ? "ANY" : viewAtts.chartSeries;
            if (scaleFactor >= lowerScaleFactorLimit && scaleFactor <= upperScaleFactorLimit && (chartSeries.equalsIgnoreCase("ANY") || chartSeries.equalsIgnoreCase(this.entries[i].info.seriesCode)) && RpfTocHandler.isOkZone(this.entries[i].zone, okZones)) {
                int hits = this.entries[i].coverage.setBoundaryHits(ullat, ullon, lrlat, lrlon);
                if (this.DEBUG_RPFTOCDETAIL) {
                    Debug.output("getBestCoverageEntry(): Boundary Hits = " + hits);
                }
                if (bestEntry != null) {
                    float bestScaleDiff;
                    boolean betterScale = false;
                    float newScaleDiff = RpfFrameCacheHandler.scaleDifference(proj, this.entries[i].coverage);
                    if (newScaleDiff <= (bestScaleDiff = RpfFrameCacheHandler.scaleDifference(proj, bestEntry.coverage))) {
                        betterScale = true;
                    }
                    if (betterScale && this.entries[i].coverage.setPercentCoverage(ullat, ullon, lrlat, lrlon) >= bestEntry.coverage.getPercentCoverage() && (hits >= prevBoundaryHits || hits >= 6)) {
                        if (newScaleDiff < bestScaleDiff) {
                            coverageEntries.clear();
                        }
                        coverageEntries.add(this.entries[i]);
                        bestEntry = this.entries[i];
                        prevBoundaryHits = hits;
                        if (this.DEBUG_RPFTOC) {
                            Debug.output("getBestCoverageEntry(): Found a match in a BR with coverage of " + this.entries[i].coverage.getPercentCoverage() + "%.");
                        }
                    } else if (betterScale && this.entries[i].coverage.getPercentCoverage() > 0.0f) {
                        if (newScaleDiff < bestScaleDiff) {
                            coverageEntries.clear();
                        }
                        coverageEntries.add(this.entries[i]);
                    }
                } else if (hits > prevBoundaryHits && this.entries[i].coverage.setPercentCoverage(ullat, ullon, lrlat, lrlon) > 0.0f) {
                    bestEntry = this.entries[i];
                    prevBoundaryHits = hits;
                    coverageEntries.add(this.entries[i]);
                    if (this.DEBUG_RPFTOC) {
                        Debug.output("getBestCoverageEntry(): Found a match in a BR with coverage of " + this.entries[i].coverage.getPercentCoverage() + "%.");
                    }
                }
            }
            ++i;
        }
        if (this.DEBUG_RPFTOC) {
            if (bestEntry != null) {
                Debug.output("getBestCoverageEntry(): found the best");
                Debug.output("################");
                Debug.output(bestEntry.toString());
                Debug.output("Returning the following coverage boxes: ");
                int i2 = 0;
                while (i2 < coverageEntries.size()) {
                    Debug.output(coverageEntries.get(i2).toString());
                    ++i2;
                }
            } else {
                Debug.output("getBestCoverageEntry(): no box found");
            }
        }
        return coverageEntries;
    }

    public static char[] getOkZones(float ullat, float lrlat, char zone) {
        char backupZone;
        char[] okZones = new char[7];
        okZones[0] = zone;
        char currentZone = zone;
        int i = 0;
        while (i < 3) {
            if (!RpfTocHandler.isAboveZone(ullat, currentZone)) break;
            okZones[i + 1] = backupZone = RpfTocHandler.getHigherZone(currentZone);
            currentZone = backupZone;
            ++i;
        }
        int k = i;
        currentZone = zone;
        while (k < i + 3) {
            if (!RpfTocHandler.isBelowZone(ullat, currentZone)) break;
            okZones[k + 1] = backupZone = RpfTocHandler.getLowerZone(currentZone);
            currentZone = backupZone;
            ++k;
        }
        int size = 0;
        int j = 0;
        while (j < okZones.length) {
            if (okZones[j] != '\u0000') {
                ++size;
            }
            ++j;
        }
        char[] returnZones = new char[size];
        int j2 = 0;
        while (j2 < size) {
            returnZones[j2] = okZones[j2];
            ++j2;
        }
        return returnZones;
    }

    public static boolean isOkZone(char zone, char[] okZones) {
        boolean ok = false;
        int i = 0;
        while (i < okZones.length) {
            if (zone == okZones[i]) {
                ok = true;
            }
            ++i;
        }
        return ok;
    }

    protected static boolean isBelowZone(float lowerLat, char zone) {
        float zoneLowerLat = RpfTocHandler.getLowerZoneExtent(zone);
        return lowerLat < zoneLowerLat;
    }

    protected static boolean isAboveZone(float upperLat, char zone) {
        float zoneUpperLat = RpfTocHandler.getUpperZoneExtent(zone);
        return upperLat > zoneUpperLat;
    }

    public static float getUpperZoneExtent(char zone) {
        if (zone >= '0' && zone <= '9') {
            int i = zone - 49;
            return CADRG_zone_extents[i + 1];
        }
        int i = zone - 65;
        if (i == 9) {
            --i;
        }
        return -1 * CADRG_zone_extents[i];
    }

    public static float getLowerZoneExtent(char zone) {
        if (zone >= '0' && zone <= '9') {
            int i = zone - 49;
            return CADRG_zone_extents[i];
        }
        int i = zone - 65;
        if (i == 9) {
            --i;
        }
        return -1 * CADRG_zone_extents[i + 1];
    }

    public static char getLowerZone(char zone) {
        if (zone >= '2' && zone <= '9') {
            zone = (char)(zone - '\u0001');
        } else if (zone == '1') {
            zone = (char)65;
        } else if (zone >= 'A' && zone < 'H') {
            zone = (char)(zone + '\u0001');
        } else if (zone == 'H') {
            zone = (char)74;
        }
        return zone;
    }

    public static char getHigherZone(char zone) {
        if (zone >= '1' && zone < '9') {
            zone = (char)(zone + '\u0001');
        } else if (zone >= 'B' && zone < 'J' || zone >= 'b' && zone < 'j') {
            zone = (char)(zone - '\u0001');
        } else if (zone == 'J' || zone == 'j') {
            zone = (char)(zone - 2);
        } else if (zone == 'A' || zone == 'a') {
            zone = (char)49;
        }
        return zone;
    }

    public RpfTocEntry[] getEntries() {
        return this.entries;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            Debug.output("Usage: java RpfTocHandler <path to RPF directory>");
            return;
        }
        Debug.init(System.getProperties());
        RpfTocHandler toc = new RpfTocHandler();
        if (!toc.loadFile(args[0])) {
            Debug.output("RpfTocHandler: NOT read sucessfully!");
        } else {
            RpfTocEntry[] e = toc.getEntries();
            Debug.output("For A.TOC: " + args[0]);
            int i = 0;
            while (i < e.length) {
                Debug.output(e[i].toString());
                ++i;
            }
        }
        System.exit(0);
    }
}

