/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.rpf;

import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.layer.rpf.RpfConstants;
import com.bbn.openmap.layer.util.LayerUtils;
import com.bbn.openmap.proj.CADRG;
import com.bbn.openmap.util.PropUtils;
import java.util.Properties;

public class RpfViewAttributes
implements RpfConstants,
PropertyConsumer {
    public static final String ANY = "ANY";
    public static final String ALL = "ALL";
    protected String propertyPrefix = null;
    public int numberOfColors;
    public int opaqueness;
    public int colorModel;
    public boolean scaleImages;
    public float imageScaleFactor;
    public String chartSeries;
    public boolean requireProjection;
    public boolean showMaps;
    public boolean showInfo;
    public CADRG proj;
    public boolean autofetchAttributes;

    public RpfViewAttributes() {
        this.setDefaults();
    }

    public void setDefaults() {
        this.numberOfColors = 216;
        this.opaqueness = 255;
        this.scaleImages = true;
        this.imageScaleFactor = 4.0f;
        this.colorModel = 0;
        this.chartSeries = ANY;
        this.requireProjection = true;
        this.showMaps = true;
        this.showInfo = false;
        this.autofetchAttributes = false;
    }

    public void setProperties(Properties props) {
        this.setProperties(null, props);
    }

    public void setProperties(String prefix, Properties props) {
        this.propertyPrefix = prefix;
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.opaqueness = LayerUtils.intFromProperties(props, prefix + "opaque", this.opaqueness);
        this.numberOfColors = LayerUtils.intFromProperties(props, prefix + "numberColors", this.numberOfColors);
        this.showMaps = LayerUtils.booleanFromProperties(props, prefix + "showMaps", this.showMaps);
        this.showInfo = LayerUtils.booleanFromProperties(props, prefix + "showInfo", this.showInfo);
        this.scaleImages = LayerUtils.booleanFromProperties(props, prefix + "scaleImages", this.scaleImages);
        this.chartSeries = props.getProperty(prefix + "chartSeries");
        this.autofetchAttributes = LayerUtils.booleanFromProperties(props, prefix + "autofetchAttributes", this.autofetchAttributes);
        this.imageScaleFactor = LayerUtils.floatFromProperties(props, prefix + "imageScaleFactor", this.imageScaleFactor);
        String colormodel = props.getProperty(prefix + "colormodel");
        this.colorModel = colormodel != null && colormodel.equalsIgnoreCase("indexed") ? 1 : 0;
    }

    public Properties getProperties(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        String prefix = PropUtils.getScopedPropertyPrefix(this.propertyPrefix);
        props.put(prefix + "opaque", Integer.toString(this.opaqueness));
        props.put(prefix + "numberColors", Integer.toString(this.numberOfColors));
        props.put(prefix + "showMaps", new Boolean(this.showMaps).toString());
        props.put(prefix + "showInfo", new Boolean(this.showInfo).toString());
        props.put(prefix + "scaleImages", new Boolean(this.scaleImages).toString());
        props.put(prefix + "chartSeries", this.chartSeries);
        props.put(prefix + "autofetchAttributes", new Boolean(this.autofetchAttributes).toString());
        props.put(prefix + "imageScaleFactor", Float.toString(this.imageScaleFactor));
        if (this.colorModel == 1) {
            props.put(prefix + "colormodel", "indexed");
        }
        return props;
    }

    public Properties getPropertyInfo(Properties list) {
        if (list == null) {
            list = new Properties();
        }
        list.put("opaque", "Integer representing opaqueness level (0-255, 0 is clear)");
        list.put("numberColors", "Number of colors to use for the maps (16, 32, 216)");
        list.put("showMaps", "Flag to display maps");
        list.put("showMaps.editor", "com.bbn.openmap.util.propertyEditor.OnOffPropertyEditor");
        list.put("showInfo", "Flag to show data attributes");
        list.put("showInfo.editor", "com.bbn.openmap.util.propertyEditor.OnOffPropertyEditor");
        list.put("scaleImages", "Flag to scale the images to fit the map scale.  If false, images appear when map scale fits the chart scale.");
        list.put("scaleImages.editor", "com.bbn.openmap.util.propertyEditor.OnOffPropertyEditor");
        list.put("chartSeries", "The chart scale code to display.  ANY is default");
        list.put("autofetchAttributes", "Flag to tell the layer to automatically fetch the attribute data for the images");
        list.put("autofetchAttributes.editor", "com.bbn.openmap.util.propertyEditor.OnOffPropertyEditor");
        list.put("imageScaleFactor", "Multiplier to limit the scales that a given chart will be displayed for a map (4.0 is the default).");
        list.put("colormodel", "If 'indexed', the images will be built using a colortable.  This is not the default.");
        return list;
    }

    public String getInitPropertiesOrder() {
        return " showMaps showInfo scaleImages imageScaleFactor opaque numberColors chartSeries autofetchAttributes colormodel";
    }

    public void setPropertyPrefix(String prefix) {
        this.propertyPrefix = prefix;
    }

    public String getPropertyPrefix() {
        return this.propertyPrefix;
    }
}

