/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.shape;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.MoreMath;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.shape.ESRIBoundingBox;
import com.bbn.openmap.layer.shape.ShapeLayer;
import com.bbn.openmap.layer.shape.SpatialIndex;
import com.bbn.openmap.layer.shape.SpatialIndexHandler;
import com.bbn.openmap.layer.util.LayerUtils;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.DataBounds;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.Component;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class MultiShapeLayer
extends ShapeLayer {
    public static final String ShapeFileListProperty = "shapeFileList";
    protected Collection spatialIndexes;

    public void setSpatialIndexes(Collection siv) {
        this.spatialIndexes = siv;
    }

    public Collection getSpatialIndexes() {
        return this.spatialIndexes;
    }

    public void setProperties(String prefix, Properties props) {
        this.setPropertyPrefix(prefix);
        String realPrefix = PropUtils.getScopedPropertyPrefix(this);
        String prettyName = realPrefix + "prettyName";
        String defaultName = this.getName();
        if (defaultName == null) {
            defaultName = "Anonymous";
        }
        this.setName(props.getProperty(prettyName, defaultName));
        this.setAddToBeanContext(PropUtils.booleanFromProperties(props, realPrefix + "addToBeanContext", this.addToBeanContext));
        this.autoPalette = PropUtils.booleanFromProperties(props, realPrefix + "autoPalette", this.autoPalette);
        this.setSpatialIndexes(realPrefix, props);
        this.shadowX = LayerUtils.intFromProperties(props, realPrefix + "shadowX", 0);
        this.shadowY = LayerUtils.intFromProperties(props, realPrefix + "shadowY", 0);
    }

    protected void setSpatialIndexes(String prefix, Properties p) {
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        String listValue = p.getProperty(prefix + ShapeFileListProperty);
        if (Debug.debugging("shape")) {
            Debug.output(this.getName() + "| list = \"" + listValue + "\"");
        }
        if (listValue == null) {
            Debug.error("No property \"" + prefix + ShapeFileListProperty + "\" found in application properties.");
            return;
        }
        StringTokenizer tokens = new StringTokenizer(listValue, " ");
        Vector<String> shapeFiles = new Vector<String>();
        while (tokens.hasMoreTokens()) {
            shapeFiles.add(tokens.nextToken());
        }
        this.spatialIndexes = new Vector(shapeFiles.size());
        Iterator list = shapeFiles.iterator();
        while (list.hasNext()) {
            String listName = (String)list.next();
            SpatialIndexHandler sih = new SpatialIndexHandler(prefix + listName, p);
            this.spatialIndexes.add(sih);
            if (!Debug.debugging("shape")) continue;
            Debug.output("MultiShapeLayer adding: " + sih);
        }
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        props.remove(prefix + "shapeFile");
        props.remove(prefix + "spatialIndex");
        props.remove(prefix + "pointImageURL");
        Iterator sis = this.spatialIndexes.iterator();
        StringBuffer list = new StringBuffer();
        while (sis.hasNext()) {
            SpatialIndexHandler sih = (SpatialIndexHandler)sis.next();
            sih.getProperties(props);
            String pp = sih.getPropertyPrefix();
            pp = pp.substring(pp.lastIndexOf(46) + 1);
            list.append(" " + pp);
        }
        props.put(prefix + ShapeFileListProperty, list.toString());
        return props;
    }

    public Properties getPropertyInfo(Properties props) {
        props = super.getPropertyInfo(props);
        props.remove("shapeFile");
        props.remove("spatialIndex");
        props.remove("pointImageURL");
        props.remove("shapeFile.editor");
        props.remove("spatialIndex.editor");
        props.remove("pointImageURL.editor");
        Iterator sis = this.spatialIndexes.iterator();
        while (sis.hasNext()) {
            ((SpatialIndexHandler)sis.next()).getPropertyInfo(props);
        }
        props.put(ShapeFileListProperty, "List of marker names for SpatialIndexHandlers");
        return props;
    }

    public synchronized OMGraphicList prepare() {
        if (this.spatialIndexes == null || this.spatialIndexes.size() == 0) {
            Debug.message("shape", "MultiShapeLayer: spatialIndexes is empty!");
            return new OMGraphicList();
        }
        Projection projection = this.getProjection();
        if (projection == null) {
            Debug.message("basic", "MultiShapeLayer|" + this.getName() + ": prepare called with null projection");
            return new OMGraphicList();
        }
        LatLonPoint ul = projection.getUpperLeft();
        LatLonPoint lr = projection.getLowerRight();
        float ulLat = ul.getLatitude();
        float ulLon = ul.getLongitude();
        float lrLat = lr.getLatitude();
        float lrLon = lr.getLongitude();
        OMGraphicList masterList = new OMGraphicList();
        OMGraphicList list = null;
        if (ulLon > lrLon || MoreMath.approximately_equal(ulLon, lrLon, 0.001f)) {
            if (Debug.debugging("shape")) {
                Debug.output("MultiShapeLayer.computeGraphics(): Dateline is on screen");
            }
            double ymin = Math.min(ulLat, lrLat);
            double ymax = Math.max(ulLat, lrLat);
            Iterator sii = this.spatialIndexes.iterator();
            while (sii.hasNext()) {
                SpatialIndexHandler sih = (SpatialIndexHandler)sii.next();
                if (!sih.enabled) continue;
                try {
                    list = sih.getGraphics(ulLon, ymin, 180.0, ymax, list);
                    list = sih.getGraphics(-180.0, ymin, lrLon, ymax, list);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                catch (FormatException fe) {
                    fe.printStackTrace();
                }
                masterList.add(list);
            }
        } else {
            double xmin = Math.min(ulLon, lrLon);
            double xmax = Math.max(ulLon, lrLon);
            double ymin = Math.min(ulLat, lrLat);
            double ymax = Math.max(ulLat, lrLat);
            Iterator sii = this.spatialIndexes.iterator();
            while (sii.hasNext()) {
                SpatialIndexHandler sih = (SpatialIndexHandler)sii.next();
                if (!sih.enabled) continue;
                if (Debug.debugging("shape")) {
                    Debug.output("  Getting graphics from " + sih.prettyName + " spatial index");
                }
                try {
                    list = sih.getGraphics(xmin, ymin, xmax, ymax, list);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                catch (FormatException fe) {
                    fe.printStackTrace();
                }
                masterList.add(list);
            }
        }
        if (masterList != null) {
            masterList.generate(projection, true);
        }
        return masterList;
    }

    public Component getGUI() {
        if (this.box == null) {
            this.box = new JPanel();
            JTabbedPane tabs = new JTabbedPane();
            this.box.setLayout(new BoxLayout(this.box, 1));
            this.box.setAlignmentX(0.0f);
            Iterator sii = this.spatialIndexes.iterator();
            while (sii.hasNext()) {
                SpatialIndexHandler sih = (SpatialIndexHandler)sii.next();
                JPanel stuff = (JPanel)sih.getGUI();
                if (stuff == null) continue;
                tabs.addTab(sih.getPrettyName(), stuff);
            }
            this.box.add(tabs);
            JPanel pal2 = new JPanel();
            JButton redraw = new JButton("Redraw Layer");
            redraw.setActionCommand("redrawCmd");
            redraw.addActionListener(this);
            pal2.add(redraw);
            this.box.add(pal2);
        }
        return this.box;
    }

    public DataBounds getDataBounds() {
        DataBounds box = null;
        ESRIBoundingBox bounds = new ESRIBoundingBox();
        Iterator sii = this.spatialIndexes.iterator();
        while (sii.hasNext()) {
            SpatialIndex si = (SpatialIndex)sii.next();
            if (si == null) continue;
            ESRIBoundingBox boundingBox = this.spatialIndex.getBounds();
            if (bounds == null) continue;
            bounds.addBounds(boundingBox);
        }
        return box;
    }
}

