/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.shape;

import com.bbn.openmap.io.BinaryBufferedFile;
import com.bbn.openmap.io.BinaryFile;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.shape.ESRIBoundingBox;
import com.bbn.openmap.layer.shape.ESRIPointRecord;
import com.bbn.openmap.layer.shape.ESRIPolygonRecord;
import com.bbn.openmap.layer.shape.ESRIRecord;
import com.bbn.openmap.layer.shape.ShapeUtils;
import com.bbn.openmap.util.Debug;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.Vector;
import javax.swing.ImageIcon;

public class SpatialIndex
extends ShapeUtils {
    public static final int SHAPE_FILE_HEADER_LENGTH = 100;
    public static final int SHAPE_RECORD_HEADER_LENGTH = 8;
    public static final int SPATIAL_INDEX_HEADER_LENGTH = 100;
    public static final int SPATIAL_INDEX_RECORD_LENGTH = 40;
    public static final int DEFAULT_SHAPE_RECORD_SIZE = 50000;
    protected BinaryBufferedFile ssx;
    protected BinaryBufferedFile shp;
    protected ImageIcon pointIcon;
    protected ESRIBoundingBox bounds = null;
    static /* synthetic */ Class class$com$bbn$openmap$layer$shape$SpatialIndex;

    public SpatialIndex(String ssxFilename) throws IOException {
        this.ssx = new BinaryBufferedFile(ssxFilename);
    }

    public SpatialIndex(String ssxFilename, String shpFilename) throws IOException {
        if (Debug.debugging("spatialindex")) {
            Debug.output("SpatialIndex(" + ssxFilename + ", " + shpFilename + ");");
        }
        this.ssx = new BinaryBufferedFile(ssxFilename);
        this.shp = new BinaryBufferedFile(shpFilename);
    }

    public ESRIBoundingBox getBounds() {
        block3: {
            if (this.bounds != null) break block3;
            try {
                this.locateRecords(-180.0, -90.0, 180.0, 90.0);
            }
            catch (IOException ioe) {
                this.bounds = null;
            }
            catch (FormatException fe) {
                this.bounds = null;
            }
        }
        return this.bounds;
    }

    public void resetBounds() {
        this.bounds = null;
    }

    public ESRIRecord makeESRIRecord(int shapeType, byte[] b, int off) throws IOException {
        switch (shapeType) {
            case 0: {
                return null;
            }
            case 1: {
                return new ESRIPointRecord(b, off, this.pointIcon);
            }
            case 3: 
            case 5: {
                return new ESRIPolygonRecord(b, off);
            }
            case 8: {
                Debug.output("SpatialIndex.makeESRIRecord: Arc NYI");
                return null;
            }
        }
        return null;
    }

    public ESRIRecord[] locateRecords(double xmin, double ymin, double xmax, double ymax) throws IOException, FormatException {
        int result;
        boolean gatherBounds = false;
        if (this.bounds == null) {
            this.bounds = new ESRIBoundingBox();
            gatherBounds = true;
        }
        if (Debug.debugging("spatialindex")) {
            Debug.output("locateRecords:");
            Debug.output("\txmin: " + xmin + "; ymin: " + ymin);
            Debug.output("\txmax: " + xmax + "; ymax: " + ymax);
        }
        byte[] ixRecord = new byte[40];
        int recNum = 0;
        Vector<ESRIRecord> v = new Vector<ESRIRecord>();
        int sRecordSize = 50000;
        byte[] sRecord = new byte[sRecordSize];
        this.ssx.seek(32L);
        this.ssx.byteOrder(false);
        int shapeType = this.ssx.readInteger();
        this.ssx.seek(100L);
        while ((result = this.ssx.read(ixRecord, 0, 40)) > 0) {
            ++recNum;
            double xmin2 = ShapeUtils.readLEDouble(ixRecord, 8);
            double ymin2 = ShapeUtils.readLEDouble(ixRecord, 16);
            double xmax2 = ShapeUtils.readLEDouble(ixRecord, 24);
            double ymax2 = ShapeUtils.readLEDouble(ixRecord, 32);
            if (Debug.debugging("spatialindexdetail")) {
                Debug.output("Looking at rec num " + recNum);
                Debug.output("  " + xmin2 + ", " + ymin2 + "\n  " + xmax2 + ", " + ymax2);
            }
            if (gatherBounds) {
                this.bounds.addPoint(xmin2, ymin2);
                this.bounds.addPoint(xmax2, ymax2);
            }
            if (!SpatialIndex.intersects(xmin, ymin, xmax, ymax, xmin2, ymin2, xmax2, ymax2)) continue;
            int offset = ShapeUtils.readBEInt(ixRecord, 0);
            int byteOffset = offset * 2;
            int contentLength = ShapeUtils.readBEInt(ixRecord, 4);
            int recordSize = contentLength * 2 + 8;
            if (recordSize < 0) {
                Debug.error("SpatialIndex: supposed to read record size of " + recordSize);
                break;
            }
            if (recordSize > sRecordSize) {
                sRecordSize = recordSize;
                if (Debug.debugging("spatialindexdetail")) {
                    Debug.output("Shapefile SpatialIndex record size: " + sRecordSize);
                }
                sRecord = new byte[sRecordSize];
            }
            if (Debug.debugging("spatialindex")) {
                Debug.output("going to shp byteOffset = " + byteOffset + " for record size = " + recordSize + ", offset = " + offset + ", shape type = " + shapeType);
            }
            try {
                this.shp.seek(byteOffset);
                int nBytes = this.shp.read(sRecord, 0, recordSize);
                if (nBytes < recordSize) {
                    Debug.error("Shapefile SpatialIndex expected " + recordSize + " bytes, but got " + nBytes + " bytes instead.");
                }
                ESRIRecord record = this.makeESRIRecord(shapeType, sRecord, 0);
                v.addElement(record);
            }
            catch (IOException ioe) {
                Debug.error("SpatialIndex.locateRecords: IOException. ");
                ioe.printStackTrace();
                break;
            }
        }
        if (Debug.debugging("spatialindex")) {
            Debug.output("Processed " + recNum + " records");
            Debug.output("Selected " + v.size() + " records");
        }
        int nRecords = v.size();
        this.ssx.seek(0L);
        this.shp.seek(0L);
        Object[] result2 = new ESRIRecord[nRecords];
        v.copyInto(result2);
        return result2;
    }

    protected static final boolean intersects(double xmin1, double ymin1, double xmax1, double ymax1, double xmin2, double ymin2, double xmax2, double ymax2) {
        return !(xmax1 <= xmin2 || ymax1 <= ymin2 || xmin1 >= xmax2 || ymin1 >= ymax2);
    }

    public void dumpIndex(boolean showBounds) throws IOException {
        int result;
        byte[] ixRecord = new byte[40];
        int recNum = 0;
        this.ssx.seek(100L);
        while ((result = this.ssx.read(ixRecord, 0, 40)) > 0) {
            int offset = ShapeUtils.readBEInt(ixRecord, 0);
            int length = ShapeUtils.readBEInt(ixRecord, 4);
            Debug.output("Record " + ++recNum + ": " + offset + ", " + length + (showBounds ? "; " + ShapeUtils.readLEDouble(ixRecord, 8) + ", " + ShapeUtils.readLEDouble(ixRecord, 16) + ", " + ShapeUtils.readLEDouble(ixRecord, 24) + ", " + ShapeUtils.readLEDouble(ixRecord, 32) : ""));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected static void indexPolygons(InputStream is, long ptr, OutputStream os) {
        block11: {
            boolean moreRecords = true;
            byte[] rHdr = new byte[8];
            byte[] outBuf = new byte[40];
            int nRecords = 0;
            int recBufSize = 100000;
            byte[] recBuf = new byte[recBufSize];
            while (moreRecords) {
                int result = is.read(rHdr, 0, 8);
                if (result < 0) {
                    moreRecords = false;
                    Debug.output("Shapefile SpatialIndex Found " + nRecords + " records");
                    Debug.output("Shapefile SpatialIndex recBufSize = " + recBufSize);
                    continue;
                }
                ++nRecords;
                long recOffset = ptr;
                int recNumber = ShapeUtils.readBEInt(rHdr, 0);
                int recLengthWords = ShapeUtils.readBEInt(rHdr, 4);
                int recLengthBytes = recLengthWords * 2;
                if (recLengthBytes > recBufSize) {
                    Debug.output("Shapefile SpatialIndex increasing recBufSize to " + recLengthBytes);
                    recBufSize = recLengthBytes;
                    recBuf = new byte[recBufSize];
                }
                result = is.read(recBuf, 0, recLengthBytes);
                ESRIBoundingBox polyBounds = ShapeUtils.readBox(recBuf, 4);
                ptr += (long)(recLengthBytes + 8);
                ShapeUtils.writeBEInt(outBuf, 0, (int)(recOffset / 2L));
                ShapeUtils.writeBEInt(outBuf, 4, recLengthWords);
                ShapeUtils.writeLEDouble(outBuf, 8, polyBounds.min.x);
                ShapeUtils.writeLEDouble(outBuf, 16, polyBounds.min.y);
                ShapeUtils.writeLEDouble(outBuf, 24, polyBounds.max.x);
                ShapeUtils.writeLEDouble(outBuf, 32, polyBounds.max.y);
                os.write(outBuf, 0, 40);
            }
            Object var19_15 = null;
            try {
                is.close();
            }
            catch (IOException e2) {}
            break block11;
            {
                catch (IOException e) {
                    e.printStackTrace();
                    Object var19_16 = null;
                    try {
                        is.close();
                    }
                    catch (IOException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var19_17 = null;
                try {
                    is.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected static void indexPoints(InputStream is, long ptr, OutputStream os) {
        block11: {
            boolean moreRecords = true;
            byte[] rHdr = new byte[8];
            byte[] outBuf = new byte[40];
            int nRecords = 0;
            int recBufSize = 20;
            byte[] recBuf = new byte[recBufSize];
            while (moreRecords) {
                int result = is.read(rHdr, 0, 8);
                if (result < 0) {
                    moreRecords = false;
                    Debug.output("Found " + nRecords + " records");
                    Debug.output("recBufSize = " + recBufSize);
                    continue;
                }
                ++nRecords;
                long recOffset = ptr;
                int recNumber = ShapeUtils.readBEInt(rHdr, 0);
                int recLengthWords = ShapeUtils.readBEInt(rHdr, 4);
                int recLengthBytes = recLengthWords * 2;
                if (recLengthBytes > recBufSize) {
                    Debug.output("Shapefile SpatialIndex increasing recBufSize to " + recLengthBytes);
                    recBufSize = recLengthBytes;
                    recBuf = new byte[recBufSize];
                }
                result = is.read(recBuf, 0, recLengthBytes);
                double x = ShapeUtils.readLEDouble(recBuf, 4);
                double y = ShapeUtils.readLEDouble(recBuf, 12);
                ptr += (long)(recLengthBytes + 8);
                ShapeUtils.writeBEInt(outBuf, 0, (int)(recOffset / 2L));
                ShapeUtils.writeBEInt(outBuf, 4, recLengthWords);
                ShapeUtils.writeLEDouble(outBuf, 8, x);
                ShapeUtils.writeLEDouble(outBuf, 16, y);
                ShapeUtils.writeLEDouble(outBuf, 24, x);
                ShapeUtils.writeLEDouble(outBuf, 32, y);
                os.write(outBuf, 0, 40);
            }
            Object var22_16 = null;
            try {
                is.close();
            }
            catch (IOException e2) {}
            break block11;
            {
                catch (IOException e) {
                    e.printStackTrace();
                    Object var22_17 = null;
                    try {
                        is.close();
                    }
                    catch (IOException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var22_18 = null;
                try {
                    is.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void createIndex(String inFile, String outFile) {
        fileHeader = new byte[100];
        shp = null;
        ssx = null;
        try {
            try {
                shp = new FileInputStream(inFile);
                ssx = new FileOutputStream(outFile);
                shp.read(fileHeader, 0, 100);
                ssx.write(fileHeader, 0, 100);
                shapeType = ShapeUtils.readLEInt(fileHeader, 32);
                switch (shapeType) {
                    case 0: {
                        Debug.error("Unable to index shape type NULL");
                        ** break;
                    }
                    case 1: {
                        SpatialIndex.indexPoints(shp, 100L, ssx);
                        ** break;
                    }
                    case 3: {
                        SpatialIndex.indexPolygons(shp, 100L, ssx);
                        ** break;
                    }
                    case 5: {
                        SpatialIndex.indexPolygons(shp, 100L, ssx);
                        ** break;
                    }
                    case 8: {
                        Debug.error("Shapefile SpatialIndex: Unable to index shape type MULTIPOINT");
                        ** break;
                    }
                }
                Debug.error("Shapefile SpatialIndex.createIndex:  Unknown shape type: " + shapeType);
            }
            catch (IOException e) {
                e.printStackTrace();
                var8_7 = null;
                try {
                    shp.close();
                    ssx.close();
                    return;
                }
                catch (IOException e) {
                    return;
                }
            }
lbl40:
            // 6 sources

            var8_6 = null;
        }
        catch (Throwable var7_13) {
            var8_8 = null;
            ** try [egrp 2[TRYBLOCK] [4 : 212->224)] { 
lbl46:
            // 1 sources

            shp.close();
            ssx.close();
            throw var7_13;
lbl49:
            // 1 sources

            catch (IOException e) {
                // empty catch block
            }
            throw var7_13;
        }
        try {}
        catch (IOException e) {}
        shp.close();
        ssx.close();
        return;
    }

    public static void printUsage(PrintStream out) {
        String className = (class$com$bbn$openmap$layer$shape$SpatialIndex == null ? (class$com$bbn$openmap$layer$shape$SpatialIndex = SpatialIndex.class$("com.bbn.openmap.layer.shape.SpatialIndex")) : class$com$bbn$openmap$layer$shape$SpatialIndex).getName();
        out.println("Usage:");
        out.println();
        out.println("java " + className + " -c file.ssx file.shp");
        out.println("Creates spatial index <file.ssx> from shape file <file.shp>.");
        out.println();
        out.println("java " + className + " -d file.ssx");
        out.println("Dumps spatial index information, excluding bounding boxes to stdout.  Useful for comparing to a shape index.");
        out.println();
        out.println("java " + className + " -d -b file.ssx");
        out.println("Dumps spatial index information including bounding boxes to stdout.");
        out.println();
    }

    public static String locateFile(String name) {
        String newname;
        File file = new File(name);
        if (file.exists()) {
            return name;
        }
        URL url = ClassLoader.getSystemResource(name);
        if (url != null && (file = new File(newname = url.getFile())).exists()) {
            return newname;
        }
        return null;
    }

    public static SpatialIndex locateAndSetShapeData(String shapeFileName) {
        SpatialIndex spi = null;
        int appendixIndex = shapeFileName.indexOf(".shp");
        if (Debug.debugging("shape")) {
            Debug.output("SpatialIndex: created with just the shape file " + shapeFileName);
        }
        if (appendixIndex != -1) {
            if (BinaryFile.exists(shapeFileName)) {
                String spatialIndexFileName = shapeFileName.substring(0, appendixIndex) + ".ssx";
                if (Debug.debugging("shape")) {
                    Debug.output("Trying to locate spatial index file " + spatialIndexFileName);
                }
                if (!BinaryFile.exists(spatialIndexFileName)) {
                    String newShapeFileName = SpatialIndex.locateFile(shapeFileName);
                    if (newShapeFileName != null) {
                        Debug.output("Creating spatial index file: " + spatialIndexFileName);
                        appendixIndex = newShapeFileName.indexOf(".shp");
                        String newSpatialIndexFileName = newShapeFileName.substring(0, appendixIndex) + ".ssx";
                        SpatialIndex.createIndex(newShapeFileName, newSpatialIndexFileName);
                    } else {
                        Debug.error("Can't create SpatialIndex for URL/JAR shapefile: " + shapeFileName);
                    }
                }
                try {
                    spi = new SpatialIndex(spatialIndexFileName, shapeFileName);
                }
                catch (IOException ioe) {
                    Debug.error(ioe.getMessage());
                    ioe.printStackTrace(Debug.getErrorStream());
                    spi = null;
                }
            } else {
                Debug.error("SpatialIndex: Couldn't locate shape file " + shapeFileName);
            }
        } else if (Debug.debugging("shape")) {
            Debug.output("SpatialIndex: file " + shapeFileName + " doesn't look like a shape file");
        }
        return spi;
    }

    public static SpatialIndex locateAndSetShapeData(String shapeFileName, String spatialIndexFileName) {
        SpatialIndex spi;
        block3: {
            spi = null;
            String message = "ShapeLayer SpatialIndex: problem setting up the shape files:\n      shape file: " + shapeFileName + "\n     spatial index file: " + spatialIndexFileName;
            try {
                if (BinaryFile.exists(shapeFileName) && BinaryFile.exists(spatialIndexFileName)) {
                    spi = new SpatialIndex(spatialIndexFileName, shapeFileName);
                    break block3;
                }
                Debug.error(message);
            }
            catch (IOException ioe) {
                Debug.error(message + "\n" + ioe.getMessage());
                ioe.printStackTrace(Debug.getErrorStream());
            }
        }
        return spi;
    }

    public static void main(String[] argv) throws IOException {
        int argc = argv.length;
        if (argc == 0) {
            SpatialIndex.printUsage(System.out);
            System.exit(0);
        }
        if (argv[0].equals("-d")) {
            if (argc == 2) {
                String name = argv[1];
                SpatialIndex si = new SpatialIndex(name);
                si.dumpIndex(false);
            } else if (argc == 3 && argv[1].equals("-b")) {
                String name = argv[2];
                SpatialIndex si = new SpatialIndex(name);
                si.dumpIndex(true);
            } else {
                SpatialIndex.printUsage(System.err);
                System.exit(1);
            }
        } else if (argc == 3 && argv[0].equals("-c")) {
            String indexFile = argv[1];
            String shapeFile = argv[2];
            SpatialIndex.createIndex(shapeFile, indexFile);
        } else {
            SpatialIndex.printUsage(System.err);
            System.exit(1);
        }
    }

    public synchronized void setPointIcon(ImageIcon ii) {
        this.pointIcon = ii;
    }

    public synchronized ImageIcon getPointIcon() {
        return this.pointIcon;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

