/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.shape.areas;

import com.bbn.openmap.MoreMath;
import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.dataAccess.shape.DbfTableModel;
import com.bbn.openmap.dataAccess.shape.input.DbfInputStream;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.shape.CSVShapeInfoFile;
import com.bbn.openmap.layer.shape.ESRIRecord;
import com.bbn.openmap.layer.shape.ShapeLayer;
import com.bbn.openmap.layer.shape.SpatialIndex;
import com.bbn.openmap.layer.shape.areas.PoliticalArea;
import com.bbn.openmap.layer.util.LayerUtils;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMGeometryList;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class AreaHandler
implements PropertyConsumer {
    protected Hashtable politicalAreas;
    public static final String areasProperty = "areas";
    public static final String pointImageURLProperty = "pointImageURL";
    public static final String keyIndexProperty = "keyIndex";
    public static final String nameIndexProperty = "nameIndex";
    public static final String CacheFileProperty = "cacheFile";
    public static final String csvFileProperty = "csvFile";
    public static final String csvHeaderProperty = "csvFileHasHeader";
    public static final String dbfFileProperty = "dbfFile";
    protected Vector areasItems = new Vector();
    protected int nameIndex = 0;
    protected int keyIndex = 1;
    protected URL cacheURL = null;
    protected OMGraphicList omgraphics = null;
    protected DrawingAttributes drawingAttributes;
    protected CSVShapeInfoFile infoFile = null;
    protected DbfTableModel dbfModel = null;
    protected boolean csvHasHeader = true;
    protected Properties originalProperties = null;
    protected String originalPrefix = null;
    protected SpatialIndex spatialIndex = null;

    public AreaHandler(SpatialIndex si, DrawingAttributes da) {
        this.setDrawingAttributes(da);
        this.setSpatialIndex(si);
    }

    public void setDrawingAttributes(DrawingAttributes da) {
        this.drawingAttributes = da;
    }

    public DrawingAttributes getDrawingAttributes() {
        return this.drawingAttributes;
    }

    public void setSpatialIndex(SpatialIndex si) {
        this.spatialIndex = si;
    }

    public SpatialIndex getSpatialIndex() {
        return this.spatialIndex;
    }

    public void setProperties(Properties props) {
        this.setProperties(null, props);
    }

    public void setProperties(String prefix, Properties props) {
        if (Debug.debugging(areasProperty)) {
            Debug.output("AreaHandler: setting properties");
        }
        this.setPropertyPrefix(prefix);
        this.originalProperties = props;
        this.politicalAreas = null;
    }

    public Properties getProperties(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        return props;
    }

    public Properties getPropertyInfo(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        return props;
    }

    public void setPropertyPrefix(String pre) {
        this.originalPrefix = pre;
    }

    public String getPropertyPrefix() {
        return this.originalPrefix;
    }

    public void initialize(String prefix, Properties props) {
        if (prefix == null || props == null) {
            Debug.error("AreaHandler: initialize received bad input:\n\tprefix: " + prefix + "\n\tproperties: " + (props == null ? "null" : "OK"));
            this.politicalAreas = null;
            return;
        }
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.politicalAreas = new Hashtable();
        String cacheFile = props.getProperty(prefix + CacheFileProperty);
        try {
            this.cacheURL = LayerUtils.getResourceOrFileOrURL(this, cacheFile);
            if (this.cacheURL != null) {
                this.omgraphics = this.readCachedGraphics(this.cacheURL);
            } else {
                String dbfFile = props.getProperty(prefix + dbfFileProperty);
                URL dbfFileURL = null;
                if (dbfFile != null) {
                    dbfFileURL = LayerUtils.getResourceOrFileOrURL(this, dbfFile);
                }
                if (dbfFileURL != null) {
                    InputStream is = dbfFileURL.openStream();
                    this.dbfModel = new DbfTableModel(new DbfInputStream(is));
                }
                if (this.dbfModel == null) {
                    String csvFile = props.getProperty(prefix + csvFileProperty);
                    URL infofileURL = null;
                    if (csvFile != null) {
                        infofileURL = LayerUtils.getResourceOrFileOrURL(this, csvFile);
                    }
                    if (infofileURL != null) {
                        this.infoFile = new CSVShapeInfoFile(csvFile);
                        this.infoFile.setHeadersExist(LayerUtils.booleanFromProperties(props, prefix + csvHeaderProperty, true));
                        this.infoFile.loadData(true);
                    }
                }
            }
        }
        catch (MalformedURLException murle) {
            this.omgraphics = new OMGraphicList();
        }
        catch (IOException ioe) {
            this.omgraphics = new OMGraphicList();
        }
        catch (Exception exc) {
            this.omgraphics = new OMGraphicList();
        }
        this.keyIndex = LayerUtils.intFromProperties(props, prefix + keyIndexProperty, this.keyIndex);
        this.nameIndex = LayerUtils.intFromProperties(props, prefix + nameIndexProperty, this.nameIndex);
        String areas = props.getProperty(prefix + areasProperty);
        if (areas == null) {
            areas = "";
        }
        StringTokenizer tokenizer = new StringTokenizer(areas, " ");
        while (tokenizer.hasMoreTokens()) {
            String currentArea = tokenizer.nextToken();
            PoliticalArea newParams = new PoliticalArea(currentArea);
            if (Debug.debugging(areasProperty)) {
                Debug.output("AreaHandler: setting SPECIALIZED attributes for \"" + newParams.id + "\"");
            }
            this.areasItems.addElement(currentArea);
            newParams.drawingAttributes = new DrawingAttributes(prefix + areasProperty + "." + currentArea, props);
            this.politicalAreas.put(newParams.id.toUpperCase().intern(), newParams);
        }
        if (Debug.debugging(areasProperty)) {
            Debug.output("AreaHandler: finished initialization");
        }
    }

    public OMGraphicList readCachedGraphics(URL url) throws IOException {
        if (Debug.debugging(areasProperty)) {
            Debug.output("Reading cached graphics");
        }
        OMGraphicList omgraphics = new OMGraphicList();
        if (url != null) {
            omgraphics.readGraphics(url);
        }
        return omgraphics;
    }

    public OMGraphicList getGraphics() {
        return this.getGraphics(90.0f, -180.0f, -90.0f, 180.0f);
    }

    public OMGraphicList getGraphics(float ulLat, float ulLon, float lrLat, float lrLon) {
        if (this.cacheURL != null) {
            return this.omgraphics;
        }
        if (this.spatialIndex == null) {
            return new OMGraphicList();
        }
        if (this.politicalAreas == null) {
            this.initialize(this.originalPrefix, this.originalProperties);
        }
        OMGraphicList list = null;
        if (ulLon > lrLon || MoreMath.approximately_equal(ulLon, lrLon, 0.001f)) {
            if (Debug.debugging(areasProperty)) {
                Debug.output("AreaHandler.getGraphics(): Dateline is on screen");
            }
            double ymin = Math.min(ulLat, lrLat);
            double ymax = Math.max(ulLat, lrLat);
            try {
                DrawingAttributes drawParams;
                ESRIRecord[] records1 = this.spatialIndex.locateRecords(ulLon, ymin, 180.0, ymax);
                ESRIRecord[] records2 = this.spatialIndex.locateRecords(-180.0, ymin, lrLon, ymax);
                int nRecords1 = records1.length;
                int nRecords2 = records2.length;
                list = new OMGraphicList(nRecords1 + nRecords2);
                int i = 0;
                while (i < nRecords1) {
                    drawParams = this.getDrawParams(records1[i].getRecordNumber());
                    list.addOMGraphic(this.recordList(records1[i], drawParams));
                    ++i;
                }
                int i2 = 0;
                while (i2 < nRecords2) {
                    drawParams = this.getDrawParams(records2[i2].getRecordNumber());
                    list.addOMGraphic(this.recordList(records2[i2], drawParams));
                    ++i2;
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            catch (FormatException fe) {
                fe.printStackTrace();
            }
        } else {
            double xmin = Math.min(ulLon, lrLon);
            double xmax = Math.max(ulLon, lrLon);
            double ymin = Math.min(ulLat, lrLat);
            double ymax = Math.max(ulLat, lrLat);
            try {
                ESRIRecord[] records = this.spatialIndex.locateRecords(xmin, ymin, xmax, ymax);
                int nRecords = records.length;
                list = new OMGraphicList(nRecords);
                int i = 0;
                while (i < nRecords) {
                    DrawingAttributes drawParams = this.getDrawParams(records[i].getRecordNumber());
                    list.addOMGraphic(this.recordList(records[i], drawParams));
                    ++i;
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            catch (FormatException fe) {
                fe.printStackTrace();
            }
        }
        return list;
    }

    public String getName(Vector vector) {
        try {
            String string = (String)vector.elementAt(this.nameIndex);
            return string;
        }
        catch (ClassCastException cce) {
            return "";
        }
    }

    public String getName(Integer integer) {
        try {
            Object obj;
            if (this.infoFile != null) {
                Vector vector = this.infoFile.getRecord(integer - 1);
                if (vector != null) {
                    return (String)vector.elementAt(this.nameIndex);
                }
            } else if (this.dbfModel != null && (obj = this.dbfModel.getValueAt(integer - 1, this.nameIndex)) != null) {
                if (obj instanceof String) {
                    return (String)obj;
                }
                return obj.toString();
            }
        }
        catch (ClassCastException cce) {}
        return "";
    }

    public DrawingAttributes getDrawParamsFromCSV(int recordNumber) {
        if (this.infoFile == null) {
            return this.drawingAttributes;
        }
        Vector info = this.infoFile.getRecord(recordNumber - 1);
        if (info == null) {
            if (Debug.debugging(areasProperty)) {
                Debug.output("AreaHandler.getDrawParameters: record " + recordNumber + " has no info");
            }
            return this.drawingAttributes;
        }
        Object keyObj = info.elementAt(this.keyIndex);
        String key = null;
        PoliticalArea pa = null;
        if (keyObj != null) {
            key = ((String)keyObj).toUpperCase().intern();
            pa = (PoliticalArea)this.politicalAreas.get(key);
        }
        if (pa == null) {
            if (Debug.debugging(areasProperty)) {
                Debug.output("AreaHandler.getDrawParameters: record " + recordNumber + " has key \"" + key + "\" and DEFAULT attributes");
            }
            return this.drawingAttributes;
        }
        if (pa.name == null) {
            String name = (String)info.elementAt(this.nameIndex);
            pa.name = name != null ? name : "";
        }
        if (Debug.debugging(areasProperty)) {
            Debug.output("AreaHandler.getDrawParameters: record " + recordNumber + " has key \"" + key + "\" and SPECIALIZED attributes");
        }
        return pa.drawingAttributes;
    }

    public DrawingAttributes getDrawParamsFromDBF(int recordNumber) {
        if (this.dbfModel == null) {
            return this.drawingAttributes;
        }
        if (this.dbfModel == null || this.dbfModel.getRowCount() < recordNumber) {
            if (Debug.debugging(areasProperty)) {
                Debug.output("AreaHandler.getDrawParameters: record " + recordNumber + " has no info");
            }
            return this.drawingAttributes;
        }
        Object keyObj = this.dbfModel.getValueAt(recordNumber - 1, this.keyIndex);
        String key = null;
        PoliticalArea pa = null;
        if (keyObj != null) {
            key = ((String)keyObj).toUpperCase().intern();
            pa = (PoliticalArea)this.politicalAreas.get(key);
        }
        if (pa == null) {
            if (Debug.debugging(areasProperty)) {
                Debug.output("AreaHandler.getDrawParameters: record " + recordNumber + " has key \"" + key + "\" and DEFAULT attributes");
            }
            return this.drawingAttributes;
        }
        if (pa.name == null) {
            String name = (String)this.dbfModel.getValueAt(recordNumber - 1, this.nameIndex);
            pa.name = name != null ? name : "";
        }
        if (Debug.debugging(areasProperty)) {
            Debug.output("AreaHandler.getDrawParameters: record " + recordNumber + " has key \"" + key + "\" and SPECIALIZED attributes");
        }
        return pa.drawingAttributes;
    }

    public DrawingAttributes getDrawParams(int recordNumber) {
        if (this.dbfModel != null) {
            return this.getDrawParamsFromDBF(recordNumber);
        }
        return this.getDrawParamsFromCSV(recordNumber);
    }

    public void loadDbfModelIntoGraphics(OMGraphicList list) {
        if (list != null && this.dbfModel.getRowCount() > 0) {
            int numgraphics = list.size();
            int i = 0;
            while (i < numgraphics) {
                try {
                    OMGraphic omg = list.getOMGraphicAt(i);
                    Integer recnum = (Integer)omg.getAppObject();
                    Object inforec = this.dbfModel.getRecord(recnum - 1);
                    omg.setAppObject(inforec);
                }
                catch (ClassCastException cce) {
                    if (Debug.debugging("shape")) {
                        cce.printStackTrace();
                    }
                }
                catch (NullPointerException npe) {
                    npe.printStackTrace();
                }
                ++i;
            }
        }
    }

    protected OMGraphicList recordList(ESRIRecord rec, DrawingAttributes drawParams) {
        int recNumber = rec.getRecordNumber();
        OMGraphicList recList = new OMGraphicList(10);
        if (drawParams != null) {
            rec.addOMGraphics(recList, drawParams);
        } else {
            rec.addOMGraphics(recList, DrawingAttributes.getDefaultClone());
        }
        recList.setAppObject(new Integer(recNumber));
        return recList;
    }

    public PoliticalArea findPoliticalArea(String area_key) {
        if (this.politicalAreas == null) {
            Debug.message(areasProperty, "AreaHandler: initializing graphic attributes");
            this.initialize(this.originalPrefix, this.originalProperties);
            if (this.omgraphics == null) {
                this.omgraphics = this.getGraphics();
                if (this.dbfModel != null) {
                    this.loadDbfModelIntoGraphics(this.omgraphics);
                } else {
                    this.infoFile.loadIntoGraphics(this.omgraphics);
                }
            }
            this.politicalAreas = this.determinePoliticalAreas(this.omgraphics);
            Debug.message(areasProperty, "AreaHandler: completed initialization");
        }
        if (this.politicalAreas != null) {
            String key = area_key.toUpperCase().intern();
            return (PoliticalArea)this.politicalAreas.get(key);
        }
        Debug.error("AreaHandler: initialization failed for " + this.originalPrefix + "\n\tNo data will be displayed");
        return null;
    }

    public OMGeometryList findGraphics(String area_key) {
        PoliticalArea area = this.findPoliticalArea(area_key);
        if (area == null) {
            return null;
        }
        return area.getGeometry();
    }

    public Hashtable determinePoliticalAreas(OMGraphicList graphicList) {
        if (Debug.debugging(areasProperty)) {
            Debug.output("AreaHandler: Determining political areas from OMGraphicList");
        }
        Hashtable poli_areas = new Hashtable();
        return this.determinePoliticalAreas(graphicList, poli_areas);
    }

    public Hashtable determinePoliticalAreas(OMGraphicList graphicList, Hashtable poli_areas) {
        String name = null;
        String key = null;
        if (graphicList != null) {
            int size = graphicList.size();
            int i = 0;
            while (i < size) {
                OMGraphic graphic = graphicList.getOMGraphicAt(i);
                Object obj = graphic.getAppObject();
                if (obj == null) {
                    if (Debug.debugging("verbose")) {
                        Debug.error("AreaHandler: Caught a null app object for graphic #" + i);
                    }
                } else {
                    if (obj instanceof Vector) {
                        Vector pair = (Vector)obj;
                        name = (String)pair.elementAt(this.nameIndex);
                        key = ((String)pair.elementAt(this.keyIndex)).toUpperCase().intern();
                        if (Debug.debugging(areasProperty)) {
                            Debug.output("AreaHandler: looking at " + name + ", " + key);
                        }
                    } else if (obj instanceof String) {
                        key = (String)obj;
                        if (Debug.debugging(areasProperty)) {
                            Debug.output("AreaHandler: String app object, looking at " + key);
                        }
                    } else if (Debug.debugging("verbose")) {
                        Debug.output("AreaHandler: Unidentified app object type " + obj);
                    }
                    PoliticalArea area = (PoliticalArea)poli_areas.get(key);
                    if (area == null) {
                        area = new PoliticalArea(name, key);
                        poli_areas.put(key, area);
                    }
                    area.addGraphic(graphic);
                }
                ++i;
            }
            if (Debug.debugging(areasProperty)) {
                Debug.output("AreaHandler: Finished determinePoliticalAreas: " + poli_areas.size() + " areas defined.");
            }
        }
        return poli_areas;
    }

    protected Color getColor(String colorString) {
        Color result = Color.black;
        try {
            result = LayerUtils.parseColor(colorString);
        }
        catch (NumberFormatException nfe) {
            result = this.GetColorFromString(colorString);
        }
        return result;
    }

    protected Color GetColorFromString(String token) {
        String tokstring = token;
        Color result = Color.black;
        if (Debug.debugging(areasProperty)) {
            Debug.output("AreaHandler: GetColorFromString(" + tokstring + ")");
        }
        result = tokstring.equals("black") ? Color.black : (tokstring.equals("blue") ? Color.blue : (tokstring.equals("cyan") ? Color.cyan : (tokstring.equals("darkGray") ? Color.darkGray : (tokstring.equals("gray") ? Color.gray : (tokstring.equals("green") ? Color.green : (tokstring.equals("lightGray") ? Color.lightGray : (tokstring.equals("magenta") ? Color.magenta : (tokstring.equals("orange") ? Color.orange : (tokstring.equals("pink") ? Color.pink : (tokstring.equals("red") ? Color.red : (tokstring.equals("white") ? Color.white : (tokstring.equals("yellow") ? Color.yellow : Color.decode(tokstring)))))))))))));
        if (Debug.debugging(areasProperty)) {
            Debug.output("AreaHandler.GetColorFromToken returns (" + result + ")");
        }
        return result;
    }

    public static void main(String[] argv) {
        String propertiesFile = null;
        String prefix = null;
        String outputFile = null;
        Debug.init();
        if (argv.length < 6) {
            AreaHandler.printUsage();
        }
        int i = 0;
        while (i < argv.length) {
            if (argv[i].equalsIgnoreCase("-props")) {
                propertiesFile = argv[++i];
            } else if (argv[i].equalsIgnoreCase("-prefix")) {
                prefix = argv[++i];
            } else if (argv[i].equalsIgnoreCase("-file")) {
                outputFile = argv[++i];
            }
            ++i;
        }
        if (propertiesFile == null || prefix == null || outputFile == null) {
            AreaHandler.printUsage();
        }
        try {
            Properties properties = new Properties();
            URL propertiesURL = new URL(propertiesFile);
            InputStream is = propertiesURL.openStream();
            properties.load(is);
            ShapeLayer sl = new ShapeLayer();
            sl.setProperties(prefix, properties);
            AreaHandler ah = new AreaHandler(sl.getSpatialIndex(), sl.getDrawingAttributes());
            ah.setProperties(prefix, properties);
            ah.getGraphics().writeGraphics(outputFile);
        }
        catch (MalformedURLException murle) {
            Debug.error("Bad URL for properties file : " + propertiesFile);
            AreaHandler.printUsage();
        }
        catch (IOException ioe) {
            Debug.error("IOException creating cached graphics file: " + outputFile);
            AreaHandler.printUsage();
        }
    }

    public static void printUsage() {
        Debug.output("Usage: java com.bbn.openmap.layer.shape.areas.AreaHandler -props <URL to properties file> -prefix <handler property prefix> -file <path to output file>");
        System.exit(-1);
    }
}

