/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.vpf;

import com.bbn.openmap.io.Closable;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.vpf.CoverageTable;
import com.bbn.openmap.layer.vpf.DcwColumnInfo;
import com.bbn.openmap.layer.vpf.DcwRecordFile;
import com.bbn.openmap.layer.vpf.DcwThematicIndex;
import com.bbn.openmap.layer.vpf.MutableInt;
import com.bbn.openmap.layer.vpf.RunQueue;
import com.bbn.openmap.layer.vpf.TerminatingRunnable;
import com.bbn.openmap.layer.vpf.TilingAdapter;
import com.bbn.openmap.layer.vpf.VPFUtil;
import com.bbn.openmap.util.Debug;
import java.util.ArrayList;
import java.util.List;

public class FeatureClassInfo
extends DcwRecordFile
implements TerminatingRunnable,
Closable {
    private final CoverageTable ctable;
    private final String columnname;
    private int mycolumn = -1;
    private boolean fullInit = false;
    private static final RunQueue tq = new RunQueue(true, 1, true);
    private final List tmpVec = new ArrayList();
    protected String tileFileName;
    protected String tileFileColName;
    protected char featureType;
    public static final String TILE_ID_COLUMN_NAME = "tile_id";
    protected DcwThematicIndex thematicIndex = null;

    public FeatureClassInfo(CoverageTable cthis, String colname, String tablepath, String ftname) throws FormatException {
        super(tablepath + ftname, true);
        if (Debug.debugging("vpf.fci")) {
            Debug.output("FCI set to peruse (" + this.filename + ") created with colname (" + colname + ") , tablepath (" + tablepath + ") and ftname (" + ftname + ")");
        }
        this.ctable = cthis;
        this.columnname = colname.toLowerCase().intern();
    }

    public FeatureClassInfo(CoverageTable cthis, String colname, String tablepath, String ftname, String tileDirFile, String tileDirFileColName) throws FormatException {
        super(tablepath + ftname, false);
        this.fullInit = true;
        this.ctable = cthis;
        this.columnname = colname.toLowerCase().intern();
        this.tileFileName = tileDirFile;
        this.tileFileColName = tileDirFileColName;
        this.featureType = "fac".equals(this.tileFileName) ? (char)65 : ("end".equals(this.tileFileName) ? (char)69 : ("cnd".equals(this.tileFileName) ? (char)78 : ("txt".equals(this.tileFileName) ? (char)84 : ("edg".equals(this.tileFileName) ? (char)76 : (char)83))));
        if (Debug.debugging("vpf.fci")) {
            Debug.output("FCI: set to peruse (" + this.filename + ") and column (" + colname + ")");
            Debug.output("  setting tile directory file (" + tileDirFile + "), tile id column (" + tileDirFileColName + ")");
        }
    }

    public TilingAdapter getTilingAdapter() {
        return this.getTilingAdapter(TILE_ID_COLUMN_NAME, this.tileFileColName);
    }

    public String getTileThematicFileName() {
        int colId;
        if (this.columnInfo != null && (colId = this.getTileIdIndex()) != -1) {
            return this.columnInfo[colId].getThematicIndexName();
        }
        return null;
    }

    public synchronized boolean initThematicIndex(String path) {
        try {
            String thematicIndexName;
            if (this.thematicIndex == null && (thematicIndexName = this.getTileThematicFileName()) != null) {
                this.thematicIndex = new DcwThematicIndex(path + thematicIndexName, this.byteorder);
            }
        }
        catch (FormatException fe) {
            if (Debug.debugging("vpf.FormatException")) {
                Debug.output("FeatureClassInfo.initTI: " + fe.getClass() + " " + fe.getMessage());
            }
            return false;
        }
        return this.thematicIndex != null;
    }

    public DcwThematicIndex getThematicIndex() {
        return this.thematicIndex;
    }

    public int getTileIdIndex() {
        return this.whatColumn(TILE_ID_COLUMN_NAME);
    }

    public int getFaccIndex() {
        return this.whatColumn("f_code");
    }

    public int getTilePrimitiveIdColIndex() {
        return this.whatColumn(this.tileFileColName);
    }

    public char getFeatureType() {
        return this.featureType;
    }

    public synchronized void run() {
        if (this.fullInit) {
            return;
        }
        try {
            this.fullInit = true;
            this.finishInitialization();
        }
        catch (FormatException f) {
            // empty catch block
        }
        this.close();
    }

    public boolean close(boolean done) {
        block2: {
            this.close();
            if (this.thematicIndex == null) break block2;
            try {
                this.thematicIndex.close();
            }
            catch (FormatException fe) {}
        }
        return true;
    }

    public void findYourself(DcwRecordFile rf) {
        this.mycolumn = rf.whatColumn(this.columnname);
    }

    public synchronized String getDescription(List l, MutableInt type) {
        if (!this.fullInit) {
            if (Debug.debugging("vpf")) {
                Debug.output("getDescription forcing init " + this.columnname + " " + this.tablename);
            }
            this.run();
        }
        if (this.mycolumn == -1) {
            return null;
        }
        int i = VPFUtil.objectToInt(l.get(this.mycolumn));
        if (i <= 0) {
            return null;
        }
        return this.getDescription(i, type);
    }

    private synchronized String getDescription(int ftid, MutableInt type) {
        StringBuffer retval;
        block13: {
            retval = null;
            try {
                if (!this.getRow(this.tmpVec, ftid)) {
                    return null;
                }
                boolean haveivdtindex = false;
                int i = 0;
                while (i < this.columnInfo.length) {
                    block15: {
                        String s;
                        block16: {
                            String dciVDT;
                            DcwColumnInfo dci;
                            block14: {
                                dci = this.columnInfo[i];
                                s = null;
                                dciVDT = dci.getVDT();
                                if (dciVDT != "int.vdt") break block14;
                                int val = VPFUtil.objectToInt(this.tmpVec.get(i));
                                if (val == Integer.MIN_VALUE) break block15;
                                if (!haveivdtindex) {
                                    type.value = (short)val;
                                    haveivdtindex = true;
                                }
                                if ((s = this.ctable.getDescription(this.tablename, dci.getColumnName(), val)) == null) {
                                    s = "[" + val + "]";
                                }
                                break block16;
                            }
                            if (dciVDT == "char.vdt") {
                                String val = (String)this.tmpVec.get(i);
                                s = this.ctable.getDescription(this.tablename, dci.getColumnName(), val);
                                if (s == null) {
                                    s = "[" + val + "]";
                                }
                            } else if (dci.isNonKey()) {
                                s = this.tmpVec.get(i).toString();
                            }
                        }
                        if (s != null) {
                            if (retval == null) {
                                retval = new StringBuffer(s);
                            } else {
                                retval.append("; ").append(s);
                            }
                        }
                    }
                    ++i;
                }
            }
            catch (FormatException e) {
                if (!Debug.debugging("vpf")) break block13;
                e.printStackTrace();
            }
        }
        return retval == null ? null : retval.toString();
    }
}

