/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.vpf;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.vpf.AreaTable;
import com.bbn.openmap.layer.vpf.CoordFloatString;
import com.bbn.openmap.layer.vpf.CoverageTable;
import com.bbn.openmap.layer.vpf.EdgeTable;
import com.bbn.openmap.layer.vpf.FeatureCacheGraphicList;
import com.bbn.openmap.layer.vpf.LayerGraphicWarehouseSupport;
import com.bbn.openmap.layer.vpf.NodeTable;
import com.bbn.openmap.layer.vpf.PrimitiveTable;
import com.bbn.openmap.layer.vpf.TextTable;
import com.bbn.openmap.layer.vpf.TileDirectory;
import com.bbn.openmap.layer.vpf.VPFFeatureCache;
import com.bbn.openmap.layer.vpf.VPFFeatureGraphicWarehouse;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMPoint;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.omGraphics.OMText;
import com.bbn.openmap.util.Debug;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class VPFCachedFeatureGraphicWarehouse
extends VPFFeatureGraphicWarehouse {
    protected VPFFeatureCache featureCache = null;

    public VPFCachedFeatureGraphicWarehouse() {
    }

    public VPFCachedFeatureGraphicWarehouse(VPFFeatureCache vfc) {
        this();
        this.setFeatureCache(vfc);
    }

    public void setFeatureCache(VPFFeatureCache vfc) {
        this.featureCache = vfc;
    }

    public VPFFeatureCache getFeatureCache() {
        return this.featureCache;
    }

    public void createArea(CoverageTable covtable, AreaTable areatable, List facevec, LatLonPoint ll1, LatLonPoint ll2, float dpplat, float dpplon, String featureType) {
        ArrayList ipts = new ArrayList();
        int totalSize = 0;
        try {
            totalSize = areatable.computeEdgePoints(facevec, ipts);
        }
        catch (FormatException f) {
            Debug.output("FormatException in computeEdgePoints: " + f);
            return;
        }
        if (totalSize == 0) {
            return;
        }
        OMPoly py = LayerGraphicWarehouseSupport.createAreaOMPoly(ipts, totalSize, ll1, ll2, dpplat, dpplon, covtable.doAntarcticaWorkaround);
        DrawingAttributes da = this.getAttributesForFeature(featureType);
        da.setLinePaint(da.getFillPaint());
        da.setSelectPaint(da.getFillPaint());
        da.setTo(py);
        this.addToCachedList(py, featureType, areatable);
    }

    public void createEdge(CoverageTable c, EdgeTable edgetable, List edgevec, LatLonPoint ll1, LatLonPoint ll2, float dpplat, float dpplon, CoordFloatString coords, String featureType) {
        OMPoly py = LayerGraphicWarehouseSupport.createEdgeOMPoly(coords, ll1, ll2, dpplat, dpplon);
        this.getAttributesForFeature(featureType).setTo(py);
        py.setIsPolygon(false);
        this.addToCachedList(py, featureType, edgetable);
    }

    public void createText(CoverageTable c, TextTable texttable, List textvec, float latitude, float longitude, String text, String featureType) {
        OMText txt = LayerGraphicWarehouseSupport.createOMText(text, latitude, longitude);
        this.getAttributesForFeature(featureType).setTo(txt);
        this.addToCachedList(txt, featureType, texttable);
    }

    public void createNode(CoverageTable c, NodeTable t, List nodeprim, float latitude, float longitude, boolean isEntityNode, String featureType) {
        OMPoint pt = LayerGraphicWarehouseSupport.createOMPoint(latitude, longitude);
        this.getAttributesForFeature(featureType).setTo(pt);
        this.addToCachedList(pt, featureType, t);
    }

    protected void addToCachedList(OMGraphic omg, String featureType, PrimitiveTable pt) {
        if (this.featureCache != null) {
            this.featureCache.addToCachedList(omg, featureType, pt);
        } else {
            this.graphics.add(omg);
        }
    }

    public boolean needToFetchTileContents(String currentFeature, TileDirectory currentTile) {
        if (this.featureCache != null) {
            return this.featureCache.needToFetchTileContents(currentFeature, currentTile, this.graphics);
        }
        return super.needToFetchTileContents(currentFeature, currentTile);
    }

    public OMGraphicList getGraphics() {
        if (this.featureCache != null) {
            OMGraphicList ret = new OMGraphicList();
            Iterator it = this.graphics.iterator();
            while (it.hasNext()) {
                OMGraphic omg = (OMGraphic)it.next();
                if (omg instanceof FeatureCacheGraphicList) {
                    FeatureCacheGraphicList fcgl = (FeatureCacheGraphicList)((FeatureCacheGraphicList)omg).clone();
                    fcgl.setDrawingAttributes(this);
                    ret.add(fcgl);
                    continue;
                }
                ret.add(omg);
            }
            return ret;
        }
        return this.graphics;
    }
}

