/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.vpf;

import com.bbn.openmap.layer.util.cacheHandler.CacheHandler;
import com.bbn.openmap.layer.util.cacheHandler.CacheObject;
import com.bbn.openmap.layer.vpf.FeatureCacheGraphicList;
import com.bbn.openmap.layer.vpf.PrimitiveTable;
import com.bbn.openmap.layer.vpf.TileDirectory;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.util.Debug;

public class VPFFeatureCache
extends CacheHandler {
    public VPFFeatureCache() {
    }

    public VPFFeatureCache(int maxSize) {
        super(maxSize);
    }

    protected void addToCachedList(OMGraphic omg, String featureType, PrimitiveTable pt) {
        String key = VPFFeatureCache.createTableCacheKey(featureType, pt.getTileDirectory().getPath());
        OMGraphicList omgl = (OMGraphicList)this.get(key);
        omgl.add(omg);
    }

    public static String createTableCacheKey(String featureType, String tilePath) {
        return featureType + "-" + tilePath;
    }

    public synchronized boolean loadCachedGraphicList(String featureType, String tilePath, OMGraphicList requestor) {
        String key = VPFFeatureCache.createTableCacheKey(featureType, tilePath);
        boolean exists = this.searchCache(key) != null;
        FeatureCacheGraphicList fcgl = (FeatureCacheGraphicList)this.get(key);
        fcgl.setFeatureName(featureType);
        requestor.add(fcgl);
        return exists;
    }

    public boolean needToFetchTileContents(String currentFeature, TileDirectory currentTile, OMGraphicList requestor) {
        if (this.loadCachedGraphicList(currentFeature, currentTile.getPath(), requestor)) {
            if (Debug.debugging("vpf.cache")) {
                Debug.output("VPFFeatureCache: Loaded Cached List: " + VPFFeatureCache.createTableCacheKey(currentFeature, currentTile.getPath()));
            }
            return false;
        }
        return true;
    }

    public CacheObject load(String key) {
        if (key != null) {
            return new VPFListCacheObject(key, new FeatureCacheGraphicList());
        }
        return null;
    }

    public static class VPFListCacheObject
    extends CacheObject {
        public VPFListCacheObject(String id, OMGraphicList obj) {
            super(id, obj);
        }

        public void finalize() {
            ((OMGraphicList)this.obj).clear();
        }
    }
}

