/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.vpf;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.vpf.AreaTable;
import com.bbn.openmap.layer.vpf.CoordFloatString;
import com.bbn.openmap.layer.vpf.CoverageTable;
import com.bbn.openmap.layer.vpf.EdgeTable;
import com.bbn.openmap.layer.vpf.LayerGraphicWarehouseSupport;
import com.bbn.openmap.layer.vpf.LibrarySelectionTable;
import com.bbn.openmap.layer.vpf.NodeTable;
import com.bbn.openmap.layer.vpf.TextTable;
import com.bbn.openmap.layer.vpf.TileDirectory;
import com.bbn.openmap.layer.vpf.VPFFeatureWarehouse;
import com.bbn.openmap.layer.vpf.VPFLayerGraphicWarehouse;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMPoint;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.omGraphics.OMText;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.JTabbedPane;

public class VPFFeatureGraphicWarehouse
extends VPFLayerGraphicWarehouse
implements VPFFeatureWarehouse {
    public static final String DEFAULT = "DEFAULT";
    Hashtable featureDrawingAttributes;

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        this.createFeatureDrawingAttributes(prefix, props, this.getFeatures());
    }

    public void createFeatureDrawingAttributes(String prefix, Properties props, List features) {
        String realPrefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.featureDrawingAttributes = new Hashtable();
        if (this.drawingAttributes != null) {
            this.featureDrawingAttributes.put(DEFAULT, this.drawingAttributes);
        } else {
            this.drawingAttributes = DrawingAttributes.getDefaultClone();
        }
        Iterator fiter = features.iterator();
        while (fiter.hasNext()) {
            String feature = ((String)fiter.next()).intern();
            DrawingAttributes da = (DrawingAttributes)this.drawingAttributes.clone();
            da.setProperties(realPrefix + feature, props);
            if (da.equals(this.drawingAttributes)) {
                da = this.drawingAttributes;
            }
            this.featureDrawingAttributes.put(feature, da);
        }
    }

    public void setFeatureDrawingAttributes(Hashtable attributes) {
        this.featureDrawingAttributes = attributes;
    }

    public Hashtable getFeatureDrawingAttributes() {
        return this.featureDrawingAttributes;
    }

    public Component getGUI(LibrarySelectionTable lst) {
        JTabbedPane jtp = new JTabbedPane();
        jtp.addTab(DEFAULT, null, this.drawingAttributes.getGUI(), "General Attributes");
        List features = this.getFeatures();
        int size = features.size();
        int i = 0;
        while (i < size) {
            String currentFeature = (String)features.get(i);
            DrawingAttributes da = this.getAttributesForFeature(currentFeature);
            if (da != null && !da.equals(this.drawingAttributes)) {
                String desc = null;
                try {
                    desc = lst.getDescription(currentFeature);
                }
                catch (FormatException fe) {
                    // empty catch block
                }
                if (desc == null) {
                    desc = "Feature Description Unavailable";
                }
                jtp.addTab(currentFeature, null, da.getGUI(), desc);
            }
            ++i;
        }
        return jtp;
    }

    public DrawingAttributes getAttributesForFeature(String featureType) {
        if (featureType != null) {
            DrawingAttributes ret;
            if (this.featureDrawingAttributes != null) {
                ret = (DrawingAttributes)this.featureDrawingAttributes.get(featureType);
                if (ret == null) {
                    ret = this.drawingAttributes;
                }
            } else {
                ret = this.drawingAttributes;
            }
            return ret;
        }
        return this.drawingAttributes;
    }

    public void createArea(CoverageTable covtable, AreaTable areatable, List facevec, LatLonPoint ll1, LatLonPoint ll2, float dpplat, float dpplon, String featureType) {
        ArrayList ipts = new ArrayList();
        int totalSize = 0;
        try {
            totalSize = areatable.computeEdgePoints(facevec, ipts);
        }
        catch (FormatException f) {
            Debug.output("FormatException in computeEdgePoints: " + f);
            return;
        }
        if (totalSize == 0) {
            return;
        }
        OMPoly py = LayerGraphicWarehouseSupport.createAreaOMPoly(ipts, totalSize, ll1, ll2, dpplat, dpplon, covtable.doAntarcticaWorkaround);
        this.getAttributesForFeature(featureType).setTo(py);
        py.setLinePaint(py.getFillPaint());
        py.setSelectPaint(py.getFillPaint());
        this.graphics.add(py);
    }

    public void createEdge(CoverageTable c, EdgeTable edgetable, List edgevec, LatLonPoint ll1, LatLonPoint ll2, float dpplat, float dpplon, CoordFloatString coords, String featureType) {
        OMPoly py = LayerGraphicWarehouseSupport.createEdgeOMPoly(coords, ll1, ll2, dpplat, dpplon);
        this.getAttributesForFeature(featureType).setTo(py);
        py.setIsPolygon(false);
        this.graphics.add(py);
    }

    public void createText(CoverageTable c, TextTable texttable, List textvec, float latitude, float longitude, String text, String featureType) {
        OMText txt = LayerGraphicWarehouseSupport.createOMText(text, latitude, longitude);
        this.getAttributesForFeature(featureType).setTo(txt);
        this.graphics.add(txt);
    }

    public void createNode(CoverageTable c, NodeTable t, List nodeprim, float latitude, float longitude, boolean isEntityNode, String featureType) {
        OMPoint pt = LayerGraphicWarehouseSupport.createOMPoint(latitude, longitude);
        this.getAttributesForFeature(featureType).setTo(pt);
        this.graphics.add(pt);
    }

    public boolean needToFetchTileContents(String currentFeature, TileDirectory currentTile) {
        return true;
    }

    public static void main(String[] argv) {
        new VPFFeatureGraphicWarehouse();
    }
}

