/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.omGraphics.OMColor;
import com.bbn.openmap.util.PropUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeSupport;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;

public class BasicStrokeEditorMenu
extends JPopupMenu {
    protected BasicStroke basicStroke = null;
    protected PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    protected float width;
    protected int endCaps;
    protected int lineJoins;
    protected float miterLimit;
    protected float[] dash;
    protected float dashPhase;
    protected JButton launchButton;
    public static final String NONE = "No Dash Pattern";

    public BasicStrokeEditorMenu() {
        this(new BasicStroke(1.0f));
    }

    public BasicStrokeEditorMenu(BasicStroke bs) {
        this.basicStroke = bs != null ? bs : new BasicStroke(1.0f);
        this.setStrokeWidth(this.basicStroke.getLineWidth());
        this.setMiterLimit(this.basicStroke.getMiterLimit());
        this.setDash(this.basicStroke.getDashArray());
        this.setDashPhase(this.basicStroke.getDashPhase());
        this.setEndCaps(this.basicStroke.getEndCap());
        this.setLineJoins(this.basicStroke.getLineJoin());
        this.setBasicStroke(this.basicStroke);
    }

    public void setLaunchButton(JButton lb) {
        this.launchButton = lb;
    }

    public JButton getLaunchButton() {
        if (this.launchButton == null) {
            BasicStroke bs = this.getBasicStroke();
            float buttonHeight = 20.0f;
            ImageIcon icon = BasicStrokeEditorMenu.createIcon(this.getBasicStroke(), 50, (int)buttonHeight, true);
            this.launchButton = new JButton(icon);
            this.launchButton.setToolTipText("Modify Line Parameters");
            this.launchButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    JButton button = BasicStrokeEditorMenu.this.getLaunchButton();
                    JPopupMenu popup = new JPopupMenu();
                    BasicStrokeEditorMenu.this.setGUI(popup);
                    popup.show(button, button.getWidth(), 0);
                }
            });
        }
        return this.launchButton;
    }

    public void resetStroke() {
        BasicStroke oldStroke = this.basicStroke;
        this.setMiterLimit(this.miterLimit);
        this.basicStroke = new BasicStroke(this.width, this.endCaps, this.lineJoins, this.miterLimit, this.dash, this.dashPhase);
        if (this.launchButton != null) {
            this.launchButton.setIcon(BasicStrokeEditorMenu.createIcon(this.basicStroke, 50, 20, true));
        }
        this.pcs.firePropertyChange("line", oldStroke, this.basicStroke);
    }

    public void show(Component invoker, int x, int y) {
        this.removeAll();
        this.setGUI(this);
        super.show(invoker, x, y);
    }

    public JPopupMenu setGUI(JPopupMenu popup) {
        ImageIcon ii;
        JMenu capMenu = new JMenu("Cap Decoration");
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String command = ae.getActionCommand();
                try {
                    BasicStrokeEditorMenu.this.setEndCaps(Integer.parseInt(command));
                    BasicStrokeEditorMenu.this.resetStroke();
                }
                catch (NumberFormatException e) {}
            }
        };
        ButtonGroup group = new ButtonGroup();
        JRadioButtonMenuItem button = new JRadioButtonMenuItem("Butt", this.endCaps == 0);
        button.setActionCommand(String.valueOf(0));
        group.add(button);
        button.addActionListener(listener);
        capMenu.add(button);
        button = new JRadioButtonMenuItem("Round", this.endCaps == 1);
        button.setActionCommand(String.valueOf(1));
        group.add(button);
        button.addActionListener(listener);
        capMenu.add(button);
        button = new JRadioButtonMenuItem("Square", this.endCaps == 2);
        button.setActionCommand(String.valueOf(2));
        group.add(button);
        button.addActionListener(listener);
        capMenu.add(button);
        JMenu joinMenu = new JMenu("Joint Decoration");
        listener = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String command = ae.getActionCommand();
                try {
                    BasicStrokeEditorMenu.this.setLineJoins(Integer.parseInt(command));
                    BasicStrokeEditorMenu.this.resetStroke();
                }
                catch (NumberFormatException e) {}
            }
        };
        group = new ButtonGroup();
        button = new JRadioButtonMenuItem("Miter", this.lineJoins == 0);
        button.setActionCommand(String.valueOf(0));
        group.add(button);
        button.addActionListener(listener);
        joinMenu.add(button);
        button = new JRadioButtonMenuItem("Round", this.lineJoins == 1);
        button.setActionCommand(String.valueOf(1));
        group.add(button);
        button.addActionListener(listener);
        joinMenu.add(button);
        button = new JRadioButtonMenuItem("Bevel", this.lineJoins == 2);
        button.setActionCommand(String.valueOf(2));
        group.add(button);
        button.addActionListener(listener);
        joinMenu.add(button);
        JMenu widthMenu = new JMenu("Line Width");
        listener = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String command = ae.getActionCommand();
                try {
                    BasicStrokeEditorMenu.this.setStrokeWidth(Integer.parseInt(command));
                    BasicStrokeEditorMenu.this.resetStroke();
                }
                catch (NumberFormatException e) {}
            }
        };
        group = new ButtonGroup();
        int i = 1;
        while (i < 13) {
            ii = BasicStrokeEditorMenu.createIcon(new BasicStroke(i), 50, 20, true);
            button = new JRadioButtonMenuItem(ii, (int)this.width == i);
            button.setActionCommand(String.valueOf(i));
            group.add(button);
            button.addActionListener(listener);
            widthMenu.add(button);
            ++i;
        }
        JMenu dashMenu = new JMenu("Dash Pattern");
        listener = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String command = ae.getActionCommand();
                try {
                    BasicStrokeEditorMenu.this.setDash(BasicStrokeEditorMenu.stringToDashArray(command));
                    BasicStrokeEditorMenu.this.resetStroke();
                }
                catch (NumberFormatException e) {}
            }
        };
        group = new ButtonGroup();
        String[] patterns = new String[]{null, "1 3", "3 3", "12 10", "12 10 6 10", "20 10", "20 10 6 10", "20 10 6 10 6 10"};
        String currentDash = BasicStrokeEditorMenu.dashArrayToString(this.getDash());
        i = 0;
        while (i < patterns.length) {
            BasicStroke dashStroke = new BasicStroke(1.0f, 2, 0, 10.0f, BasicStrokeEditorMenu.stringToDashArray(patterns[i]), 0.0f);
            ii = BasicStrokeEditorMenu.createIcon(dashStroke, 90, 10, true);
            button = new JRadioButtonMenuItem(ii, currentDash.equals(patterns[i]));
            button.setActionCommand(patterns[i]);
            group.add(button);
            button.addActionListener(listener);
            dashMenu.add(button);
            ++i;
        }
        popup.add(widthMenu);
        popup.add(dashMenu);
        popup.add(capMenu);
        popup.add(joinMenu);
        return popup;
    }

    public static String dashArrayToString(float[] da) {
        if (da == null) {
            return NONE;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < da.length) {
            sb.append(Float.toString(da[i]) + " ");
            ++i;
        }
        return sb.toString();
    }

    public static float[] stringToDashArray(String das) {
        if (das == null || das.equals(NONE) || das.equals("")) {
            return null;
        }
        Vector floats = PropUtils.parseSpacedMarkers(das);
        float[] ret = new float[floats.size()];
        int index = 0;
        Enumeration thing = floats.elements();
        while (thing.hasMoreElements()) {
            String f = (String)thing.nextElement();
            try {
                ret[index++] = new Float(f).floatValue();
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
        return ret;
    }

    public BasicStroke getBasicStroke() {
        return this.basicStroke;
    }

    public void setBasicStroke(BasicStroke bs) {
        this.basicStroke = bs;
    }

    public void setPropertyChangeSupport(PropertyChangeSupport propertyChangeSupport) {
        this.pcs = propertyChangeSupport;
    }

    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.pcs;
    }

    public static ImageIcon createIcon(BasicStroke stroke, int width, int height, boolean horizontalOrientation) {
        BufferedImage bigImage = new BufferedImage(width, height, 2);
        Graphics2D g = (Graphics2D)bigImage.getGraphics();
        g.setBackground(OMColor.clear);
        g.setPaint(OMColor.clear);
        g.fillRect(0, 0, width, height);
        g.setPaint(Color.black);
        g.setStroke(stroke);
        if (horizontalOrientation) {
            g.drawLine(0, height / 2, width, height / 2);
        } else {
            g.drawLine(width / 2, 0, width / 2, height);
        }
        return new ImageIcon(bigImage);
    }

    public void setStrokeWidth(float w) {
        if (w < 1.0f) {
            w = 1.0f;
        }
        this.width = w;
    }

    public float getStrokeWidth() {
        return this.width;
    }

    public void setMiterLimit(float ml) {
        this.miterLimit = ml < 1.0f ? 10.0f : ml;
    }

    public float getMiterLimit() {
        return this.miterLimit;
    }

    public void setDash(float[] da) {
        this.dash = da;
    }

    public float[] getDash() {
        return this.dash;
    }

    public void setDashPhase(float dp) {
        this.dashPhase = dp;
    }

    public float getDashPhase() {
        return this.dashPhase;
    }

    public void setEndCaps(int ec) {
        this.endCaps = ec;
    }

    public int getEndCaps() {
        return this.endCaps;
    }

    public void setLineJoins(int lj) {
        this.lineJoins = lj;
    }

    public int getLineJoins() {
        return this.lineJoins;
    }
}

