/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.layer.util.stateMachine.State;
import com.bbn.openmap.omGraphics.EditableOMGraphic;
import com.bbn.openmap.omGraphics.GrabPoint;
import com.bbn.openmap.omGraphics.GraphicAttributes;
import com.bbn.openmap.omGraphics.OMColor;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMLine;
import com.bbn.openmap.omGraphics.OffsetGrabPoint;
import com.bbn.openmap.omGraphics.editable.GraphicEditState;
import com.bbn.openmap.omGraphics.editable.GraphicSelectedState;
import com.bbn.openmap.omGraphics.editable.LineStateMachine;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;

public class EditableOMLine
extends EditableOMGraphic {
    protected GrabPoint gp1;
    protected GrabPoint gp2;
    protected OffsetGrabPoint gpo;
    protected OffsetGrabPoint gpm;
    protected OMLine line;
    public static final int STARTING_POINT_INDEX = 0;
    public static final int ENDING_POINT_INDEX = 1;
    public static final int OFFSET_POINT_INDEX = 2;
    protected JMenu arrowheadMenu = null;

    public EditableOMLine() {
        this.createGraphic(null);
    }

    public EditableOMLine(GraphicAttributes ga) {
        this.createGraphic(ga);
    }

    public EditableOMLine(OMLine oml) {
        this.setGraphic(oml);
    }

    public void init() {
        Debug.message("eomg", "EditableOMLine.init()");
        this.setStateMachine(new LineStateMachine(this));
        this.gPoints = new GrabPoint[3];
    }

    public void setGraphic(OMGraphic graphic) {
        this.init();
        if (graphic instanceof OMLine) {
            this.line = (OMLine)graphic;
            this.stateMachine.setSelected();
            this.setGrabPoints(this.line);
        } else {
            this.createGraphic(null);
        }
    }

    public void createGraphic(GraphicAttributes ga) {
        this.init();
        this.stateMachine.setUndefined();
        int renderType = 0;
        int lineType = 3;
        if (ga != null) {
            renderType = ga.getRenderType();
            lineType = ga.getLineType();
        }
        if (Debug.debugging("eoml")) {
            Debug.output("EditableOMLine.createGraphic(): rendertype = " + renderType);
        }
        if (lineType == 0) {
            lineType = 3;
            ga.setLineType(3);
        }
        switch (renderType) {
            case 1: {
                this.line = new OMLine(90.0f, -180.0f, 90.0f, -180.0f, lineType);
                break;
            }
            case 3: {
                this.line = new OMLine(90.0f, -180.0f, 0, 0, 0, 0);
                break;
            }
            default: {
                this.line = new OMLine(-1, -1, -1, -1);
            }
        }
        if (ga != null) {
            ga.setTo(this.line);
        }
    }

    public OMGraphic getGraphic() {
        return this.line;
    }

    public void setMovingPoint(GrabPoint gp) {
        super.setMovingPoint(gp);
        this.gpm = null;
    }

    public void attachToMovingGrabPoint(OffsetGrabPoint gp) {
        gp.addGrabPoint(this.gpo);
    }

    public void detachFromMovingGrabPoint(OffsetGrabPoint gp) {
        gp.removeGrabPoint(this.gpo);
    }

    public void assertGrabPoints() {
        if (this.gp1 == null) {
            this.gPoints[0] = this.gp1 = new GrabPoint(-1, -1);
        }
        if (this.gp2 == null) {
            this.gPoints[1] = this.gp2 = new GrabPoint(-1, -1);
        }
        if (this.gpo == null) {
            this.gpo = new OffsetGrabPoint(-1, -1);
            this.gPoints[2] = this.gpo;
            this.gpo.addGrabPoint(this.gp1);
            this.gpo.addGrabPoint(this.gp2);
        }
    }

    public void setGrabPoints(OMGraphic graphic) {
        if (!(graphic instanceof OMLine)) {
            return;
        }
        this.assertGrabPoints();
        OMLine line = (OMLine)graphic;
        boolean ntr = line.getNeedToRegenerate();
        int renderType = line.getRenderType();
        if (!ntr) {
            Point p;
            float[] ll;
            if (renderType == 1) {
                Debug.message("eomg", "EditableOMLine: modifying lat/lon line");
                if (this.projection != null) {
                    ll = line.getLL();
                    p = this.projection.forward(ll[0], ll[1]);
                    this.gp1.set((int)p.getX(), (int)p.getY());
                    this.projection.forward(ll[2], ll[3], p);
                    this.gp2.set((int)p.getX(), (int)p.getY());
                }
            } else {
                Debug.message("eomg", "EditableOMLine: modifying x/y or offset standard line");
                this.gp1.set(line.xpoints[0][0], line.ypoints[0][0]);
                int last = line.xpoints[0].length - 1;
                this.gp2.set(line.xpoints[0][last], line.ypoints[0][last]);
            }
            if (line.getRenderType() == 3 && this.projection != null) {
                ll = line.getLL();
                p = this.projection.forward(ll[0], ll[1]);
                this.gpo.set((int)p.getX(), (int)p.getY());
                this.gpo.updateOffsets();
            }
        } else {
            Debug.message("eomg", "EditableOMLine.setGrabPoints: graphic needs to be regenerated");
        }
    }

    public void setGrabPoints() {
        float[] floats;
        int renderType = this.line.getRenderType();
        if (renderType == 1) {
            if (this.projection != null) {
                floats = new float[4];
                LatLonPoint llp = this.projection.inverse(this.gp1.getX(), this.gp1.getY());
                floats[0] = llp.getLatitude();
                floats[1] = llp.getLongitude();
                this.projection.inverse(this.gp2.getX(), this.gp2.getY(), llp);
                floats[2] = llp.getLatitude();
                floats[3] = llp.getLongitude();
                this.line.setLL(floats);
            } else {
                Debug.message("eomg", "EditableOMLine.setGrabPoints: projection is null, can't figure out LATLON points for line.");
            }
        } else if (renderType == 3) {
            if (this.projection != null) {
                floats = new float[4];
                LatLonPoint llp = this.projection.inverse(this.gpo.getX(), this.gpo.getY());
                floats[0] = llp.getLatitude();
                floats[1] = llp.getLongitude();
                floats[2] = 0.0f;
                floats[3] = 0.0f;
                this.line.setLL(floats);
            } else {
                Debug.message("eomg", "EditableOMLine.setGrabPoints: projection is null, can't figure out LATLON points for line offset.");
            }
        }
        if (renderType == 2 || renderType == 3) {
            int[] ints = new int[4];
            if (renderType == 3 && this.gpo != null) {
                ints[0] = this.gp1.getX() - this.gpo.getX();
                ints[1] = this.gp1.getY() - this.gpo.getY();
                ints[2] = this.gp2.getX() - this.gpo.getX();
                ints[3] = this.gp2.getY() - this.gpo.getY();
            } else {
                ints[0] = this.gp1.getX();
                ints[1] = this.gp1.getY();
                ints[2] = this.gp2.getX();
                ints[3] = this.gp2.getY();
            }
            this.line.setPts(ints);
        }
    }

    public void move(MouseEvent e) {
        if (this.line.getRenderType() == 3) {
            this.gpm = new OffsetGrabPoint(e.getX(), e.getY());
            this.gpm.addGrabPoint(this.gp1);
            this.gpm.addGrabPoint(this.gp2);
        } else {
            this.gpm = this.gpo;
            this.gpm.set(e.getX(), e.getY());
            this.gpm.updateOffsets();
        }
        this.movingPoint = this.gpm;
    }

    public boolean generate(Projection proj) {
        Debug.message("eomg", "EditableOMLine.generate()");
        if (this.line != null) {
            this.line.generate(proj);
        }
        if (this.gp1 != null) {
            this.gp1.generate(proj);
        }
        if (this.gp2 != null) {
            this.gp2.generate(proj);
        }
        if (this.gpo != null) {
            this.gpo.generate(proj);
            this.gpo.updateOffsets();
        }
        return true;
    }

    public void regenerate(Projection proj) {
        Debug.message("eomg", "EditableOMLine.regenerate()");
        if (this.line != null) {
            this.line.generate(proj);
        }
        this.setGrabPoints(this.line);
        if (this.gp1 != null) {
            this.gp1.generate(proj);
        }
        if (this.gp2 != null) {
            this.gp2.generate(proj);
        }
        if (this.gpo != null) {
            this.gpo.generate(proj);
            this.gpo.updateOffsets();
        }
    }

    public void render(Graphics graphics) {
        Debug.message("eomg", "EditableOMLine.render()");
        State state = this.getStateMachine().getState();
        if (this.line != null) {
            this.line.setVisible(true);
            this.line.render(graphics);
            this.line.setVisible(false);
        } else {
            Debug.message("eomg", "EditableOMLine.render: null line.");
        }
        if (state instanceof GraphicSelectedState) {
            if (this.gp1 != null) {
                this.gp1.setVisible(true);
                this.gp1.render(graphics);
                this.gp1.setVisible(false);
            }
            if (this.gp2 != null) {
                this.gp2.setVisible(true);
                this.gp2.render(graphics);
                this.gp2.setVisible(false);
            }
        }
        if ((state instanceof GraphicSelectedState || state instanceof GraphicEditState) && this.gpo != null && this.line.getRenderType() == 3) {
            this.gpo.setVisible(true);
            this.gpo.render(graphics);
            this.gpo.setVisible(false);
        }
    }

    public Component getGUI(GraphicAttributes graphicAttributes) {
        if (graphicAttributes != null) {
            JMenu ahm = this.getArrowHeadMenu();
            graphicAttributes.setLineMenuAdditions(new JMenu[]{ahm});
            return graphicAttributes.getGUI();
        }
        return null;
    }

    public JMenu getArrowHeadMenu() {
        if (this.arrowheadMenu == null) {
            this.arrowheadMenu = new JMenu("Arrows");
            ActionListener listener = new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    String command = ae.getActionCommand();
                    try {
                        int what = Integer.parseInt(command);
                        if (what < 0) {
                            ((OMLine)EditableOMLine.this.getGraphic()).addArrowHead(false);
                        } else {
                            ((OMLine)EditableOMLine.this.getGraphic()).addArrowHead(what);
                        }
                        EditableOMLine.this.generate(EditableOMLine.this.getProjection());
                        EditableOMLine.this.repaint();
                    }
                    catch (NumberFormatException e) {}
                }
            };
            boolean doArrowHead = ((OMLine)this.getGraphic()).doArrowHead;
            int currentDirection = ((OMLine)this.getGraphic()).arrowDirectionType;
            int descDir = -1;
            ButtonGroup group = new ButtonGroup();
            ImageIcon ii = this.createArrowIcon(new BasicStroke(1.0f), 50, 20, descDir);
            JRadioButtonMenuItem button = new JRadioButtonMenuItem(ii, !doArrowHead);
            button.setActionCommand(String.valueOf(descDir));
            group.add(button);
            button.addActionListener(listener);
            this.arrowheadMenu.add(button);
            descDir = 0;
            while (descDir <= 2) {
                ii = this.createArrowIcon(new BasicStroke(1.0f), 50, 20, descDir);
                button = new JRadioButtonMenuItem(ii, doArrowHead && currentDirection == descDir);
                button.setActionCommand(String.valueOf(descDir));
                group.add(button);
                button.addActionListener(listener);
                this.arrowheadMenu.add(button);
                ++descDir;
            }
        }
        return this.arrowheadMenu;
    }

    public ImageIcon createArrowIcon(BasicStroke stroke, int width, int height, int arrowHeadType) {
        BufferedImage bigImage = new BufferedImage(width, height, 2);
        Graphics2D g = (Graphics2D)bigImage.getGraphics();
        int middleY = height / 2;
        g.setBackground(OMColor.clear);
        g.setPaint(OMColor.clear);
        g.fillRect(0, 0, width, height);
        g.setPaint(Color.black);
        g.setStroke(stroke);
        g.drawLine(0, middleY, width, middleY);
        int upTip = (int)((double)height * 0.25);
        int downTip = (int)((double)height * 0.75);
        Polygon poly = null;
        if (arrowHeadType == 0 || arrowHeadType == 2) {
            int rightWingX = (int)((double)width * 0.75);
            poly = new Polygon(new int[]{width, rightWingX, rightWingX}, new int[]{middleY, upTip, downTip}, 3);
            g.fill(poly);
            g.draw(poly);
        }
        if (arrowHeadType == 1 || arrowHeadType == 2) {
            int leftWingX = (int)((double)width * 0.25);
            poly = new Polygon(new int[]{0, leftWingX, leftWingX}, new int[]{middleY, upTip, downTip}, 3);
            g.fill(poly);
            g.draw(poly);
        }
        return new ImageIcon(bigImage);
    }
}

