/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.omGraphics.OMColor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.ImageIcon;

public class LineChoice {
    protected ImageIcon icon;
    protected BasicStroke stroke;
    protected int DEFAULT_ICON_WIDTH = 47;
    protected int DEFAULT_ICON_HEIGHT = 17;

    public LineChoice(String imageResourceName, BasicStroke stroke, String toolTip) {
        URL url = this.getClass().getResource(imageResourceName);
        this.icon = new ImageIcon(url, toolTip);
        this.stroke = stroke;
    }

    public LineChoice(BasicStroke stroke, String toolTip) {
        this.icon = LineChoice.createIcon(stroke, this.DEFAULT_ICON_WIDTH, this.DEFAULT_ICON_HEIGHT, true);
        this.stroke = stroke;
    }

    public LineChoice(BasicStroke stroke, int width, int height, boolean horizontalOrientation, String toolTip) {
        this.icon = LineChoice.createIcon(stroke, width, height, horizontalOrientation);
        this.stroke = stroke;
    }

    public BasicStroke getStroke() {
        return this.stroke;
    }

    public void setStroke(BasicStroke stroke) {
        this.stroke = stroke;
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public void setIcon(ImageIcon iicon) {
        this.icon = iicon;
    }

    public static ImageIcon createIcon(BasicStroke stroke, int width, int height, boolean horizontalOrientation) {
        BufferedImage bigImage = new BufferedImage(width, height, 2);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Graphics2D g = ge.createGraphics(bigImage);
        g.setBackground(OMColor.clear);
        g.setPaint(OMColor.clear);
        g.fillRect(0, 0, width, height);
        g.setStroke(stroke);
        g.setPaint(Color.black);
        if (horizontalOrientation) {
            g.drawLine(0, height / 2, width, height / 2);
        } else {
            g.drawLine(width / 2, 0, width / 2, height);
        }
        return new ImageIcon(bigImage);
    }
}

