/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.geo.Geo;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMPoint;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.omGraphics.OMText;
import com.bbn.openmap.proj.Length;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.Graphics;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DecimalFormat;

public class OMDistance
extends OMPoly {
    protected OMGraphicList labels = new OMGraphicList();
    protected OMGraphicList points = new OMGraphicList();
    protected transient Length distUnits = Length.NM;
    public DecimalFormat df = new DecimalFormat("0.#");
    protected boolean paintOnlyPoly = false;

    public OMDistance() {
        this.setRenderType(1);
    }

    public OMDistance(float[] llPoints, int units, int lType, Length distanceUnits) {
        this(llPoints, units, lType, -1, distanceUnits);
    }

    public OMDistance(float[] llPoints, int units, int lType, int nsegs, Length distanceUnits) {
        super(llPoints, units, lType, nsegs);
        this.setDistUnits(distanceUnits);
    }

    public void setDistUnits(Length distanceUnits) {
        this.distUnits = distanceUnits;
    }

    public Length getDistUnits() {
        return this.distUnits;
    }

    public void setLocation(float[] llPoints, int units) {
        this.units = 1;
        if (units == 0) {
            ProjMath.arrayDegToRad(llPoints);
        }
        this.rawllpts = llPoints;
        this.setNeedToRegenerate(true);
        this.setRenderType(1);
    }

    public void createLabels() {
        this.labels.clear();
        this.points.clear();
        if (this.rawllpts == null) {
            return;
        }
        if (this.rawllpts.length < 4) {
            return;
        }
        Geo lastGeo = Geo.createGeo(this.rawllpts[0], this.rawllpts[1]);
        this.points.add(new OMPoint(ProjMath.radToDeg(this.rawllpts[0]), ProjMath.radToDeg(this.rawllpts[1]), 1));
        boolean l = false;
        float cumulativeDist = 0.0f;
        int p = 2;
        while (p < this.rawllpts.length) {
            Geo curGeo = Geo.createGeo(this.rawllpts[p], this.rawllpts[p + 1]);
            float dist = this.getDist(lastGeo, curGeo);
            this.labels.add(this.createLabel(lastGeo, curGeo, dist, cumulativeDist += dist, this.distUnits));
            this.points.add(new OMPoint(ProjMath.radToDeg(this.rawllpts[p]), ProjMath.radToDeg(this.rawllpts[p + 1]), 1));
            lastGeo = curGeo;
            p += 2;
        }
    }

    public OMText createLabel(Geo g1, Geo g2, float dist, float cumulativeDist, Length distanceUnits) {
        Geo mid;
        switch (this.getLineType()) {
            case 1: {
                float lat = (float)(g1.getLatitude() + g2.getLatitude()) / 2.0f;
                float lon = (float)(g1.getLongitude() + g2.getLongitude()) / 2.0f;
                mid = new Geo(lat, lon);
                break;
            }
            case 2: {
                System.err.println("Rhumb distance calculation not implemented.");
            }
            default: {
                mid = g1.midPoint(g2);
            }
        }
        String text = this.df.format(distanceUnits.fromRadians(dist)) + " (" + this.df.format(distanceUnits.fromRadians(cumulativeDist)) + ") " + distanceUnits.getAbbr();
        OMText omtext = new OMText((float)mid.getLatitude(), (float)mid.getLongitude(), text, 0);
        return omtext;
    }

    public float getDist(Geo g1, Geo g2) {
        switch (this.getLineType()) {
            case 1: {
                float lonDist = ProjMath.lonDistance((float)g2.getLongitude(), (float)g1.getLongitude());
                float latDist = (float)g2.getLatitude() - (float)g1.getLatitude();
                return (float)Math.sqrt(lonDist * lonDist + latDist * latDist);
            }
            case 2: {
                Debug.error("Rhumb distance calculation not implemented.");
            }
        }
        return (float)g1.distance(g2);
    }

    public boolean generate(Projection proj) {
        boolean ret = super.generate(proj);
        this.createLabels();
        this.labels.generate(proj);
        this.points.generate(proj);
        return ret;
    }

    public void render(Graphics g) {
        super.render(g);
        if (!this.paintOnlyPoly) {
            this.labels.setLinePaint(this.getLinePaint());
            if (this.isMatted()) {
                this.labels.setFillPaint(this.getMattingPaint());
            }
            this.points.setLinePaint(this.getLinePaint());
            this.points.setFillPaint(this.getLinePaint());
            this.labels.render(g);
            this.points.render(g);
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeObject(this.distUnits.getAbbr());
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.distUnits = Length.get((String)stream.readObject());
    }
}

