/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.omGraphics.OMAction;
import com.bbn.openmap.omGraphics.OMGeometry;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGrid;
import com.bbn.openmap.omGraphics.grid.OMGridGenerator;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.GraphicList;
import com.bbn.openmap.util.HandleError;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.io.EOFException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class OMGraphicList
extends OMGraphic
implements GraphicList,
Serializable {
    public static final transient int LAST_ADDED_ON_TOP = 0;
    public static final transient int FIRST_ADDED_ON_TOP = 1;
    public static final int NONE = -1;
    protected int traverseMode = 1;
    protected boolean vague = false;
    protected List graphics = null;
    protected boolean allowDuplicates = true;
    protected boolean processAllGeometries = false;

    public OMGraphicList() {
        this(10);
    }

    public OMGraphicList(int initialCapacity) {
        this.graphics = new ArrayList(initialCapacity);
    }

    public OMGraphicList(int initialCapacity, int capacityIncrement) {
        this(initialCapacity);
    }

    public OMGraphicList(List list) {
        this.graphics = list;
    }

    public String getDescription() {
        return this.getDescription(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDescription(int level) {
        StringBuffer sb = new StringBuffer();
        if (level > 0) {
            sb.append("|--> ");
        }
        sb.append("OMGraphicList with " + this.size() + " OMGraphic" + (this.size() == 1 ? "\n" : "s\n"));
        OMGraphicList oMGraphicList = this;
        synchronized (oMGraphicList) {
            StringBuffer sb1 = new StringBuffer();
            int i = 0;
            while (i < level) {
                sb1.append("     ");
                ++i;
            }
            String spacer = sb1.toString();
            Iterator it = this.iterator();
            while (it.hasNext()) {
                sb.append(spacer + ((OMGraphic)it.next()).getDescription(level + 1) + "\n");
            }
        }
        return sb.toString();
    }

    public void setVague(boolean value) {
        this.vague = value;
    }

    public boolean isVague() {
        return this.vague;
    }

    public void addOMGraphic(OMGraphic g) {
        this._add(g);
    }

    public void add(OMGraphic g) {
        this._add(g);
    }

    protected synchronized void _add(OMGeometry g) {
        this.checkForDuplicate(g);
        this.graphics.add(g);
    }

    public void setTraverseMode(int mode) {
        this.traverseMode = mode;
    }

    public int getTraverseMode() {
        return this.traverseMode;
    }

    public synchronized void clear() {
        this.graphics.clear();
    }

    public synchronized boolean isEmpty() {
        return this.graphics.isEmpty();
    }

    public synchronized int size() {
        return this.graphics.size();
    }

    public synchronized void setOMGraphicAt(OMGraphic graphic, int index) {
        this.graphics.set(index, graphic);
    }

    public OMGraphic getOMGraphicAt(int location) {
        return (OMGraphic)this._getAt(location);
    }

    protected synchronized OMGeometry _getAt(int location) {
        if (location < 0 || location >= this.graphics.size()) {
            return null;
        }
        return (OMGeometry)this.graphics.get(location);
    }

    protected synchronized void _setAt(OMGeometry graphic, int index) {
        this.graphics.set(index, graphic);
    }

    public OMGraphic getOMGraphicWithAppObject(Object appObj) {
        return (OMGraphic)this._getWithAppObject(appObj);
    }

    protected synchronized OMGeometry _getWithAppObject(Object appObj) {
        Iterator it = this.graphics.iterator();
        while (it.hasNext()) {
            OMGraphicList omgl;
            OMGraphic tGeom;
            OMGeometry graphic = (OMGeometry)it.next();
            Object tObj = graphic.getAppObject();
            if (appObj == tObj || appObj.equals(tObj)) {
                return graphic;
            }
            if (!(graphic instanceof OMGraphicList) || ((OMGraphicList)graphic).isVague() || (tGeom = (omgl = (OMGraphicList)graphic).getOMGraphicWithAppObject(appObj)) == null) continue;
            return tGeom;
        }
        return null;
    }

    public void removeOMGraphicAt(int location) {
        this._remove(location);
    }

    public boolean remove(OMGraphic graphic) {
        return this._remove(graphic);
    }

    protected synchronized Object _remove(int location) {
        return this.graphics.remove(location);
    }

    protected synchronized boolean _remove(OMGeometry geometry) {
        boolean found = false;
        found = this.graphics.remove(geometry);
        if (!found && !this.isVague()) {
            Iterator it = this.graphics.iterator();
            while (it.hasNext()) {
                OMGraphic graphic = (OMGraphic)it.next();
                if (!(graphic instanceof OMGraphicList)) continue;
                found = ((OMGraphicList)graphic)._remove(geometry);
            }
        }
        return found;
    }

    public int indexOf(OMGraphic graphic) {
        return this._indexOf(graphic);
    }

    protected synchronized int _indexOf(OMGeometry geometry) {
        return this.graphics.indexOf(geometry);
    }

    public void insertOMGraphicAt(OMGraphic graphic, int location) {
        this._insert(graphic, location);
    }

    protected synchronized void _insert(OMGeometry geometry, int location) {
        this.graphics.add(location, geometry);
    }

    public void moveIndexedOneToTop(int location) {
        if (this.traverseMode == 1) {
            this.moveIndexedOneToFront(location);
        } else {
            this.moveIndexedOneToBack(location);
        }
    }

    public void moveIndexedToTop(int location) {
        if (this.traverseMode == 1) {
            this.moveIndexedToFirst(location);
        } else {
            this.moveIndexedToLast(location);
        }
    }

    public void moveIndexedOneToBottom(int location) {
        OMGeometry tmpGraphic = this._getAt(location);
        if (this.traverseMode == 1) {
            this.moveIndexedOneToBack(location);
        } else {
            this.moveIndexedOneToFront(location);
        }
    }

    public void moveIndexedToBottom(int location) {
        OMGeometry tmpGraphic = this._getAt(location);
        if (this.traverseMode == 1) {
            this.moveIndexedToLast(location);
        } else {
            this.moveIndexedToFirst(location);
        }
    }

    public void moveIndexedToFirst(int location) {
        int listSize = this.size();
        if (location > 0 && location < listSize) {
            OMGeometry tmpGraphic = this._getAt(location);
            int i = location;
            while (i > 0) {
                this._setAt(this._getAt(i - 1), i);
                --i;
            }
            this._setAt(tmpGraphic, 0);
        }
    }

    public void moveIndexedOneToFront(int location) {
        int listSize = this.size();
        if (location > 0 && location < listSize) {
            OMGeometry tmpGraphic = this._getAt(location);
            this._setAt(this._getAt(location - 1), location);
            this._setAt(tmpGraphic, location - 1);
        }
    }

    public void moveIndexedToLast(int location) {
        int listSize = this.size();
        if (location < listSize - 1 && location >= 0) {
            OMGeometry tmpGraphic = this._getAt(location);
            int i = location;
            while (i < listSize - 1) {
                this._setAt(this._getAt(i + 1), i);
                ++i;
            }
            this._setAt(tmpGraphic, listSize - 1);
        }
    }

    public void moveIndexedOneToBack(int location) {
        int listSize = this.size();
        if (location < listSize - 1 && location >= 0) {
            OMGeometry tmpGraphic = this._getAt(location);
            this._setAt(this._getAt(location + 1), location);
            this._setAt(tmpGraphic, location + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStroke(Stroke stroke) {
        super.setStroke(stroke);
        OMGraphicList oMGraphicList = this;
        synchronized (oMGraphicList) {
            Iterator it = this.graphics.iterator();
            while (it.hasNext()) {
                ((OMGraphic)it.next()).setStroke(stroke);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFillPaint(Paint paint) {
        super.setFillPaint(paint);
        OMGraphicList oMGraphicList = this;
        synchronized (oMGraphicList) {
            Iterator it = this.graphics.iterator();
            while (it.hasNext()) {
                ((OMGraphic)it.next()).setFillPaint(paint);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTextureMask(TexturePaint texture) {
        super.setTextureMask(texture);
        OMGraphicList oMGraphicList = this;
        synchronized (oMGraphicList) {
            Iterator it = this.graphics.iterator();
            while (it.hasNext()) {
                ((OMGraphic)it.next()).setTextureMask(texture);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLinePaint(Paint paint) {
        super.setLinePaint(paint);
        OMGraphicList oMGraphicList = this;
        synchronized (oMGraphicList) {
            Iterator it = this.graphics.iterator();
            while (it.hasNext()) {
                ((OMGraphic)it.next()).setLinePaint(paint);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectPaint(Paint paint) {
        super.setSelectPaint(paint);
        OMGraphicList oMGraphicList = this;
        synchronized (oMGraphicList) {
            Iterator it = this.graphics.iterator();
            while (it.hasNext()) {
                ((OMGraphic)it.next()).setSelectPaint(paint);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMattingPaint(Paint paint) {
        super.setMattingPaint(paint);
        OMGraphicList oMGraphicList = this;
        synchronized (oMGraphicList) {
            Iterator it = this.graphics.iterator();
            while (it.hasNext()) {
                ((OMGraphic)it.next()).setMattingPaint(paint);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMatted(boolean value) {
        super.setMatted(value);
        OMGraphicList oMGraphicList = this;
        synchronized (oMGraphicList) {
            Iterator it = this.graphics.iterator();
            while (it.hasNext()) {
                ((OMGraphic)it.next()).setMatted(value);
            }
        }
    }

    public void project(Projection p) {
        this.generate(p, false);
    }

    public void project(Projection p, boolean forceProjectAll) {
        this.generate(p, forceProjectAll);
    }

    public boolean generate(Projection p) {
        this.generate(p, true);
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void generate(Projection p, boolean forceProjectAll) {
        block2: {
            iterator = this.iterator();
            if (!forceProjectAll) ** GOTO lbl10
            while (iterator.hasNext()) {
                ((OMGraphic)iterator.next()).generate(p);
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                ((OMGraphic)iterator.next()).regenerate(p);
lbl10:
                // 2 sources

                ** while (iterator.hasNext())
            }
        }
    }

    public synchronized void render(Graphics gr) {
        if (this.traverseMode == 1) {
            ListIterator iterator = this.graphics.listIterator(this.graphics.size());
            while (iterator.hasPrevious()) {
                OMGraphic graphic = (OMGraphic)iterator.previous();
                if (!this.shouldProcess(graphic)) continue;
                graphic.render(gr);
            }
        } else {
            ListIterator iterator = this.graphics.listIterator();
            while (iterator.hasNext()) {
                OMGraphic graphic = (OMGraphic)iterator.next();
                if (!this.shouldProcess(graphic)) continue;
                graphic.render(gr);
            }
        }
    }

    public synchronized void renderAllAsSelected(Graphics gr) {
        if (this.traverseMode == 1) {
            ListIterator iterator = this.graphics.listIterator(this.graphics.size());
            while (iterator.hasPrevious()) {
                OMGraphic graphic = (OMGraphic)iterator.previous();
                if (!this.shouldProcess(graphic)) continue;
                graphic.select();
                graphic.render(gr);
                graphic.deselect();
            }
        } else {
            ListIterator iterator = this.graphics.listIterator();
            while (iterator.hasNext()) {
                OMGraphic graphic = (OMGraphic)iterator.next();
                if (!this.shouldProcess(graphic)) continue;
                graphic.select();
                graphic.render(gr);
                graphic.deselect();
            }
        }
    }

    protected boolean shouldProcess(OMGeometry omg) {
        return this.processAllGeometries || omg.isVisible();
    }

    public void setProcessAllGeometries(boolean set) {
        this.processAllGeometries = set;
    }

    public boolean getProcessAllGeometries() {
        return this.processAllGeometries;
    }

    public float distance(int x, int y) {
        return this._findClosest((int)x, (int)y, (float)Float.MAX_VALUE, (boolean)false).d;
    }

    protected synchronized OMDist _findClosest(int x, int y, float limit, boolean resetSelect) {
        OMDist omd = new OMDist();
        if (this.size() != 0) {
            if (this.traverseMode == 1) {
                int i = 0;
                ListIterator iterator = this.graphics.listIterator();
                while (iterator.hasNext()) {
                    OMDist tomd = this.findClosestTest(omd, i, (OMGeometry)iterator.next(), x, y, limit, resetSelect);
                    if (tomd == null) continue;
                    omd = tomd;
                    if (omd.d != 0.0f) {
                        ++i;
                        continue;
                    }
                    break;
                }
            } else {
                int i = this.graphics.size();
                ListIterator iterator = this.graphics.listIterator(i);
                while (iterator.hasPrevious()) {
                    OMDist tomd = this.findClosestTest(omd, i, (OMGeometry)iterator.previous(), x, y, limit, resetSelect);
                    if (tomd == null) continue;
                    omd = tomd;
                    if (omd.d != 0.0f) {
                        --i;
                        continue;
                    }
                    break;
                }
            }
        }
        if (Debug.debugging("omgraphics")) {
            int size = this.size();
            if (omd.omg != null && this.isVague()) {
                omd.omg = this;
                Debug.output(this.getClass().getName() + "(" + size + ") detecting hit and vagueness, returning " + omd);
            } else if (omd.omg != null && !this.isVague()) {
                Debug.output(this.getClass().getName() + "(" + size + ") detecting hit, no vagueness, returning contained " + omd);
            } else {
                Debug.output(this.getClass().getName() + "(" + size + ") omd.omg " + (omd.omg == null ? "== null" : "!= null"));
            }
        }
        return omd;
    }

    protected synchronized OMDist findClosestTest(OMDist current, int index, OMGeometry graphic, int x, int y, float limit, boolean resetSelect) {
        if (current == null) {
            current = new OMDist();
        }
        float currentDistance = Float.MAX_VALUE;
        if (!this.shouldProcess(graphic)) {
            return null;
        }
        if (graphic instanceof OMGraphicList) {
            OMGraphicList omgl = (OMGraphicList)graphic;
            OMDist dist = omgl._findClosest(x, y, limit, resetSelect);
            if (dist.omg != null) {
                currentDistance = dist.d;
                graphic = dist.omg;
            }
        } else {
            if (resetSelect) {
                graphic.deselect();
            }
            currentDistance = graphic.distance(x, y);
        }
        if (currentDistance < limit && currentDistance < current.d) {
            current.omg = !this.isVague() ? graphic : this;
            current.index = index;
            current.d = currentDistance;
        }
        return current;
    }

    public OMGraphic findClosest(int x, int y, float limit) {
        return (OMGraphic)this._findClosest((int)x, (int)y, (float)limit, (boolean)false).omg;
    }

    public OMGraphic findClosest(int x, int y) {
        return this.findClosest(x, y, Float.MAX_VALUE);
    }

    public int findIndexOfClosest(int x, int y, float limit) {
        return this._findClosest((int)x, (int)y, (float)limit, (boolean)false).index;
    }

    public int findIndexOfClosest(int x, int y) {
        return this._findClosest((int)x, (int)y, (float)Float.MAX_VALUE, (boolean)false).index;
    }

    protected OMDist _findClosest(int x, int y, float limit) {
        return this._findClosest(x, y, limit, false);
    }

    public OMGraphic selectClosest(int x, int y) {
        return (OMGraphic)this._selectClosest(x, y, Float.MAX_VALUE);
    }

    public OMGraphic selectClosest(int x, int y, float limit) {
        return (OMGraphic)this._selectClosest(x, y, limit);
    }

    protected synchronized OMGeometry _selectClosest(int x, int y, float limit) {
        OMDist omd = null;
        OMGeometry ret = null;
        if (this.isVague() && (omd = this._findClosest(x, y, limit, true)) != null) {
            this.selectAll();
            return this;
        }
        if (this.size() != 0) {
            if (this.traverseMode == 1) {
                ListIterator iterator = this.graphics.listIterator();
                while (iterator.hasNext()) {
                    OMDist tomd = this.selectClosestTest(omd, 0, (OMGeometry)iterator.next(), x, y, limit);
                    if (tomd == null) continue;
                    omd = tomd;
                    if (omd.d != 0.0f) {
                        continue;
                    }
                    break;
                }
            } else {
                ListIterator iterator = this.graphics.listIterator(this.graphics.size());
                while (iterator.hasPrevious()) {
                    OMDist tomd = this.selectClosestTest(omd, 0, (OMGeometry)iterator.previous(), x, y, limit);
                    if (tomd == null) continue;
                    omd = tomd;
                    if (omd.d != 0.0f) {
                        continue;
                    }
                    break;
                }
            }
        }
        if (omd != null) {
            ret = omd.omg;
        }
        return ret;
    }

    protected OMDist selectClosestTest(OMDist current, int index, OMGeometry graphic, int x, int y, float limit) {
        if (current == null) {
            current = new OMDist();
        }
        OMGeometry oldGraphic = current.omg;
        OMDist ret = this.findClosestTest(current, index, graphic, x, y, limit, true);
        if (ret != null && oldGraphic != ret.omg) {
            if (oldGraphic != null) {
                oldGraphic.deselect();
            }
            ret.omg.select();
        }
        return ret;
    }

    public void select() {
        this.selectAll();
        super.select();
    }

    public OMGraphic getOMGraphicThatContains(int x, int y) {
        return (OMGraphic)this._getContains(x, y);
    }

    protected synchronized OMGeometry _getContains(int x, int y) {
        OMGeometry ret = null;
        OMGraphicList tomgl = null;
        if (this.size() != 0) {
            if (this.traverseMode == 1) {
                ListIterator iterator = this.graphics.listIterator();
                while (iterator.hasNext()) {
                    OMGraphic graphic = (OMGraphic)iterator.next();
                    if (!this.shouldProcess(graphic)) continue;
                    if (graphic instanceof OMGraphicList) {
                        tomgl = (OMGraphicList)graphic;
                        ret = tomgl._getContains(x, y);
                        if (ret == null) continue;
                        if (!tomgl.isVague()) break;
                        ret = graphic;
                        break;
                    }
                    if (!graphic.contains(x, y)) continue;
                    ret = graphic;
                    break;
                }
            } else {
                ListIterator iterator = this.graphics.listIterator(this.graphics.size());
                while (iterator.hasPrevious()) {
                    OMGraphic graphic = (OMGraphic)iterator.previous();
                    if (!this.shouldProcess(graphic)) continue;
                    if (graphic instanceof OMGraphicList) {
                        tomgl = (OMGraphicList)graphic;
                        ret = tomgl._getContains(x, y);
                        if (ret == null) continue;
                        if (!tomgl.isVague()) break;
                        ret = graphic;
                        break;
                    }
                    if (!graphic.contains(x, y)) continue;
                    ret = graphic;
                    break;
                }
            }
        }
        if (ret != null && this.isVague()) {
            ret = this;
        }
        return ret;
    }

    public void deselect() {
        this.deselectAll();
        super.deselect();
    }

    public synchronized void deselectAll() {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            ((OMGeometry)it.next()).deselect();
        }
    }

    public synchronized void selectAll() {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            ((OMGeometry)it.next()).select();
        }
    }

    public void doAction(OMGraphic graphic, OMAction action) {
        this._doAction(graphic, action);
    }

    protected void _doAction(OMGeometry graphic, OMAction action) {
        boolean alreadyOnList;
        Debug.message("omgl", "OMGraphicList.doAction()");
        if (graphic == null) {
            return;
        }
        int i = this._indexOf(graphic);
        boolean bl = alreadyOnList = i != -1;
        if (action == null || action.getValue() == 0 && !alreadyOnList) {
            Debug.message("omgl", "OMGraphicList.doAction: adding graphic with null action");
            this._add(graphic);
            return;
        }
        if (action.isMask(64) || action.isMask(128) && !alreadyOnList) {
            Debug.message("omgl", "OMGraphicList.doAction: adding graphic");
            this._add(graphic);
        }
        if (action.isMask(4)) {
            Debug.message("omgl", "OMGraphicList.doAction: removing graphic");
            this._remove(graphic);
        }
        if (action.isMask(256)) {
            Debug.message("omgl", "OMGraphicList.doAction: raising graphic");
            this.moveIndexedOneToTop(i);
        }
        if (action.isMask(1)) {
            Debug.message("omgl", "OMGraphicList.doAction: raising graphic to top");
            this.moveIndexedToTop(i);
        }
        if (action.isMask(512)) {
            Debug.message("omgl", "OMGraphicList.doAction: lowering graphic");
            this.moveIndexedOneToBottom(i);
        }
        if (action.isMask(2)) {
            Debug.message("omgl", "OMGraphicList.doAction: lowering graphic to bottom");
            this.moveIndexedOneToBottom(i);
        }
        if (action.isMask(32)) {
            Debug.message("omgl", "OMGraphicList.doAction: deselecting all graphics.");
            this.deselectAll();
        }
        if (action.isMask(8)) {
            Debug.message("omgl", "OMGraphicList.doAction: selecting graphic");
            graphic.select();
        }
        if (action.isMask(16)) {
            Debug.message("omgl", "OMGraphicList.doAction: deselecting graphic");
            graphic.deselect();
        }
        if (action.isMask(1024)) {
            Debug.message("omgl", "OMGraphicList.doAction: sorting the list");
            this.sort();
        }
    }

    public synchronized void setVisible(boolean visible) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            ((OMGeometry)it.next()).setVisible(visible);
        }
    }

    public synchronized boolean isVisible() {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            if (!((OMGeometry)it.next()).isVisible()) continue;
            return true;
        }
        return false;
    }

    public void setAllowDuplicates(boolean set) {
        this.allowDuplicates = set;
    }

    public boolean getAllowDuplicates() {
        return this.allowDuplicates;
    }

    protected synchronized void checkForDuplicate(OMGeometry g) {
        if (!this.allowDuplicates) {
            this.graphics.remove(g);
        }
    }

    public synchronized boolean contains(OMGeometry g) {
        boolean ret = false;
        if (g != null) {
            Iterator it = this.iterator();
            while (it.hasNext()) {
                OMGeometry itg = (OMGeometry)it.next();
                if (g != itg && (!(itg instanceof OMGraphicList) || !((OMGraphicList)itg).contains(g))) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    public synchronized void setGridGenerator(OMGridGenerator generator, Projection proj) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            OMGraphic graphic = (OMGraphic)it.next();
            if (!(graphic instanceof OMGrid)) continue;
            ((OMGrid)graphic).setGenerator(generator);
            if (proj == null) continue;
            graphic.generate(proj);
        }
    }

    public synchronized List getTargets() {
        if (this.graphics == null) {
            this.graphics = new ArrayList();
        }
        return this.graphics;
    }

    public synchronized void setTargets(List list) {
        this.graphics = list;
    }

    public synchronized Iterator iterator() {
        return this.graphics.iterator();
    }

    public void readGraphics(URL cacheURL) throws IOException {
        block4: {
            try {
                ObjectInputStream objstream = new ObjectInputStream(cacheURL.openStream());
                if (Debug.debugging("omgraphics")) {
                    Debug.output("OMGeomtryList: Opened " + cacheURL.toString());
                }
                this.readGraphics(objstream);
                objstream.close();
                if (!Debug.debugging("omgraphics")) break block4;
                Debug.output("OMGeometryList: closed " + cacheURL.toString());
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                throw new HandleError(aioobe);
            }
            catch (ClassCastException cce) {
                cce.printStackTrace();
            }
        }
    }

    public synchronized void readGraphics(ObjectInputStream objstream) throws IOException {
        Debug.message("omgraphics", "OMGraphicList: Reading cached graphics");
        try {
            while (true) {
                try {
                    OMGraphic omg = (OMGraphic)objstream.readObject();
                    this.add(omg);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                catch (OptionalDataException ode) {
                    ode.printStackTrace();
                }
            }
        }
        catch (EOFException e) {
            return;
        }
    }

    public void writeGraphics(String graphicsSaveFile) throws IOException {
        FileOutputStream ostream = new FileOutputStream(graphicsSaveFile);
        ObjectOutputStream objectstream = new ObjectOutputStream(ostream);
        this.writeGraphics(objectstream);
        objectstream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void writeGraphics(ObjectOutputStream objectstream) throws IOException {
        List list = this.graphics;
        synchronized (list) {
            Iterator it = this.iterator();
            while (it.hasNext()) {
                OMGeometry g = (OMGeometry)it.next();
                try {
                    objectstream.writeObject(g);
                }
                catch (IOException e) {
                    Debug.error("OMGeometryList: Couldn't write object " + g + "\nOMGeometryList: Reason: " + e.toString());
                }
            }
        }
        objectstream.close();
    }

    public void sort() {
    }

    protected OMGraphic objectToOMGraphic(Object obj) {
        if (obj instanceof OMGraphic) {
            return (OMGraphic)obj;
        }
        return null;
    }

    public synchronized Object clone() {
        OMGraphicList omgl = (OMGraphicList)super.clone();
        omgl.graphics = new ArrayList(this.size());
        Iterator it = this.iterator();
        while (it.hasNext()) {
            omgl.add((OMGraphic)((OMGraphic)it.next()).clone());
        }
        return omgl;
    }

    protected static class OMDist {
        public OMGeometry omg = null;
        public float d = Float.POSITIVE_INFINITY;
        public int index = -1;

        protected OMDist() {
        }

        public String toString() {
            return "OMDist: omg=" + (this.omg == null ? "null" : this.omg.getClass().getName()) + ", d=" + this.d + ", index=" + this.index;
        }
    }
}

