/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.omGraphics.NatCubicClosedSpline;
import com.bbn.openmap.omGraphics.NatCubicSpline;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.omGraphics.geom.BasicGeometry;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.Point;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;

public class OMSpline
extends OMPoly {
    private transient NatCubicSpline natCubic = new NatCubicSpline();
    private transient NatCubicClosedSpline natCubicClosed = new NatCubicClosedSpline();

    public OMSpline() {
    }

    public OMSpline(float[] llPoints, int units, int lType) {
        super(llPoints, units, lType);
    }

    public OMSpline(float[] llPoints, int units, int lType, int nsegs) {
        super(llPoints, units, lType, nsegs);
    }

    public OMSpline(int[] xypoints) {
        super(xypoints);
    }

    public OMSpline(int[] xPoints, int[] yPoints) {
        super(xPoints, yPoints);
    }

    public OMSpline(float latPoint, float lonPoint, int[] xypoints, int cMode) {
        super(latPoint, lonPoint, xypoints, cMode);
    }

    public OMSpline(float latPoint, float lonPoint, int[] xPoints, int[] yPoints, int cMode) {
        super(latPoint, lonPoint, xPoints, yPoints, cMode);
    }

    public boolean generate(Projection proj) {
        this.shape = null;
        if (proj == null) {
            Debug.message("omspline", "OMSpline: null projection in generate!");
            return false;
        }
        NatCubicSpline spline = this.isGeometryClosed() ? this.natCubicClosed : this.natCubic;
        spline.setSteps(this.nsegs);
        switch (this.renderType) {
            case 2: {
                if (this.xs == null) {
                    Debug.message("omspline", "OMSpline x/y rendertype null coordinates");
                    this.setNeedToRegenerate(true);
                    return false;
                }
                int[][] splinePoints = spline.calc(this.xs, this.ys);
                this.xpoints = new int[1][0];
                this.xpoints[0] = splinePoints[0];
                this.ypoints = new int[1][0];
                this.ypoints[0] = splinePoints[1];
                if (!this.doShapes) break;
                this.setNeedToRegenerate(false);
                this.createShape();
                break;
            }
            case 3: {
                if (this.xs == null) {
                    Debug.message("omspline", "OMSpline offset rendertype null coordinates");
                    this.setNeedToRegenerate(true);
                    return false;
                }
                int npts = this.xs.length;
                int[] _x = new int[npts];
                int[] _y = new int[npts];
                Point origin = proj.forward(this.lat, this.lon, new Point(0, 0), true);
                if (this.coordMode == 0) {
                    int i = 0;
                    while (i < npts) {
                        _x[i] = this.xs[i] + origin.x;
                        _y[i] = this.ys[i] + origin.y;
                        ++i;
                    }
                } else {
                    _x[0] = this.xs[0] + origin.x;
                    _y[0] = this.ys[0] + origin.y;
                    int i = 1;
                    while (i < npts) {
                        _x[i] = this.xs[i] + _x[i - 1];
                        _y[i] = this.ys[i] + _y[i - 1];
                        ++i;
                    }
                }
                int[][] splinePoints = spline.calc(_x, _y);
                this.xpoints = new int[1][0];
                this.xpoints[0] = splinePoints[0];
                this.ypoints = new int[1][0];
                this.ypoints[0] = splinePoints[1];
                if (!this.doShapes) break;
                this.setNeedToRegenerate(false);
                this.createShape();
                break;
            }
            case 1: {
                if (this.rawllpts == null) {
                    Debug.message("omspline", "OMSpline latlon rendertype null coordinates");
                    this.setNeedToRegenerate(true);
                    return false;
                }
                float[] splinellpts = spline.calc(this.rawllpts, 1.0E-8f);
                ArrayList vector = proj.forwardPoly(splinellpts, this.lineType, this.nsegs, this.isPolygon);
                int size = vector.size();
                if (!this.doShapes) {
                    this.xpoints = new int[size / 2][0];
                    this.ypoints = new int[this.xpoints.length][0];
                }
                int i = 0;
                int j = 0;
                while (i < size) {
                    if (this.doShapes) {
                        GeneralPath gp = BasicGeometry.createShape((int[])vector.get(i), (int[])vector.get(i + 1), this.isPolygon);
                        if (this.shape == null) {
                            this.shape = gp;
                        } else {
                            this.shape.append(gp, false);
                        }
                    } else {
                        this.xpoints[j] = (int[])vector.get(i);
                        this.ypoints[j] = (int[])vector.get(i + 1);
                    }
                    i += 2;
                    ++j;
                }
                break;
            }
            case 0: {
                Debug.error("OMSpline.generate: invalid RenderType");
                return false;
            }
        }
        this.setNeedToRegenerate(false);
        return true;
    }
}

