/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics.event;

import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.event.GestureResponsePolicy;
import com.bbn.openmap.omGraphics.event.MapMouseInterpreter;
import com.bbn.openmap.util.Debug;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class StandardMapMouseInterpreter
implements MapMouseInterpreter {
    protected boolean DEBUG = false;
    protected OMGraphicHandlerLayer layer = null;
    protected String[] mouseModeServiceList = null;
    protected String lastToolTip = null;
    protected GestureResponsePolicy grp = null;
    protected GeometryOfInterest clickInterest = null;
    protected GeometryOfInterest movementInterest = null;
    protected boolean consumeEvents = false;
    protected boolean noTimerOverOMGraphic = true;
    protected int mouseTimerInterval = 150;
    protected Timer mouseTimer = null;
    protected MouseTimerListener mouseTimerListener = new MouseTimerListener();
    protected MouseEvent currentMouseEvent;

    public StandardMapMouseInterpreter() {
        this.DEBUG = Debug.debugging("grp");
    }

    public StandardMapMouseInterpreter(OMGraphicHandlerLayer l) {
        this();
        this.setLayer(l);
    }

    public void setConsumeEvents(boolean consume) {
        this.consumeEvents = consume;
    }

    public boolean getConsumeEvents() {
        return this.consumeEvents;
    }

    public void setLayer(OMGraphicHandlerLayer l) {
        this.layer = l;
    }

    public OMGraphicHandlerLayer getLayer() {
        return this.layer;
    }

    public void setMouseModeServiceList(String[] list) {
        this.mouseModeServiceList = list;
    }

    public boolean isLeftMouseButton(MouseEvent me) {
        return SwingUtilities.isLeftMouseButton(me) && !me.isControlDown();
    }

    public String[] getMouseModeServiceList() {
        return this.mouseModeServiceList;
    }

    protected void setClickInterest(GeometryOfInterest goi) {
        this.clickInterest = goi;
    }

    protected GeometryOfInterest getClickInterest() {
        return this.clickInterest;
    }

    protected void setMovementInterest(GeometryOfInterest goi) {
        this.movementInterest = goi;
    }

    protected GeometryOfInterest getMovementInterest() {
        return this.movementInterest;
    }

    public OMGraphic getGeometryUnder(MouseEvent me) {
        OMGraphic omg = null;
        OMGraphicList list = null;
        if (this.layer != null) {
            list = this.layer.getList();
            if (list != null) {
                omg = list.findClosest(me.getX(), me.getY(), 4.0f);
            } else if (this.DEBUG) {
                Debug.output("SMMI: no layer to evaluate mouse event");
            }
        } else if (this.DEBUG) {
            Debug.output("SMMI: no layer to evaluate mouse event");
        }
        return omg;
    }

    public boolean mousePressed(MouseEvent e) {
        if (this.DEBUG) {
            Debug.output("SMMI: mousePressed()");
        }
        this.setCurrentMouseEvent(e);
        boolean ret = false;
        GeometryOfInterest goi = this.getClickInterest();
        OMGraphic omg = this.getGeometryUnder(e);
        if (goi != null && !goi.appliesTo(omg, e)) {
            if (goi.isLeftButton()) {
                this.leftClickOff(goi.getGeometry(), e);
            } else {
                this.rightClickOff(goi.getGeometry(), e);
            }
            this.setClickInterest(null);
        }
        if (omg != null) {
            if (this.isLeftMouseButton(e)) {
                this.select(omg);
            }
            this.setClickInterest(new GeometryOfInterest(omg, e));
            ret = true;
        }
        return ret && this.consumeEvents;
    }

    public boolean mouseReleased(MouseEvent e) {
        this.setCurrentMouseEvent(e);
        return false;
    }

    public boolean mouseClicked(MouseEvent e) {
        this.setCurrentMouseEvent(e);
        GeometryOfInterest goi = this.getClickInterest();
        if (goi != null) {
            if (this.isLeftMouseButton(e)) {
                this.leftClick(goi.getGeometry(), e);
            } else {
                this.rightClick(goi.getGeometry(), e);
            }
        } else if (this.isLeftMouseButton(e)) {
            this.leftClick(e);
        } else {
            this.rightClick(e);
        }
        return this.consumeEvents;
    }

    public void mouseEntered(MouseEvent e) {
        this.setCurrentMouseEvent(e);
    }

    public void mouseExited(MouseEvent e) {
        this.setCurrentMouseEvent(e);
    }

    public boolean mouseDragged(MouseEvent e) {
        this.setCurrentMouseEvent(e);
        GeometryOfInterest goi = this.getClickInterest();
        if (goi != null) {
            this.setClickInterest(null);
        }
        return this.mouseMoved(e) && this.consumeEvents;
    }

    public boolean mouseMoved(MouseEvent e) {
        this.setCurrentMouseEvent(e);
        boolean ret = false;
        if (this.noTimerOverOMGraphic && this.getMovementInterest() != null || this.mouseTimerInterval <= 0) {
            return this.updateMouseMoved(e);
        }
        if (this.mouseTimer == null) {
            this.mouseTimer = new Timer(this.mouseTimerInterval, this.mouseTimerListener);
            this.mouseTimer.setRepeats(false);
        }
        this.mouseTimerListener.setEvent(e);
        this.mouseTimer.restart();
        return false;
    }

    public void setNoTimerOverOMGraphic(boolean val) {
        this.noTimerOverOMGraphic = val;
    }

    public boolean getNoTimerOverOMGraphic() {
        return this.noTimerOverOMGraphic;
    }

    public void setMouseTimerInterval(int interval) {
        this.mouseTimerInterval = interval;
    }

    public int getMouseTimerInterval() {
        return this.mouseTimerInterval;
    }

    protected boolean updateMouseMoved(MouseEvent e) {
        boolean ret = false;
        OMGraphic omg = this.getGeometryUnder(e);
        GeometryOfInterest goi = this.getMovementInterest();
        if (omg != null && this.grp != null) {
            if (goi == null || !goi.appliesTo(omg)) {
                if (goi != null) {
                    this.mouseNotOver(goi.getGeometry());
                }
                goi = new GeometryOfInterest(omg, e);
                this.setMovementInterest(goi);
                this.setNoTimerOverOMGraphic(!omg.shouldRenderFill());
                ret = this.mouseOver(omg, e);
            }
        } else {
            if (goi != null) {
                this.mouseNotOver(goi.getGeometry());
                this.setMovementInterest(null);
            }
            ret = this.mouseOver(e);
        }
        return ret && this.consumeEvents;
    }

    public void mouseMoved() {
        GeometryOfInterest goi = this.getMovementInterest();
        if (goi != null) {
            this.mouseNotOver(goi.getGeometry());
            this.setMovementInterest(null);
        }
    }

    public boolean leftClick(MouseEvent me) {
        if (this.DEBUG) {
            Debug.output("leftClick(MAP) at " + me.getX() + ", " + me.getY());
        }
        return false;
    }

    public boolean leftClick(OMGraphic omg, MouseEvent me) {
        if (this.DEBUG) {
            Debug.output("leftClick(" + omg.getClass().getName() + ") at " + me.getX() + ", " + me.getY());
        }
        return true;
    }

    public boolean leftClickOff(OMGraphic omg, MouseEvent me) {
        if (this.DEBUG) {
            Debug.output("leftClickOff(" + omg.getClass().getName() + ") at " + me.getX() + ", " + me.getY());
        }
        return false;
    }

    public boolean rightClick(MouseEvent me) {
        boolean ret = false;
        if (this.DEBUG) {
            Debug.output("rightClick(MAP) at " + me.getX() + ", " + me.getY());
        }
        return this.displayPopup(this.grp.getItemsForMapMenu(), me);
    }

    public boolean rightClick(OMGraphic omg, MouseEvent me) {
        if (this.DEBUG) {
            Debug.output("rightClick(" + omg.getClass().getName() + ") at " + me.getX() + ", " + me.getY());
        }
        return this.displayPopup(this.grp.getItemsForOMGraphicMenu(omg), me);
    }

    protected boolean displayPopup(List contents, MouseEvent me) {
        if (this.DEBUG) {
            Debug.output("displayPopup(" + contents + ") " + me);
        }
        if (contents != null && contents.size() > 0) {
            JPopupMenu jpm = new JPopupMenu();
            Iterator it = contents.iterator();
            while (it.hasNext()) {
                jpm.add((Component)it.next());
            }
            jpm.show((Component)me.getSource(), me.getX(), me.getY());
            return true;
        }
        return false;
    }

    public boolean rightClickOff(OMGraphic omg, MouseEvent me) {
        if (this.DEBUG) {
            Debug.output("rightClickOff(" + omg.getClass().getName() + ") at " + me.getX() + ", " + me.getY());
        }
        return false;
    }

    public boolean mouseOver(MouseEvent me) {
        if (this.DEBUG) {
            Debug.output("mouseOver(MAP) at " + me.getX() + ", " + me.getY());
        }
        return false;
    }

    public boolean mouseOver(OMGraphic omg, MouseEvent me) {
        if (this.DEBUG) {
            Debug.output("mouseOver(" + omg.getClass().getName() + ") at " + me.getX() + ", " + me.getY());
        }
        if (this.grp != null) {
            this.handleToolTip(this.grp.getToolTipTextFor(omg));
            this.handleInfoLine(this.grp.getInfoText(omg));
            if (this.grp.isHighlightable(omg)) {
                this.grp.highlight(omg);
            }
        }
        return true;
    }

    protected void handleToolTip(String tip) {
        if (this.lastToolTip == tip) {
            return;
        }
        this.lastToolTip = tip;
        if (this.layer != null) {
            if (this.lastToolTip != null) {
                this.layer.fireRequestToolTip(this.lastToolTip);
            } else {
                this.layer.fireHideToolTip();
            }
        }
    }

    protected void handleInfoLine(String line) {
        if (this.layer != null) {
            this.layer.fireRequestInfoLine(line == null ? "" : line);
        }
    }

    public boolean mouseNotOver(OMGraphic omg) {
        if (this.DEBUG) {
            Debug.output("mouseNotOver(" + omg.getClass().getName() + ")");
        }
        if (this.grp != null) {
            this.grp.unhighlight(omg);
        }
        this.handleToolTip(null);
        this.handleInfoLine(null);
        return false;
    }

    public void select(OMGraphic omg) {
        if (this.grp != null && this.grp.isSelectable(omg)) {
            OMGraphicList omgl = new OMGraphicList();
            omgl.add(omg);
            this.grp.select(omgl);
        }
    }

    public void deselect(OMGraphic omg) {
        if (this.grp != null && this.grp.isSelectable(omg)) {
            OMGraphicList omgl = new OMGraphicList();
            omgl.add(omg);
            this.grp.deselect(omgl);
        }
    }

    protected void setCurrentMouseEvent(MouseEvent me) {
        this.currentMouseEvent = me;
    }

    public MouseEvent getCurrentMouseEvent() {
        return this.currentMouseEvent;
    }

    public void setGRP(GestureResponsePolicy grp) {
        this.grp = grp;
    }

    public GestureResponsePolicy getGRP() {
        return this.grp;
    }

    protected class MouseTimerListener
    implements ActionListener {
        private MouseEvent event;

        protected MouseTimerListener() {
        }

        public synchronized void setEvent(MouseEvent e) {
            this.event = e;
        }

        public synchronized void actionPerformed(ActionEvent ae) {
            if (this.event != null) {
                StandardMapMouseInterpreter.this.updateMouseMoved(this.event);
            }
        }
    }

    public class GeometryOfInterest {
        OMGraphic omg;
        int button;
        boolean leftButton;

        public GeometryOfInterest(OMGraphic geom, MouseEvent me) {
            this.omg = geom;
            this.button = this.getButton(me);
            this.leftButton = StandardMapMouseInterpreter.this.isLeftMouseButton(me);
        }

        public boolean appliesTo(OMGraphic geom) {
            return geom == this.omg;
        }

        public boolean appliesTo(OMGraphic geom, MouseEvent me) {
            return geom == this.omg && this.sameButton(me);
        }

        public boolean sameButton(MouseEvent me) {
            return this.button == this.getButton(me);
        }

        public OMGraphic getGeometry() {
            return this.omg;
        }

        public int getButton() {
            return this.button;
        }

        protected int getButton(MouseEvent me) {
            if (SwingUtilities.isLeftMouseButton(me)) {
                return 0;
            }
            if (SwingUtilities.isRightMouseButton(me)) {
                return 1;
            }
            return 2;
        }

        public boolean isLeftButton() {
            return this.leftButton;
        }
    }
}

