/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.plugin;

import com.bbn.openmap.Environment;
import com.bbn.openmap.I18n;
import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.event.MapMouseListener;
import com.bbn.openmap.event.SelectMouseMode;
import com.bbn.openmap.layer.util.LayerUtils;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.plugin.PlugIn;
import com.bbn.openmap.plugin.PlugInLayer;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.PropUtils;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Properties;

public abstract class AbstractPlugIn
implements PlugIn,
PropertyConsumer,
MapMouseListener {
    protected Component component = null;
    protected String prefix = null;
    protected String name = this.getClass().getName();
    protected MapMouseListener mml = this;
    protected boolean addToBeanContext = true;
    public I18n i18n = Environment.getI18n();

    public AbstractPlugIn() {
    }

    public AbstractPlugIn(Component comp) {
        this.setComponent(comp);
    }

    public void setName(String name) {
        this.name = name;
        Component comp = this.getComponent();
        if (comp != null) {
            comp.setName(name);
        }
    }

    public String getName() {
        Component comp = this.getComponent();
        if (comp != null) {
            this.name = comp.getName();
        }
        return this.name;
    }

    public void setComponent(Component comp) {
        this.component = comp;
    }

    public Component getComponent() {
        return this.component;
    }

    public void repaint() {
        this.component.repaint();
    }

    public void doPrepare() {
        if (this.component instanceof PlugInLayer) {
            ((PlugInLayer)this.component).doPrepare();
        }
    }

    public void setMapMouseListener(MapMouseListener mml) {
        this.mml = mml;
    }

    public MapMouseListener getMapMouseListener() {
        return this.mml;
    }

    public abstract OMGraphicList getRectangle(Projection var1);

    public Component getGUI() {
        return null;
    }

    public void setAddToBeanContext(boolean value) {
        this.addToBeanContext = value;
    }

    public boolean getAddToBeanContext() {
        return this.addToBeanContext;
    }

    public void setProperties(Properties setList) {
        this.setProperties(null, setList);
    }

    public void setProperties(String prefix, Properties setList) {
        this.setPropertyPrefix(prefix);
        String realPrefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.name = setList.getProperty(realPrefix + "prettyName");
        this.setAddToBeanContext(LayerUtils.booleanFromProperties(setList, realPrefix + "addToBeanContext", this.addToBeanContext));
    }

    public Properties getProperties(Properties getList) {
        if (getList == null) {
            getList = new Properties();
        }
        String realPrefix = PropUtils.getScopedPropertyPrefix(this);
        getList.put(realPrefix + "addToBeanContext", new Boolean(this.addToBeanContext).toString());
        return getList;
    }

    public Properties getPropertyInfo(Properties list) {
        if (list == null) {
            list = new Properties();
        }
        list.put("addToBeanContext", "Flag to give the PlugIn access to all of the other application components.");
        list.put("addToBeanContext.editor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        return list;
    }

    public void setPropertyPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPropertyPrefix() {
        return this.prefix;
    }

    public String[] getMouseModeServiceList() {
        return new String[]{SelectMouseMode.modeID};
    }

    public boolean mousePressed(MouseEvent e) {
        return false;
    }

    public boolean mouseReleased(MouseEvent e) {
        return false;
    }

    public boolean mouseClicked(MouseEvent e) {
        return false;
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public boolean mouseDragged(MouseEvent e) {
        return false;
    }

    public boolean mouseMoved(MouseEvent e) {
        return false;
    }

    public void mouseMoved() {
    }

    public void removed() {
    }
}

