/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.plugin;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.layer.util.LayerUtils;
import com.bbn.openmap.omGraphics.OMColorChooser;
import com.bbn.openmap.omGraphics.OMGeometry;
import com.bbn.openmap.omGraphics.OMGeometryList;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMLine;
import com.bbn.openmap.omGraphics.OMText;
import com.bbn.openmap.omGraphics.geom.PolygonGeometry;
import com.bbn.openmap.omGraphics.geom.PolylineGeometry;
import com.bbn.openmap.plugin.OMGraphicHandlerPlugIn;
import com.bbn.openmap.proj.Ellipsoid;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.MGRSPoint;
import com.bbn.openmap.proj.coords.UTMPoint;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PaletteHelper;
import com.bbn.openmap.util.PropUtils;
import com.bbn.openmap.util.quadtree.QuadTree;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Paint;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class UTMGridPlugIn
extends OMGraphicHandlerPlugIn {
    protected boolean UTM_DEBUG = false;
    protected boolean UTM_DEBUG_VERBOSE = false;
    public static final int INTERVAL_100K = 100000;
    public static final float DEFAULT_UTM_LABEL_CUTOFF_SCALE = 3.3E7f;
    protected boolean showZones = true;
    protected boolean showLabels = true;
    protected float labelCutoffScale = 3.3E7f;
    protected boolean show100kGrid = false;
    protected int distanceGridResolution = 0;
    protected Paint utmGridPaint = Color.black;
    protected Paint distanceGridPaint = Color.black;
    protected QuadTree labelTree;
    protected OMGraphicList labelList;
    protected OMGraphicList verticalList;
    protected OMGraphicList horizontalList;
    public static final String ShowLabelsProperty = "showLabels";
    public static final String ShowZonesProperty = "showZones";
    public static final String LabelCutoffScaleProperty = "labelCutoffScale";
    public static final String Show100kGridProperty = "show100KmGrid";
    public static final String UTMGridColorProperty = "utmGridColor";
    public static final String DistanceGridColorProperty = "distanceGridColor";
    public static final String DistanceGridResolutionProperty = "distanceGridResolution";
    private boolean colorChooserLock = false;
    static /* synthetic */ Class class$com$bbn$openmap$plugin$UTMGridPlugIn;

    public UTMGridPlugIn() {
        this.UTM_DEBUG = Debug.debugging("utmgrid");
        this.UTM_DEBUG_VERBOSE = Debug.debugging("utmgrid_verbose");
    }

    protected OMGeometryList createUTMZoneVerticalLines() {
        OMGeometryList verticalList = new OMGeometryList();
        float[] points = null;
        int lon = -180;
        while (lon < 180) {
            points = lon == 6 ? new float[]{56.0f, lon, -80.0f, lon} : (lon > 6 && lon < 42 ? new float[]{72.0f, lon, -80.0f, lon} : new float[]{84.0f, lon, -80.0f, lon});
            verticalList.add(new PolylineGeometry.LL(points, 0, 3));
            lon += 6;
        }
        points = new float[]{72.0f, 6.0f, 64.0f, 6.0f};
        verticalList.add(new PolylineGeometry.LL(points, 0, 3));
        points = new float[]{64.0f, 3.0f, 56.0f, 3.0f};
        verticalList.add(new PolylineGeometry.LL(points, 0, 3));
        points = new float[]{84.0f, 9.0f, 72.0f, 9.0f};
        verticalList.add(new PolylineGeometry.LL(points, 0, 3));
        points = new float[]{84.0f, 21.0f, 72.0f, 21.0f};
        verticalList.add(new PolylineGeometry.LL(points, 0, 3));
        points = new float[]{84.0f, 33.0f, 72.0f, 33.0f};
        verticalList.add(new PolylineGeometry.LL(points, 0, 3));
        verticalList.setLinePaint(this.utmGridPaint);
        return verticalList;
    }

    protected OMGeometryList createUTMZoneHorizontalLines() {
        OMGeometryList horizontalList = new OMGeometryList();
        float[] points = null;
        int lat = -80;
        while (lat <= 72) {
            points = new float[]{lat, -180.0f, lat, -90.0f, lat, 0.0f, lat, 90.0f, lat, 180.0f};
            horizontalList.add(new PolylineGeometry.LL(points, 0, 2));
            lat += 8;
        }
        points = new float[]{84.0f, -180.0f, 84.0f, -90.0f, 84.0f, 0.0f, 84.0f, 90.0f, 84.0f, 180.0f};
        horizontalList.add(new PolylineGeometry.LL(points, 0, 2));
        horizontalList.setLinePaint(this.utmGridPaint);
        return horizontalList;
    }

    protected QuadTree createUTMZoneLabels() {
        float latitude;
        QuadTree labelTree = new QuadTree();
        UTMPoint utm = new UTMPoint();
        LatLonPoint llp = new LatLonPoint();
        int lat = -80;
        while (lat <= 72) {
            int lon = -180;
            while (lon < 180) {
                block6: {
                    float longitude;
                    block5: {
                        block4: {
                            latitude = lat;
                            longitude = lon;
                            if (lat != 56 || lon != 6) break block4;
                            longitude = 3.0f;
                            break block5;
                        }
                        if (lat == 72 && lon > 0 && lon < 42) break block6;
                    }
                    llp.setLatLon(latitude, longitude);
                    this.addLabel(llp, UTMPoint.LLtoUTM(llp, utm), labelTree);
                }
                lon += 6;
            }
            lat += 8;
        }
        latitude = 72.0f;
        llp.setLatLon(latitude, 9.0f);
        this.addLabel(llp, UTMPoint.LLtoUTM(llp, utm), labelTree);
        llp.setLongitude(21.0f);
        this.addLabel(llp, UTMPoint.LLtoUTM(llp, utm), labelTree);
        llp.setLongitude(33.0f);
        this.addLabel(llp, UTMPoint.LLtoUTM(llp, utm), labelTree);
        return labelTree;
    }

    protected void addLabel(LatLonPoint llp, UTMPoint utm, QuadTree labelTree) {
        float latitude = llp.getLatitude();
        float longitude = llp.getLongitude();
        labelTree.put(latitude, longitude, new OMText(latitude, longitude, 2, -2, utm.zone_number + "" + utm.zone_letter, 0));
    }

    protected OMGraphicList createEquiDistanceLines(UTMPoint utm, int gridLineInterval) {
        OMLine line;
        OMGraphicList list = new OMGraphicList();
        UTMPoint utm1 = new UTMPoint(utm);
        UTMPoint utm2 = new UTMPoint(utm);
        LatLonPoint point1 = new LatLonPoint();
        LatLonPoint point2 = new LatLonPoint();
        UTMPoint utmp = new UTMPoint(utm);
        LatLonPoint llp = new LatLonPoint();
        int endNorthing = (int)Math.floor(utm.northing / 100000.0f) + 10;
        int startNorthing = (int)Math.floor(utm.northing / 100000.0f) - 10;
        int numVertLines = 9;
        int numHorLines = endNorthing - startNorthing;
        float[][] vertPoints = new float[numVertLines][numHorLines * 2];
        if (this.UTM_DEBUG_VERBOSE) {
            Debug.output("Array is [" + vertPoints.length + "][" + vertPoints[0].length + "]");
        }
        int coordCount = 0;
        boolean doPolys = true;
        utm1.easting = 100000.0f;
        utm2.easting = 900000.0f;
        int i = startNorthing;
        while (i < endNorthing) {
            utm2.northing = utm1.northing = (float)i * (float)gridLineInterval;
            utmp.northing = utm1.northing;
            if (doPolys) {
                int j = 0;
                while (j < numVertLines) {
                    utmp.easting = (float)(j + 1) * (float)gridLineInterval;
                    llp = utmp.toLatLonPoint(Ellipsoid.WGS_84, llp);
                    vertPoints[j][coordCount] = llp.getLatitude();
                    vertPoints[j][coordCount + 1] = llp.getLongitude();
                    if (this.UTM_DEBUG_VERBOSE) {
                        Debug.output("for vline " + j + ", point " + i + ", easting: " + utmp.easting + ", northing: " + utmp.northing + ", lat:" + vertPoints[j][coordCount] + ", lon:" + vertPoints[j][coordCount + 1]);
                    }
                    ++j;
                }
                coordCount += 2;
            }
            point1 = utm1.toLatLonPoint(Ellipsoid.WGS_84, point1);
            point2 = utm2.toLatLonPoint(Ellipsoid.WGS_84, point2);
            float lat2 = point1.getLatitude();
            if (lat2 < 84.0f) {
                line = new OMLine(point1.getLatitude(), point1.getLongitude(), point2.getLatitude(), point2.getLongitude(), 3);
                line.setLinePaint(this.distanceGridPaint);
                list.add(line);
            }
            ++i;
        }
        if (doPolys) {
            OMGeometryList polys = new OMGeometryList();
            i = 0;
            while (i < vertPoints.length) {
                if (this.UTM_DEBUG_VERBOSE) {
                    int k = 0;
                    while (k < vertPoints[i].length) {
                        System.out.println(" for poly " + i + ": lat = " + vertPoints[i][k] + ", lon = " + vertPoints[i][k + 1]);
                        k += 2;
                    }
                }
                PolylineGeometry.LL poly = new PolylineGeometry.LL(vertPoints[i], 0, 3);
                polys.add(poly);
                ++i;
            }
            polys.setLinePaint(this.distanceGridPaint);
            list.add(polys);
        } else {
            if (this.UTM_DEBUG) {
                Debug.output("Doing vertical lines");
            }
            utm1.northing = startNorthing;
            utm2.northing = endNorthing;
            i = 1;
            while (i <= 9) {
                utm1.easting = (float)i * 100000.0f;
                utm2.easting = (float)i * 100000.0f;
                point1 = utm1.toLatLonPoint(Ellipsoid.WGS_84, point1);
                point2 = utm2.toLatLonPoint(Ellipsoid.WGS_84, point2);
                line = new OMLine(point1.getLatitude(), point1.getLongitude(), point2.getLatitude(), point2.getLongitude(), 3);
                line.setLinePaint(this.distanceGridPaint);
                list.add(line);
                ++i;
            }
        }
        return list;
    }

    protected OMGeometryList createMGRSRectangles(LatLonPoint llp, int accuracy, int numRects) {
        return this.createMGRSRectangles(llp, accuracy, numRects, Ellipsoid.WGS_84);
    }

    protected OMGeometryList createMGRSRectangles(LatLonPoint llp, int accuracy, int numRects, Ellipsoid ellipsoid) {
        MGRSPoint mgrs = new MGRSPoint();
        mgrs.setAccuracy(accuracy);
        MGRSPoint.LLtoMGRS(llp, ellipsoid, mgrs);
        mgrs = new MGRSPoint(mgrs.getMGRS());
        mgrs.setAccuracy(accuracy);
        float accuracyBonus = 100000.0f / (float)Math.pow(10.0, accuracy);
        OMGeometryList list = new OMGeometryList();
        float i = (float)(-numRects) * accuracyBonus;
        while (i < (float)numRects * accuracyBonus) {
            float j = (float)(-numRects) * accuracyBonus;
            while (j < (float)numRects * accuracyBonus) {
                if (Debug.debugging("utmdistancegrid")) {
                    System.out.print(".");
                }
                list.add(this.createMGRSRectangle(mgrs, i, j, accuracyBonus, ellipsoid));
                j += accuracyBonus;
            }
            if (Debug.debugging("utmdistancegrid")) {
                System.out.println("");
            }
            i += accuracyBonus;
        }
        return list;
    }

    protected OMGeometry createMGRSRectangle(MGRSPoint mgrsBasePoint, float voffset, float hoffset, float interval, Ellipsoid ellipsoid) {
        float[] llpoints = new float[10];
        float easting = mgrsBasePoint.easting + hoffset;
        float northing = mgrsBasePoint.northing + voffset;
        int zone_number = mgrsBasePoint.zone_number;
        char zone_letter = mgrsBasePoint.zone_letter;
        LatLonPoint llp1 = new LatLonPoint();
        MGRSPoint.UTMtoLL(ellipsoid, northing, easting, zone_number, zone_letter, llp1);
        llpoints[0] = llp1.getLatitude();
        llpoints[1] = llp1.getLongitude();
        llpoints[8] = llp1.getLatitude();
        llpoints[9] = llp1.getLongitude();
        MGRSPoint.UTMtoLL(ellipsoid, northing, easting + interval, zone_number, zone_letter, llp1);
        llpoints[2] = llp1.getLatitude();
        llpoints[3] = llp1.getLongitude();
        MGRSPoint.UTMtoLL(ellipsoid, northing + interval, easting + interval, zone_number, zone_letter, llp1);
        llpoints[4] = llp1.getLatitude();
        llpoints[5] = llp1.getLongitude();
        MGRSPoint.UTMtoLL(ellipsoid, northing + interval, easting, zone_number, zone_letter, llp1);
        llpoints[6] = llp1.getLatitude();
        llpoints[7] = llp1.getLongitude();
        MGRSPoint mgrs = new MGRSPoint(northing, easting, zone_number, zone_letter);
        mgrs.setAccuracy(mgrsBasePoint.getAccuracy());
        MGRSPoint.MGRStoLL(mgrs, ellipsoid, llp1);
        String mgrsString = mgrs.getMGRS();
        if (Debug.debugging("utmgriddetail")) {
            Debug.output(" - assigning " + mgrsString + " to poly with " + mgrs.getAccuracy());
        }
        PolygonGeometry.LL poly = new PolygonGeometry.LL(llpoints, 0, interval <= 1000.0f ? 1 : 3);
        poly.setAppObject(mgrsString);
        return poly;
    }

    public OMGraphicList getRectangle(Projection p) {
        OMGraphicList list = this.getList();
        if (this.verticalList == null) {
            this.verticalList = this.createUTMZoneVerticalLines();
            this.horizontalList = this.createUTMZoneHorizontalLines();
            this.labelTree = this.createUTMZoneLabels();
        }
        list.clear();
        if (this.showZones) {
            list.add(this.verticalList);
            list.add(this.horizontalList);
        }
        LatLonPoint center = p.getCenter();
        UTMPoint utm = new UTMPoint(center);
        if (this.show100kGrid) {
            Debug.message("utmgrid", "Creating 100k distance lines...");
            OMGraphicList hunKLines = this.createEquiDistanceLines(utm, 100000);
            list.add(hunKLines);
        }
        if (this.distanceGridResolution > 0) {
            Debug.message("utmgrid", "Creating distance lines...");
            float decisionAid = 100000.0f / (float)Math.pow(10.0, this.distanceGridResolution);
            float dglc = 30.0f * decisionAid;
            int numberBasedForScale = (int)(p.getScale() / (2.0f * decisionAid));
            if (numberBasedForScale > 10) {
                numberBasedForScale = 10;
            }
            OMGeometryList geoList = this.createMGRSRectangles(center, this.distanceGridResolution, numberBasedForScale);
            if (this.showLabels && p.getScale() <= dglc) {
                Debug.message("utmgrid", "Creating labels for distance lines ...");
                OMGraphicList textList = new OMGraphicList();
                LatLonPoint llp = new LatLonPoint();
                Point point = new Point();
                Iterator it = geoList.iterator();
                while (it.hasNext()) {
                    PolygonGeometry.LL pll = (PolygonGeometry.LL)it.next();
                    String labelString = (String)pll.getAppObject();
                    if (labelString == null) continue;
                    float[] ll = pll.getLatLonArray();
                    llp.setLatLon(ll[0], ll[1], true);
                    p.forward(llp, point);
                    double x = point.getX();
                    double y = point.getY();
                    int buffer = 20;
                    if (!(x > (double)(-buffer)) && !(x < (double)(p.getWidth() + buffer)) || !(y > (double)(-buffer)) && !(y < (double)(p.getHeight() + buffer))) continue;
                    OMText label = new OMText(llp.getLatitude(), llp.getLongitude(), 4, -4, labelString, 0);
                    label.setLinePaint(this.distanceGridPaint);
                    textList.add(label);
                }
                list.add(textList);
            }
            geoList.setLinePaint(this.distanceGridPaint);
            list.add(geoList);
        }
        if (this.labelList != null) {
            this.labelList.clear();
        } else {
            this.labelList = new OMGraphicList();
        }
        if (this.showLabels && p.getScale() <= this.labelCutoffScale) {
            Debug.message("utmgrid", "Creating labels for map...");
            LatLonPoint ul = p.getUpperLeft();
            LatLonPoint lr = p.getLowerRight();
            Vector labels = this.labelTree.get(ul.getLatitude(), ul.getLongitude(), lr.getLatitude(), lr.getLongitude());
            this.labelList.setTargets(labels);
            this.labelList.setLinePaint(this.getUTMGridPaint());
            list.add(this.labelList);
        }
        Debug.message("utmgrid", "Generating OMGraphics...");
        list.generate(p);
        Debug.message("utmgrid", "Done.");
        return list;
    }

    public Component getGUI() {
        JPanel panel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        panel.setLayout(gridbag);
        JCheckBox setZonesButton = new JCheckBox(this.i18n.get(class$com$bbn$openmap$plugin$UTMGridPlugIn == null ? (class$com$bbn$openmap$plugin$UTMGridPlugIn = UTMGridPlugIn.class$("com.bbn.openmap.plugin.UTMGridPlugIn")) : class$com$bbn$openmap$plugin$UTMGridPlugIn, "setZonesButton", "Show UTM Zone Grid"), this.showZones);
        setZonesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JCheckBox button = (JCheckBox)ae.getSource();
                UTMGridPlugIn.this.showZones = button.isSelected();
                UTMGridPlugIn.this.doPrepare();
            }
        });
        c.gridy = 0;
        c.anchor = 17;
        gridbag.setConstraints(setZonesButton, c);
        panel.add(setZonesButton);
        JCheckBox set100kGridButton = new JCheckBox(this.i18n.get(class$com$bbn$openmap$plugin$UTMGridPlugIn == null ? (class$com$bbn$openmap$plugin$UTMGridPlugIn = UTMGridPlugIn.class$("com.bbn.openmap.plugin.UTMGridPlugIn")) : class$com$bbn$openmap$plugin$UTMGridPlugIn, "set100kGridButton", "Show 100Km Distance Grid"), this.show100kGrid);
        set100kGridButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JCheckBox button = (JCheckBox)ae.getSource();
                UTMGridPlugIn.this.show100kGrid = button.isSelected();
                UTMGridPlugIn.this.doPrepare();
            }
        });
        c.gridy = 1;
        gridbag.setConstraints(set100kGridButton, c);
        panel.add(set100kGridButton);
        JCheckBox setLabelsButton = new JCheckBox(this.i18n.get(class$com$bbn$openmap$plugin$UTMGridPlugIn == null ? (class$com$bbn$openmap$plugin$UTMGridPlugIn = UTMGridPlugIn.class$("com.bbn.openmap.plugin.UTMGridPlugIn")) : class$com$bbn$openmap$plugin$UTMGridPlugIn, "setLabelsButton", "Show Zone Labels"), this.showLabels);
        setLabelsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JCheckBox button = (JCheckBox)ae.getSource();
                UTMGridPlugIn.this.showLabels = button.isSelected();
                UTMGridPlugIn.this.doPrepare();
            }
        });
        c.gridy = 2;
        gridbag.setConstraints(setLabelsButton, c);
        panel.add(setLabelsButton);
        JPanel resPanel = PaletteHelper.createPaletteJPanel(this.i18n.get(class$com$bbn$openmap$plugin$UTMGridPlugIn == null ? (class$com$bbn$openmap$plugin$UTMGridPlugIn = UTMGridPlugIn.class$("com.bbn.openmap.plugin.UTMGridPlugIn")) : class$com$bbn$openmap$plugin$UTMGridPlugIn, "resPanel", "Distance Grid Units"));
        String[] resStrings = new String[]{this.i18n.get(class$com$bbn$openmap$plugin$UTMGridPlugIn == null ? (class$com$bbn$openmap$plugin$UTMGridPlugIn = UTMGridPlugIn.class$("com.bbn.openmap.plugin.UTMGridPlugIn")) : class$com$bbn$openmap$plugin$UTMGridPlugIn, "resStrings.noGrid", " No Grid "), this.i18n.get(class$com$bbn$openmap$plugin$UTMGridPlugIn == null ? (class$com$bbn$openmap$plugin$UTMGridPlugIn = UTMGridPlugIn.class$("com.bbn.openmap.plugin.UTMGridPlugIn")) : class$com$bbn$openmap$plugin$UTMGridPlugIn, "resStrings.10000m", " 10,000 meter   "), this.i18n.get(class$com$bbn$openmap$plugin$UTMGridPlugIn == null ? (class$com$bbn$openmap$plugin$UTMGridPlugIn = UTMGridPlugIn.class$("com.bbn.openmap.plugin.UTMGridPlugIn")) : class$com$bbn$openmap$plugin$UTMGridPlugIn, "resStrings.1000m", " 1000 meter "), this.i18n.get(class$com$bbn$openmap$plugin$UTMGridPlugIn == null ? (class$com$bbn$openmap$plugin$UTMGridPlugIn = UTMGridPlugIn.class$("com.bbn.openmap.plugin.UTMGridPlugIn")) : class$com$bbn$openmap$plugin$UTMGridPlugIn, "resStrings.100m", " 100 meter "), this.i18n.get(class$com$bbn$openmap$plugin$UTMGridPlugIn == null ? (class$com$bbn$openmap$plugin$UTMGridPlugIn = UTMGridPlugIn.class$("com.bbn.openmap.plugin.UTMGridPlugIn")) : class$com$bbn$openmap$plugin$UTMGridPlugIn, "resStrings.10m", " 10 meter "), this.i18n.get(class$com$bbn$openmap$plugin$UTMGridPlugIn == null ? (class$com$bbn$openmap$plugin$UTMGridPlugIn = UTMGridPlugIn.class$("com.bbn.openmap.plugin.UTMGridPlugIn")) : class$com$bbn$openmap$plugin$UTMGridPlugIn, "resStrings.1m", " 1 meter ")};
        JComboBox<String> resList = new JComboBox<String>(resStrings);
        resList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComboBox jcb = (JComboBox)e.getSource();
                UTMGridPlugIn.this.setDistanceGridResolution(jcb.getSelectedIndex());
                UTMGridPlugIn.this.doPrepare();
            }
        });
        resPanel.add(resList);
        c.gridy = 3;
        c.anchor = 10;
        gridbag.setConstraints(resPanel, c);
        panel.add(resPanel);
        JButton utmGridColorButton = new JButton(this.i18n.get(class$com$bbn$openmap$plugin$UTMGridPlugIn == null ? (class$com$bbn$openmap$plugin$UTMGridPlugIn = UTMGridPlugIn.class$("com.bbn.openmap.plugin.UTMGridPlugIn")) : class$com$bbn$openmap$plugin$UTMGridPlugIn, "utmGridColorButton", "Set UTM Grid Color"));
        utmGridColorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                Color tmpPaint = UTMGridPlugIn.this.getNewPaint((Component)ae.getSource(), UTMGridPlugIn.this.i18n.get(class$com$bbn$openmap$plugin$UTMGridPlugIn == null ? (class$com$bbn$openmap$plugin$UTMGridPlugIn = UTMGridPlugIn.class$("com.bbn.openmap.plugin.UTMGridPlugIn")) : class$com$bbn$openmap$plugin$UTMGridPlugIn, "utmGridColorChooser", "Choose UTM Grid Color"), (Color)UTMGridPlugIn.this.getUTMGridPaint());
                if (tmpPaint != null) {
                    UTMGridPlugIn.this.setUTMGridPaint(tmpPaint);
                    UTMGridPlugIn.this.doPrepare();
                }
            }
        });
        c.gridy = 4;
        gridbag.setConstraints(utmGridColorButton, c);
        panel.add(utmGridColorButton);
        JButton distGridColorButton = new JButton(this.i18n.get(class$com$bbn$openmap$plugin$UTMGridPlugIn == null ? (class$com$bbn$openmap$plugin$UTMGridPlugIn = UTMGridPlugIn.class$("com.bbn.openmap.plugin.UTMGridPlugIn")) : class$com$bbn$openmap$plugin$UTMGridPlugIn, "distGridColorButton", "Set Distance Grid Color"));
        distGridColorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                Color tmpPaint = UTMGridPlugIn.this.getNewPaint((Component)ae.getSource(), UTMGridPlugIn.this.i18n.get(class$com$bbn$openmap$plugin$UTMGridPlugIn == null ? (class$com$bbn$openmap$plugin$UTMGridPlugIn = UTMGridPlugIn.class$("com.bbn.openmap.plugin.UTMGridPlugIn")) : class$com$bbn$openmap$plugin$UTMGridPlugIn, "distanceGridColorChooser", "Choose Distance Grid Color"), (Color)UTMGridPlugIn.this.getDistanceGridPaint());
                if (tmpPaint != null) {
                    UTMGridPlugIn.this.setDistanceGridPaint(tmpPaint);
                    UTMGridPlugIn.this.doPrepare();
                }
            }
        });
        c.gridy = 5;
        gridbag.setConstraints(distGridColorButton, c);
        panel.add(distGridColorButton);
        return panel;
    }

    protected Color getNewPaint(Component source, String title, Color startingColor) {
        Color newPaint = null;
        if (this.getLock()) {
            newPaint = OMColorChooser.showDialog(source, title, startingColor);
            this.releaseLock();
        }
        return newPaint;
    }

    protected synchronized boolean getLock() {
        if (!this.colorChooserLock) {
            this.colorChooserLock = true;
            return this.colorChooserLock;
        }
        return false;
    }

    protected synchronized void releaseLock() {
        this.colorChooserLock = false;
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.showLabels = LayerUtils.booleanFromProperties(props, prefix + ShowLabelsProperty, this.showLabels);
        this.showZones = LayerUtils.booleanFromProperties(props, prefix + ShowZonesProperty, this.showZones);
        this.show100kGrid = LayerUtils.booleanFromProperties(props, prefix + Show100kGridProperty, this.show100kGrid);
        this.labelCutoffScale = LayerUtils.floatFromProperties(props, prefix + LabelCutoffScaleProperty, this.labelCutoffScale);
        this.utmGridPaint = LayerUtils.parseColorFromProperties(props, prefix + UTMGridColorProperty, this.utmGridPaint);
        this.distanceGridPaint = LayerUtils.parseColorFromProperties(props, prefix + DistanceGridColorProperty, this.distanceGridPaint);
        this.setDistanceGridResolution(LayerUtils.intFromProperties(props, prefix + DistanceGridResolutionProperty, this.distanceGridResolution));
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        props.put(prefix + ShowLabelsProperty, new Boolean(this.showLabels).toString());
        props.put(prefix + ShowZonesProperty, new Boolean(this.showZones).toString());
        props.put(prefix + LabelCutoffScaleProperty, Float.toString(this.labelCutoffScale));
        props.put(prefix + Show100kGridProperty, new Boolean(this.show100kGrid).toString());
        props.put(prefix + UTMGridColorProperty, Integer.toHexString(((Color)this.utmGridPaint).getRGB()));
        props.put(prefix + DistanceGridColorProperty, Integer.toHexString(((Color)this.distanceGridPaint).getRGB()));
        props.put(prefix + DistanceGridResolutionProperty, Integer.toString(this.distanceGridResolution));
        return props;
    }

    public Properties getPropertyInfo(Properties props) {
        props = super.getPropertyInfo(props);
        String interString = this.i18n.get(class$com$bbn$openmap$plugin$UTMGridPlugIn == null ? (class$com$bbn$openmap$plugin$UTMGridPlugIn = UTMGridPlugIn.class$("com.bbn.openmap.plugin.UTMGridPlugIn")) : class$com$bbn$openmap$plugin$UTMGridPlugIn, ShowZonesProperty, 3, "Show UTM Zone Grid Lines.");
        props.put(ShowZonesProperty, interString);
        interString = this.i18n.get(class$com$bbn$openmap$plugin$UTMGridPlugIn == null ? (class$com$bbn$openmap$plugin$UTMGridPlugIn = UTMGridPlugIn.class$("com.bbn.openmap.plugin.UTMGridPlugIn")) : class$com$bbn$openmap$plugin$UTMGridPlugIn, ShowZonesProperty, ShowZonesProperty);
        props.put("showZones.label", interString);
        props.put("showZones.editor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        interString = this.i18n.get(class$com$bbn$openmap$plugin$UTMGridPlugIn == null ? (class$com$bbn$openmap$plugin$UTMGridPlugIn = UTMGridPlugIn.class$("com.bbn.openmap.plugin.UTMGridPlugIn")) : class$com$bbn$openmap$plugin$UTMGridPlugIn, UTMGridColorProperty, 3, "Color for UTM Zone Grid lines.");
        props.put(UTMGridColorProperty, interString);
        interString = this.i18n.get(class$com$bbn$openmap$plugin$UTMGridPlugIn == null ? (class$com$bbn$openmap$plugin$UTMGridPlugIn = UTMGridPlugIn.class$("com.bbn.openmap.plugin.UTMGridPlugIn")) : class$com$bbn$openmap$plugin$UTMGridPlugIn, UTMGridColorProperty, UTMGridColorProperty);
        props.put("utmGridColor.label", interString);
        props.put("utmGridColor.editor", "com.bbn.openmap.util.propertyEditor.ColorPropertyEditor");
        interString = this.i18n.get(class$com$bbn$openmap$plugin$UTMGridPlugIn == null ? (class$com$bbn$openmap$plugin$UTMGridPlugIn = UTMGridPlugIn.class$("com.bbn.openmap.plugin.UTMGridPlugIn")) : class$com$bbn$openmap$plugin$UTMGridPlugIn, ShowLabelsProperty, 3, "Show Labels for Grid Lines");
        props.put(ShowLabelsProperty, interString);
        interString = this.i18n.get(class$com$bbn$openmap$plugin$UTMGridPlugIn == null ? (class$com$bbn$openmap$plugin$UTMGridPlugIn = UTMGridPlugIn.class$("com.bbn.openmap.plugin.UTMGridPlugIn")) : class$com$bbn$openmap$plugin$UTMGridPlugIn, ShowLabelsProperty, ShowLabelsProperty);
        props.put("showLabels.label", interString);
        props.put("showLabels.editor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        interString = this.i18n.get(class$com$bbn$openmap$plugin$UTMGridPlugIn == null ? (class$com$bbn$openmap$plugin$UTMGridPlugIn = UTMGridPlugIn.class$("com.bbn.openmap.plugin.UTMGridPlugIn")) : class$com$bbn$openmap$plugin$UTMGridPlugIn, Show100kGridProperty, 3, "Show 100Km Distance Grid Lines");
        props.put(Show100kGridProperty, interString);
        interString = this.i18n.get(class$com$bbn$openmap$plugin$UTMGridPlugIn == null ? (class$com$bbn$openmap$plugin$UTMGridPlugIn = UTMGridPlugIn.class$("com.bbn.openmap.plugin.UTMGridPlugIn")) : class$com$bbn$openmap$plugin$UTMGridPlugIn, Show100kGridProperty, Show100kGridProperty);
        props.put("show100KmGrid.label", interString);
        props.put("show100KmGrid.editor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        interString = this.i18n.get(class$com$bbn$openmap$plugin$UTMGridPlugIn == null ? (class$com$bbn$openmap$plugin$UTMGridPlugIn = UTMGridPlugIn.class$("com.bbn.openmap.plugin.UTMGridPlugIn")) : class$com$bbn$openmap$plugin$UTMGridPlugIn, DistanceGridColorProperty, 3, "Color for Equal-Distance Grid Lines.");
        props.put(DistanceGridColorProperty, interString);
        interString = this.i18n.get(class$com$bbn$openmap$plugin$UTMGridPlugIn == null ? (class$com$bbn$openmap$plugin$UTMGridPlugIn = UTMGridPlugIn.class$("com.bbn.openmap.plugin.UTMGridPlugIn")) : class$com$bbn$openmap$plugin$UTMGridPlugIn, DistanceGridColorProperty, DistanceGridColorProperty);
        props.put("distanceGridColor.label", interString);
        props.put("distanceGridColor.editor", "com.bbn.openmap.util.propertyEditor.ColorPropertyEditor");
        interString = this.i18n.get(class$com$bbn$openmap$plugin$UTMGridPlugIn == null ? (class$com$bbn$openmap$plugin$UTMGridPlugIn = UTMGridPlugIn.class$("com.bbn.openmap.plugin.UTMGridPlugIn")) : class$com$bbn$openmap$plugin$UTMGridPlugIn, DistanceGridResolutionProperty, 3, "Meter Resolution for Distance Grid Lines (0-5)");
        props.put(DistanceGridResolutionProperty, interString);
        interString = this.i18n.get(class$com$bbn$openmap$plugin$UTMGridPlugIn == null ? (class$com$bbn$openmap$plugin$UTMGridPlugIn = UTMGridPlugIn.class$("com.bbn.openmap.plugin.UTMGridPlugIn")) : class$com$bbn$openmap$plugin$UTMGridPlugIn, DistanceGridResolutionProperty, DistanceGridResolutionProperty);
        props.put("distanceGridResolution.label", interString);
        props.put("initProperties", "showZones utmGridColor show100KmGrid showLabels distanceGridResolution distanceGridColor");
        return props;
    }

    public void setShowZones(boolean value) {
        this.showZones = value;
    }

    public boolean isShowZones() {
        return this.showZones;
    }

    public void setShowLabels(boolean value) {
        this.showLabels = value;
    }

    public boolean isShowLabels() {
        return this.showLabels;
    }

    public void setLabelCutoffScale(float value) {
        this.labelCutoffScale = value;
    }

    public float getLabelCutoffScale() {
        return this.labelCutoffScale;
    }

    public void setShow100kGrid(boolean value) {
        this.show100kGrid = value;
    }

    public boolean isShow100kGrid() {
        return this.show100kGrid;
    }

    public void setDistanceGridResolution(int value) {
        this.distanceGridResolution = value;
        if (this.distanceGridResolution < 0 || this.distanceGridResolution > 5) {
            this.distanceGridResolution = 0;
        }
    }

    public int getDistanceGridResolution() {
        return this.distanceGridResolution;
    }

    public void setUTMGridPaint(Paint value) {
        this.utmGridPaint = value;
        if (this.verticalList != null) {
            this.verticalList.setLinePaint(this.getUTMGridPaint());
            this.horizontalList.setLinePaint(this.getUTMGridPaint());
        }
    }

    public Paint getUTMGridPaint() {
        return this.utmGridPaint;
    }

    public void setDistanceGridPaint(Paint value) {
        this.distanceGridPaint = value;
    }

    public Paint getDistanceGridPaint() {
        return this.distanceGridPaint;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

