/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.plugin;

import com.bbn.openmap.image.ImageServerConstants;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMRaster;
import com.bbn.openmap.plugin.AbstractPlugIn;
import com.bbn.openmap.plugin.PlugInLayer;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public abstract class WebImagePlugIn
extends AbstractPlugIn
implements ImageServerConstants {
    protected PlugInLayer layer = null;
    protected Projection currentProjection = null;
    protected JButton redrawButton = new JButton("Query Server");
    protected JOptionPane messageWindow = new JOptionPane();

    public abstract String createQueryString(Projection var1);

    /*
     * WARNING - void declaration
     */
    public OMGraphicList getRectangle(Projection p) {
        OMGraphicList list = new OMGraphicList();
        this.currentProjection = p;
        String urlString = this.createQueryString(p);
        if (Debug.debugging("plugin")) {
            Debug.output("WebImagePlugIn.getRectangle() with \"" + urlString + "\"");
        }
        if (urlString == null) {
            return list;
        }
        URL url = null;
        try {
            url = new URL(urlString);
            HttpURLConnection urlc = (HttpURLConnection)url.openConnection();
            if (Debug.debugging("plugin")) {
                Debug.output("url content type: " + urlc.getContentType());
            }
            if (urlc == null || urlc.getContentType() == null) {
                if (this.layer != null) {
                    this.layer.fireRequestMessage(this.getName() + ": unable to connect to " + this.getServerName());
                } else {
                    Debug.error(this.getName() + ": unable to connect to " + this.getServerName());
                }
                return list;
            }
            if (urlc.getContentType().startsWith("text")) {
                String st;
                BufferedReader bin = new BufferedReader(new InputStreamReader(urlc.getInputStream()));
                String message = "";
                while ((st = bin.readLine()) != null) {
                    void var7_12;
                    message = message + (String)var7_12;
                }
                if (this.layer != null) {
                    this.layer.fireRequestMessage(message);
                }
            } else if (urlc.getContentType().startsWith("image")) {
                InputStream in = urlc.getInputStream();
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                int buflen = 2048;
                byte[] buf = new byte[buflen];
                int len = -1;
                while ((len = in.read(buf, 0, buflen)) != -1) {
                    out.write(buf, 0, len);
                }
                out.flush();
                out.close();
                ImageIcon ii = new ImageIcon(out.toByteArray());
                OMRaster image = new OMRaster(0, 0, ii);
                list.add(image);
            }
        }
        catch (MalformedURLException murle) {
            Debug.error("WebImagePlugIn: URL \"" + urlString + "\" is malformed.");
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(null, this.getName() + ":\n\n   Couldn't connect to " + this.getServerName(), "Connection Problem", 1);
        }
        list.generate(p);
        return list;
    }

    public abstract String getServerName();

    public Component getGUI() {
        JPanel panel = new JPanel(new GridLayout(0, 1));
        JButton parameterButton = new JButton("Adjust Parameters");
        parameterButton.setActionCommand("displayPropertiesCmd");
        if (this.layer != null) {
            parameterButton.addActionListener(this.layer);
        }
        JButton viewQueryButton = new JButton("View Current Query");
        viewQueryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (WebImagePlugIn.this.layer != null) {
                    String query = WebImagePlugIn.this.createQueryString(WebImagePlugIn.this.currentProjection);
                    Vector queryStrings = PropUtils.parseMarkers(query, "&");
                    StringBuffer updatedQuery = new StringBuffer();
                    Iterator it = queryStrings.iterator();
                    if (it.hasNext()) {
                        updatedQuery.append((String)it.next());
                    }
                    while (it.hasNext()) {
                        updatedQuery.append("&\n   ");
                        updatedQuery.append((String)it.next());
                    }
                    JOptionPane cfr_ignored_0 = WebImagePlugIn.this.messageWindow;
                    JOptionPane.showMessageDialog(null, updatedQuery.toString(), "Current Query for " + WebImagePlugIn.this.getName(), 1);
                }
            }
        });
        this.redrawButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (WebImagePlugIn.this.layer != null) {
                    WebImagePlugIn.this.layer.doPrepare();
                }
            }
        });
        this.redrawButton.setEnabled(this.layer != null);
        panel.add(parameterButton);
        panel.add(viewQueryButton);
        panel.add(this.redrawButton);
        return panel;
    }

    public void setComponent(Component comp) {
        super.setComponent(comp);
        this.layer = comp instanceof PlugInLayer ? (PlugInLayer)comp : null;
        this.redrawButton.setEnabled(this.layer != null);
    }
}

