/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.MoreMath;
import com.bbn.openmap.proj.GreatCircle;
import com.bbn.openmap.proj.Proj;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.util.Debug;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.io.Serializable;
import java.util.ArrayList;

public abstract class Azimuth
extends Proj {
    static final float ACCEPTABLE_AZ = ProjMath.degToRad(5.0f);
    protected Point world;
    protected boolean clockwise = true;
    protected static Color spaceColor = Color.black;

    public Azimuth(LatLonPoint center, float scale, int width, int height, int type) {
        super(center, scale, width, height, type);
    }

    public String toString() {
        return " world(" + this.world.x + "," + this.world.y + ") " + super.toString();
    }

    protected void computeParameters() {
        this.planetPixelRadius = this.planetRadius * (float)this.pixelsPerMeter;
        this.planetPixelCircumference = (float)Math.PI * 2 * this.planetPixelRadius;
        this.minscale = (float)Math.ceil(2.0f * this.planetPixelRadius / 2.1474836E9f);
        if (this.minscale < 1.0f) {
            this.minscale = 1.0f;
        }
        if (this.scale < this.minscale) {
            this.scale = this.minscale;
        }
        float f = this.maxscale = this.width < this.height ? this.planetPixelRadius * 2.0f / (float)this.width : this.planetPixelRadius * 2.0f / (float)this.height;
        if (this.maxscale < this.minscale) {
            this.maxscale = this.minscale;
        }
        if (this.scale > this.maxscale) {
            this.scale = this.maxscale;
        }
        this.scaled_radius = this.planetPixelRadius / this.scale;
        if (this.world == null) {
            this.world = new Point(0, 0);
        }
        this.world.x = (int)(this.planetPixelRadius * 2.0f / this.scale);
        this.XSCALE_THRESHOLD = (int)(this.planetPixelRadius * 2.0f / 64000.0f);
        if (Debug.debugging("proj")) {
            Debug.output("Azimuth.computeParameters(): world.x = " + this.world.x + " XSCALE_THRESHOLD = " + this.XSCALE_THRESHOLD);
        }
    }

    public void setClockwiseTraversal(boolean value) {
        this.clockwise = value;
    }

    public boolean isClockwiseTraversal() {
        return this.clockwise;
    }

    public final Point forward(LatLonPoint llp, Point pt) {
        return this._forward(this.normalize_latitude(llp.radlat_), Proj.wrap_longitude(llp.radlon_), pt, null);
    }

    public final Point forward(float lat, float lon, Point pt) {
        return this._forward(this.normalize_latitude(ProjMath.degToRad(lat)), Proj.wrap_longitude(ProjMath.degToRad(lon)), pt, null);
    }

    public final Point forward(float lat, float lon, Point pt, boolean isRadian) {
        return this._forward(this.normalize_latitude(lat), Proj.wrap_longitude(lon), pt, null);
    }

    protected abstract Point _forward(float var1, float var2, Point var3, AzimuthVar var4);

    public void pan(float Az) {
        if (MoreMath.approximately_equal(Math.abs(Az), 180.0f, 0.01f)) {
            this._panS();
        } else if (MoreMath.approximately_equal(Az, -135.0f, 0.01f)) {
            this._panSW();
        } else if (MoreMath.approximately_equal(Az, -90.0f, 0.01f)) {
            this._panW();
        } else if (MoreMath.approximately_equal(Az, -45.0f, 0.01f)) {
            this._panNW();
        } else if (MoreMath.approximately_equal(Az, 0.0f, 0.01f)) {
            this._panN();
        } else if (MoreMath.approximately_equal(Az, 45.0f, 0.01f)) {
            this._panNE();
        } else if (MoreMath.approximately_equal(Az, 90.0f, 0.01f)) {
            this._panE();
        } else if (MoreMath.approximately_equal(Az, 135.0f, 0.01f)) {
            this._panSE();
        } else {
            super.pan(Az);
        }
    }

    protected void _panNW() {
        if (this.overNorthPole()) {
            this.setCenter(new LatLonPoint(1.5707964f, this.ctrLon - 0.7853982f, true));
        } else {
            LatLonPoint to = this.inverse(0, 0);
            float lat = this.inverse((int)(this.width / 2), (int)0).radlat_;
            to.setLatitude(ProjMath.radToDeg(lat));
            if (MoreMath.approximately_equal(to.radlon_, this.ctrLon, 1.0E-4f)) {
                to = GreatCircle.spherical_between(this.ctrLat, this.ctrLon, 1.5707964f, -0.7853982f);
            }
            this.setCenter(to);
        }
    }

    protected void _panN() {
        if (this.overNorthPole()) {
            this.setCenter(90.0f, ProjMath.radToDeg(this.ctrLon));
        } else {
            LatLonPoint to = this.inverse(this.width / 2, 0);
            if (MoreMath.approximately_equal(to.radlat_, this.ctrLat, 1.0E-4f)) {
                to = GreatCircle.spherical_between(this.ctrLat, this.ctrLon, 1.5707964f, 0.0f);
            }
            this.setCenter(to);
        }
    }

    protected void _panNE() {
        if (this.overNorthPole()) {
            this.setCenter(new LatLonPoint(1.5707964f, this.ctrLon + 0.7853982f, true));
        } else {
            LatLonPoint to = this.inverse(this.width - 1, 0);
            float lat = this.inverse((int)(this.width / 2), (int)0).radlat_;
            to.setLatitude(ProjMath.radToDeg(lat));
            if (MoreMath.approximately_equal(to.radlon_, this.ctrLon, 1.0E-4f)) {
                to = GreatCircle.spherical_between(this.ctrLat, this.ctrLon, 1.5707964f, 0.7853982f);
            }
            this.setCenter(to);
        }
    }

    protected void _panE() {
        if (this.overNorthPole() || this.overSouthPole()) {
            this.setCenter(new LatLonPoint(this.ctrLat, this.ctrLon + 0.7853982f, true));
        } else {
            LatLonPoint to = this.inverse(new Point(this.width - 1, this.height / 2));
            to.setLatitude(ProjMath.radToDeg(this.ctrLat));
            if (MoreMath.approximately_equal(to.radlon_, this.ctrLon, 1.0E-4f)) {
                to = GreatCircle.spherical_between(this.ctrLat, this.ctrLon, 1.5707964f, 1.5707964f);
            }
            this.setCenter(to);
        }
    }

    protected void _panSE() {
        if (this.overSouthPole()) {
            this.setCenter(new LatLonPoint(-1.5707964f, this.ctrLon + 0.7853982f, true));
        } else {
            LatLonPoint to = this.inverse(this.width - 1, this.height - 1);
            float lat = this.inverse((int)(this.width / 2), (int)(this.height - 1)).radlat_;
            to.setLatitude(ProjMath.radToDeg(lat));
            if (MoreMath.approximately_equal(to.radlon_, this.ctrLon, 1.0E-4f)) {
                to = GreatCircle.spherical_between(this.ctrLat, this.ctrLon, 1.5707964f, 2.3561945f);
            }
            this.setCenter(to);
        }
    }

    protected void _panS() {
        if (this.overSouthPole()) {
            this.setCenter(-90.0f, ProjMath.radToDeg(this.ctrLon));
        } else {
            LatLonPoint to = this.inverse(this.width / 2, this.height);
            if (MoreMath.approximately_equal(to.radlat_, this.ctrLat, 1.0E-4f)) {
                to = GreatCircle.spherical_between(this.ctrLat, this.ctrLon, 1.5707964f, (float)Math.PI);
            }
            this.setCenter(to);
        }
    }

    protected void _panSW() {
        if (this.overSouthPole()) {
            this.setCenter(new LatLonPoint(-1.5707964f, this.ctrLon - 0.7853982f, true));
        } else {
            LatLonPoint to = this.inverse(0, this.height - 1);
            float lat = this.inverse((int)(this.width / 2), (int)(this.height - 1)).radlat_;
            to.setLatitude(ProjMath.radToDeg(lat));
            if (MoreMath.approximately_equal(to.radlon_, this.ctrLon, 1.0E-4f)) {
                to = GreatCircle.spherical_between(this.ctrLat, this.ctrLon, 1.5707964f, -2.3561945f);
            }
            this.setCenter(to);
        }
    }

    protected void _panW() {
        if (this.overNorthPole() || this.overSouthPole()) {
            this.setCenter(new LatLonPoint(this.ctrLat, this.ctrLon - 0.7853982f, true));
        } else {
            LatLonPoint to = this.inverse(new Point(0, this.height / 2));
            to.setLatitude(ProjMath.radToDeg(this.ctrLat));
            if (MoreMath.approximately_equal(to.radlon_, this.ctrLon, 1.0E-4f)) {
                to = GreatCircle.spherical_between(this.ctrLat, this.ctrLon, 1.5707964f, -1.5707964f);
            }
            this.setCenter(to);
        }
    }

    public boolean overNorthPole() {
        return this.overPoint(1.5707964f, 0.0f);
    }

    public boolean overSouthPole() {
        return this.overPoint(-1.5707964f, 0.0f);
    }

    public boolean overPoint(float lat, float lon) {
        AzimuthVar azVar = new AzimuthVar();
        Point pt = this._forward(lat, lon, new Point(), azVar);
        if (azVar.invalid_forward) {
            return false;
        }
        return pt.x >= 0 && pt.x <= this.width && pt.y >= 0 && pt.y <= this.height;
    }

    protected ArrayList _forwardPoly(float[] rawllpts, int ltype, int nsegs, boolean isFilled) {
        int[] y_;
        int[] x_;
        int len = rawllpts.length >>> 1;
        if (len < 2) {
            return new ArrayList(0);
        }
        if (this.isComplicatedLineType(ltype)) {
            return this.doPolyDispatch(rawllpts, ltype, nsegs, isFilled);
        }
        int invalid_count = 0;
        boolean prev_invalid = false;
        Point temp = new Point();
        AzimuthVar az_first = null;
        AzimuthVar az_save = null;
        AzimuthVar azVar = new AzimuthVar();
        ArrayList<AzimuthVar> sections = new ArrayList<AzimuthVar>(128);
        int[] xs = new int[len];
        int[] ys = new int[len];
        this._forward(rawllpts[0], rawllpts[1], temp, azVar);
        xs[0] = temp.x;
        ys[0] = temp.y;
        prev_invalid = azVar.invalid_forward;
        if (prev_invalid) {
            ++invalid_count;
        } else {
            azVar.index = 0;
            azVar.current_azimuth = GreatCircle.spherical_azimuth(this.ctrLat, this.ctrLon, rawllpts[0], rawllpts[1]);
            if (!isFilled) {
                sections.add(azVar);
            } else {
                az_first = azVar;
            }
            azVar = new AzimuthVar();
        }
        int i = 0;
        int j = 0;
        i = 1;
        j = 2;
        while (i < len) {
            azVar.invalid_forward = false;
            this._forward(rawllpts[j], rawllpts[j + 1], temp, azVar);
            boolean curr_invalid = azVar.invalid_forward;
            xs[i] = temp.x;
            ys[i] = temp.y;
            if (!curr_invalid && prev_invalid) {
                azVar.index = i - 1;
                azVar.current_azimuth = GreatCircle.spherical_azimuth(this.ctrLat, this.ctrLon, rawllpts[j - 2], rawllpts[j - 1]);
                sections.add(azVar);
                azVar = new AzimuthVar();
            } else if (curr_invalid) {
                if (!prev_invalid) {
                    azVar.index = i;
                    if (isFilled && invalid_count == 0) {
                        az_save = azVar;
                    } else {
                        sections.add(azVar);
                    }
                    azVar = new AzimuthVar();
                }
                ++invalid_count;
            }
            prev_invalid = curr_invalid;
            ++i;
            j += 2;
        }
        if (invalid_count == 0) {
            ArrayList<int[]> ret_val = new ArrayList<int[]>(2);
            ret_val.add(xs);
            ret_val.add(ys);
            return ret_val;
        }
        if (invalid_count == len) {
            return new ArrayList(0);
        }
        if (!prev_invalid) {
            if (isFilled && az_save != null) {
                int l = az_save.index;
                x_ = new int[len + l];
                y_ = new int[len + l];
                System.arraycopy(xs, 0, x_, 0, len);
                System.arraycopy(ys, 0, y_, 0, len);
                System.arraycopy(xs, 0, x_, len, l);
                System.arraycopy(ys, 0, y_, len, l);
                az_save.index = len + l;
                sections.add(az_save);
                xs = x_;
                ys = y_;
            } else {
                if (isFilled && az_save == null) {
                    Debug.output("AA, filled, no-wrap!");
                }
                azVar.index = i;
                j = rawllpts.length;
                azVar.current_azimuth = GreatCircle.spherical_azimuth(this.ctrLat, this.ctrLon, rawllpts[j - 2], rawllpts[j - 1]);
                sections.add(azVar);
            }
        } else if (az_save != null) {
            Debug.output("DD, filled!");
            sections.add(az_first);
            sections.add(az_save);
        }
        int size = sections.size();
        ArrayList<int[]> ret_val = new ArrayList<int[]>(size);
        if (isFilled && len > 2) {
            this.generateFilledPoly(xs, ys, sections, ret_val);
            return ret_val;
        }
        j = 0;
        while (j < size) {
            AzimuthVar az1 = (AzimuthVar)sections.get(j);
            AzimuthVar az2 = (AzimuthVar)sections.get(j + 1);
            int off1 = az1.index;
            int off2 = az2.index;
            int l = off2 - off1;
            x_ = new int[l];
            y_ = new int[l];
            System.arraycopy(xs, off1, x_, 0, l);
            System.arraycopy(ys, off1, y_, 0, l);
            ret_val.add(x_);
            ret_val.add(y_);
            j += 2;
        }
        return ret_val;
    }

    private void generateFilledPoly(int[] xs, int[] ys, ArrayList sections, ArrayList ret_vec) {
        ArrayList<Object> merged = null;
        ArrayList<Serializable> masterList = new ArrayList<Serializable>();
        float[] edgePoints = null;
        int bg = 0;
        int io = 1;
        int vertexCount = 0;
        while (sections.size() > 0) {
            AzimuthVar beginAz = (AzimuthVar)sections.get(bg);
            AzimuthVar ioAz = (AzimuthVar)sections.get(io);
            int oi = this.findClosestAzimuth(sections, ioAz.current_azimuth, this.clockwise);
            AzimuthVar oiAz = (AzimuthVar)sections.get(oi);
            int en = oi + 1;
            if (oi == bg) {
                if (merged != null) {
                    edgePoints = this.getHemisphereEdge(oiAz.current_azimuth, ioAz.current_azimuth);
                    merged.add(edgePoints);
                    masterList.add(new Integer(vertexCount += edgePoints.length >>> 1));
                    merged = null;
                    vertexCount = 0;
                } else {
                    this.hemisphereClip(xs, ys, oiAz, ioAz, ret_vec);
                }
                sections.remove(io);
                sections.remove(bg);
                bg = 0;
                io = 1;
                continue;
            }
            if (merged == null) {
                merged = new ArrayList<Object>();
                masterList.add(merged);
                merged.add(beginAz);
                merged.add(ioAz);
                vertexCount += ioAz.index - beginAz.index;
            }
            edgePoints = this.getHemisphereEdge(oiAz.current_azimuth, ioAz.current_azimuth);
            vertexCount += edgePoints.length >>> 1;
            merged.add(edgePoints);
            AzimuthVar endAz = (AzimuthVar)sections.get(en);
            merged.add(oiAz);
            merged.add(endAz);
            vertexCount += endAz.index - oiAz.index;
            sections.set(io, endAz);
            sections.remove(en);
            sections.remove(oi);
        }
        Point temp = new Point();
        int masterSize = masterList.size();
        int i = 0;
        while (i < masterSize) {
            merged = (ArrayList<Object>)masterList.get(i);
            vertexCount = (Integer)masterList.get(i + 1);
            int[] x_ = new int[vertexCount];
            int[] y_ = new int[vertexCount];
            int off = 0;
            int size = merged.size();
            int j = 0;
            while (j < size) {
                int off1 = ((AzimuthVar)merged.get((int)j)).index;
                int off2 = ((AzimuthVar)merged.get((int)(j + 1))).index;
                int l = off2 - off1;
                System.arraycopy(xs, off1, x_, off, l);
                System.arraycopy(ys, off1, y_, off, l);
                off += l;
                edgePoints = (float[])merged.get(j + 2);
                int edgelen = edgePoints.length;
                int k = 0;
                while (k < edgelen) {
                    this._forward(edgePoints[k], edgePoints[k + 1], temp, null);
                    x_[off] = temp.x;
                    y_[off] = temp.y;
                    ++off;
                    k += 2;
                }
                j += 3;
            }
            ret_vec.add(x_);
            ret_vec.add(y_);
            i += 2;
        }
    }

    private int findClosestAzimuth(ArrayList sections, float az, boolean clockwise) {
        float closest = clockwise ? (float)Math.PI * -2 : (float)Math.PI * 2;
        int id = -1;
        int k = sections.size() - 2;
        while (k >= 0) {
            AzimuthVar oiAz = (AzimuthVar)sections.get(k);
            float delta = az - oiAz.current_azimuth;
            if ((double)delta > Math.PI) {
                delta = (float)Math.PI * -2 + delta;
            } else if ((double)delta < -Math.PI) {
                delta = (float)Math.PI * 2 + delta;
            }
            if (clockwise) {
                if (delta > 0.0f) {
                    delta = (float)Math.PI * -2 + delta;
                }
                if (closest <= delta) {
                    closest = delta;
                    id = k;
                }
            } else {
                if (delta < 0.0f) {
                    delta = (float)Math.PI * 2 + delta;
                }
                if (closest >= delta) {
                    closest = delta;
                    id = k;
                }
            }
            k -= 2;
        }
        return id;
    }

    private float[] getHemisphereEdge(float oiAz, float ioAz) {
        float delta = oiAz - ioAz;
        if ((double)delta > Math.PI) {
            delta = (float)Math.PI * -2 + delta;
        } else if ((double)delta < -Math.PI) {
            delta = (float)Math.PI * 2 + delta;
        }
        delta = Math.abs(delta);
        LatLonPoint ll1 = GreatCircle.spherical_between(this.ctrLat, this.ctrLon, 1.5707964f, ioAz);
        LatLonPoint ll2 = GreatCircle.spherical_between(this.ctrLat, this.ctrLon, 1.5707964f, oiAz);
        int npts = (int)(Math.abs(delta) / ACCEPTABLE_AZ);
        if (npts == 0) {
            ++npts;
        }
        float[] radpts = GreatCircle.great_circle(ll1.radlat_, ll1.radlon_, ll2.radlat_, ll2.radlon_, npts, true);
        return radpts;
    }

    private void hemisphereClip(int[] xs, int[] ys, AzimuthVar oiAz, AzimuthVar ioAz, ArrayList ret_vec) {
        float[] radpts = this.getHemisphereEdge(oiAz.current_azimuth, ioAz.current_azimuth);
        int len = radpts.length;
        int m = len >>> 1;
        int off1 = oiAz.index;
        int off2 = ioAz.index;
        int l = off2 - off1;
        int[] x_ = new int[l + m];
        int[] y_ = new int[l + m];
        System.arraycopy(xs, off1, x_, 0, l);
        System.arraycopy(ys, off1, y_, 0, l);
        Point temp = new Point();
        int i = l;
        int j = 0;
        while (j < len) {
            this._forward(radpts[j], radpts[j + 1], temp, null);
            x_[i] = temp.x;
            y_[i] = temp.y;
            ++i;
            j += 2;
        }
        ret_vec.add(x_);
        ret_vec.add(y_);
    }

    public boolean forwardRaw(float[] rawllpts, int rawoff, int[] xcoords, int[] ycoords, boolean[] visible, int copyoff, int copylen) {
        Point temp = new Point();
        AzimuthVar azVar = new AzimuthVar();
        boolean ok = true;
        int end = copylen + copyoff;
        int i = copyoff;
        int j = rawoff;
        while (i < end) {
            this._forward(rawllpts[j], rawllpts[j + 1], temp, azVar);
            xcoords[i] = temp.x;
            ycoords[i] = temp.y;
            visible[i] = ok = !azVar.invalid_forward;
            ++i;
            j += 2;
        }
        return ok;
    }

    public void drawBackground(Graphics2D g, Paint paint) {
        g.setPaint(paint);
        this.drawBackground(g);
    }

    public void drawBackground(Graphics g) {
        if (this.scale <= 2.0E7f) {
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            return;
        }
        Paint oldPaint = null;
        oldPaint = g instanceof Graphics2D ? ((Graphics2D)g).getPaint() : g.getColor();
        g.setColor(spaceColor);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        int s = this.world.x;
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setPaint(oldPaint);
        } else {
            g.setColor((Color)oldPaint);
        }
        g.fillArc(this.width / 2 - s / 2, this.height / 2 - s / 2, s, s, 0, 360);
    }

    public String getName() {
        return "Azimuth";
    }

    protected static class AzimuthVar {
        boolean invalid_forward = false;
        float current_azimuth = Float.NaN;
        int index;

        protected AzimuthVar() {
        }
    }
}

