/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.proj.CADRG;
import com.bbn.openmap.proj.Gnomonic;
import com.bbn.openmap.proj.LLXY;
import com.bbn.openmap.proj.LLXYView;
import com.bbn.openmap.proj.Mercator;
import com.bbn.openmap.proj.MercatorView;
import com.bbn.openmap.proj.Orthographic;
import com.bbn.openmap.proj.OrthographicView;
import com.bbn.openmap.proj.Projection;

public class ProjectionFactory {
    protected static LatLonPoint llp = new LatLonPoint();

    private ProjectionFactory() {
    }

    public static Projection makeProjection(int projType, float centerLat, float centerLon, float scale, int width, int height) {
        llp.setLatLon(centerLat, centerLon);
        switch (projType) {
            case 42: {
                return new CADRG(llp, scale, width, height);
            }
            case 2: {
                return new Mercator(llp, scale, width, height);
            }
            case 22: {
                return new MercatorView(llp, scale, width, height);
            }
            case 6304: {
                return new LLXY(llp, scale, width, height);
            }
            case 6303: {
                return new LLXYView(llp, scale, width, height);
            }
            case 7: {
                return new Orthographic(llp, scale, width, height);
            }
            case 77: {
                return new OrthographicView(llp, scale, width, height);
            }
            case 12: {
                return new Gnomonic(llp, scale, width, height);
            }
        }
        System.err.println("Unknown projection type " + projType + " in ProjectionFactory.create()");
        return null;
    }

    public static Projection makeProjection(int newProjType, Projection p) {
        LatLonPoint ctr = p.getCenter();
        return ProjectionFactory.makeProjection(newProjType, ctr.getLatitude(), ctr.getLongitude(), p.getScale(), p.getWidth(), p.getHeight());
    }

    public static int getProjType(String projName) {
        int projType = 2;
        if (projName != null) {
            if (projName.equalsIgnoreCase("Mercator")) {
                projType = 2;
            } else if (projName.equalsIgnoreCase("MercatorView")) {
                projType = 22;
            } else if (projName.equalsIgnoreCase("Orthographic")) {
                projType = 7;
            } else if (projName.equalsIgnoreCase("OrthographicView")) {
                projType = 77;
            } else if (projName.equalsIgnoreCase("LLXY")) {
                projType = 6304;
            } else if (projName.equalsIgnoreCase("EPSG-4326")) {
                projType = 6303;
            } else if (projName.equalsIgnoreCase("CADRG")) {
                projType = 42;
            } else if (projName.equalsIgnoreCase("Gnomonic")) {
                projType = 12;
            }
        }
        return projType;
    }

    public static String[] getAvailableProjections() {
        int nProjections = 5;
        String[] projNames = new String[nProjections];
        projNames[0] = "Mercator";
        projNames[1] = "Orthographic";
        projNames[2] = "LLXY";
        projNames[3] = "CADRG";
        projNames[4] = "Gnomonic";
        return projNames;
    }
}

