/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj.coords;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.proj.Ellipsoid;
import com.bbn.openmap.proj.ProjMath;

public class UTMPoint {
    public float northing;
    public float easting;
    public int zone_number;
    public char zone_letter;

    public UTMPoint() {
    }

    public UTMPoint(float northing, float easting, int zone_number, char zone_letter) {
        this.northing = northing;
        this.easting = easting;
        this.zone_number = zone_number;
        this.zone_letter = zone_letter;
    }

    public UTMPoint(UTMPoint point) {
        this(point.northing, point.easting, point.zone_number, point.zone_letter);
    }

    public UTMPoint(LatLonPoint llpoint) {
        this(llpoint, Ellipsoid.WGS_84);
    }

    public UTMPoint(LatLonPoint llpoint, Ellipsoid ellip) {
        this();
        UTMPoint.LLtoUTM(llpoint, ellip, this);
    }

    public LatLonPoint toLatLonPoint() {
        return UTMPoint.UTMtoLL(this, Ellipsoid.WGS_84, new LatLonPoint());
    }

    public LatLonPoint toLatLonPoint(Ellipsoid ellip) {
        return UTMPoint.UTMtoLL(this, ellip, new LatLonPoint());
    }

    public LatLonPoint toLatLonPoint(Ellipsoid ellip, LatLonPoint llpoint) {
        return UTMPoint.UTMtoLL(this, ellip, llpoint);
    }

    public String toString() {
        return "UTMPoint[northing=" + this.northing + ", easting=" + this.easting + ", zone_number=" + this.zone_number + ", zone_letter=" + this.zone_letter + "]";
    }

    public static UTMPoint LLtoUTM(LatLonPoint llpoint) {
        return UTMPoint.LLtoUTM(llpoint, Ellipsoid.WGS_84, new UTMPoint());
    }

    public static UTMPoint LLtoUTM(LatLonPoint llpoint, UTMPoint utmpoint) {
        return UTMPoint.LLtoUTM(llpoint, Ellipsoid.WGS_84, utmpoint);
    }

    public static UTMPoint LLtoUTM(LatLonPoint llpoint, Ellipsoid ellip, UTMPoint utmpoint) {
        double Lat = llpoint.getLatitude();
        double Long2 = llpoint.getLongitude();
        double a = ellip.radius;
        double eccSquared = ellip.eccsq;
        double k0 = 0.9996;
        double LongTemp = Long2 + 180.0 - (double)((int)((Long2 + 180.0) / 360.0) * 360) - 180.0;
        double LatRad = llpoint.radlat_;
        double LongRad = llpoint.radlon_;
        int ZoneNumber = (int)((LongTemp + 180.0) / 6.0) + 1;
        if (Lat >= 56.0 && Lat < 64.0 && LongTemp >= 3.0 && LongTemp < 12.0) {
            ZoneNumber = 32;
        }
        if (Lat >= 72.0 && Lat < 84.0) {
            if (LongTemp >= 0.0 && LongTemp < 9.0) {
                ZoneNumber = 31;
            } else if (LongTemp >= 9.0 && LongTemp < 21.0) {
                ZoneNumber = 33;
            } else if (LongTemp >= 21.0 && LongTemp < 33.0) {
                ZoneNumber = 35;
            } else if (LongTemp >= 33.0 && LongTemp < 42.0) {
                ZoneNumber = 37;
            }
        }
        double LongOrigin = (ZoneNumber - 1) * 6 - 180 + 3;
        double LongOriginRad = ProjMath.degToRad(LongOrigin);
        double eccPrimeSquared = eccSquared / (1.0 - eccSquared);
        double N = a / Math.sqrt(1.0 - eccSquared * Math.sin(LatRad) * Math.sin(LatRad));
        double T = Math.tan(LatRad) * Math.tan(LatRad);
        double C = eccPrimeSquared * Math.cos(LatRad) * Math.cos(LatRad);
        double A = Math.cos(LatRad) * (LongRad - LongOriginRad);
        double M = a * ((1.0 - eccSquared / 4.0 - 3.0 * eccSquared * eccSquared / 64.0 - 5.0 * eccSquared * eccSquared * eccSquared / 256.0) * LatRad - (3.0 * eccSquared / 8.0 + 3.0 * eccSquared * eccSquared / 32.0 + 45.0 * eccSquared * eccSquared * eccSquared / 1024.0) * Math.sin(2.0 * LatRad) + (15.0 * eccSquared * eccSquared / 256.0 + 45.0 * eccSquared * eccSquared * eccSquared / 1024.0) * Math.sin(4.0 * LatRad) - 35.0 * eccSquared * eccSquared * eccSquared / 3072.0 * Math.sin(6.0 * LatRad));
        float UTMEasting = (float)(k0 * N * (A + (1.0 - T + C) * A * A * A / 6.0 + (5.0 - 18.0 * T + T * T + 72.0 * C - 58.0 * eccPrimeSquared) * A * A * A * A * A / 120.0) + 500000.0);
        float UTMNorthing = (float)(k0 * (M + N * Math.tan(LatRad) * (A * A / 2.0 + (5.0 - T + 9.0 * C + 4.0 * C * C) * A * A * A * A / 24.0 + (61.0 - 58.0 * T + T * T + 600.0 * C - 330.0 * eccPrimeSquared) * A * A * A * A * A * A / 720.0)));
        if (Lat < 0.0) {
            UTMNorthing += 1.0E7f;
        }
        if (utmpoint != null) {
            utmpoint.northing = UTMNorthing;
            utmpoint.easting = UTMEasting;
            utmpoint.zone_number = ZoneNumber;
            utmpoint.zone_letter = UTMPoint.UTMLetterDesignator(Lat);
            return utmpoint;
        }
        return new UTMPoint(UTMNorthing, UTMEasting, ZoneNumber, UTMPoint.UTMLetterDesignator(Lat));
    }

    protected static char UTMLetterDesignator(double Lat) {
        int LetterDesignator = 90;
        if (84.0 >= Lat && Lat >= 72.0) {
            LetterDesignator = 88;
        } else if (72.0 > Lat && Lat >= 64.0) {
            LetterDesignator = 87;
        } else if (64.0 > Lat && Lat >= 56.0) {
            LetterDesignator = 86;
        } else if (56.0 > Lat && Lat >= 48.0) {
            LetterDesignator = 85;
        } else if (48.0 > Lat && Lat >= 40.0) {
            LetterDesignator = 84;
        } else if (40.0 > Lat && Lat >= 32.0) {
            LetterDesignator = 83;
        } else if (32.0 > Lat && Lat >= 24.0) {
            LetterDesignator = 82;
        } else if (24.0 > Lat && Lat >= 16.0) {
            LetterDesignator = 81;
        } else if (16.0 > Lat && Lat >= 8.0) {
            LetterDesignator = 80;
        } else if (8.0 > Lat && Lat >= 0.0) {
            LetterDesignator = 78;
        } else if (0.0 > Lat && Lat >= -8.0) {
            LetterDesignator = 77;
        } else if (-8.0 > Lat && Lat >= -16.0) {
            LetterDesignator = 76;
        } else if (-16.0 > Lat && Lat >= -24.0) {
            LetterDesignator = 75;
        } else if (-24.0 > Lat && Lat >= -32.0) {
            LetterDesignator = 74;
        } else if (-32.0 > Lat && Lat >= -40.0) {
            LetterDesignator = 72;
        } else if (-40.0 > Lat && Lat >= -48.0) {
            LetterDesignator = 71;
        } else if (-48.0 > Lat && Lat >= -56.0) {
            LetterDesignator = 70;
        } else if (-56.0 > Lat && Lat >= -64.0) {
            LetterDesignator = 69;
        } else if (-64.0 > Lat && Lat >= -72.0) {
            LetterDesignator = 68;
        } else if (-72.0 > Lat && Lat >= -80.0) {
            LetterDesignator = 67;
        }
        return (char)LetterDesignator;
    }

    public static LatLonPoint UTMtoLL(UTMPoint utm_point, Ellipsoid ellip, LatLonPoint llpoint) {
        return UTMPoint.UTMtoLL(ellip, utm_point.northing, utm_point.easting, utm_point.zone_number, utm_point.zone_letter, llpoint);
    }

    public static LatLonPoint UTMtoLL(Ellipsoid ellip, float UTMNorthing, float UTMEasting, String UTMZone, LatLonPoint llpoint) {
        if (UTMZone == null || UTMZone.equals("")) {
            return null;
        }
        int ZoneNumber = 1;
        char ZoneLetter = 'N';
        int ln = UTMZone.length() - 1;
        if (ln > 0 && !Character.isLetter(ZoneLetter = (char)UTMZone.charAt(ln))) {
            ZoneLetter = 'N';
            ++ln;
        }
        try {
            ZoneNumber = Integer.parseInt(UTMZone.substring(0, ln));
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        return UTMPoint.UTMtoLL(ellip, UTMNorthing, UTMEasting, ZoneNumber, ZoneLetter, llpoint);
    }

    public static LatLonPoint UTMtoLL(Ellipsoid ellip, float UTMNorthing, float UTMEasting, int ZoneNumber, boolean isnorthern, LatLonPoint llpoint) {
        return UTMPoint.UTMtoLL(ellip, UTMNorthing, UTMEasting, ZoneNumber, isnorthern ? (char)'N' : 'M', llpoint);
    }

    public static LatLonPoint UTMtoLL(Ellipsoid ellip, float UTMNorthing, float UTMEasting, int ZoneNumber, char ZoneLetter, LatLonPoint llpoint) {
        if (ZoneNumber < 0 || ZoneNumber > 60) {
            return null;
        }
        double k0 = 0.9996;
        double a = ellip.radius;
        double eccSquared = ellip.eccsq;
        double e1 = (1.0 - Math.sqrt(1.0 - eccSquared)) / (1.0 + Math.sqrt(1.0 - eccSquared));
        double x = (double)UTMEasting - 500000.0;
        double y = UTMNorthing;
        if (ZoneLetter >= 'N') {
            boolean NorthernHemisphere = true;
        } else {
            boolean NorthernHemisphere = false;
            y -= 1.0E7;
        }
        double LongOrigin = (ZoneNumber - 1) * 6 - 180 + 3;
        double eccPrimeSquared = eccSquared / (1.0 - eccSquared);
        double M = y / k0;
        double mu = M / (a * (1.0 - eccSquared / 4.0 - 3.0 * eccSquared * eccSquared / 64.0 - 5.0 * eccSquared * eccSquared * eccSquared / 256.0));
        double phi1Rad = mu + (3.0 * e1 / 2.0 - 27.0 * e1 * e1 * e1 / 32.0) * Math.sin(2.0 * mu) + (21.0 * e1 * e1 / 16.0 - 55.0 * e1 * e1 * e1 * e1 / 32.0) * Math.sin(4.0 * mu) + 151.0 * e1 * e1 * e1 / 96.0 * Math.sin(6.0 * mu);
        double phi1 = ProjMath.radToDeg(phi1Rad);
        double N1 = a / Math.sqrt(1.0 - eccSquared * Math.sin(phi1Rad) * Math.sin(phi1Rad));
        double T1 = Math.tan(phi1Rad) * Math.tan(phi1Rad);
        double C1 = eccPrimeSquared * Math.cos(phi1Rad) * Math.cos(phi1Rad);
        double R1 = a * (1.0 - eccSquared) / Math.pow(1.0 - eccSquared * Math.sin(phi1Rad) * Math.sin(phi1Rad), 1.5);
        double D = x / (N1 * k0);
        double Lat = phi1Rad - N1 * Math.tan(phi1Rad) / R1 * (D * D / 2.0 - (5.0 + 3.0 * T1 + 10.0 * C1 - 4.0 * C1 * C1 - 9.0 * eccPrimeSquared) * D * D * D * D / 24.0 + (61.0 + 90.0 * T1 + 298.0 * C1 + 45.0 * T1 * T1 - 252.0 * eccPrimeSquared - 3.0 * C1 * C1) * D * D * D * D * D * D / 720.0);
        Lat = ProjMath.radToDeg(Lat);
        double Long2 = (D - (1.0 + 2.0 * T1 + C1) * D * D * D / 6.0 + (5.0 - 2.0 * C1 + 28.0 * T1 - 3.0 * C1 * C1 + 8.0 * eccPrimeSquared + 24.0 * T1 * T1) * D * D * D * D * D / 120.0) / Math.cos(phi1Rad);
        Long2 = LongOrigin + ProjMath.radToDeg(Long2);
        if (llpoint != null) {
            llpoint.setLatLon((float)Lat, (float)Long2);
            return llpoint;
        }
        return new LatLonPoint((float)Lat, (float)Long2);
    }
}

