/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.symbology.milStd2525;

import com.bbn.openmap.tools.symbology.milStd2525.CodeFunctionID;
import com.bbn.openmap.tools.symbology.milStd2525.SymbolPart;
import com.bbn.openmap.util.ComponentFactory;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class CodePosition {
    public static final char NO_CHAR = ' ';
    public static final int NO_NUMBER = -1;
    protected int hierarchyNumber;
    protected char id;
    protected String prettyName;
    protected int startIndex;
    protected int endIndex;
    protected CodePosition nextPosition = null;
    protected SymbolPart symbolPart = null;
    public static boolean DEBUG = false;
    public static final String NameProperty = "name";
    public static final String NextProperty = "next";
    protected List choices;

    public CodePosition() {
        DEBUG = Debug.debugging("codeposition");
    }

    public CodePosition(String name, int start, int end) {
        this();
        this.startIndex = start - 1;
        this.endIndex = end;
        this.prettyName = name;
    }

    public List getPositionChoices() {
        return this.choices;
    }

    public CodePosition getFromChoices(int hierarchyNumber) {
        List aList = this.getPositionChoices();
        if (aList != null) {
            Iterator it = aList.iterator();
            while (it.hasNext()) {
                CodePosition cp = (CodePosition)it.next();
                if (hierarchyNumber != cp.getHierarchyNumber()) continue;
                return cp;
            }
        }
        return null;
    }

    protected CodePosition addPositionChoice(int index, String entry, String prefix, Properties props) {
        String className = this.getClass().getName();
        CodePosition cp = (CodePosition)ComponentFactory.create(className);
        if (cp != null) {
            if (DEBUG) {
                Debug.output("CodePosition:  created position (" + className + ")");
            }
            cp.symbolPart = this.getSymbolPart(prefix + entry, prefix, props);
            prefix = PropUtils.getScopedPropertyPrefix(prefix) + entry + ".";
            cp.hierarchyNumber = index;
            cp.id = entry.charAt(0);
            cp.prettyName = props.getProperty(prefix + NameProperty);
            this.addPositionChoice(cp);
        } else if (DEBUG) {
            Debug.output("CodePosition: couldn't create position (" + className + ")");
        }
        return cp;
    }

    public void addPositionChoice(CodePosition cp) {
        if (this.choices == null) {
            this.choices = new LinkedList();
        }
        this.choices.add(cp);
    }

    protected void parsePositions(String prefix, Properties props) {
        int index = 1;
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        String entry = props.getProperty(prefix + Integer.toString(index));
        while (entry != null) {
            this.addPositionChoice(index, entry, prefix, props);
            entry = props.getProperty(prefix + Integer.toString(++index));
        }
    }

    protected SymbolPart getSymbolPart(String entry, String prefix, Properties props) {
        int offset = prefix.length();
        return new SymbolPart(this, entry, props, null, offset, offset + this.endIndex - this.startIndex, false);
    }

    protected void parseHierarchy(String hCode, Properties props, SymbolPart parent) {
        LinkedList<SymbolPart> parentList = null;
        int levelCounter = 1;
        while (levelCounter > 0) {
            String entry;
            String hierarchyCode = hCode + "." + levelCounter;
            if (DEBUG) {
                Debug.output("CodePosition.parse: " + hierarchyCode + " with " + this.getPrettyName());
            }
            if ((entry = props.getProperty(hierarchyCode)) != null) {
                CodeFunctionID cp = new CodeFunctionID();
                SymbolPart sp = new SymbolPart(cp, entry, props, parent);
                if (parentList == null && (parentList = parent.getSubs()) == null) {
                    parentList = new LinkedList<SymbolPart>();
                    parent.setSubs(parentList);
                }
                if (DEBUG) {
                    Debug.output("CodePosition.parse: adding " + sp.getPrettyName() + " to " + parent.getPrettyName());
                }
                parentList.add(sp);
                if (DEBUG) {
                    Debug.output("CodePosition.parse: looking for children of " + sp.getPrettyName());
                }
                cp.parseHierarchy(hierarchyCode, props, sp);
                ++levelCounter;
                continue;
            }
            levelCounter = -1;
        }
    }

    public int getHierarchyNumber() {
        return this.hierarchyNumber;
    }

    public String getHierarchyNumberString() {
        return Integer.toString(this.hierarchyNumber);
    }

    public char getID() {
        return this.id;
    }

    public String getPrettyName() {
        return this.prettyName;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public CodePosition getNextPosition() {
        return this.nextPosition;
    }

    public String toString() {
        return this.getPrettyName();
    }
}

