/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.symbology.milStd2525;

import com.bbn.openmap.event.ListenerSupport;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.tools.symbology.milStd2525.CodeOptions;
import com.bbn.openmap.tools.symbology.milStd2525.CodePosition;
import com.bbn.openmap.tools.symbology.milStd2525.CodeScheme;
import com.bbn.openmap.tools.symbology.milStd2525.SymbolPart;
import com.bbn.openmap.tools.symbology.milStd2525.SymbolReferenceLibrary;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PaletteHelper;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;

public class SymbolChooser
extends JPanel
implements ActionListener {
    private static boolean DEBUG = false;
    private boolean playWithLineStyle = false;
    private String lineStyle = "Angled";
    protected boolean showAll = false;
    public static final String CreateImageCmd = "CreateImageCommand";
    public static final String EMPTY_FEATURE_LIST = null;
    DefaultMutableTreeNode currentSymbol = null;
    SymbolTreeHolder selectedTreeHolder;
    protected DrawingAttributes drawingAttributes = new DrawingAttributes();
    JButton clearFeaturesButton;
    JButton createImageFileButton;
    JTextField nameField;
    SymbolReferenceLibrary library;
    List trees;
    JScrollPane treeView;
    JPanel optionPanel;
    BufferedImage symbolImage;

    public SymbolChooser(SymbolReferenceLibrary srl) {
        this.library = srl;
        try {
            this.trees = this.createNodes(srl);
        }
        catch (FormatException fe) {
            Debug.output("Caught FormatException reading data: " + fe.getMessage());
        }
        this.init(srl, this.trees);
    }

    public void setSelectedTreeHolder(SymbolTreeHolder sth) {
        this.selectedTreeHolder = sth;
        this.treeView.setViewportView(sth.getTree());
        this.optionPanel.removeAll();
        this.optionPanel.add(sth.getOptionPanel());
        this.nameField.setText("");
        this.paintSymbolImage();
        this.revalidate();
    }

    protected void paintSymbolImage() {
        if (this.symbolImage != null) {
            Graphics2D g = (Graphics2D)this.symbolImage.getGraphics();
            g.setPaint(this.getBackground());
            g.fill(new Rectangle(0, 0, 100, 100));
        }
        if (this.currentSymbol != null) {
            // empty if block
        }
    }

    protected void init(SymbolReferenceLibrary srl, List trees) {
        GridBagLayout outergridbag = new GridBagLayout();
        GridBagConstraints outerc = new GridBagConstraints();
        JPanel setChoicePanel = new JPanel();
        JLabel setChoiceLabel = new JLabel("Symbol Set:");
        JComboBox<Object> setChoices = new JComboBox<Object>(trees.toArray());
        setChoices.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComboBox jcb = (JComboBox)e.getSource();
                SymbolChooser.this.setSelectedTreeHolder((SymbolTreeHolder)jcb.getSelectedItem());
            }
        });
        setChoicePanel.add(setChoiceLabel);
        setChoicePanel.add(setChoices);
        this.treeView = new JScrollPane(((SymbolTreeHolder)setChoices.getSelectedItem()).getTree());
        this.setLayout(outergridbag);
        outerc.fill = 1;
        outerc.gridwidth = 0;
        outerc.weighty = 0.0;
        outerc.insets = new Insets(5, 10, 5, 10);
        outergridbag.setConstraints(setChoicePanel, outerc);
        this.add(setChoicePanel);
        outerc.weightx = 1.0;
        outerc.weighty = 1.0;
        outerc.gridwidth = -1;
        outergridbag.setConstraints(this.treeView, outerc);
        this.add(this.treeView);
        JPanel symbolPanel = PaletteHelper.createVerticalPanel(" Current Symbol ");
        this.symbolImage = new BufferedImage(100, 100, 1);
        this.paintSymbolImage();
        ImageIcon ii = new ImageIcon(this.symbolImage);
        JLabel symbolImageArea = new JLabel(ii);
        symbolPanel.add(symbolImageArea);
        outerc.weightx = 0.0;
        outerc.gridwidth = 0;
        outergridbag.setConstraints(symbolPanel, outerc);
        this.add(symbolPanel);
        this.optionPanel = PaletteHelper.createVerticalPanel(" Symbol Attributes ");
        this.optionPanel.add(((SymbolTreeHolder)setChoices.getSelectedItem()).getOptionPanel());
        outergridbag.setConstraints(this.optionPanel, outerc);
        this.add(this.optionPanel);
        GridBagLayout gridbag2 = new GridBagLayout();
        GridBagConstraints c2 = new GridBagConstraints();
        JPanel namePanel = new JPanel();
        namePanel.setLayout(gridbag2);
        c2.weightx = 0.0;
        c2.anchor = 17;
        JLabel nameLabel = new JLabel("Symbol Code: ");
        gridbag2.setConstraints(nameLabel, c2);
        namePanel.add(nameLabel);
        c2.fill = 2;
        c2.weightx = 1.0;
        this.nameField = new JTextField();
        gridbag2.setConstraints(this.nameField, c2);
        namePanel.add(this.nameField);
        this.createImageFileButton = new JButton("Create Image File");
        this.createImageFileButton.addActionListener(this);
        this.createImageFileButton.setActionCommand(CreateImageCmd);
        this.createImageFileButton.setEnabled(false);
        c2.weightx = 0.0;
        gridbag2.setConstraints(this.createImageFileButton, c2);
        namePanel.add(this.createImageFileButton);
        outerc.weighty = 0.0;
        outerc.gridwidth = 0;
        outergridbag.setConstraints(namePanel, outerc);
        this.add(namePanel);
    }

    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if (command == CreateImageCmd) {
            // empty if block
        }
    }

    private List createNodes(SymbolReferenceLibrary srl) throws FormatException {
        LinkedList<SymbolTreeHolder> treeList = new LinkedList<SymbolTreeHolder>();
        List subs = srl.getHead().getSubs();
        int count = 1;
        if (subs != null) {
            Iterator it = subs.iterator();
            while (it.hasNext()) {
                SymbolPart schemeSymbolPart = (SymbolPart)it.next();
                CodeOptions options = ((CodeScheme)srl.positionTree.getFromChoices(count++)).getCodeOptions(null);
                treeList.add(new SymbolTreeHolder(schemeSymbolPart, options));
            }
        }
        return treeList;
    }

    private void addNodes(DefaultMutableTreeNode node, SymbolPart sp) {
        DefaultMutableTreeNode newNode = null;
        List subs = sp.getSubs();
        if (subs != null) {
            Iterator it = subs.iterator();
            while (it.hasNext()) {
                sp = (SymbolPart)it.next();
                newNode = new DefaultMutableTreeNode(sp);
                node.add(newNode);
                this.addNodes(newNode, sp);
            }
        }
    }

    protected static void launchFrame(JComponent content, String title, boolean exitOnClose) {
        JFrame frame = new JFrame(title);
        frame.getContentPane().add(content);
        if (exitOnClose) {
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
        }
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SymbolChooser sc = new SymbolChooser(new SymbolReferenceLibrary());
        SymbolChooser.launchFrame(sc, "MIL-STD-2525B Symbology Chooser", true);
    }

    public class SymbolTreeHolder
    extends ListenerSupport
    implements TreeSelectionListener {
        JTree tree;
        JPanel optionPanel;
        CodeOptions options;

        public SymbolTreeHolder(SymbolPart schemeSymbolPart, CodeOptions opts) {
            super(schemeSymbolPart);
            DefaultMutableTreeNode top = new DefaultMutableTreeNode(schemeSymbolPart);
            SymbolChooser.this.addNodes(top, schemeSymbolPart);
            this.tree = new JTree(top);
            this.tree.getSelectionModel().setSelectionMode(1);
            this.tree.setVisibleRowCount(10);
            this.tree.addTreeSelectionListener(this);
            if (SymbolChooser.this.playWithLineStyle) {
                this.tree.putClientProperty("JTree.lineStyle", SymbolChooser.this.lineStyle);
            }
            this.options = opts;
            this.optionPanel = this.getOptionPanel();
        }

        public JTree getTree() {
            return this.tree;
        }

        public void valueChanged(TreeSelectionEvent e) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            Object nodeInfo = node.getUserObject();
            if (nodeInfo instanceof SymbolPart) {
                SymbolPart symbolPart = (SymbolPart)nodeInfo;
                SymbolChooser.this.currentSymbol = node;
                SymbolChooser.this.nameField.setText(symbolPart.getSymbolCode());
            } else {
                SymbolChooser.this.nameField.setText("");
            }
        }

        public JPanel getOptionPanel() {
            if (this.optionPanel == null) {
                this.optionPanel = new JPanel();
                GridBagLayout gridbag = new GridBagLayout();
                GridBagConstraints c = new GridBagConstraints();
                this.optionPanel.setLayout(gridbag);
                if (this.options != null) {
                    int i = 0;
                    Iterator it = this.options.getOptions().iterator();
                    while (it.hasNext()) {
                        CodePosition cp = (CodePosition)it.next();
                        List lt = cp.getPositionChoices();
                        if (lt == null) continue;
                        JLabel label = new JLabel(cp.getPrettyName() + ": ");
                        c.gridx = 0;
                        c.gridy = i++;
                        c.weightx = 0.0;
                        c.fill = 0;
                        c.anchor = 13;
                        gridbag.setConstraints(label, c);
                        this.optionPanel.add(label);
                        JComboBox<Object> jcb = new JComboBox<Object>(lt.toArray());
                        jcb.addActionListener(new ActionListener(this){
                            private final /* synthetic */ SymbolTreeHolder this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void actionPerformed(ActionEvent ae) {
                                this.this$1.setPositionSetting((CodePosition)((JComboBox)ae.getSource()).getSelectedItem());
                            }
                        });
                        c.gridx = 1;
                        c.anchor = 17;
                        c.fill = 2;
                        c.weightx = 1.0;
                        gridbag.setConstraints(jcb, c);
                        this.optionPanel.add(jcb);
                    }
                } else {
                    this.optionPanel.add(new JLabel("No options available for these symbols."));
                }
            }
            return this.optionPanel;
        }

        public void setPositionSetting(CodePosition cp) {
            Debug.output("Setting " + cp.getPrettyName());
        }

        public String toString() {
            return ((SymbolPart)this.getSource()).getCodePosition().getPrettyName();
        }
    }
}

